/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentraldata.util.login;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentraldata.util.login.LoginLdapConnection;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import gls.outils.GLS;

public class AuthentificationPrism {
    private IBusinessService business;
    private String loginMethodsAuthorized;
    private String defaultLoginMethod;

    public AuthentificationPrism(IBusinessService business) {
        this.business = business;
        this.loginMethodsAuthorized = business.getConfiguration().getString("login.methods", "prism");
        this.defaultLoginMethod = business.getConfiguration().getString("login.method.default", "prism");
    }

    public PrismCentralUser login(String login, String mdp) {
        String connectionType = this.business.getUserConnectionType(login);
        if (connectionType == null) {
            connectionType = this.defaultLoginMethod;
        }
        String[] types = connectionType.split(",");
        String methodToUse = null;
        for (int i = 0; i < types.length; ++i) {
            methodToUse = types[i];
            PrismCentralUser user = this.login(methodToUse, login, mdp);
            if (user == null) continue;
            return user;
        }
        return null;
    }

    public PrismCentralUser login(String type, String login, String mdp) {
        if (!this.loginMethodsAuthorized.contains(type)) {
            return null;
        }
        if (GLS.estVide((String)mdp)) {
            Log.debug("Erreur LOGIN " + login + " : MDP NULL");
            return null;
        }
        switch (type) {
            case "prism": {
                return this.business.login(login, mdp);
            }
            case "ldap": {
                return this.loginLDAP(login, mdp);
            }
        }
        return null;
    }

    private PrismCentralUser loginLDAP(String login, String password) {
        String securityPrincipalPattern;
        LoginLdapConnection ldap = new LoginLdapConnection();
        String host = null;
        String ldapLogin = null;
        String ldapPassword = null;
        int port = 0;
        String domainName = null;
        try {
            host = this.business.getConfiguration().getString("ldap.host");
            port = this.business.getConfiguration().getInt("ldap.port", 636);
            domainName = this.business.getConfiguration().getString("ldap.domainName");
            securityPrincipalPattern = this.business.getConfiguration().getString("ldap.securityPrincipal.pattern");
        }
        catch (PrismConfigurationError e) {
            Log.error((Object)e);
            return null;
        }
        try {
            ldapLogin = this.business.getConfiguration().getString("ldap.user");
            ldapPassword = this.business.getConfiguration().getString("ldap.password");
        }
        catch (PrismConfigurationError e) {
            Log.error((Object)e);
        }
        if (GLS.estVide((String)password)) {
            Log.debug("Erreur LOGIN " + login + " : MDP NULL");
            return null;
        }
        if (!(GLS.estVide((String)ldapLogin) || GLS.estVide((String)ldapPassword) || ldap.login(securityPrincipalPattern, ldapLogin, ldapPassword, host, port, domainName))) {
            Log.debug("LDAP connection error - host : " + host + " - Port : " + port + " - DomainName : " + domainName);
            return null;
        }
        boolean loged = ldap.login(securityPrincipalPattern, login, password, host, port, domainName);
        if (loged) {
            return this.business.loginLDAP(login);
        }
        Log.debug("LDAP connection error - host : " + host + " - Port : " + port + " - DomainName : " + domainName);
        return null;
    }
}

