/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentraldata.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.Adler32;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class URLTools {
    private static TrustManager openTrustManager = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };
    private static HostnameVerifier openHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };

    public static void main(String[] args) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, IOException {
        String remoteUrl = "";
        URLConnection remoteConn = null;
        if (args.length == 0) {
            System.out.println("USAGE: java URLTools <url> [<cert file>]");
            System.exit(-1);
        } else if (args.length == 1) {
            remoteUrl = args[0];
            remoteConn = URLTools.getConnection(remoteUrl);
        } else if (args.length == 2) {
            remoteUrl = args[0];
            String certFile = args[1];
            SSLSocketFactory sslSocketFactory = URLTools.getSSLSocketFactory(certFile);
            remoteConn = URLTools.getConnection(remoteUrl, new HashMap<String, String>(), sslSocketFactory);
        }
        String rawData = URLTools.fetchUrlString(remoteConn);
        System.out.println(rawData);
    }

    public static String formatCert(String inputCert) {
        String[] certLines;
        String beginCert = "-----BEGIN CERTIFICATE-----";
        String endCert = "-----END CERTIFICATE-----";
        StringBuilder resultBuilder = new StringBuilder();
        if (!inputCert.startsWith(beginCert)) {
            inputCert = beginCert + "\n" + inputCert;
        }
        if (!inputCert.endsWith(endCert)) {
            inputCert = inputCert + "\n" + endCert;
        }
        inputCert = inputCert.replaceAll(beginCert, "\n" + beginCert + "\n").replaceAll(endCert, "\n" + endCert + "\n").replaceAll("\n\n", "\n");
        for (String currLine : certLines = inputCert.split("[\r\n]+")) {
            if (currLine.length() > 64) {
                currLine = currLine.replaceAll("(.{64})", "$1\n");
            }
            resultBuilder.append(currLine).append("\n");
        }
        return resultBuilder.toString().replaceAll("\n\n", "\n").trim();
    }

    public static SSLSocketFactory getSSLSocketFactory(String certFile) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        return URLTools.getSSLSocketFactory(true, certFile, "TLS", "PKIX");
    }

    public static SSLSocketFactory getSSLSocketFactory(String certFile, String trustCertFile) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        return URLTools.getSSLSocketFactory(true, certFile, trustCertFile, "TLS", "PKIX");
    }

    public static SSLSocketFactory getSSLSocketFactory(String certFile, String passwordCertFile, String trustCertFile, String passWordtrustCertFile) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        return URLTools.getSSLSocketFactory(certFile, passwordCertFile, trustCertFile, passWordtrustCertFile, "TLS", "PKIX");
    }

    public static SSLSocketFactory getSSLSocketFactory(boolean certInFile, String theCert, String secureProtocol, String tmAlgorithm) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        Certificate theCertificate = certInFile ? URLTools.getCertificateFromFile(theCert) : URLTools.getCertificateFromString(theCert);
        KeyStore keyStore = URLTools.getKeyStore(theCertificate);
        TrustManagerFactory tmFactory = URLTools.getTrustManagerFactory(keyStore, tmAlgorithm);
        return URLTools.getSSLSocketFactory(tmFactory, secureProtocol);
    }

    public static SSLSocketFactory getSSLSocketFactory(boolean certInFile, String theCert, String theTrustCert, String secureProtocol, String tmAlgorithm) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = null;
        if (theTrustCert != null) {
            Certificate theTrustCertificate = certInFile ? URLTools.getCertificateFromFile(theTrustCert) : URLTools.getCertificateFromString(theTrustCert);
            keyStore = URLTools.getKeyStore(theTrustCertificate);
        }
        TrustManagerFactory tmFactory = URLTools.getTrustManagerFactory(keyStore, tmAlgorithm);
        Certificate theCertificate = certInFile ? URLTools.getCertificateFromFile(theCert) : URLTools.getCertificateFromString(theCert);
        keyStore = URLTools.getKeyStore(theCertificate);
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keyStore, null);
        return URLTools.getSSLSocketFactory(kmfactory, tmFactory, secureProtocol);
    }

    public static SSLSocketFactory getSSLSocketFactory(String theCert, String passwordTheCert, String theTrustCert, String passwordTheTrustCert, String secureProtocol, String tmAlgorithm) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException {
        KeyStore keyStore = null;
        if (theTrustCert != null) {
            keyStore = URLTools.createKeyStore(new URL("file:" + theTrustCert), passwordTheTrustCert);
        }
        TrustManagerFactory tmFactory = URLTools.getTrustManagerFactory(keyStore, tmAlgorithm);
        KeyStore keystore = URLTools.createKeyStore(new URL("file:" + theCert), passwordTheCert);
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, passwordTheCert != null ? passwordTheCert.toCharArray() : null);
        return URLTools.getSSLSocketFactory(kmfactory, tmFactory, secureProtocol);
    }

    public static SSLSocketFactory getSSLSocketFactory(TrustManagerFactory tmFactory, String secureProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        if (secureProtocol == null) {
            secureProtocol = "TLS";
        }
        SSLContext sslContext = SSLContext.getInstance(secureProtocol);
        sslContext.init(null, tmFactory.getTrustManagers(), null);
        return sslContext.getSocketFactory();
    }

    public static SSLSocketFactory getSSLSocketFactory(KeyManagerFactory kmfactory, TrustManagerFactory tmFactory, String secureProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        if (secureProtocol == null) {
            secureProtocol = "TLS";
        }
        SSLContext sslcontext = SSLContext.getInstance(secureProtocol);
        sslcontext.init(kmfactory.getKeyManagers(), tmFactory.getTrustManagers(), null);
        return sslcontext.getSocketFactory();
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, String tmAlgorithm) throws NoSuchAlgorithmException, KeyStoreException {
        if (tmAlgorithm == null) {
            tmAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(tmAlgorithm);
        tmFactory.init(keyStore);
        return tmFactory;
    }

    public static KeyStore getKeyStore(Certificate theCert) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("theCert", theCert);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createKeyStore(URL url, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (url == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        KeyStore keystore = KeyStore.getInstance("jks");
        try (InputStream is = null;){
            is = url.openStream();
            keystore.load(is, password != null ? password.toCharArray() : null);
        }
        return keystore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCertificateFromString(String pemString) throws CertificateException, IOException {
        Certificate theCert;
        if (pemString == null || pemString.length() == 0) {
            throw new CertificateException("Null or zero length Certificate string");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream certStream = new ByteArrayInputStream(pemString.getBytes("US-ASCII"));
        try {
            theCert = certFactory.generateCertificate(certStream);
        }
        finally {
            if (certStream != certStream) {
                certStream.close();
            }
        }
        return theCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCertificateFromFile(String certFile) throws CertificateException, IOException {
        Certificate theCert;
        if (certFile == null || certFile.length() == 0) {
            throw new CertificateException("ERROR: Null or zero length certificate file names are not allowed.");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        BufferedInputStream certStream = new BufferedInputStream(new FileInputStream(certFile));
        try {
            theCert = certFactory.generateCertificate(certStream);
        }
        finally {
            if (certStream != certStream) {
                ((InputStream)certStream).close();
            }
        }
        return theCert;
    }

    public static HttpsURLConnection getEncryptedNoauthConnection(URL theUrl, String secureSocketProtocol) throws IOException {
        SSLContext sslContext = null;
        HttpsURLConnection connection = (HttpsURLConnection)theUrl.openConnection();
        try {
            sslContext = SSLContext.getInstance(secureSocketProtocol);
        }
        catch (NoSuchAlgorithmException ne) {
            throw new IOException("ERROR: Unable to create SSL Context using protocol: " + secureSocketProtocol + ".\nMessage: " + ne.getMessage());
        }
        TrustManager[] trustManagers = new TrustManager[]{openTrustManager};
        connection.setHostnameVerifier(openHostnameVerifier);
        try {
            sslContext.init(null, trustManagers, null);
        }
        catch (KeyManagementException ke) {
            throw new IOException("ERROR: Unable to initialize SSL Context using trust manager: " + trustManagers + ".\nMessage: " + ke.getMessage());
        }
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        return connection;
    }

    public static byte[] getData(URLConnection theConnection) throws IOException {
        return URLTools.emptyStream(theConnection.getInputStream());
    }

    public static String getCertInfo(HttpsURLConnection theConnection) throws IOException {
        StringBuilder resultBuffer = new StringBuilder();
        if (theConnection != null) {
            try {
                Certificate[] certificateList;
                resultBuffer.append("Response Code : " + theConnection.getResponseCode()).append("\n");
                resultBuffer.append("Cipher Suite : " + theConnection.getCipherSuite()).append("\n");
                resultBuffer.append("\n");
                for (Certificate currCert : certificateList = theConnection.getServerCertificates()) {
                    resultBuffer.append("Certificate Type : " + currCert.getType()).append("\n");
                    resultBuffer.append("Certificate Hash Code : " + currCert.hashCode()).append("\n");
                    resultBuffer.append("Certificate Public Key Algorithm : " + currCert.getPublicKey().getAlgorithm()).append("\n");
                    resultBuffer.append("Certificate Public Key Format : " + currCert.getPublicKey().getFormat()).append("\n");
                    resultBuffer.append("\n");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                throw new IOException("ERROR: SSL Peer Unverified. URL: " + theConnection + ".\nMessage: " + e.getMessage());
            }
        }
        return resultBuffer.toString();
    }

    public static URLConnection getConnection(String theUrl, Map<String, String> reqHeaders, SSLSocketFactory sslSocketFactory) throws IOException {
        URLConnection theConnection;
        if (theUrl.toLowerCase().startsWith("https://")) {
            if (sslSocketFactory == null) {
                theConnection = URLTools.getEncryptedNoauthConnection(new URL(theUrl), "TLS");
            } else {
                HttpsURLConnection secConnection = (HttpsURLConnection)new URL(theUrl).openConnection();
                secConnection.setSSLSocketFactory(sslSocketFactory);
                theConnection = secConnection;
            }
        } else {
            theConnection = new URL(theUrl).openConnection();
        }
        if (reqHeaders != null) {
            URLTools.setHeaders(theConnection, reqHeaders);
        }
        return theConnection;
    }

    public static URLConnection getConnection(String theUrl, Map<String, String> reqHeaders) throws IOException {
        return URLTools.getConnection(theUrl, reqHeaders, null);
    }

    public static URLConnection getConnection(String theUrl) throws IOException {
        return URLTools.getConnection(theUrl, null, null);
    }

    public static URLConnection getConnection(String theUrl, SSLSocketFactory sslSocketFactory) throws IOException {
        return URLTools.getConnection(theUrl, null, sslSocketFactory);
    }

    public static String fetchUrlString(String theUrl) throws IOException {
        return new String(URLTools.fetchUrl(URLTools.getConnection(theUrl), null, "GET"));
    }

    public static String fetchUrlString(URLConnection theConnection) throws IOException {
        return new String(URLTools.fetchUrl(theConnection, null, "GET"));
    }

    public static byte[] fetchUrl(String theUrl) throws IOException {
        return URLTools.fetchUrl(URLTools.getConnection(theUrl), null, "GET");
    }

    public static byte[] fetchUrl(URLConnection theConnection) throws IOException {
        return URLTools.fetchUrl(theConnection, null, "GET");
    }

    public static byte[] fetchUrl(String theUrl, String dataBuffer) throws IOException {
        return URLTools.fetchUrl(URLTools.getConnection(theUrl), dataBuffer.getBytes(), dataBuffer == null ? "GET" : "POST");
    }

    public static byte[] fetchUrl(URLConnection theConnection, byte[] dataBuffer, String reqMethod) throws IOException {
        byte[] responseBuffer = null;
        try {
            theConnection.setUseCaches(false);
            theConnection.setDoInput(true);
            theConnection.setRequestProperty("Cache-Control", "no-cache");
            if (reqMethod.toUpperCase().equals("GET")) {
                theConnection.setDoOutput(false);
                if (theConnection instanceof HttpURLConnection) {
                    HttpURLConnection theHttpConnection = (HttpURLConnection)theConnection;
                    theHttpConnection.setRequestMethod("GET");
                }
            } else {
                theConnection.setDoOutput(true);
                if (theConnection instanceof HttpURLConnection) {
                    HttpURLConnection theHttpConnection = (HttpURLConnection)theConnection;
                    theHttpConnection.setRequestMethod("POST");
                }
                URLTools.fillStream(theConnection.getOutputStream(), dataBuffer);
            }
            responseBuffer = URLTools.getData(theConnection);
        }
        catch (MalformedURLException e) {
            throw new IOException("ERROR: Invalid URL: " + theConnection + ".\nMessage: " + e.getMessage());
        }
        return responseBuffer;
    }

    public static Map<String, String> getResponseHeaders(URLConnection remoteConn) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Map<String, List<String>> headerFields = remoteConn.getHeaderFields();
        Set<String> headerFieldsSet = headerFields.keySet();
        for (String headerFieldKey : headerFieldsSet) {
            if (headerFieldKey == null) continue;
            List<String> headerFieldValue = headerFields.get(headerFieldKey);
            headerMap.put(headerFieldKey, URLTools.csvList(headerFieldValue));
        }
        return headerMap;
    }

    public static String csvList(List<String> theList) {
        StringBuilder mergedValue = new StringBuilder();
        for (String currValue : theList) {
            if (mergedValue.length() > 0) {
                mergedValue.append(",");
            }
            mergedValue.append(currValue);
        }
        return mergedValue.toString();
    }

    public static String dumpMap(Map<String, String> theMap) {
        String entryTemplate = "%s=\"%s\";";
        StringBuilder resultBuffer = new StringBuilder();
        for (Map.Entry<String, String> currEntry : theMap.entrySet()) {
            resultBuffer.append(String.format(entryTemplate, currEntry.getKey(), currEntry.getValue()));
        }
        if (resultBuffer.length() > 1) {
            resultBuffer.deleteCharAt(resultBuffer.length() - 1);
        }
        return resultBuffer.toString();
    }

    public static void fillStream(OutputStream outStream, byte[] streamData) throws IOException {
        try {
            outStream.write(streamData);
            outStream.flush();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] emptyStream(InputStream inStream) throws IOException {
        int DEFAULT_BLOCK_SIZE = 4096;
        ByteArrayOutputStream outStream = null;
        if (inStream == null) {
            return new byte[0];
        }
        try {
            int numBytes;
            outStream = new ByteArrayOutputStream();
            byte[] byteBuffer = new byte[DEFAULT_BLOCK_SIZE];
            while ((numBytes = inStream.read(byteBuffer)) > -1) {
                outStream.write(byteBuffer, 0, numBytes);
            }
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return outStream.toByteArray();
    }

    public static long getAdler32(byte[] rawData) {
        if (rawData == null) {
            return 0L;
        }
        Adler32 checksum = new Adler32();
        checksum.update(rawData, 0, rawData.length);
        return checksum.getValue();
    }

    public static void setHeader(URLConnection remoteConn, String headerName, String headerValue) {
        remoteConn.setRequestProperty(headerName, headerValue);
    }

    public static void setHeaders(URLConnection remoteConn, Map<String, String> httpHeaders) {
        for (String headerName : httpHeaders.keySet()) {
            remoteConn.setRequestProperty(headerName, httpHeaders.get(headerName));
        }
    }

    public static void dumpRequestHeaders(URLConnection remoteConn, String prefix) {
        for (String currHeader : remoteConn.getRequestProperties().keySet()) {
            if (currHeader == null) continue;
            for (String headerValue : remoteConn.getRequestProperties().get(currHeader)) {
                System.out.println(prefix + " " + currHeader + ": " + headerValue);
            }
        }
    }

    public static void dumpResponseHeaders(URLConnection remoteConn, String prefixStr) {
        for (String currHeader : remoteConn.getHeaderFields().keySet()) {
            if (currHeader == null) continue;
            for (String headerValue : remoteConn.getHeaderFields().get(currHeader)) {
                System.out.println(prefixStr + " " + currHeader + ": " + headerValue);
            }
        }
    }

    public static void addChecksumHeader(String headerName, Map<String, String> theMap, byte[] rawData) {
        if (rawData == null) {
            theMap.put(headerName, "");
        } else {
            theMap.put(headerName, Long.toString(URLTools.getAdler32(rawData)));
        }
    }

    public static String getChecksumHeader(String headerName, Map<String, String> theMap) {
        return theMap.get(headerName);
    }

    public static String logPrefix(String msgType, Thread theThread) {
        StringBuffer resultStr = new StringBuffer(msgType);
        resultStr.append(": [");
        resultStr.append(theThread.getStackTrace()[2].getClassName().toString());
        resultStr.append(" :: ");
        resultStr.append(theThread.getStackTrace()[2].getMethodName().toString());
        resultStr.append("] ");
        return resultStr.toString();
    }
}

