/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentraldata.util;

import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.EvenementsDAOJDBC;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class PrismCodeEvenementGenerator {
    private static final String CODE_EVENEMENT_PATTERN = "[^%]*((%DATE%)?[^%]*(%DATEINVERSEE%)?[^%]*(%CODENATURE%)?)*[^%]*";
    private EvenementsDAOJDBC evenementsDAOJDBC;
    private IReferentielDAO referentiel;
    private NumberFormat nf;

    public PrismCodeEvenementGenerator(EvenementsDAOJDBC evenementsDAOJDBC, IReferentielDAO referentiel, NumberFormat nf) {
        this.evenementsDAOJDBC = evenementsDAOJDBC;
        this.referentiel = referentiel;
        this.nf = nf;
    }

    public String genereCodeEvenement(Connection connectionInit, String nature, String delegation, String centre, long dateCreation) {
        String codeEvenementPattern = this.referentiel.getConfiguration().getString("genereCodeClair.pattern");
        if (codeEvenementPattern != null && codeEvenementPattern.matches(CODE_EVENEMENT_PATTERN)) {
            return this.genereCodeEvenementPattern(connectionInit, codeEvenementPattern, nature, delegation, centre, dateCreation);
        }
        return this.genereCodeEvenementSimple(connectionInit, nature, delegation, centre, dateCreation);
    }

    public String genereCodeEvenementSimple(Connection connectionInit, String nature, String delegation, String centre, long dateCreation) {
        int nb = this.evenementsDAOJDBC.getNbEvenementParNatureJournee(connectionInit, nature, delegation, centre, dateCreation);
        String codeNature = nature.substring(0, nature.length() > 10 ? 10 : nature.length()).toUpperCase();
        String codeCentre = !GLS.estVide((String)centre) ? this.referentiel.getCodesCentre().get(centre) + "_" : (!GLS.estVide((String)delegation) ? delegation.substring(0, delegation.length() < 3 ? delegation.length() : 3).toUpperCase() + "_" : ConfigurationFactory.getInstance().get("zoneroutiere"));
        Calendar date = GLSDate.toDate((long)dateCreation);
        String d = GLSDate.toDate((Calendar)date, (DateFormat)GLSDate.formatDateJourSimple);
        return codeCentre.concat(d).concat("_").concat(codeNature).concat("_").concat(this.nf.format(nb + 1));
    }

    public String genereCodeEvenementPattern(Connection connectionInit, String codeEvenementPattern, String nature, String delegation, String centre, long dateCreation) {
        int nb = this.evenementsDAOJDBC.getNbEvenementParNatureJournee(connectionInit, nature, delegation, centre, dateCreation);
        String codeNature = nature.substring(0, nature.length() > 10 ? 10 : nature.length()).toUpperCase();
        String codeCentre = !GLS.estVide((String)centre) ? this.referentiel.getCodesCentre().get(centre) : ConfigurationFactory.getInstance().get("zoneroutiere");
        SimpleDateFormat formatDateInversee = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat formatDate = new SimpleDateFormat("ddMMyyyy");
        Calendar date = GLSDate.toDate((long)dateCreation);
        String d = GLSDate.toDate((Calendar)date, (DateFormat)formatDate);
        codeEvenementPattern = codeEvenementPattern.replace("%DATE%", d);
        d = GLSDate.toDate((Calendar)date, (DateFormat)formatDateInversee);
        codeEvenementPattern = codeEvenementPattern.replace("%DATEINVERSEE%", d);
        codeEvenementPattern = codeEvenementPattern.replace("%CODENATURE%", codeNature);
        String codeEvenement = codeCentre.concat("_").concat(codeEvenementPattern).concat("_").concat(this.nf.format(nb + 1));
        return codeEvenement;
    }
}

