/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentraldata.util;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.geometry.Geometry;
import gls.wms.RequestParameter;
import gls.wms.RequestParameterImp;
import gls.wms.WMSClient;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.stream.Collectors;

public class ImageEvenement {
    private Image wmsImage;

    public Image getImage(Evenement e, double delta, int imageWidth, int imageHeight) throws Exception {
        IConfiguration c = ConfigurationFactory.getInstance();
        float[] xs = e.getLocalisation().getX();
        float[] ys = e.getLocalisation().getY();
        Double maxX = null;
        Double minX = null;
        Double maxY = null;
        Double minY = null;
        for (int i = 0; i < xs.length; ++i) {
            if (maxX == null) {
                maxX = xs[i];
                minX = xs[i];
                maxY = ys[i];
                minY = ys[i];
            }
            if ((double)xs[i] > maxX) {
                maxX = xs[i];
            }
            if ((double)xs[i] < minX) {
                minX = xs[i];
            }
            if ((double)ys[i] > maxY) {
                maxY = ys[i];
            }
            if (!((double)ys[i] < minY)) continue;
            minY = ys[i];
        }
        Rectangle2D r = new Line2D.Double(new Point2D.Double(minX - delta, maxY + delta), new Point2D.Double(maxX + delta, minY - delta)).getBounds2D();
        if (r != null) {
            RequestParameterImp requestParameter = new RequestParameterImp();
            requestParameter.setSrs(c.get("rapport.evt.carto.projection"));
            requestParameter.setBoundingbox((float)r.getMinX(), (float)r.getMinY(), (float)r.getMaxX(), (float)r.getMaxY());
            double scale = Geometry.getEchelle((double)r.getHeight(), (double)r.getWidth(), (double)imageWidth, (double)imageHeight);
            requestParameter.setImageFormat(c.get("carto.formatImage"));
            requestParameter.setImageWidth((int)(r.getWidth() / scale));
            requestParameter.setImageHeight((int)(r.getHeight() / scale));
            requestParameter.setVariable("eventid", String.valueOf(e.getkEventid()));
            WMSClient wms = new WMSClient("ImageEvenementExport", c.get("carto.mci.url"), c.get("carto.mci.map"), c.get("carto.mci.evt.layers"));
            wms.getImage((RequestParameter)requestParameter);
            this.wmsImage = wms.getImageLayer();
            return this.wmsImage;
        }
        throw new Exception("ERREUR AUCUN TRACE A AFFICHER");
    }

    public Image getImage(List<Evenement> evenements, double delta, int imageWidth, int imageHeight) throws Exception {
        Rectangle2D r;
        IConfiguration c = ConfigurationFactory.getInstance();
        Double maxX = null;
        Double minX = null;
        Double maxY = null;
        Double minY = null;
        for (Evenement e2 : evenements) {
            if (e2.getLocalisation() == null) continue;
            float[] xs = e2.getLocalisation().getX();
            float[] ys = e2.getLocalisation().getY();
            for (int i = 0; i < xs.length; ++i) {
                if (maxX == null) {
                    maxX = xs[i];
                    minX = xs[i];
                    maxY = ys[i];
                    minY = ys[i];
                }
                if ((double)xs[i] > maxX) {
                    maxX = xs[i];
                }
                if ((double)xs[i] < minX) {
                    minX = xs[i];
                }
                if ((double)ys[i] > maxY) {
                    maxY = ys[i];
                }
                if (!((double)ys[i] < minY)) continue;
                minY = ys[i];
            }
        }
        if (delta == 0.0) {
            delta = Math.max(Math.abs(maxX - minX) * 0.1, Math.abs(maxY - minY) * 0.1);
        }
        if (delta == 0.0) {
            delta = 0.002;
        }
        if ((r = new Line2D.Double(new Point2D.Double(minX - delta, maxY + delta), new Point2D.Double(maxX + delta, minY - delta)).getBounds2D()) != null) {
            RequestParameterImp requestParameter = new RequestParameterImp();
            requestParameter.setSrs(c.get("rapport.evt.carto.projection"));
            requestParameter.setBoundingbox((float)r.getMinX(), (float)r.getMinY(), (float)r.getMaxX(), (float)r.getMaxY());
            double scale = Geometry.getEchelle((double)r.getHeight(), (double)r.getWidth(), (double)imageWidth, (double)imageHeight);
            requestParameter.setImageFormat(c.get("carto.formatImage"));
            requestParameter.setImageWidth((int)(r.getWidth() / scale));
            requestParameter.setImageHeight((int)(r.getHeight() / scale));
            String evenementsId = evenements.stream().map(e -> String.valueOf(e.getkEventid())).collect(Collectors.joining("%2C"));
            requestParameter.setVariable("eventid", evenementsId);
            WMSClient wms = new WMSClient("ImageEvenementExport", c.get("carto.mci.url"), c.get("carto.mci.map"), c.get("carto.mci.evts.layers"));
            wms.getImage((RequestParameter)requestParameter);
            this.wmsImage = wms.getImageLayer();
            return this.wmsImage;
        }
        throw new Exception("ERREUR AUCUN TRACE A AFFICHER");
    }
}

