/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentral.data.ISuiviActiviteService;
import com.geolocsystems.prismcentral.export.csv.CSVUtils;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Util;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import gls.outils.fichier.MonFichier;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SuiviActiviteService
implements ISuiviActiviteService {
    protected IAdminDAO adminDal;
    protected IUserDAO userDal;
    protected IReferentielDAO referentielDal;
    protected IIG4DAO ig4Dal;
    public static final int TYPE_UTILISATEUR_IMPORT_METIER = 2;
    public static final int TYPE_UTILISATEUR_PRISM = 1;
    private static final long serialVersionUID = 1832979256504127634L;
    protected static String FICHIER_IMPORT_UTILISATEUR = "export_agent_m2m.csv";
    protected static String FICHIER_IMPORT_MATERIEL = "export_materiel_m2m.csv";
    protected static int LIGNE_NOM = 1;
    protected static int LIGNE_PRENOM = 2;
    protected static int LIGNE_CODE = 0;
    protected static int LIGNE_CENTRE = 3;
    protected static int LIGNE_DELEGATION = 4;
    protected static int LIGNE_IMMATRICULATION = 1;
    protected static int LIGNE_CODE_VEHICULE = 0;
    protected static int LIGNE_DESCRIPTION = 2;
    protected static int LIGNE_CENTRE_VEHICULE = 3;
    protected static int LIGNE_MARQUE = 4;
    protected static int LIGNE_DELEGATION_VEHICULE = 5;
    protected int nbLignesEnteteAgent = 0;
    protected int nbLignesEnteteVehicule = 0;
    IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();
    private IMcigDAO mcigDal;
    private IEvenementsDAO evtDal;
    private IVehiculeDAO vehiculeDal;

    public SuiviActiviteService() {
        this.userDal = DAOFactory.getInstance().getUserDAO(this.referentielDal);
        this.referentielDal = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.vehiculeDal = DAOFactory.getInstance().getVehiculeDAO(null);
        this.mcigDal = DAOFactory.getInstance().getMcigDAO(this.referentielDal, null);
        this.adminDal = DAOFactory.getInstance().getAdminDAO(this.referentielDal);
        this.evtDal = DAOFactory.getInstance().getEvenementsDAO(this.referentielDal, this.userDal, this.mcigDal);
        this.ig4Dal = DAOFactory.getInstance().getIG4DAO(this.adminDal, this.referentielDal, this.userDal, this.evtDal, this.mcigDal, this.vehiculeDal);
    }

    public boolean estZoneValide(String zone) {
        if (!GLS.estVide((String)zone) && !this.estSuiviParDefaut()) {
            return GLS.estDansLaListe((String[])this.getZonesRoutiere(), (String)zone);
        }
        return false;
    }

    public boolean estSuiviParDefaut() {
        return GLS.estVide((String[])this.getZonesRoutiere());
    }

    public boolean exportation(List<Partenaire> partenairesATraiter) {
        return this.ig4Dal.exportation(partenairesATraiter);
    }

    protected String genererExportCSV(List<Mission> missions) {
        return CSVUtils.genereCSV(missions);
    }

    public List<Mission> getMissions(Date dateDeb, Date dateFin) {
        return this.ig4Dal.getMissionsV2(dateDeb, dateFin);
    }

    public boolean exportationV2(List<Partenaire> partenairesATraiter, Date dateDeb, Date dateFin) {
        if (!GLS.estVide(partenairesATraiter)) {
            List<Mission> missions = this.getMissions(dateDeb, dateFin);
            if (!GLS.estVide(missions)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                    if (!new File(partenaire.getCheminServeur()).exists()) {
                        new File(partenaire.getCheminServeur()).mkdirs();
                    }
                    if (this.referentielDal.getConfiguration().getBoolean("ig4.export.suppr", true)) {
                        Fichier.effacerFichiers((String)partenaire.getCheminServeur());
                    }
                    if (!new File(partenaire.getRepArchivage()).exists()) {
                        new File(partenaire.getRepArchivage()).mkdirs();
                    }
                    Log.debug("EXPORT CSV MISSIONS");
                    String csv = this.genererExportCSV(missions);
                    Log.debug("CSV MISSIONS - " + csv);
                    String nomFichier = Util.getFilePattern((Date)dateDeb, (String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0);
                    MonFichier f = new MonFichier(partenaire.getCheminServeur() + nomFichier, 1);
                    try {
                        f.ecrire(csv);
                        f.fermer();
                    }
                    catch (Exception e) {
                        Log.error("erreur ecriture fichier ", e);
                    }
                    f = new MonFichier(partenaire.getRepArchivage() + nomFichier, 1);
                    try {
                        f.ecrire(csv);
                        f.fermer();
                    }
                    catch (Exception e) {
                        Log.error("erreur ecriture fichier archivage ", e);
                    }
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement export IG4 termin\u00e9");
                }
            } else {
                Log.info("aucune mission \u00e0 exporter ");
            }
        }
        return true;
    }

    public boolean importation(List<Partenaire> partenairesATraiter) {
        try {
            FICHIER_IMPORT_UTILISATEUR = this.referentielDal.getConfiguration().getString("ig4.nomfichier.agent", FICHIER_IMPORT_UTILISATEUR);
            FICHIER_IMPORT_MATERIEL = this.referentielDal.getConfiguration().getString("ig4.nomfichier.vehicule", FICHIER_IMPORT_MATERIEL);
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        try {
            this.nbLignesEnteteAgent = this.referentielDal.getConfiguration().getInt("ig4.nblignesentete.agent", this.nbLignesEnteteAgent);
            this.nbLignesEnteteVehicule = this.referentielDal.getConfiguration().getInt("ig4.nblignesentete.vehicule", this.nbLignesEnteteVehicule);
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        try {
            if (!GLS.estVide(partenairesATraiter)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                    if (!new File(partenaire.getRepertoireReception()).exists()) {
                        new File(partenaire.getRepertoireReception()).mkdirs();
                    }
                    this.importUtilisateurs(partenaire.getRepertoireReception().concat(FICHIER_IMPORT_UTILISATEUR));
                    this.importVehicules(partenaire.getRepertoireReception().concat(FICHIER_IMPORT_MATERIEL));
                    String string = partenaire.getRepertoireReception().concat(FICHIER_IMPORT_UTILISATEUR);
                    String string2 = partenaire.getRepArchivage().concat(FICHIER_IMPORT_UTILISATEUR).concat("_");
                    GLS.getDate();
                    GLS.getDate();
                    Calendar calendar = GLSDate.maintenant();
                    GLS.getDate();
                    this.archiveFichierImportUtilisateur(string, string2.concat(GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJourDatex)));
                    String string3 = partenaire.getRepertoireReception().concat(FICHIER_IMPORT_MATERIEL);
                    String string4 = partenaire.getRepArchivage().concat(FICHIER_IMPORT_MATERIEL).concat("_");
                    GLS.getDate();
                    GLS.getDate();
                    Calendar calendar2 = GLSDate.maintenant();
                    GLS.getDate();
                    this.archiveFichierImportVehicule(string3, string4.concat(GLSDate.toDate((Calendar)calendar2, (DateFormat)GLSDate.formatDateJourDatex)));
                }
            }
        }
        catch (Exception e) {
            Log.error("ERREUR IMPORT IG4", e);
            return false;
        }
        return true;
    }

    protected void supprimerCorrespondancesUtilisateurs() {
        this.ig4Dal.supprimerCorrespondances("ig4.corres_utilisateurs");
    }

    protected void supprimerCorrespondanceUtilisateurs(String id) {
        this.ig4Dal.supprimerCorrespondance("ig4.corres_utilisateurs", id);
    }

    public FichierCSV getFichierCSV(String nomFichier) {
        return new FichierCSV(nomFichier);
    }

    public void importUtilisateurs(String fichierCSV) {
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = this.getFichierCSV(fichierCSV);
            f.setNbLignesEntete(this.nbLignesEnteteAgent);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir " + fichierCSV);
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            this.supprimerCorrespondancesUtilisateurs();
            ArrayList<UserExport> utilisateurs = new ArrayList<UserExport>();
            for (Object ligne : f.values()) {
                try {
                    utilisateurs.add(this.convertirUtilisateur((String[])ligne));
                }
                catch (Exception e) {
                    Log.error("ERREUR IMPORT UTILISATEUR " + e.getMessage());
                }
            }
            boolean modif = false;
            for (UserExport u : utilisateurs) {
                this.supprimerCorrespondanceUtilisateurs(u.getCode());
                this.ig4Dal.ajouterCorrespondance("ig4.corres_utilisateurs", u.getCode(), GLS.estVide((String)u.getMatricule()) ? u.getCode() : u.getMatricule(), u.getCodeServiceIg4());
                switch (this.ig4Dal.getEtatImportation(u)) {
                    case 0: {
                        String password = this.getPassword(u);
                        String zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
                        this.ig4Dal.ajouterUtilisateur(u, password, zoneRoutiere);
                        modif = true;
                        break;
                    }
                    case 1: {
                        this.ig4Dal.modiferUtilisateur(u);
                        modif = true;
                        break;
                    }
                    case 2: {
                        Log.info("Aucun changement utilisateur " + u.getCode());
                    }
                }
            }
            boolean suppr = this.ig4Dal.archiveUtilisateurs();
            if (suppr || modif) {
                this.adminDal.updateDateModificationAdmin("utilisateurs");
            }
        }
    }

    protected void archiveFichierImportUtilisateur(String fichierSource, String fichierDestination) {
    }

    protected void archiveFichierImportVehicule(String fichierSource, String fichierDestination) {
    }

    public String getProfil(PrismCentralUser user, String[] ligne) {
        return this.ig4Dal.getCorresPref().get("profil");
    }

    protected boolean estProfilResponsable(String[] ligne) {
        return false;
    }

    public String getPassword(PrismCentralUser user) {
        return MetierCommun.instanceOf().hashPassword(this.ig4Dal.getCorresPref().get("mdp"));
    }

    public void importVehicules(String fichierCSV) {
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = this.getFichierCSV(fichierCSV);
            f.setNbLignesEntete(this.nbLignesEnteteVehicule);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir " + fichierCSV);
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            this.ig4Dal.supprimerCorrespondances("ig4.corres_vehicules");
            ArrayList<VehiculeExport> vehicules = new ArrayList<VehiculeExport>();
            for (Object ligne : f.values()) {
                try {
                    this.verifierMarque((String[])ligne);
                    vehicules.add(this.convertirVehicule((String[])ligne));
                }
                catch (Exception e) {
                    Log.error("ERREUR IMPORT VEHICULE " + e.getMessage());
                }
            }
            boolean modif = false;
            for (VehiculeExport v : vehicules) {
                switch (this.ig4Dal.getEtatImportation(v)) {
                    case 0: {
                        this.ig4Dal.ajouterVehicule(v);
                        modif = true;
                        break;
                    }
                    case 1: {
                        this.ig4Dal.modiferVehicule(v);
                        modif = true;
                        break;
                    }
                    case 2: {
                        Log.info("Aucun changement vehicule " + v.getCode());
                    }
                }
                this.ig4Dal.supprimerCorrespondance("ig4.corres_vehicules", v.getCode());
                this.ig4Dal.ajouterCorrespondance("ig4.corres_vehicules", v.getCode(), GLS.estVide((String)v.getCodeServiceIg4()) ? v.getCode() : v.getCodeServiceIg4(), v.getCodeServiceIg4());
            }
            boolean suppr = this.archiveVehicules();
            if (suppr || modif) {
                this.adminDal.updateDateModificationAdmin("vehicules");
            }
        }
    }

    protected void verifierMarque(String[] ligne) throws Exception {
        this.ig4Dal.verifierMarqueVehicule(this.convertirLigneVehicule(ligne));
    }

    protected boolean archiveVehicules() {
        return this.ig4Dal.archiveVehicules();
    }

    protected UserExport convertirUtilisateur(String[] ligne) throws Exception {
        UserExport u = new UserExport();
        if (GLS.estVide((String)ligne[LIGNE_CODE])) {
            throw new Exception("UTILISATEUR NON INTEGRE - LE CODE EST NULL " + ligne[LIGNE_NOM]);
        }
        u.setNom(ligne[LIGNE_NOM].concat(" ").concat(ligne[LIGNE_PRENOM]).concat(" (").concat(ligne[LIGNE_CODE]).concat(")"));
        u.setCode(ligne[LIGNE_CODE]);
        Centre centre = null;
        String delegation = null;
        if (!GLS.estVide((String)ligne[LIGNE_CENTRE])) {
            centre = this.getCentreParCode(ligne[LIGNE_CENTRE], this.ig4Dal.getCorresDelegationsCentre());
            if (centre == null) {
                throw new Exception("UTILISATEUR NON INTEGRE - LE CENTRE N'EXISTE PAS - " + ligne[LIGNE_CENTRE]);
            }
            delegation = centre.getDelegation();
        } else if (ligne.length > LIGNE_DELEGATION && !GLS.estVide((String)ligne[LIGNE_DELEGATION]) && (delegation = this.getCorresInversee(ligne[LIGNE_DELEGATION], this.ig4Dal.getCorresDelegations())) == null) {
            throw new Exception("UTILISATEUR NON INTEGRE - LA DELEGATION N'EXISTE PAS - " + ligne[LIGNE_DELEGATION]);
        }
        if (centre == null || GLS.estVide((String)centre.getNom())) {
            if (GLS.estVide(delegation)) {
                u.setCentre(null);
                u.setDelegation(null);
            } else {
                u.setCentre(null);
                u.setDelegation(delegation);
            }
        } else {
            if (GLS.estVide(delegation)) {
                throw new Exception("UTILISATEUR NON INTEGRE - LA DELEGATION N'EXISTE PAS EN BASE POUR LE CENTRE - " + ligne[LIGNE_CENTRE]);
            }
            u.setDelegation(delegation);
            u.setCentre(centre.getNom());
        }
        Profil profil = new Profil();
        profil.setName(this.getProfil(u, ligne));
        u.setProfil(profil);
        u.setCodeServiceIg4(ligne[LIGNE_CENTRE]);
        u.setArchive(false);
        return u;
    }

    protected String[] convertirLigneVehicule(String[] ligne) {
        return ligne;
    }

    protected VehiculeExport convertirVehicule(String[] ligne) throws Exception {
        int codeMarque;
        VehiculeExport v = new VehiculeExport();
        v.setImmatriculation(ligne[LIGNE_IMMATRICULATION]);
        v.setCode(ligne[LIGNE_CODE_VEHICULE]);
        v.setDescription(ligne[LIGNE_DESCRIPTION]);
        Centre centre = null;
        String delegation = null;
        if (!GLS.estVide((String)ligne[LIGNE_CENTRE_VEHICULE])) {
            centre = this.getCentreParCode(ligne[LIGNE_CENTRE_VEHICULE], this.ig4Dal.getCorresDelegationsCentre());
            if (centre == null) {
                throw new Exception("VEHICULE NON INTEGRE - LE CENTRE N'EXISTE PAS - " + ligne[LIGNE_CENTRE_VEHICULE]);
            }
            delegation = centre.getDelegation();
        } else if (ligne.length > LIGNE_DELEGATION_VEHICULE && !GLS.estVide((String)ligne[LIGNE_DELEGATION_VEHICULE]) && (delegation = this.getCorresInversee(ligne[LIGNE_DELEGATION_VEHICULE], this.ig4Dal.getCorresDelegations())) == null) {
            throw new Exception("VEHICULE NON INTEGRE - LA DELEGATION N'EXISTE PAS - " + ligne[LIGNE_DELEGATION_VEHICULE]);
        }
        if (centre == null || GLS.estVide((String)centre.getNom())) {
            if (GLS.estVide(delegation)) {
                v.setCentre(null);
                v.setDelegation(null);
            } else {
                v.setCentre(null);
                v.setDelegation(delegation);
            }
        } else {
            if (GLS.estVide(delegation)) {
                throw new Exception("VEHICULE NON INTEGRE - LA DELEGATION N'EXISTE PAS EN BASE POUR LE CENTRE - " + ligne[LIGNE_CENTRE_VEHICULE]);
            }
            v.setDelegation(delegation);
            v.setCentre(centre.getNom());
        }
        v.setCodeServiceIg4(ligne[LIGNE_CENTRE_VEHICULE]);
        try {
            codeMarque = this.adminDal.getMarqueVehicule(ligne[LIGNE_MARQUE]);
        }
        catch (Exception e) {
            Log.error("ERREUR - VEHICULE NON INTEGRE - ERREUR RECUPERATION MARQUE - " + ligne[LIGNE_MARQUE], e);
            codeMarque = -1;
        }
        v.setArchive(false);
        if (codeMarque == -1) {
            throw new Exception("ERREUR - VEHICULE NON INTEGRE - LA MARQUE N'EXISTE PAS EN BASE - " + ligne[LIGNE_DESCRIPTION]);
        }
        v.setType(codeMarque);
        return v;
    }

    public String getCorresInversee(String valeur, Map<String, String> map) throws Exception {
        if (map.containsValue(valeur)) {
            for (String k : map.keySet()) {
                if (!map.get(k).equals(valeur)) continue;
                return k;
            }
        }
        return null;
    }

    public Centre getCentreParCode(String valeur, Map<String, Centre> map) throws Exception {
        return map.get(valeur);
    }

    public String getCorres(String valeur, Map<String, String> map) throws Exception {
        if (map.containsKey(valeur)) {
            return map.get(valeur);
        }
        return null;
    }

    public String[] getZonesRoutiere() {
        return null;
    }
}

