/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentral.export.csv.CSVUtils;
import com.geolocsystems.prismcentral.service.SuiviActiviteService;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class SuiviActiviteCD34Service
extends SuiviActiviteService {
    private static final long serialVersionUID = 3762358758026004781L;
    private static final int LIGNE_LOGIN = 0;
    private static final int LIGNE_MARQUE_VEHICULE = 3;
    private static final int LIGNE_UO_VEHICULE = 6;
    private static final int HEURE_HHNS_MIDI_DEBUT = 12;
    private static final int MINUTE_HHNS_MIDI_DEBUT = 0;
    private static final int HEURE_HHNS_MIDI_FIN = 13;
    private static final int MINUTE_HHNS_MIDI_FIN = 30;
    private static final int HEURE_HHNS_SOIR_DEBUT = 17;
    private static final int MINUTE_HHNS_SOIR_DEBUT = 30;
    private static final int HEURE_HHNS_SOIR_FIN = 8;
    private static final int MINUTE_HHNS_SOIR_FIN = 0;
    private static final int HEURE_HHNS_NUIT_DEBUT = 22;
    private static final int MINUTE_HHNS_NUIT_DEBUT = 0;
    private static final int HEURE_HHNS_NUIT_FIN = 7;
    private static final int MINUTE_HHNS_NUIT_FIN = 0;
    private static final int SUPPLEMENT_TEMPS_HHNS = 15;
    private static final int SUPPLEMENT_TEMPS_HHNS_NUIT = 30;
    private static final int SUPPLEMENT_TEMPS_HHNS_NUIT_PROLONGE = 20;
    private static final String PROFIL_COORDONNATEUR = "Coordonnateur";
    private static final int LIGNE_UO = 7;
    private static final int LIGNE_MATRICULE = 1;
    private static final int LIGNE_POSTE = 4;
    private static final int LIGNE_NOM = 2;
    private static final int LIGNE_PRENOM = 3;
    private static final String CLE_PROFIL_CORRESPONDANCE = "profil";

    public SuiviActiviteCD34Service() {
        this.nbLignesEnteteAgent = 0;
        this.nbLignesEnteteVehicule = 0;
    }

    @Override
    protected boolean estProfilResponsable(String[] ligne) {
        return !GLS.estVide((String)ligne[LIGNE_CODE]) && !GLS.estVide((String)ligne[0]);
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"cd34"};
    }

    @Override
    public FichierCSV getFichierCSV(String nomFichier) {
        return new FichierCSV(nomFichier, StandardCharsets.UTF_8);
    }

    @Override
    public UserExport convertirUtilisateur(String[] ligne) throws Exception {
        UserExport u = new UserExport();
        if (GLS.estVide((String)ligne[0])) {
            throw new Exception("UTILISATEUR NON INTEGRE - LE CODE / LOGIN EST NULL " + ligne[2] + " -- [" + GLS.getString((String[])ligne) + "]");
        }
        String matricule = ligne[1];
        u.setMatricule(matricule);
        u.setNom(ligne[2].concat(" ").concat(ligne[3]).concat(" (").concat(String.valueOf(GLS.getInt((String)matricule))).concat(")"));
        u.setCode(ligne[0]);
        Centre centre = null;
        if (!GLS.estVide((String)ligne[7])) {
            centre = this.getCentreParCode(ligne[7], this.ig4Dal.getCorresDelegationsCentre());
        }
        if (centre == null) {
            throw new Exception("UTILISATEUR NON INTEGRE - LE CENTRE EST NULL CENTRE - " + ligne[7] + " -- [" + GLS.getString((String[])ligne) + "]");
        }
        u.setDelegation(centre.getDelegation());
        u.setCentre(centre.getNom());
        String nomProfil = this.getProfil(ligne[4]);
        if (GLS.estVide((String)nomProfil)) {
            throw new Exception("UTILISATEUR NON INTEGRE - LE PROFIL N'EXISTE PAS - " + ligne[4] + " -- [" + GLS.getString((String[])ligne) + "]");
        }
        Profil profil = new Profil();
        profil.setName(nomProfil);
        u.setProfil(profil);
        u.setCodeServiceIg4(ligne[7]);
        u.setArchive(false);
        return u;
    }

    public String getProfil(String codeProfilExt) {
        return this.getProfil().get(codeProfilExt);
    }

    public Map<String, String> getProfil() {
        return this.ig4Dal.getCorresDynamiques().get(CLE_PROFIL_CORRESPONDANCE);
    }

    public Map<String, String> getMarques() {
        return this.ig4Dal.getCorresDynamiques().get("marque");
    }

    @Override
    public List<Mission> getMissions(Date dateDeb, Date dateFin) {
        ArrayList<Mission> missions = new ArrayList<Mission>();
        List<Mission> missionsEmbarque = this.ig4Dal.getMissionsV2(dateDeb, dateFin);
        if (!GLS.estVide(missionsEmbarque)) {
            missions.addAll(missionsEmbarque);
        }
        return missions;
    }

    @Override
    protected void archiveFichierImportUtilisateur(String fichierSource, String fichierDestination) {
        try {
            Log.debug("ARCHIVAGE UTILISATEUR -- " + fichierSource + " --> " + fichierDestination);
            Fichier.instanceOf();
            Fichier.copier((String)fichierSource, (String)fichierDestination);
        }
        catch (Exception e) {
            Log.error("ERREUR ARCHIVAGE UTILISATEUR", e);
        }
    }

    @Override
    protected void archiveFichierImportVehicule(String fichierSource, String fichierDestination) {
        try {
            Log.debug("ARCHIVAGE VEHICULE -- " + fichierSource + " --> " + fichierDestination);
            Fichier.instanceOf();
            Fichier.copier((String)fichierSource, (String)fichierDestination);
        }
        catch (Exception e) {
            Log.error("ERREUR ARCHIVAGE VEHICULE", e);
        }
    }

    @Override
    protected void verifierMarque(String[] ligne) throws Exception {
    }

    @Override
    public VehiculeExport convertirVehicule(String[] ligne) throws Exception {
        int codeMarque;
        VehiculeExport v = new VehiculeExport();
        v.setImmatriculation(ligne[LIGNE_IMMATRICULATION]);
        v.setCode(ligne[LIGNE_CODE_VEHICULE]);
        v.setDescription(ligne[LIGNE_DESCRIPTION]);
        Centre centre = null;
        if (!GLS.estVide((String)ligne[6])) {
            centre = this.getCentreParCode(ligne[6], this.ig4Dal.getCorresDelegationsCentre());
        }
        if (centre == null) {
            throw new Exception("VEHICULE NON INTEGRE - LE CENTRE EST NULL CENTRE - " + ligne[6] + " -- [" + GLS.getString((String[])ligne) + "]");
        }
        if (GLS.estVide((String)centre.getDelegation()) || GLS.estVide((String)centre.getNom())) {
            throw new Exception("VEHICULE NON INTEGRE - LE CENTRE OU LA DELEGATION EST VIDE - " + ligne[6] + ligne[6] + " -- [" + GLS.getString((String[])ligne) + "]");
        }
        v.setDelegation(centre.getDelegation());
        v.setCentre(centre.getNom());
        v.setCodeServiceIg4(v.getImmatriculation());
        String nomMarquePrism = this.getMarques().get(ligne[3]);
        try {
            codeMarque = this.adminDal.getMarqueVehicule(nomMarquePrism);
        }
        catch (Exception e) {
            Log.error("ERREUR - VEHICULE NON INTEGRE - ERREUR RECUPERATION MARQUE - " + ligne[3], e);
            codeMarque = -1;
        }
        v.setArchive(false);
        if (codeMarque == -1) {
            throw new Exception("ERREUR - VEHICULE NON INTEGRE - LA MARQUE N'EXISTE PAS EN BASE - " + ligne[LIGNE_DESCRIPTION] + " -- " + ligne[3]);
        }
        v.setType(codeMarque);
        return v;
    }

    @Override
    protected boolean archiveVehicules() {
        return this.ig4Dal.archiveVehicules(false);
    }

    @Override
    protected String genererExportCSV(List<Mission> missions) {
        if (!GLS.estVide(missions)) {
            Log.debug("NB MISSIONS - " + missions.size());
        } else {
            Log.debug("AUCUNE MISSION A EXPORTER");
        }
        return CSVUtils.genereCSVCD34(missions).replace("\"", "");
    }

    public static boolean estHorsHeureNormaleService(long t) {
        if (t > 0L) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(t);
            return SuiviActiviteCD34Service.estDateCompriseEntre(c, 12, 0, 13, 30) || SuiviActiviteCD34Service.estDateCompriseEntre(c, 17, 30, 8, 0);
        }
        return false;
    }

    public static boolean estDateCompriseEntre(Calendar c, int hdeb, int mindeb, int hfin, int minfin) {
        Calendar borneDeb = GregorianCalendar.getInstance();
        Calendar borneFin = GregorianCalendar.getInstance();
        borneDeb.setTime(c.getTime());
        borneDeb.set(11, hdeb);
        borneDeb.set(12, mindeb);
        borneFin.setTime(c.getTime());
        borneFin.set(11, hfin);
        borneFin.set(12, minfin);
        if (hdeb > hfin || hdeb == hfin && mindeb > minfin) {
            Calendar borneMin = GregorianCalendar.getInstance();
            Calendar borneMax = GregorianCalendar.getInstance();
            borneMin.setTime(c.getTime());
            borneMin.set(11, 0);
            borneMin.set(12, 0);
            borneMax.setTime(c.getTime());
            borneMax.set(11, 23);
            borneMax.set(12, 59);
            return c.after(borneDeb) && c.before(borneMax) || c.after(borneMin) && c.before(borneFin);
        }
        return c.after(borneDeb) && c.before(borneFin);
    }

    public static boolean estHeureDeNuit(long t) {
        if (t > 0L) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(t);
            return SuiviActiviteCD34Service.estDateCompriseEntre(c, 22, 0, 7, 0);
        }
        return false;
    }

    public static long getHeureFinRecalculee(ActionCentral a) {
        return SuiviActiviteCD34Service.getHeureFinRecalculee(a.getDebut(), a.getFin());
    }

    public static long getHeureFinRecalculee(long hdebut, long hfin) {
        int supplement = 0;
        long retour = hfin;
        if (hdebut > 0L && hfin <= 0L) {
            supplement = 60000;
            supplement = SuiviActiviteCD34Service.estHeureDeNuit(hdebut) ? (supplement *= 30) : (supplement *= 15);
            retour = hdebut + (long)supplement;
        } else if (SuiviActiviteCD34Service.estHorsHeureNormaleService(hfin)) {
            supplement = 60000;
            if (SuiviActiviteCD34Service.estHeureDeNuit(hfin)) {
                retour = hdebut + (long)(supplement *= 30) < hfin ? (retour += 1200000L) : hdebut + (long)supplement;
            } else if (hdebut + (long)(supplement *= 15) > hfin) {
                retour = hdebut + (long)supplement;
            }
        }
        return retour;
    }

    @Override
    protected void supprimerCorrespondanceUtilisateurs(String id) {
        this.ig4Dal.supprimerCorrespondance("ig4.corres_utilisateurs", id, " and id_prism in (select sna from prism.utilisateur where type_utilisateur = 2)");
    }

    @Override
    protected void supprimerCorrespondancesUtilisateurs() {
        this.ig4Dal.supprimerCorrespondances("ig4.corres_utilisateurs where id_prism in (select sna from prism.utilisateur where type_utilisateur = 2)");
    }
}

