/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentral.export.csv.CSVUtils;
import com.geolocsystems.prismcentral.service.SuiviActiviteService;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class SuiviActiviteCD22Service
extends SuiviActiviteService {
    private static final long serialVersionUID = 3762358758026004781L;
    private static final int LIGNE_LOGIN = 5;
    private static final int HEURE_HHNS_MIDI_DEBUT = 12;
    private static final int MINUTE_HHNS_MIDI_DEBUT = 0;
    private static final int HEURE_HHNS_MIDI_FIN = 13;
    private static final int MINUTE_HHNS_MIDI_FIN = 30;
    private static final int HEURE_HHNS_SOIR_DEBUT = 17;
    private static final int MINUTE_HHNS_SOIR_DEBUT = 30;
    private static final int HEURE_HHNS_SOIR_FIN = 8;
    private static final int MINUTE_HHNS_SOIR_FIN = 0;
    private static final int HEURE_HHNS_NUIT_DEBUT = 22;
    private static final int MINUTE_HHNS_NUIT_DEBUT = 0;
    private static final int HEURE_HHNS_NUIT_FIN = 7;
    private static final int MINUTE_HHNS_NUIT_FIN = 0;
    private static final int SUPPLEMENT_TEMPS_HHNS = 15;
    private static final int SUPPLEMENT_TEMPS_HHNS_NUIT = 30;
    private static final int SUPPLEMENT_TEMPS_HHNS_NUIT_PROLONGE = 20;
    private static final String PROFIL_COORDONNATEUR = "Coordonnateur";

    public SuiviActiviteCD22Service() {
        this.nbLignesEnteteAgent = 1;
        this.nbLignesEnteteVehicule = 1;
    }

    @Override
    protected boolean estProfilResponsable(String[] ligne) {
        return !GLS.estVide((String)ligne[LIGNE_CODE]) && !GLS.estVide((String)ligne[5]);
    }

    @Override
    public String getProfil(PrismCentralUser user, String[] ligne) {
        if (this.estProfilResponsable(ligne)) {
            return this.ig4Dal.getCorresPref().get("profil_responsable");
        }
        return this.ig4Dal.getCorresPref().get("profil_agent");
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"cd22"};
    }

    @Override
    public UserExport convertirUtilisateur(String[] ligneInit) throws Exception {
        String[] ligne = new String[ligneInit.length];
        ligne[SuiviActiviteCD22Service.LIGNE_CODE] = ligneInit[1];
        ligne[SuiviActiviteCD22Service.LIGNE_NOM] = ligneInit[2];
        ligne[SuiviActiviteCD22Service.LIGNE_PRENOM] = ligneInit[3];
        ligne[SuiviActiviteCD22Service.LIGNE_CENTRE] = ligneInit[5];
        ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION] = ligneInit[4];
        ligne[5] = ligneInit[0];
        if (!GLS.estVide((String)ligne[LIGNE_CENTRE]) && ligne[LIGNE_CENTRE].startsWith("Administration Antenne") || this.estProfilResponsable(ligne)) {
            ligne[SuiviActiviteCD22Service.LIGNE_CENTRE] = null;
        }
        if (!GLS.estVide((String)ligne[LIGNE_DELEGATION]) && ligne[LIGNE_DELEGATION].equals("DI AUTRE")) {
            ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION] = null;
        }
        return super.convertirUtilisateur(ligne);
    }

    @Override
    public List<Mission> getMissions(Date dateDeb, Date dateFin) {
        ArrayList<Mission> missions = new ArrayList<Mission>();
        List<Mission> missionsEmbarque = this.ig4Dal.getMissionsV2(dateDeb, dateFin);
        List<Mission> missionsCentral = this.ig4Dal.getMissionsCentral(new String[]{PROFIL_COORDONNATEUR}, dateDeb, dateFin);
        if (!GLS.estVide(missionsEmbarque)) {
            missions.addAll(missionsEmbarque);
        }
        if (!GLS.estVide(missionsCentral)) {
            missions.addAll(missionsCentral);
        }
        return missions;
    }

    @Override
    protected String[] convertirLigneVehicule(String[] ligneInit) {
        String[] ligne = new String[ligneInit.length > LIGNE_DELEGATION_VEHICULE + 1 ? ligneInit.length : LIGNE_DELEGATION_VEHICULE + 1];
        ligne[SuiviActiviteCD22Service.LIGNE_CODE_VEHICULE] = ligneInit[0];
        ligne[SuiviActiviteCD22Service.LIGNE_DESCRIPTION] = ligneInit[1];
        ligne[SuiviActiviteCD22Service.LIGNE_MARQUE] = ligneInit[2];
        ligne[SuiviActiviteCD22Service.LIGNE_CENTRE_VEHICULE] = ligneInit[4];
        ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION_VEHICULE] = ligneInit[3];
        if (!GLS.estVide((String)ligne[LIGNE_CENTRE]) && ligne[LIGNE_CENTRE].startsWith("Administration Antenne")) {
            ligne[SuiviActiviteCD22Service.LIGNE_CENTRE] = null;
        }
        if (!GLS.estVide((String)ligne[LIGNE_DELEGATION_VEHICULE]) && ligne[LIGNE_DELEGATION_VEHICULE].equals("DI AUTRE")) {
            ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION_VEHICULE] = null;
        }
        return ligne;
    }

    @Override
    public VehiculeExport convertirVehicule(String[] ligneInit) throws Exception {
        String[] ligne = new String[ligneInit.length > LIGNE_DELEGATION_VEHICULE + 1 ? ligneInit.length : LIGNE_DELEGATION_VEHICULE + 1];
        ligne[SuiviActiviteCD22Service.LIGNE_CODE_VEHICULE] = ligneInit[0];
        ligne[SuiviActiviteCD22Service.LIGNE_DESCRIPTION] = ligneInit[1];
        ligne[SuiviActiviteCD22Service.LIGNE_MARQUE] = ligneInit[2];
        ligne[SuiviActiviteCD22Service.LIGNE_CENTRE_VEHICULE] = ligneInit[4];
        ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION_VEHICULE] = ligneInit[3];
        if (!GLS.estVide((String)ligne[LIGNE_CENTRE]) && ligne[LIGNE_CENTRE].startsWith("Administration Antenne")) {
            ligne[SuiviActiviteCD22Service.LIGNE_CENTRE] = null;
        }
        if (!GLS.estVide((String)ligne[LIGNE_DELEGATION_VEHICULE]) && ligne[LIGNE_DELEGATION_VEHICULE].equals("DI AUTRE")) {
            ligne[SuiviActiviteCD22Service.LIGNE_DELEGATION_VEHICULE] = null;
        }
        return super.convertirVehicule(ligne);
    }

    @Override
    protected boolean archiveVehicules() {
        return this.ig4Dal.archiveVehicules(false);
    }

    @Override
    protected String genererExportCSV(List<Mission> missions) {
        return CSVUtils.genereCSVCD22(missions).replace("\"", "");
    }

    public static boolean estHorsHeureNormaleService(long t) {
        if (t > 0L) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(t);
            return SuiviActiviteCD22Service.estDateCompriseEntre(c, 12, 0, 13, 30) || SuiviActiviteCD22Service.estDateCompriseEntre(c, 17, 30, 8, 0);
        }
        return false;
    }

    public static boolean estDateCompriseEntre(Calendar c, int hdeb, int mindeb, int hfin, int minfin) {
        Calendar borneDeb = GregorianCalendar.getInstance();
        Calendar borneFin = GregorianCalendar.getInstance();
        borneDeb.setTime(c.getTime());
        borneDeb.set(11, hdeb);
        borneDeb.set(12, mindeb);
        borneFin.setTime(c.getTime());
        borneFin.set(11, hfin);
        borneFin.set(12, minfin);
        if (hdeb > hfin || hdeb == hfin && mindeb > minfin) {
            Calendar borneMin = GregorianCalendar.getInstance();
            Calendar borneMax = GregorianCalendar.getInstance();
            borneMin.setTime(c.getTime());
            borneMin.set(11, 0);
            borneMin.set(12, 0);
            borneMax.setTime(c.getTime());
            borneMax.set(11, 23);
            borneMax.set(12, 59);
            return c.after(borneDeb) && c.before(borneMax) || c.after(borneMin) && c.before(borneFin);
        }
        return c.after(borneDeb) && c.before(borneFin);
    }

    public static boolean estHeureDeNuit(long t) {
        if (t > 0L) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(t);
            return SuiviActiviteCD22Service.estDateCompriseEntre(c, 22, 0, 7, 0);
        }
        return false;
    }

    public static long getHeureFinRecalculee(ActionCentral a) {
        return SuiviActiviteCD22Service.getHeureFinRecalculee(a.getDebut(), a.getFin());
    }

    public static long getHeureFinRecalculee(long hdebut, long hfin) {
        int supplement = 0;
        long retour = hfin;
        if (hdebut > 0L && hfin <= 0L) {
            supplement = 60000;
            supplement = SuiviActiviteCD22Service.estHeureDeNuit(hdebut) ? (supplement *= 30) : (supplement *= 15);
            retour = hdebut + (long)supplement;
        } else if (SuiviActiviteCD22Service.estHorsHeureNormaleService(hfin)) {
            supplement = 60000;
            if (SuiviActiviteCD22Service.estHeureDeNuit(hfin)) {
                retour = hdebut + (long)(supplement *= 30) < hfin ? (retour += 1200000L) : hdebut + (long)supplement;
            } else if (hdebut + (long)(supplement *= 15) > hfin) {
                retour = hdebut + (long)supplement;
            }
        }
        return retour;
    }

    @Override
    protected void supprimerCorrespondanceUtilisateurs(String id) {
        this.ig4Dal.supprimerCorrespondance("ig4.corres_utilisateurs", id, " and id_prism in (select sna from prism.utilisateur where type_utilisateur = 2)");
    }

    @Override
    protected void supprimerCorrespondancesUtilisateurs() {
        this.ig4Dal.supprimerCorrespondances("ig4.corres_utilisateurs where id_prism in (select sna from prism.utilisateur where type_utilisateur = 2)");
    }
}

