/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Util;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.ImportEvenementService;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ImportEvenementUsagersCD26Service
extends ImportEvenementService {
    private static final Logger LOGGER = Logger.getLogger(ImportEvenementUsagersCD26Service.class);
    public static final String TYPE_IMPORT_CSV = "csv";
    public static final String TYPE_IMPORT_WEBSERVICE = "webservice";
    public static final int APPLI_USAGER_DISTANCE_RECHERCHE_DEFAUT = 300;
    private static final int LIGNE_ID = 0;
    private static final int LIGNE_X = 1;
    private static final int LIGNE_Y = 2;
    private static final int LIGNE_DATE_HEURE = 3;
    private static final int LIGNE_TYPE_EVT = 4;
    private static final int LIGNE_CED = 5;
    private static final int LIGNE_FORMAT_PHOTO = 6;
    private static final int LIGNE_PHOTO = 7;
    private long maxDateSignalement;
    private long minDateSignalement;
    protected Map<String, String> corresCentre;
    protected static String FICHIER_IMPORT_JE_SIGNALE = "export_jesignale.csv";
    private static final long serialVersionUID = -4071873117796838664L;
    protected static String NB_SIGNALEMENT_USAGER = "nbSignalementUsager";

    public ImportEvenementUsagersCD26Service() {
        this.nbLignesEntete = 0;
    }

    @Override
    protected void init() {
        super.init();
        this.corresCentre = this.importEvenementDal.getCorrespondance("centre");
        if (this.corresCentre == null) {
            this.corresCentre = new HashMap<String, String>();
        }
    }

    @Override
    public String[] getZonesRoutiere() {
        return new String[]{"cd26"};
    }

    @Override
    protected String getCodeUtilisateur() {
        return "#USAGERS";
    }

    @Override
    protected Nature getNatureEvenement(String[] ligne) {
        return this.service.getNatureFromDescription((String)this.corresDescriptions.get(ligne[LIGNE_DESCRIPTION]));
    }

    protected Nature getNatureEvenement(String codeDescription) {
        return this.service.getNatureFromDescription(codeDescription);
    }

    private List<Evenement> getEvenementsProches(String description, Position point) {
        ArrayList<Evenement> evenements = new ArrayList<Evenement>();
        IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.moduleMetier(null, null, (int)0);
        ArrayList<String> descriptions = new ArrayList<String>(1);
        descriptions.add(description);
        f.descriptions = descriptions;
        f.distance = this.referentielDal.getConfiguration().getInt("appliusager.distance", 300);
        f.point = point;
        List situations = this.service.getEvenements(f, null);
        if (!GLS.estVide((List)situations)) {
            for (Situation s : situations) {
                evenements.addAll(s.getEvenements());
            }
        }
        return evenements;
    }

    private Evenement getEvenementProche(String description, Position p) {
        List<Evenement> evenements = this.getEvenementsProches(description, p);
        Evenement lePlusProche = null;
        if (!GLS.estVide(evenements)) {
            if (evenements.size() == 1) {
                lePlusProche = evenements.get(0);
            } else {
                double distancePlusProche = Double.MAX_VALUE;
                for (Evenement evt : evenements) {
                    double distance = Geometry.distanceLL((double)p.getX(), (double)p.getY(), (double)evt.getLocalisation().getPositionDebut().getX(), (double)evt.getLocalisation().getPositionDebut().getY());
                    if (!(distance < distancePlusProche)) continue;
                    distancePlusProche = distance;
                    lePlusProche = evt;
                }
            }
        }
        return lePlusProche;
    }

    @Override
    protected boolean estLigneValide(String[] ligne) {
        return ligne != null && ligne.length >= 6;
    }

    @Override
    protected SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }

    @Override
    public Evenement ligneToEvenement(String[] ligne) throws Exception {
        long dateSignalement = this.getDateFormat().parse(ligne[3]).getTime();
        if (dateSignalement > this.minDateSignalement) {
            Nature n;
            Evenement evenement;
            Log.debug("INTEGRATION LIGNE " + ligne[0] + " - " + ligne[1] + " - " + ligne[2] + " - " + ligne[3] + " - " + ligne[4] + " - " + ligne[5]);
            String description = (String)this.corresDescriptions.get(ligne[4]);
            Position pointDebut = new Position();
            pointDebut.setX((float)GLS.getDouble((String)ligne[1], (double)0.0));
            pointDebut.setY((float)GLS.getDouble((String)ligne[2], (double)0.0));
            this.service.getNatures();
            Evenement evenementDejaExistantProche = this.getEvenementProche(description, pointDebut);
            ArrayList<Object> photos = new ArrayList<Object>();
            if (evenementDejaExistantProche != null) {
                evenement = evenementDejaExistantProche;
                evenement.setNumVersion(evenement.getNumVersion() + 1);
                evenement.setDateMaj(dateSignalement);
                n = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
                for (String nomPhoto : evenement.getPhotos()) {
                    photos.add(this.service.getPhoto(nomPhoto));
                }
            } else {
                evenement = new Evenement();
                n = (Nature)DeepCopy.copy((Object)this.getNatureEvenement(description));
                evenement.setValeurNature(n.extraireValeurs());
                ValeurChampCollectionChoixUnique d = evenement.getValeurNature().getDescription();
                ValeurChampLocalisation l = evenement.getValeurNature().getLocalisation();
                l.setPositionDebut(pointDebut);
                List listeDesc = (List)this.service.getDescriptionsNatureMap().get(n.getCode());
                evenement.setCodeUtilisateur("#USAGERS");
                evenement.setType(2);
                Centre c = MetierCommun.getCentreParCode((List)this.service.getDelegations(), (String)ligne[5]);
                evenement.setDateCreation(dateSignalement);
                evenement.setDateMaj(Calendar.getInstance().getTimeInMillis());
                int iDesc = MetierCommun.getIndiceObjetListe((List)listeDesc, (Object)description);
                if (iDesc <= -1) {
                    LOGGER.error((Object)("erreur description nature impossible \u00e0 trouver " + ligne[0] + " " + ligne[LIGNE_DESCRIPTION]));
                    throw new RuntimeException();
                }
                IDescription desc = (IDescription)listeDesc.get(iDesc);
                if (c != null) {
                    evenement.setDistrict(c.getDelegation());
                    evenement.setCei(c.getNom());
                } else {
                    LOGGER.error((Object)("ERREUR CENTRE " + ligne[5] + " -- " + ligne));
                }
                d.setIndexSelectionnee(iDesc);
                d.setValeur(desc.getLibelle());
                evenement.setNumVersion(1);
            }
            evenement.setAnnule(false);
            evenement.setTermine(false);
            if (!GLS.estVide((String)ligne[7])) {
                if (GLS.egal((String)ligne[6], (String)"jpeg") || GLS.egal((String)ligne[6], (String)"jpg")) {
                    byte[] photo = this.compresserPhoto(Base64.getDecoder().decode(ligne[7]));
                    if (photo != null) {
                        photos.add(photo);
                        evenement.getPhotos().add(Util.getHashPhoto(photo));
                    } else {
                        Log.error("ERREUR PHOTO INVALIDE" + ligne[0] + " ");
                    }
                    Util.sauvegarderPhotos(this.service, evenement, photos);
                } else {
                    Log.error("FORMAT PHOTO " + ligne[0] + " " + ligne[6] + " NOM PRIS EN CHARGE");
                }
            }
            evenement.setDateMaj(Calendar.getInstance().getTimeInMillis());
            this.majEvenement(n, evenement, ligne);
            if (dateSignalement > this.maxDateSignalement) {
                this.maxDateSignalement = dateSignalement;
            }
            return evenement;
        }
        throw new Exception("\u00e9v\u00e8nement d\u00e9j\u00e0 int\u00e9gr\u00e9 - " + ligne[0] + " - " + dateSignalement + " < " + this.minDateSignalement);
    }

    private byte[] compresserPhoto(byte[] bPhoto) {
        try {
            BufferedImage src = ImageIO.read(new ByteArrayInputStream(bPhoto));
            int height = 640;
            int width = (int)((double)height * (1.0 * (double)src.getWidth() / (double)src.getHeight()));
            BufferedImage resizedImage = new BufferedImage(width, height, src.getType());
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(src, 0, 0, width, height, null);
            g.dispose();
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            return GLS.getImagesBytes((Image)resizedImage);
        }
        catch (IOException e) {
            Log.error("Erreur cr\u00e9ation miniature", e);
            return bPhoto;
        }
    }

    private Image convert(String image) throws IOException {
        byte[] data = Base64.getDecoder().decode(image);
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        BufferedImage bImage2 = ImageIO.read(bis);
        ImageIO.write((RenderedImage)bImage2, "jpg", new File("output.jpg"));
        return bImage2;
    }

    @Override
    protected String[] getListeChampsMaj() {
        return null;
    }

    @Override
    protected void cloturerEvenements(MainCourante mc, HashSet<String> evtMaj) {
        IBusinessService.EvenementFiltre filtreSql2 = IBusinessService.EvenementFiltre.getVersionActive(null, null);
        ArrayList<String> nautres = new ArrayList<String>();
        nautres.add("chan");
        filtreSql2.nature = nautres;
        filtreSql2.annules = 0;
        filtreSql2.termines = 0;
        List listeSituation2 = this.service.getEvenements(filtreSql2, null);
        for (Situation situation : listeSituation2) {
            for (Evenement evtTemp : situation.getEvenements()) {
                try {
                    ValeurChampTexte v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evtTemp.getValeurNature().getValeurs(), (String)"");
                    if (GLS.estVide((String)v.getValeur()) || evtMaj.contains(evtTemp.getIdReference())) continue;
                    this.cloturerEvenement(mc, evtTemp);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    @Override
    protected void majEvenement(Nature n, Evenement evenement, String[] ligne) {
        try {
            ValeurChampTexte v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)NB_SIGNALEMENT_USAGER);
            String ancienneValeur = v.getValeur();
            v.setValeur(GLS.getString((Object)(GLS.getInt((String)ancienneValeur) + 1)));
        }
        catch (Exception e) {
            LOGGER.error((Object)NB_SIGNALEMENT_USAGER, (Throwable)e);
        }
    }

    @Override
    protected String getNomFichierImport() {
        try {
            if (this.referentielDal.getConfiguration().containsKey((Object)"appliusager.nomfichier")) {
                FICHIER_IMPORT_JE_SIGNALE = this.referentielDal.getConfiguration().getString("appliusager.nomfichier");
            }
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        return FICHIER_IMPORT_JE_SIGNALE;
    }

    @Override
    public boolean importation(List<Partenaire> partenairesATraiter) {
        try {
            if (this.referentielDal.getConfiguration().containsKey((Object)"appliusager.nblignesentete")) {
                this.nbLignesEntete = this.referentielDal.getConfiguration().getInt("appliusager.nblignesentete", this.nbLignesEntete);
            }
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        try {
            if (!GLS.estVide(partenairesATraiter)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                    if (!new File(partenaire.getRepertoireReception()).exists()) {
                        new File(partenaire.getRepertoireReception()).mkdirs();
                    }
                    this.maxDateSignalement = 0L;
                    this.minDateSignalement = partenaire.getDernierTransfert() != null ? partenaire.getDernierTransfert().getTime() : 0L;
                    this.importEvenementsFichier(partenaire.getRepertoireReception().concat(this.getNomFichierImport()));
                    if (this.maxDateSignalement <= 0L) continue;
                    this.service.miseAjourPartenaire(partenaire, new Date(this.maxDateSignalement));
                }
            }
        }
        catch (Exception e) {
            Log.error("ERREUR IMPORT APPLI USAGERS", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean importEvenementsFichier(String fichierCSV) {
        this.timeStart = Calendar.getInstance().getTimeInMillis();
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV);
            f.setNbLignesEntete(this.nbLignesEntete);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            MainCourante mc = MetierCommun.genereMainCourante((String)"#USAGERS", (String)"#USAGERS");
            PrismCentralUser utilisateurUsager = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
            this.service.verificationMainCourante(utilisateurUsager, mc, 0);
            for (String[] ligne : f.values()) {
                if (this.estLigneValide(ligne)) {
                    try {
                        Evenement evenement = this.ligneToEvenement(ligne);
                        PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(evenement.getCodeUtilisateur());
                        this.sauvegarder(evenement, utilisateur, mc);
                    }
                    catch (Exception e) {
                        Log.error("ERREUR IMPORT EVENEMENT " + ligne[0] + " " + e.getMessage(), e);
                    }
                    continue;
                }
                Log.debug("LIGNE NON INTEGREE " + ligne);
            }
            return true;
        }
        return false;
    }

    @Override
    public void sauvegarder(List<Evenement> listeEvts) {
        LOGGER.debug((Object)"Debut");
        try {
            if (listeEvts != null && listeEvts.size() > 0) {
                MainCourante mc = MetierCommun.genereMainCourante((String)"#USAGERS", (String)"#USAGERS");
                PrismCentralUser utilisateurUsager = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
                this.service.verificationMainCourante(utilisateurUsager, mc, 0);
                for (Evenement evenementTemp : listeEvts) {
                    PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(evenementTemp.getCodeUtilisateur());
                    this.sauvegarder(evenementTemp, utilisateur, mc);
                }
                this.service.deconnexion(mc);
            } else {
                LOGGER.debug((Object)"Pas d'\u00e9v\u00e9nement \u00e0 synchroniser");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Ev\u00e9nement non cr\u00e9\u00e9", (Throwable)e);
        }
    }

    @Override
    public void sauvegarder(Evenement evenement, PrismCentralUser utilisateur, MainCourante mc) {
        try {
            EvenementASauvegarder eas = null;
            evenement.setMainCourante(mc);
            eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evenement, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)true);
            InfoTerritoire info = new InfoTerritoire();
            info.setCentre(evenement.getCei());
            info.setDelegation(evenement.getDistrict());
            eas.setInfoTerritoire(info);
            this.traitementEvenement(eas);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la synchronisation ", (Throwable)e);
        }
    }

    protected void importEvenementsWebService(String url) {
    }
}

