/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prism.localisation.BouchonCartoService;
import com.geolocsystems.prism.localisation.CartojCartoService;
import com.geolocsystems.prism.localisation.ICartoServiceData;
import com.geolocsystems.prism.localisation.ServletCartoService;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IImportEvenementDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOConfigurationException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.IEvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.geolocsystems.prismcentral.data.IImportEvenementService;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentral.maincourante.CommentaireComposantFactory2;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import gls.outils.GLS;
import gls.outils.Util;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportEvenementService
implements IImportEvenementService {
    private static final Logger LOGGER = Logger.getLogger(ImportEvenementService.class);
    private static final String DRIVER_POSTGRES = "org.postgresql.Driver";
    private static final long serialVersionUID = -6037920796012512785L;
    protected IReferentielDAO referentielDal;
    protected IImportEvenementDAO importEvenementDal;
    protected IBusinessService service = new BusinessServiceDAO();
    protected Extension config;
    private static ICartoServiceData cartoInstance;
    protected static String FICHIER_IMPORT_LITTERALIS;
    protected static int LIGNE_IDEVT;
    protected static int LIGNE_DESCRIPTION;
    protected static int LIGNE_AXE;
    protected static int LIGNE_PRDEB;
    protected static int LIGNE_ABSDEB;
    protected static int LIGNE_PRFIN;
    protected static int LIGNE_ABSFIN;
    protected static int LIGNE_COMMUNE;
    protected static int LIGNE_DATEDEB;
    protected static int LIGNE_DATEFIN;
    protected int nbLignesEntete = 0;
    private static final String CARTO_TYPE_BOUCHON = "bouchon";
    private static final String CARTO_TYPE_SERVLET = "servlet";
    private static final String CARTO_TYPE_CARTOJ = "cartoj";
    protected Map<String, String> corresDescriptions;
    IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();
    IEvenementsDAO evtsDAO;
    protected long timeStart;
    private IUserDAO userDAO;
    private IVehiculeDAO vehiculeDAO;
    private IMcigDAO mcigDAO;

    public ImportEvenementService() {
        this.referentielDal = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.userDAO = DAOFactory.getInstance().getUserDAO(this.referentielDal);
        this.vehiculeDAO = DAOFactory.getInstance().getVehiculeDAO(this.service);
        this.mcigDAO = DAOFactory.getInstance().getMcigDAO(this.referentielDal, this.vehiculeDAO);
        this.evtsDAO = DAOFactory.getInstance().getEvenementsDAO(this.referentielDal, this.userDAO, this.mcigDAO);
        this.importEvenementDal = DAOFactory.getInstance().getImportEvenementDAO(this.referentielDal, this.evtsDAO);
        this.config = this.service.getConfiguration();
        this.init();
    }

    protected void init() {
        this.corresDescriptions = this.importEvenementDal.getCorrespondance("description");
        if (this.corresDescriptions == null) {
            this.corresDescriptions = new HashMap<String, String>();
        }
    }

    public String[] getZonesRoutiere() {
        return null;
    }

    public boolean estZoneValide(String zone) {
        if (!GLS.estVide((String)zone) && !this.estImportParDefaut()) {
            return GLS.estDansLaListe((String[])this.getZonesRoutiere(), (String)zone);
        }
        return false;
    }

    public boolean estImportParDefaut() {
        return GLS.estVide((String[])this.getZonesRoutiere());
    }

    protected String getNomFichierImport() {
        try {
            if (this.referentielDal.getConfiguration().containsKey((Object)"litteralis.nomfichier")) {
                FICHIER_IMPORT_LITTERALIS = this.referentielDal.getConfiguration().getString("litteralis.nomfichier");
            }
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        return FICHIER_IMPORT_LITTERALIS;
    }

    public boolean importation(List<Partenaire> partenairesATraiter) {
        try {
            if (this.referentielDal.getConfiguration().containsKey((Object)"litteralis.nblignesentete")) {
                this.nbLignesEntete = this.referentielDal.getConfiguration().getInt("litteralis.nblignesentete", this.nbLignesEntete);
            }
        }
        catch (Exception e) {
            Log.debug("PAs de modification noms fichiers");
        }
        try {
            if (!GLS.estVide(partenairesATraiter)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    if (partenaire.isTypeEchangeFichier()) {
                        Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                        if (!new File(partenaire.getRepertoireReception()).exists()) {
                            new File(partenaire.getRepertoireReception()).mkdirs();
                        }
                        this.importEvenementsFichier(partenaire.getRepertoireReception().concat(this.getNomFichierImport()));
                        this.miseAJourPartenaire();
                        continue;
                    }
                    if (!partenaire.isTypeEchangeBDD()) continue;
                    this.importEvenementsBDD(this.getConnexion(partenaire));
                    this.miseAJourPartenaire();
                }
            }
        }
        catch (Exception e) {
            Log.error("ERREUR IMPORT LITTERALIS", e);
            return false;
        }
        return true;
    }

    protected void miseAJourPartenaire() {
    }

    protected boolean estLigneValide(String[] ligne) {
        return true;
    }

    protected Connection getConnexion(Partenaire p) throws SQLException {
        String url = p.getNomServeur();
        String driverClassName = DRIVER_POSTGRES;
        String password = p.getPassword();
        String username = p.getLogin();
        if (!GLS.estVide((String)driverClassName)) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DAOConfigurationException("Driver class '" + driverClassName + "' is missing in classpath.", e);
            }
        }
        return DriverManager.getConnection(url, username, password);
    }

    public void importEvenementsBDD(Connection connection) {
    }

    public boolean importEvenementsFichier(String fichierCSV) {
        this.timeStart = Calendar.getInstance().getTimeInMillis();
        FichierCSV f = null;
        if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
            f = new FichierCSV(fichierCSV);
            f.setNbLignesEntete(this.nbLignesEntete);
        } else {
            Log.error("ERREUR fichier impossible \u00e0 ouvrir");
        }
        if (f != null && f.isReady()) {
            Log.info("D\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            int indice = 0;
            try {
                f.setIndiceChampCle(indice);
                f.charger();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            ArrayList<Evenement> evenements = new ArrayList<Evenement>();
            for (String[] ligne : f.values()) {
                if (this.estLigneValide(ligne)) {
                    try {
                        evenements.add(this.ligneToEvenement(ligne));
                    }
                    catch (Exception e) {
                        Log.error("ERREUR IMPORT EVENEMENT " + ligne[0] + " " + e.getMessage());
                    }
                    continue;
                }
                Log.debug("LIGNE NON INTEGREE " + ligne);
            }
            if (evenements.size() > 0) {
                this.sauvegarder(evenements);
                return true;
            }
        }
        return false;
    }

    public void importEvenements(List<String[]> valeurs) {
        ArrayList<Evenement> evenements = new ArrayList<Evenement>();
        for (String[] ligne : valeurs) {
            try {
                evenements.add(this.ligneToEvenement(ligne));
            }
            catch (Exception e) {
                Log.error("ERREUR IMPORT EVENEMENT " + e.getMessage());
            }
        }
        if (evenements.size() > 0) {
            this.sauvegarder(evenements);
        }
    }

    protected SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    protected String getCodeUtilisateur() {
        return "litteralis";
    }

    protected void cloturerEvenement(MainCourante mc, Evenement e) {
        e.setDateMaj(System.currentTimeMillis());
        e.setCodeUtilisateur(this.getCodeUtilisateur());
        e.setMainCourante(mc);
        e.setTermine(true);
        e.setProgramme(false);
        this.service.sauvegarderEvenement(EvenementASauvegarder.aSauvegarder((Evenement)e, null, null, (Extension)this.service.getConfiguration(), (boolean)false, (boolean)false));
        LOGGER.info((Object)("Evenement annul\u00e9 : " + e.toString()));
    }

    protected void cloturerEvenements(MainCourante mc, HashSet<String> evtMaj) {
    }

    public void sauvegarder(List<Evenement> listeEvts) {
        LOGGER.debug((Object)"Debut");
        try {
            if (listeEvts != null && listeEvts.size() > 0) {
                HashSet<String> evtMaj = new HashSet<String>();
                PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(this.getCodeUtilisateur());
                MainCourante mc = this.service.creerMainCouranteCentral(utilisateur);
                for (Evenement evenementTemp : listeEvts) {
                    this.sauvegarder(evenementTemp, utilisateur, mc);
                    evtMaj.add(evenementTemp.getIdReference());
                }
                this.cloturerEvenements(mc, evtMaj);
                this.service.deconnexion(mc);
            } else {
                LOGGER.debug((Object)"Pas d'\u00e9v\u00e9nement \u00e0 synchroniser");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Ev\u00e9nement non cr\u00e9\u00e9", (Throwable)e);
        }
    }

    protected Nature getNatureEvenement(String[] ligne) {
        return (Nature)this.service.getNatures().get("chan");
    }

    protected void majEvenement(Nature n, Evenement evenement, String[] ligne) {
    }

    public Evenement ligneToEvenement(String[] ligne) throws Exception {
        int iDesc;
        Evenement evenement = new Evenement();
        Nature n = (Nature)DeepCopy.copy((Object)this.getNatureEvenement(ligne));
        evenement.setValeurNature(n.extraireValeurs());
        ValeurChampCollectionChoixUnique d = evenement.getValeurNature().getDescription();
        ValeurChampLocalisation l = evenement.getValeurNature().getLocalisation();
        List listeDesc = (List)this.service.getDescriptionsNatureMap().get(n.getCode());
        String description = this.corresDescriptions.get(ligne[LIGNE_DESCRIPTION]);
        if (description == null) {
            description = ligne[LIGNE_DESCRIPTION];
        }
        if ((iDesc = MetierCommun.getIndiceObjetListe((List)listeDesc, (Object)description)) <= -1) {
            LOGGER.error((Object)("erreur description nature impossible \u00e0 trouver " + ligne[LIGNE_DESCRIPTION]));
            throw new RuntimeException();
        }
        IDescription desc = (IDescription)listeDesc.get(iDesc);
        d.setIndexSelectionnee(iDesc);
        d.setValeur(desc.getLibelle());
        evenement.setAnnule(false);
        evenement.setTermine(false);
        evenement.setDateCreation(this.getDateFormat().parse(ligne[LIGNE_DATEDEB]).getTime());
        evenement.setDateMaj(Calendar.getInstance().getTimeInMillis());
        evenement.setDateFin(this.getDateFormat().parse(ligne[LIGNE_DATEFIN]).getTime());
        evenement.setIdSituation(ligne[LIGNE_IDEVT]);
        evenement.setIdReference(ligne[LIGNE_IDEVT]);
        evenement.setCodeEvenement(ligne[LIGNE_IDEVT]);
        evenement.setNumVersion(1);
        l.setAxe(ligne[LIGNE_AXE]);
        l.setCommune(ligne[LIGNE_COMMUNE]);
        l.setPrDebut(GLS.getInt((String)ligne[LIGNE_PRDEB]));
        l.setAbsPrDebut(GLS.getInt((String)ligne[LIGNE_ABSDEB]));
        if (Util.isNullOrEmpty((String)ligne[LIGNE_PRFIN]) || Util.isNullOrEmpty((String)ligne[LIGNE_ABSFIN])) {
            l.setPrFin(-1);
            l.setAbsPrFin(-1);
        } else {
            l.setPrFin(GLS.getInt((String)ligne[LIGNE_PRFIN]));
            l.setAbsPrFin(GLS.getInt((String)ligne[LIGNE_ABSFIN]));
        }
        this.majEvenement(n, evenement, ligne);
        return evenement;
    }

    protected String[] getListeChampsMaj() {
        return new String[0];
    }

    protected boolean evtsDifferents(Evenement nouveau, Evenement ancien, Nature n) {
        boolean modifie = false;
        Map<String, Nature> natures = this.referentielDal.getNatureMap();
        if (!ancien.getValeurNature().getDescription().getValeur().equals(nouveau.getValeurNature().getDescription().getValeur())) {
            modifie = true;
        }
        if (ancien.getValeurNature().getLocalisation().getAbsPrDebut() != nouveau.getValeurNature().getLocalisation().getAbsPrDebut() || ancien.getValeurNature().getLocalisation().getPrDebut() != nouveau.getValeurNature().getLocalisation().getPrDebut() || ancien.getValeurNature().getLocalisation().getAbsPrFin() != nouveau.getValeurNature().getLocalisation().getAbsPrFin() || ancien.getValeurNature().getLocalisation().getPrFin() != nouveau.getValeurNature().getLocalisation().getPrFin()) {
            modifie = true;
        }
        if (ancien.getDateFin() != nouveau.getDateFin()) {
            modifie = true;
        }
        if (ancien.getDateCreation() != nouveau.getDateCreation()) {
            modifie = true;
        }
        CommentaireComposantFactory2 factory = new CommentaireComposantFactory2();
        Nature nat = (Nature)DeepCopy.copy((Object)natures.get(n.getCode()));
        nat.chargerValeurs(nouveau.getValeurNature());
        Map<String, ChampCSV> mapNouvellesValeurs = CommentaireComposantFactory2.getMapViewCommentaire(nat, factory);
        nat = null;
        nat = (Nature)DeepCopy.copy((Object)natures.get(n.getCode()));
        nat.chargerValeurs(ancien.getValeurNature());
        Map<String, ChampCSV> mapAnciennesValeurs = CommentaireComposantFactory2.getMapViewCommentaire(nat, factory);
        for (String k : mapNouvellesValeurs.keySet()) {
            ChampCSV newVal = mapNouvellesValeurs.get(k);
            ChampCSV oldVal = mapAnciennesValeurs.get(k);
            if (!GLS.estVide((String)newVal.getValeur())) {
                if (!mapAnciennesValeurs.containsKey(k)) {
                    modifie = true;
                    continue;
                }
                if (GLS.egal((String)newVal.getValeur(), (String)oldVal.getValeur())) continue;
                modifie = true;
                continue;
            }
            if (!mapAnciennesValeurs.containsKey(k) || GLS.estVide((String)oldVal.getValeur())) continue;
            modifie = true;
        }
        for (String k : mapAnciennesValeurs.keySet()) {
            if (GLS.estVide((String)mapAnciennesValeurs.get(k).getValeur()) || mapNouvellesValeurs.containsKey(k)) continue;
            modifie = true;
        }
        return modifie;
    }

    public void sauvegarder(Evenement evenement, PrismCentralUser utilisateur, MainCourante mc) {
        block13: {
            try {
                Evenement evtBDD = null;
                if (!Util.isNullOrEmpty((String)evenement.getIdReference())) {
                    IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, (String)evenement.getIdReference());
                    List listeSituation = this.service.getEvenements(filtreSql, null);
                    for (Situation situation : listeSituation) {
                        Iterator<Object> iterator = situation.getEvenements().iterator();
                        while (iterator.hasNext()) {
                            Evenement evtTemp;
                            evtBDD = evtTemp = (Evenement)iterator.next();
                        }
                    }
                }
                EvenementASauvegarder eas = null;
                if (evtBDD == null) {
                    evenement.setCodeUtilisateur(utilisateur.getCode());
                    evenement.setMainCourante(mc);
                    eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evenement, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)true);
                } else {
                    Nature versionActive = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
                    if (this.evtsDifferents(evenement, evtBDD, versionActive)) {
                        String[] infosMaj;
                        versionActive.chargerValeurs(evtBDD.getValeurNature());
                        Nature nouvelleVersion = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
                        nouvelleVersion.chargerValeurs(evenement.getValeurNature());
                        Map champsNouvelleVersion = MetierCommun.getChamps((Nature)nouvelleVersion);
                        Map champsVersionActive = MetierCommun.getChamps((Nature)versionActive);
                        for (String champAModifier : infosMaj = this.getListeChampsMaj()) {
                            if (!champsNouvelleVersion.containsKey(champAModifier) || !champsVersionActive.containsKey(champAModifier)) continue;
                            Champ c = (Champ)champsVersionActive.get(champAModifier);
                            ValeurChamp v = ((Champ)champsNouvelleVersion.get(champAModifier)).getValeurChamp();
                            c.setValeurChamp(v);
                        }
                        evtBDD.setValeurNature(versionActive.extraireValeurs());
                        evtBDD.getValeurNature().setDescription(evenement.getValeurNature().getDescription());
                        evtBDD.getValeurNature().setLocalisation(evenement.getValeurNature().getLocalisation());
                        evtBDD.setAnnule(evenement.isAnnule());
                        evtBDD.setTermine(evenement.isTermine());
                        evtBDD.setNumVersion(evenement.getNumVersion());
                        evtBDD.setDateCreation(evenement.getDateCreation());
                        evtBDD.setDateFin(evenement.getDateFin());
                        evtBDD.setDateMaj(evenement.getDateMaj());
                        evtBDD.setCodeUtilisateur(utilisateur.getCode());
                        evtBDD.setMainCourante(mc);
                        evtBDD.setEtat(1);
                        eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evtBDD, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)false);
                    }
                }
                if (eas == null) break block13;
                if (LOGGER.isDebugEnabled()) {
                    try {
                        LOGGER.debug((Object)("Evt sauvegard\u00e9 : " + eas.getEvenement().toString()));
                        Nature n = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
                        n.chargerValeurs(evenement.getValeurNature());
                        HashMap attributsEvenements = MetierCommun.convertirAttributs((Nature)n, (Evenement)evenement);
                        StringBuffer sb = new StringBuffer();
                        for (String cle : attributsEvenements.keySet()) {
                            sb.append(cle);
                            sb.append("=");
                            sb.append((String)attributsEvenements.get(cle));
                            sb.append(";");
                        }
                        LOGGER.debug((Object)sb.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.traitementEvenement(eas);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Erreur lors de la synchronisation ", (Throwable)e);
            }
        }
    }

    public void traitementEvenement(EvenementASauvegarder eas) {
        Evenement evenement = eas.getEvenement();
        LOGGER.debug((Object)("R\u00e9ception d'un \u00e9v\u00e8nement " + evenement.getIdSituation() + " -- " + evenement.getIdReference()));
        if (evenement.getEtat() != 2) {
            try {
                ValeurChampLocalisation vcl = evenement.getLocalisation();
                boolean ponctuel = true;
                if (vcl.getPrFin() != -1 && vcl.getAbsPrFin() != -1) {
                    ponctuel = false;
                }
                this.getCartoService().localisation(vcl);
                if (ponctuel) {
                    vcl.setAbsAdresseFin(-1);
                    vcl.setPrFin(-1);
                }
                evenement.setErreur(null);
            }
            catch (ICartoService.LocalisationException e) {
                LOGGER.error((Object)"", (Throwable)e);
                evenement.setErreur(PrismI18n.getString(e.getErreurI18n()));
            }
            catch (Throwable e) {
                LOGGER.error((Object)"", e);
                evenement.setErreur("ERREUR INCONNUE LOCALISATION");
            }
        }
        LOGGER.debug((Object)"#--> Save evt");
        this.service.sauvegarderEvenement((IEvenementASauvegarder)eas);
    }

    public ICartoServiceData getCartoService() {
        if (cartoInstance == null) {
            String type;
            switch (type = ConfigurationFactory.getInstance().get("cartoservice.type")) {
                case "bouchon": {
                    cartoInstance = new BouchonCartoService();
                    break;
                }
                case "cartoj": {
                    cartoInstance = new CartojCartoService(this.config, this.service.getCaracteristiquesRoute());
                    break;
                }
                case "servlet": {
                    cartoInstance = new ServletCartoService();
                    break;
                }
                default: {
                    throw new PrismConfigurationError("Type de business service inconnu : " + type);
                }
            }
        }
        return cartoInstance;
    }

    static {
        FICHIER_IMPORT_LITTERALIS = "EXPORT_LITTERALIS-PRISM.csv";
        LIGNE_IDEVT = 0;
        LIGNE_DESCRIPTION = 9;
        LIGNE_AXE = 1;
        LIGNE_PRDEB = 2;
        LIGNE_ABSDEB = 3;
        LIGNE_PRFIN = 4;
        LIGNE_ABSFIN = 5;
        LIGNE_COMMUNE = 6;
        LIGNE_DATEDEB = 7;
        LIGNE_DATEFIN = 8;
    }
}

