/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.prism.localisation.ICartoServiceData;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IImportEvenementDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportEvenementService;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ExportEvenementService
implements IExportEvenementService {
    protected IReferentielDAO referentielDal;
    protected IImportEvenementDAO importEvenementDal;
    protected IBusinessService service = new BusinessServiceDAO();
    protected Extension config;
    private static ICartoServiceData cartoInstance;
    IIconDAO iconDal = DAOFactory.getInstance().getIconDAO();
    IEvenementsDAO evtsDAO;
    private IUserDAO userDAO;
    private IVehiculeDAO vehiculeDAO;
    private IMcigDAO mcigDAO;

    public ExportEvenementService() {
        this.referentielDal = DAOFactory.getInstance().getReferentielDAO(this.iconDal);
        this.userDAO = DAOFactory.getInstance().getUserDAO(this.referentielDal);
        this.vehiculeDAO = DAOFactory.getInstance().getVehiculeDAO(this.service);
        this.mcigDAO = DAOFactory.getInstance().getMcigDAO(this.referentielDal, this.vehiculeDAO);
        this.evtsDAO = DAOFactory.getInstance().getEvenementsDAO(this.referentielDal, this.userDAO, this.mcigDAO);
        this.importEvenementDal = DAOFactory.getInstance().getImportEvenementDAO(this.referentielDal, this.evtsDAO);
        this.config = this.service.getConfiguration();
    }

    public boolean exportation(List<Partenaire> partenairesATraiter) {
        return false;
    }

    public String[] getZonesRoutiere() {
        return null;
    }

    public boolean estZoneValide(String zone) {
        return false;
    }

    public boolean exportWSJson(Partenaire partenaire, List<Evenement> liste) {
        try {
            StringBuffer sb = new StringBuffer();
            if (partenaire.getPortServeur() == 443) {
                sb.append("https://");
            } else {
                sb.append("http://");
            }
            sb.append(partenaire.getNomServeur());
            sb.append(partenaire.getCheminServeur());
            Log.debug(sb.toString());
            URL url = new URL(sb.toString());
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setDoOutput(true);
            httpCon.setRequestProperty("Content-Type", "application/json");
            httpCon.setRequestMethod("POST");
            String postData = "{\"client_id\": \"testid\",\"code\": \"troncon1\", \"value\": \"CCH\"}";
            postData = postData.replaceAll("testid", partenaire.getLogin());
            Log.debug("postData=" + postData);
            byte[] postDataBytes = postData.getBytes("UTF-8");
            httpCon.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            httpCon.getOutputStream().write(postDataBytes);
            httpCon.connect();
            int statusCode = httpCon.getResponseCode();
            Log.debug("StatusCode = " + statusCode);
            Log.debug(httpCon.getResponseMessage());
            httpCon.disconnect();
        }
        catch (MalformedURLException e) {
            Log.error("Erreur envoi", e);
            return false;
        }
        catch (IOException e) {
            Log.error("Erreur envoi", e);
            return false;
        }
        catch (Exception e) {
            Log.error("Erreur envoi", e);
            return false;
        }
        return true;
    }
}

