/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.service;

import com.geolocsystems.eq2r.DefinitionCritere;
import com.geolocsystems.eq2r.TronconEq2r;
import com.geolocsystems.export.transfertFtp.FTPClientExample;
import com.geolocsystems.export.writer.BarreauxWriterXML;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Activite;
import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.CircuitExploitation;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.Direction;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchageExploitation;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismandroid.model.IUtilisateur;
import com.geolocsystems.prismandroid.model.InfoTerritoire;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.NiveauExploitation;
import com.geolocsystems.prismandroid.model.Parametre;
import com.geolocsystems.prismandroid.model.ParametrePatrouille;
import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.PrismAction;
import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import com.geolocsystems.prismandroid.model.TronconStats;
import com.geolocsystems.prismandroid.model.TypeUtilisateur;
import com.geolocsystems.prismandroid.model.Ua;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.ZoneSensible;
import com.geolocsystems.prismandroid.model.echanges.AlerteRequete;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureEtDescriptionScoop;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.tri.EvenementTriListe;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineList;
import com.geolocsystems.prismbirtbean.SyntheseAccidentologieBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBirt;
import com.geolocsystems.prismbirtbean.SyntheseTBDelaiDureeInterventionBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleV2Bean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueCircuitBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IAnonymisation;
import com.geolocsystems.prismcentral.DAO.IDatex2DAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IExportDAO;
import com.geolocsystems.prismcentral.DAO.IFauchageDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IImportDAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IPartenaireDAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.IVhDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOConfigurationException;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ActionProfil;
import com.geolocsystems.prismcentral.beans.Astreinte;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.BulletinInforoute;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2;
import com.geolocsystems.prismcentral.beans.BulletinVH;
import com.geolocsystems.prismcentral.beans.CircuitESVHBean;
import com.geolocsystems.prismcentral.beans.Commune;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.beans.ComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.ConfigurationBean;
import com.geolocsystems.prismcentral.beans.DatePublication;
import com.geolocsystems.prismcentral.beans.DescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.EvenementInforoute;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.FiltreComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.FiltreDescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.IEvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.InformationInterventionBean;
import com.geolocsystems.prismcentral.beans.IntentionPatrouille;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.ListeDiffusion;
import com.geolocsystems.prismcentral.beans.Localisation;
import com.geolocsystems.prismcentral.beans.LocalisationDonneesSaleuse;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.MessageAlertePublication;
import com.geolocsystems.prismcentral.beans.NatureBean;
import com.geolocsystems.prismcentral.beans.NatureExport;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.geolocsystems.prismcentral.beans.NiveauServicePeriode;
import com.geolocsystems.prismcentral.beans.Onglet;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PatrouilleVH;
import com.geolocsystems.prismcentral.beans.PrESVHBean;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHBean;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.beans.SyntheseInterventionAgentBean;
import com.geolocsystems.prismcentral.beans.SynthesePatrouillesVHBean;
import com.geolocsystems.prismcentral.beans.TableauBordFiltre;
import com.geolocsystems.prismcentral.beans.TronconESVHBean;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.TronconSuiviComplet;
import com.geolocsystems.prismcentral.beans.TypeAxeVH;
import com.geolocsystems.prismcentral.beans.TypesMarques;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvert;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentral.mail.i18n.MailI18n;
import com.geolocsystems.prismcentral.service.ExportService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.Util;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Element;

public class BusinessServiceArchiveDAO
implements IBusinessService {
    private static final long serialVersionUID = 5146456826185547753L;
    IUserDAO userDal;
    IReferentielDAO referentielDal;
    IMcigDAO mcigDal;
    IIG4DAO ig4Dal;
    IFauchageDAO fauchageDal;
    IEvenementsDAO evenements;
    IVehiculeDAO vehiculesDal;
    IAdminDAO adminDal;
    IVhDAO vhDal;
    IPublicationDAO publicationDal;
    MailService mailService;
    IDatex2DAO datex2Dal;
    IPhotoDAO photoDal;
    IIconDAO iconDal = DAOFactory.getArchiveInstance().getIconDAO();
    IExportDAO exportDal;
    IPartenaireDAO partenaireDAO;
    IImportDAO importDal;
    IAnonymisation anonymisationDal;

    public BusinessServiceArchiveDAO() {
        this.referentielDal = DAOFactory.getArchiveInstance().getReferentielDAO(this.iconDal);
        this.userDal = DAOFactory.getArchiveInstance().getUserDAO(this.referentielDal);
        this.vehiculesDal = DAOFactory.getArchiveInstance().getVehiculeDAO(this);
        this.publicationDal = DAOFactory.getArchiveInstance().getPublicationDAO(this.referentielDal, this.vehiculesDal, null);
        this.fauchageDal = DAOFactory.getArchiveInstance().getFauchageDAO();
        this.mcigDal = DAOFactory.getArchiveInstance().getMcigDAO(this.referentielDal, this.vehiculesDal);
        this.evenements = DAOFactory.getArchiveInstance().getEvenementsDAO(this.referentielDal, this.userDal, this.mcigDal);
        this.adminDal = DAOFactory.getArchiveInstance().getAdminDAO(this.referentielDal);
        this.ig4Dal = DAOFactory.getArchiveInstance().getIG4DAO(this.adminDal, this.referentielDal, this.userDal, this.evenements, this.mcigDal, this.vehiculesDal);
        this.vhDal = DAOFactory.getArchiveInstance().getVhDAO(this.referentielDal, this.publicationDal);
        this.mailService = new MailService(this, new ExportService(this));
        this.datex2Dal = DAOFactory.getArchiveInstance().getDatex2DAO();
        this.photoDal = DAOFactory.getArchiveInstance().getPhotoDAO();
        this.exportDal = DAOFactory.getArchiveInstance().getExportDAO();
        this.partenaireDAO = DAOFactory.getArchiveInstance().getPartenaireDAO();
        this.importDal = DAOFactory.getArchiveInstance().getImportDAO();
        this.anonymisationDal = DAOFactory.getArchiveInstance().getAnonymisationDAO(this.referentielDal);
    }

    public PrismCentralUser login(String user, String password) {
        Log.debug("SQLBusinessService : login");
        return this.userDal.login(user, password);
    }

    public Map<String, Nature> getNatures() {
        return this.referentielDal.getNatureMap();
    }

    public List<NatureOuRaccourci> getNaturesList() {
        return this.referentielDal.getNatures();
    }

    public List<Onglet> getOngletsChamps() {
        return this.referentielDal.getOngletsChamps();
    }

    public PrismCentralUser getUtilisateur(String codeUtilisateur) {
        return this.referentielDal.getUtilisateur(codeUtilisateur);
    }

    public List<PrismCentralUser> rechercheToutUtilisateur() {
        return this.referentielDal.rechercheToutUtilisateur();
    }

    public List<Utilisateur> rechercheToutUtilisateurEmbarque() {
        return this.userDal.rechercheToutUtilisateurEmbarque();
    }

    public List<PrismCentralUser> rechercheUtilisateurParDelegation(PrismCentralUser user) {
        return this.userDal.rechercheUtilisateurParDelegation(user);
    }

    public List<PrismCentralUser> rechercheUtilisateurParDelegationCentre(PrismCentralUser user) {
        return this.userDal.rechercheUtilisateurParDelegationCentre(user);
    }

    public PrismCentralUser rechercheUtilisateurParLogin(String codeUtilisateur) {
        return this.userDal.rechercheUtilisateurParLogin(codeUtilisateur);
    }

    public List<Situation> getEvenements(IBusinessService.EvenementFiltre filtre, List<FiltreJava> filtresJava) {
        return this.evenements.getEvenements(filtre, filtresJava);
    }

    public List<String> getKeyMCIG(TableauBordFiltre filtre) {
        return this.mcigDal.getKeyMCIG(filtre);
    }

    public Collection<MCIG> getMCIGFromRange(TableauBordFiltre filtre, int startIndex, int endIndex, List<String> keys) {
        return this.mcigDal.getMCIGFromRange(filtre, startIndex, endIndex, keys);
    }

    public List<Delegation> getDelegations() {
        return this.referentielDal.getDelegations();
    }

    public List<Delegation> getDelegationsActives() {
        return this.referentielDal.getDelegationsActives();
    }

    public Extension getConfiguration() {
        return this.referentielDal.getConfiguration();
    }

    public List<TronconFauchage> getTronconFauchage(Delegation delegation, Centre centre, Calendar dateDebut, Calendar dateFin) {
        return this.fauchageDal.getTronconFauchage(delegation, centre, dateDebut, dateFin);
    }

    public MainCourante creerMainCouranteCentral(PrismCentralUser user) {
        return this.mcigDal.creerMainCouranteCentral(user);
    }

    public void fermerMainCourante(MainCourante mc) {
        this.mcigDal.fermerMainCourante(mc);
    }

    public void inactivationEvenement(Evenement evenement) {
        this.evenements.inactivationEvenement(evenement);
    }

    public void sauvegarderEvenement(IEvenementASauvegarder eas) {
        this.evenements.sauvegarderEvenement(eas);
        if (eas.isDiffuserDatex2()) {
            this.datex2Dal.ajouterEvenementASynchroniser(eas.getEvenement());
        }
        if (eas.isEnvoyerParMail()) {
            this.mailService.evenement(eas.getEvenement());
        }
    }

    public void lireEvenement(Evenement e) {
        this.evenements.lireEvenement(e);
    }

    public Map<Integer, ModuleMetier> getModulesMetiers() {
        return this.referentielDal.getModulesMetiers();
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnIntervention(filtre);
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(List<String> idsPatrouille) {
        return this.vehiculesDal.getVehiculesEnIntervention(idsPatrouille);
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionRecente(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnInterventionRecente(filtre);
    }

    public List<Profil> getProfils() {
        return this.userDal.getProfils();
    }

    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi) {
        return this.vehiculesDal.getTronconsPatrouilles(idPatrouilleSuivi);
    }

    public List<ActionProfil> getActionsProfil() {
        return this.referentielDal.getActionsProfil();
    }

    public void creerProfil(Profil object) {
        this.adminDal.creerProfil(object);
    }

    public void updateProfil(Profil object) {
        this.adminDal.updateProfil(object);
    }

    public void creerUtilisateur(PrismCentralUser user, String newpwd) {
        this.adminDal.creerUtilisateur(user, newpwd);
    }

    public void updateUtilisateur(PrismCentralUser user, String newpwd) {
        this.adminDal.updateUtilisateur(user, newpwd);
    }

    public List<Vehicule> getListeVehicule() {
        return this.referentielDal.getListeVehicule();
    }

    public List<MarqueVehicule> getMarquesVehicules() {
        return this.referentielDal.getMarquesVehicules();
    }

    public void creerVehicule(Vehicule v) {
        this.adminDal.creerVehicule(v);
    }

    public void updateVehicule(Vehicule v) {
        this.adminDal.updateVehicule(v);
    }

    public Map<Integer, TypesMarques> getTypesMarques() {
        return this.referentielDal.getTypesMarques();
    }

    public void creerMarqueVehicule(MarqueVehicule marque) {
        this.adminDal.creerMarqueVehicule(marque);
    }

    public void updateMarqueVehicule(MarqueVehicule marque) {
        this.adminDal.updateMarqueVehicule(marque);
    }

    public void updatePatrouilleVH(PatrouilleVH patrouilleVH) {
        this.vhDal.updatePatrouilleVH(patrouilleVH);
    }

    public List<PatrouilleVH> getPatrouillesVH(Calendar calDebut, Calendar calFin) {
        return this.vhDal.getPatrouillesVH(calDebut, calFin);
    }

    public List<PatrouilleVH> getPatrouillesVH(Calendar cal) {
        return this.vhDal.getPatrouillesVH(cal);
    }

    public void creerDelegation(Delegation delegation) {
        this.adminDal.creerDelegation(delegation);
    }

    public void updateDelegation(Delegation delegation) {
        this.adminDal.updateDelegation(delegation);
    }

    public void creerCentre(Centre centre) {
        this.adminDal.creerCentre(centre);
    }

    public void updateCentre(Centre centre) {
        this.adminDal.updateCentre(centre);
    }

    public int getDernierIdBulletin(String nomCT) {
        return this.vhDal.getDernierIdBulletin(nomCT);
    }

    public HashMap<String, BulletinVH> getDerniersBulletinsCTCG() {
        return this.vhDal.getDerniersBulletinsCTCG();
    }

    public void enregistrerBulletin(BulletinVH bulletin) {
        this.vhDal.enregistrerBulletin(bulletin);
    }

    public PatrouilleVH getPatrouille(String nomCT, Calendar cal) {
        return this.vhDal.getPatrouilleVH(nomCT, cal);
    }

    public BulletinVH getBulletin(int id, String nomCT) {
        return this.vhDal.getBulletin(id, nomCT);
    }

    public List<TypeAxeVH> getTypesAxe(int typeBulletin, int id) {
        return this.vhDal.getTypesAxe(typeBulletin, id);
    }

    public List<TypeAxeVH> getTypesAxeV2(int typeBulletin, int id) {
        return this.vhDal.getTypesAxeV2(typeBulletin, id);
    }

    public List<TypeAxeVH> getTypesAxe(String nomCT, int id) {
        return this.vhDal.getTypesAxe(nomCT, id);
    }

    public List<TypeAxeVH> getTypesAxeV2(String nomCT, int id) {
        return this.vhDal.getTypesAxeV2(nomCT, id);
    }

    public List<DestinataireMail> getDestinatairesMail() {
        return this.referentielDal.getDestinatairesMail();
    }

    public List<String> getCategoriesDestinatairesMail() {
        return this.referentielDal.getCategoriesDestinatairesMail();
    }

    public void creerDestinataireMail(DestinataireMail destinataire) {
        this.adminDal.creerDestinataireMail(destinataire);
    }

    public void updateDestinataireMail(DestinataireMail destinataire) {
        this.adminDal.updateDestinataireMail(destinataire);
    }

    public List<ListeDestinataireMail> getListeDestinataireMails() {
        return this.referentielDal.getListeDestinataireMails();
    }

    public int creerListeDestinatairesMail(ListeDestinataireMail liste) {
        return this.adminDal.creerListeDestinatairesMail(liste);
    }

    public void updateListeDestinatairesMail(ListeDestinataireMail liste) {
        this.adminDal.updateListeDestinatairesMail(liste);
    }

    public List<ListeDiffusion> getListesDiffusions() {
        return this.referentielDal.getListesDiffusions();
    }

    public Map<String, List<DescriptionNature>> getDescriptionsNatureMap() {
        return this.referentielDal.getDescriptionsNatureMap();
    }

    public Map<String, Integer> getDesciptionDiffusionEvt() {
        return this.referentielDal.getDesciptionDiffusionEvt();
    }

    public void updateMailConfiguration(Map<String, Integer> diffusion, Map<String, Integer> evenements) {
        this.adminDal.updateMailConfiguration(diffusion, evenements);
    }

    public void verifierVehiculesEnDifficultes() {
        this.vehiculesDal.updateVehiculesEnDifficultes();
    }

    public Map<String, ReformulationDescription> getReformulations() {
        return this.referentielDal.getReformulations();
    }

    public void updateReformulationPublication(ReformulationDescription reformulation) {
        this.adminDal.updateReformulationPublication(reformulation);
    }

    public void depublierEvenement(Evenement e) {
        this.publicationDal.depublierEvenement(e);
    }

    public void publierEvenement(Evenement e, String ligne1, String ligne2, String ligne3, String ligne4, String ligne5) {
        this.publicationDal.publierEvenement(e, ligne1, ligne2, ligne3, ligne4, ligne5);
    }

    public Map<String, String[]> getValeursReformulation() {
        return this.referentielDal.getValeursReformulation();
    }

    public void deleteListeDestinatairesMail(ListeDestinataireMail liste) {
        this.adminDal.deleteListeDestinatairesMail(liste);
    }

    public void deleteDestinataireMail(DestinataireMail object) {
        this.adminDal.deleteDestinataireMail(object);
    }

    public void ajoutCommentaire(MainCourante mc, Commentaire c) {
        this.mcigDal.ajouterCommentaire(mc, c);
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, Date dateHisto) {
        return this.vehiculesDal.getVehiculesEnIntervention(filtre, dateHisto);
    }

    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules) {
        return this.vehiculesDal.getTronconsCompletsPatrouilles(codeVehicules);
    }

    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules, Date dateHisto) {
        return this.vehiculesDal.getTronconsCompletsPatrouilles(codeVehicules, dateHisto);
    }

    public List<Situation> getEvenementsASynchroniserDatex2(IBusinessService.EvenementFiltre filtreSql, List<FiltreJava> filtresJava) {
        return this.evenements.getEvenementsASynchroniserDatex2(filtreSql, filtresJava);
    }

    public Evenement getDernierEvenementActif(Evenement evenement) {
        return this.evenements.getDernierEvenementActif(evenement);
    }

    public byte[] getPhoto(String hash) {
        return this.photoDal.getPhoto(hash);
    }

    public void sauvegarderPhoto(String hash, byte[] data) {
        this.photoDal.sauvegarderPhoto(hash, data);
    }

    public boolean isPhotoExist(String hash) {
        return this.photoDal.isPhotoExist(hash);
    }

    public File getNatureIconHd(String code) {
        return this.iconDal.getNatureIconHd(code);
    }

    public File getVehicleIcon(String code) {
        return this.iconDal.getVehicleIcon(code);
    }

    public File getImageComboItemIcon(String nom, String valeur) {
        return this.iconDal.getImageComboItemIcon(nom, valeur);
    }

    public Map<String, Map<String, byte[]>> getImagesComposantsChoixImage(List<NatureOuRaccourci> natures) {
        return this.iconDal.getImagesComposantsChoixImage(natures);
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getVehiculesEnInterventionHistorique(filtre);
    }

    public MainCourante creerMainCourante(PrismCentralUser user, MainCourante mc, int typePoste) {
        return this.mcigDal.creerMainCourante(user, mc, typePoste);
    }

    public void fermerMainCourante(MainCourante mc, Commentaire c) {
        this.mcigDal.fermerMainCourante(mc, c);
    }

    public void debutPatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.debutPatrouille(d, ajoutCommentaire);
    }

    public void finPatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.finPatrouille(d, ajoutCommentaire);
    }

    public void verifierPatrouilleEtMainCouranteObsoletes() {
        this.mcigDal.verifierPatrouilleEtMainCouranteObsoletes();
    }

    public void deconnexion(MainCourante m) {
        this.mcigDal.deconnexion(m);
    }

    public Map<String, Circuit> getListeCircuit() {
        return this.referentielDal.getCircuits();
    }

    public List<TronconEq2r> getTronconsEq2r() {
        throw new UnsupportedOperationException();
    }

    public List<String> getListeCommunes() {
        return this.referentielDal.getListeCommunes();
    }

    public String getDelegationCommune(String commune) {
        return this.referentielDal.getDelegationCommune(commune);
    }

    public void ajouterTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public void updateTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public void deleteTronconEq2r(TronconEq2r troncon) {
        throw new UnsupportedOperationException();
    }

    public Map<Integer, Date> getDatesVisiteTronconsEq2r(Date date, List<TronconEq2r> troncons) {
        throw new UnsupportedOperationException();
    }

    public BulletinMediaVH getStructureBulletinMediaVH() {
        return this.vhDal.getStructureBulletinMediaVH();
    }

    public BulletinMediaVH getInformationsBulletinMediaVH() {
        return this.vhDal.getInformationsBulletinMediaVH();
    }

    public void enregistrerBulletinMedia(BulletinMediaVH bulletin) {
        this.vhDal.enregistrerBulletinMedia(bulletin);
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(sansCoordonnees);
    }

    public List<BarreauVH> getBarreauxVH() {
        throw new UnsupportedOperationException();
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre) {
        return this.referentielDal.getBarreauxVH(delegation, centre);
    }

    public BarreauVH getBarreauVH(String tronconId, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauVH(tronconId, sansCoordonnees);
    }

    public void updateBarreauVH(BarreauVH barreau) {
    }

    public void updateBarreauVHCCH(BarreauVH barreau) {
    }

    public void updateBarreauxVH(List<BarreauVH> barreaux) {
    }

    public void pasDeChangementBarreauxVH(String delegation, String centre, String mcigId) {
    }

    public void remiseAZeroBarreauxVH(String delegation, String centre, String mcigId) {
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre, boolean sansCoordonnees) {
        return this.referentielDal.getBarreauxVH(delegation, centre, sansCoordonnees);
    }

    public Bounds getBoundsCommune(String comm) {
        return this.referentielDal.getBoundsCommune(comm);
    }

    public List<DefinitionCritere> getDefinitionsCriteresEq2r() {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getCriteresEq2rDesactives() {
        throw new UnsupportedOperationException();
    }

    public void supprimerCritereEq2r(int object) {
        throw new UnsupportedOperationException();
    }

    public void activerCritereEq2r(int object, boolean enable) {
        throw new UnsupportedOperationException();
    }

    public void ajouterCritereEq2r(DefinitionCritere crit) {
        throw new UnsupportedOperationException();
    }

    public void updateCritereEq2r(DefinitionCritere crit) {
        throw new UnsupportedOperationException();
    }

    public List<NatureExport> getNatureExport(Nature nature) {
        return this.exportDal.getNaturesExport(nature);
    }

    public void reprisePatrouille(DonneesSynchro d, boolean ajoutCommentaire) throws Exception {
        this.vehiculesDal.reprisePatrouille(d, ajoutCommentaire);
    }

    public NatureExport getNatureExport(Nature nature, String format) {
        return this.exportDal.getNaturesExport(nature, format);
    }

    public NatureExport getNatureExport(String code, String libelle) {
        return this.exportDal.getNatureExport(code, libelle);
    }

    public ModuleMetier getModuleMetier(String libelleModuleMetier) {
        return this.referentielDal.getModuleMetier(libelleModuleMetier);
    }

    public List<NatureExport> getNatureExport(List<Nature> natures) {
        return this.exportDal.getNatureExport(natures);
    }

    public Calendar getDatePublication() {
        return this.publicationDal.getDerniereDatePublication();
    }

    public String getCoordonneesEvenementsJSON() {
        return this.publicationDal.getCoordonneesEvenementsJSON();
    }

    public String getDerniereDatePublicationJSON(DatePublication datePublication) {
        return this.publicationDal.getDerniereDatePublicationJSON(datePublication);
    }

    public String getDerniereDatePublicationJSON() {
        return this.publicationDal.getDerniereDatePublicationJSON();
    }

    public String getEvenementsPubliesJSON(String status, String nature) {
        return this.publicationDal.getEvenementsPubliesJSON(status, nature, null);
    }

    public String getEvenementsPubliesJSON() {
        return this.publicationDal.getEvenementsPubliesJSON();
    }

    public String getConfigurationJSON() {
        return this.publicationDal.getConfigurationJSON();
    }

    public String getNaturesJSON() {
        return this.referentielDal.getNaturesJSON();
    }

    public Rectangle2D getExtentMcig(String mcigId) {
        return this.mcigDal.getExtentMcig(mcigId);
    }

    public Rectangle2D[] getExtentMcig2(String mcigId) {
        return this.mcigDal.getExtentMcig2(mcigId);
    }

    public void programmeEvenement(Evenement event, boolean etat) {
        this.evenements.programmeEvenement(event, etat);
    }

    public File getModuleMetierIcon(String code) {
        return this.iconDal.getModuleMetierIcon(code);
    }

    public void initialiserReferentiel() {
        this.referentielDal.update();
    }

    public void publierPatrouilleVH(String idPatrouille) {
        this.publicationDal.publierPatrouilleVH(idPatrouille);
    }

    public void depublierPatrouilleVH(String idPatrouille) {
        this.publicationDal.depublierPatrouilleVH(idPatrouille);
    }

    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouilleSuivi) {
        return this.vehiculesDal.getTronconPatrouille(idPatrouilleSuivi);
    }

    public Map<String, Long> getMajDonneesMetiers() {
        return this.referentielDal.getMiseAJourDonneesMetiers();
    }

    public void updateSyntheseSerpeVH(Synthese synthese) {
        Log.debug("updateSyntheseSerpeVH : D\u00ef\u00bf\u00bdbut");
        synthese.setZoneRoutiere(ConfigurationFactory.getInstance().get("zoneroutiere"));
        this.referentielDal.updateSyntheseVH(synthese);
    }

    public void updateSynthesePublicationVH(Synthese synthese) {
        Log.debug("updateSynthesePublicationVH : D\u00ef\u00bf\u00bdbut");
        synthese.setZoneRoutiere(ConfigurationFactory.getInstance().get("zoneroutiere"));
        this.referentielDal.updateSynthesePublieVH(synthese);
    }

    public Synthese getSyntheseSerpeVH() {
        Log.debug("updateSyntheseSerpeVH : D\u00ef\u00bf\u00bdbut");
        return this.referentielDal.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
    }

    public Synthese getSynthesePublicationVH() {
        Log.debug("updateSyntheseSerpeVH : D\u00ef\u00bf\u00bdbut");
        return this.referentielDal.getSynthesePublieVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation) {
        Log.debug("transmettreBarreauxSerpeVH : D\u00ef\u00bf\u00bdbut");
        List<Partenaire> partenairesSerpeVH = null;
        try {
            partenairesSerpeVH = this.partenaireDAO.getListePartenaireSERPEVH();
        }
        catch (SQLException e1) {
            Log.error("getPartenaireSERPEVH", e1);
            return false;
        }
        if (partenairesSerpeVH == null || partenairesSerpeVH.size() == 0) {
            Log.error("PAs de partenaire SERPE VH");
            return true;
        }
        Synthese synthese = this.referentielDal.getSyntheseVH(ConfigurationFactory.getInstance().get("zoneroutiere"));
        BarreauxWriterXML barreauxWriter = new BarreauxWriterXML();
        Element racine = barreauxWriter.genererXMLSerpeVH();
        String nomZone = null;
        try {
            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere.serpevh");
        }
        catch (Exception e) {
            nomZone = ConfigurationFactory.getInstance().get("zoneroutiere");
        }
        Element dir = barreauxWriter.genererXMLDirSerpeVH(nomZone, synthese.getCommentaire());
        racine.addContent((Content)dir);
        Log.debug("transmettreBarreauxSerpeVH : Envoi des barreaux \u00ef\u00bf\u00bd SERPE VH");
        List<Delegation> listeDelegations = this.getDelegations();
        for (Delegation delegation : listeDelegations) {
            List<BarreauVH> listeBarreaux;
            if (selectionBarreauxParDelegation) {
                listeBarreaux = this.getBarreauxVH(delegation.getNom(), null, true);
                dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(delegation.getNom(), listeBarreaux));
                continue;
            }
            if (delegation.getCentres() == null || delegation.getCentres().size() <= 0) continue;
            for (Centre centre : delegation.getCentres()) {
                listeBarreaux = this.getBarreauxVH(delegation.getNom(), centre.getNom(), true);
                dir.addContent((Content)barreauxWriter.genererXMLCentreSerpeVH(centre.getNom(), listeBarreaux));
            }
        }
        boolean traitementOK = false;
        for (Partenaire partenaireSerpeVH : partenairesSerpeVH) {
            if (!new File(partenaireSerpeVH.getCheminServeur()).exists()) {
                new File(partenaireSerpeVH.getCheminServeur()).mkdirs();
            }
            if (!new File(partenaireSerpeVH.getRepArchivage()).exists()) {
                new File(partenaireSerpeVH.getRepArchivage()).mkdirs();
            }
            barreauxWriter.writeXmlFile(partenaireSerpeVH.getCheminServeur() + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
            StringBuffer sb = new StringBuffer("[AAAA][MM][JJ]_[HH][mm][ss][SSS]_");
            sb.append(partenaireSerpeVH.getPatternFichier());
            barreauxWriter.writeXmlFile(partenaireSerpeVH.getRepArchivage() + Util.getFilePattern((String)sb.toString(), (String)"", (String)"", (String)"", (int)0));
            if (partenaireSerpeVH.isFTP()) {
                FTPClientExample ftp = new FTPClientExample();
                try {
                    traitementOK = ftp.ftpSendOneTime(partenaireSerpeVH.getCheminServeur(), partenaireSerpeVH.getRepDepotFtp(), partenaireSerpeVH.getFtpExtensionTemporaire(), partenaireSerpeVH.getNomServeur(), partenaireSerpeVH.getPortServeur(), partenaireSerpeVH.getLogin(), partenaireSerpeVH.getPassword(), partenaireSerpeVH.getModeConnexion(), partenaireSerpeVH.getModeTransfert());
                }
                catch (Exception e) {
                    Log.error("ftpSend", e);
                }
                continue;
            }
            if (!partenaireSerpeVH.isMail()) continue;
            try {
                File input = new File(partenaireSerpeVH.getCheminServeur() + Util.getFilePattern((String)partenaireSerpeVH.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                ArrayList<File> liste = new ArrayList<File>();
                liste.add(input);
                this.mailService.sendMessage(partenaireSerpeVH.getEMail(), MailI18n.getString("vh.objet"), "", liste);
                traitementOK = true;
            }
            catch (Exception e) {
                Log.error("sendMessage", e);
            }
        }
        return traitementOK;
    }

    public boolean importationBarreaux(List<Partenaire> partenairesATraiter) {
        return true;
    }

    private Vector<BarreauVH> filtrerBarreau(List<BarreauVH> barreaux, Partenaire partenaire) {
        Vector<BarreauVH> barreauxAEnvoyer = new Vector<BarreauVH>();
        for (BarreauVH barreau : barreaux) {
            if (barreau.getMajIdPartenaire() == Integer.parseInt(partenaire.getId()) || partenaire.getDernierTransfert() != null && !barreau.getMajDate().after(partenaire.getDernierTransfert()) && !barreau.getMajDateServeur().after(partenaire.getDernierTransfert())) continue;
            barreauxAEnvoyer.add(barreau);
        }
        return barreauxAEnvoyer;
    }

    public boolean exportationBarreaux(List<Partenaire> partenairesExternes, List<Partenaire> partenairesATraiter) {
        if (partenairesATraiter != null && partenairesATraiter.size() > 0) {
            List<BarreauVH> barreaux = this.referentielDal.getBarreauxVH();
            Log.debug("Nombre de barreaux total: " + barreaux.size());
            BarreauxWriterXML barreaWriter = new BarreauxWriterXML();
            for (Partenaire partenaire : partenairesATraiter) {
                Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                Vector<BarreauVH> barreauxAEnvoyer = this.filtrerBarreau(barreaux, partenaire);
                Log.debug("[Barreaux filtr\u00ef\u00bf\u00bds]" + barreauxAEnvoyer.size());
                if (barreauxAEnvoyer.size() > 0) {
                    barreaWriter.genererXML(barreauxAEnvoyer);
                    if (!new File(partenaire.getCheminServeur()).exists()) {
                        new File(partenaire.getCheminServeur()).mkdirs();
                    }
                    if (!new File(partenaire.getRepArchivage()).exists()) {
                        new File(partenaire.getRepArchivage()).mkdirs();
                    }
                    barreaWriter.writeXmlFile(partenaire.getCheminServeur() + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                    barreaWriter.writeXmlFile(partenaire.getRepArchivage() + Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0));
                }
                Log.debug("[" + partenaire.getLibelle() + "]Traitement termin\u00ef\u00bf\u00bd");
            }
        }
        for (Partenaire partenaire : partenairesExternes) {
            FTPClientExample ftp = new FTPClientExample();
            try {
                ftp.ftpSend(partenaire.getCheminServeur(), partenaire.getRepDepotFtp(), partenaire.getFtpExtensionTemporaire(), partenaire.getNomServeur(), partenaire.getPortServeur(), partenaire.getLogin(), partenaire.getPassword(), partenaire.getModeConnexion(), partenaire.getModeTransfert());
            }
            catch (Exception e) {
                Log.error("Renommage en erreur ", e);
            }
        }
        return true;
    }

    public List<Partenaire> getListePartenaire() throws SQLException {
        return this.partenaireDAO.getListePartenaire();
    }

    public Partenaire getPartenaireSERPEVH() throws SQLException {
        return this.partenaireDAO.getPartenaireSERPEVH();
    }

    public void miseAjourPartenaire(Partenaire partenaire, Date dateIterationCourante) {
        try {
            this.partenaireDAO.miseAjourPartenaire(partenaire, dateIterationCourante);
        }
        catch (SQLException e) {
            new Exception(e);
        }
    }

    public List<ModuleMetier> getListeModulesMetiers() {
        return this.referentielDal.getListeModulesMetiers();
    }

    public Map<String, String> getMapTypeComposants() {
        return this.referentielDal.getMapTypeComposants();
    }

    public Map<String, String> getMapCorrespondanceComposantsChamp() {
        return this.referentielDal.getMapCorrespondanceComposantChamp();
    }

    public void creerCircuit(Circuit v) {
        this.adminDal.creerCircuit(v);
    }

    public void updateCircuit(Circuit v) {
        this.referentielDal.updateTronconCircuit(v);
        this.adminDal.updateCircuit(v);
    }

    public List<Circuit> getListeCircuits() {
        return this.adminDal.getListeCircuits();
    }

    public void diffusionVH() {
        this.mailService.diffusionVH();
    }

    public Map<String, ComposantBean> getMapComposants() {
        return this.referentielDal.getMapComposants();
    }

    public Map<String, ComposantBean> getMapComposantsUtilises() {
        return this.referentielDal.getMapComposantsUtilises();
    }

    public boolean updateComposantFromNature(NatureBean n, ComposantNatureCommunBean c) {
        return this.referentielDal.UpdateComposantFromNature(n, c);
    }

    public boolean deleteComposantFromNature(NatureBean n, ComposantNatureCommunBean o) {
        return this.referentielDal.DeleteComposantFromNature(n, o);
    }

    public boolean createComposantFromNature(NatureBean object, ComposantNatureCommunBean c) {
        return this.referentielDal.CreateComposantFromNature(object, c);
    }

    public List<NatureBean> getListeNaturePerso(boolean withZoneRoutiere) {
        return this.referentielDal.getListeNaturePerso(withZoneRoutiere);
    }

    public List<ComposantBean> getListComposants(boolean withZoneRoutiere) {
        return this.referentielDal.getListComposants(withZoneRoutiere);
    }

    public List<ComposantNatureCommunBean> getListComposantsCommun(FiltreComposantNatureCommunBean filtre) {
        return this.referentielDal.getListComposantsCommun(filtre);
    }

    public List<ComposantNatureCommunBean> getListComposantsNature(FiltreComposantNatureCommunBean filtre) {
        return this.referentielDal.getListComposantsNature(filtre);
    }

    public boolean creerNatureBean(NatureBean nature) {
        return this.referentielDal.creerNatureBean(nature);
    }

    public boolean updateNatureBean(NatureBean nature) {
        return this.referentielDal.updateNatureBean(nature);
    }

    public List<DescriptionNatureBean> getListDescriptionsNature(FiltreDescriptionNatureBean filtre) {
        return this.referentielDal.getListDescriptionsNature(filtre);
    }

    public boolean createDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.createDescriptionNature(d);
    }

    public boolean updateDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.updateDescriptionNature(d);
    }

    public boolean deleteDescriptionNature(DescriptionNatureBean d) {
        return this.referentielDal.deleteDescriptionNature(d);
    }

    public boolean creerComposantBean(ComposantBean composant) {
        return this.referentielDal.creerComposantBean(composant);
    }

    public boolean updateComposantBean(ComposantBean composant) {
        return this.referentielDal.updateComposantBean(composant);
    }

    public boolean updateOldPassword() {
        return this.adminDal.updateOldPassword();
    }

    public List<ConfigurationBean> getListConfiguration(boolean withZoneRoutiere) {
        return this.adminDal.getListConfiguration(withZoneRoutiere);
    }

    public void creerConfigurationBean(ConfigurationBean config) {
        this.adminDal.creerConfigurationBean(config);
    }

    public void updateConfigurationBean(ConfigurationBean config) {
        this.adminDal.updateConfigurationBean(config);
    }

    public void deleteConfiguration(String champ) {
        this.adminDal.deleteConfigurationBean(champ);
    }

    public void publierBarreauxVH(List<BarreauVH> barreaux) {
        this.referentielDal.publierBarreauxVH(barreaux);
    }

    public void depublierBarreauxVH(List<BarreauVH> barreaux) {
        this.referentielDal.depublierBarreauxVH(barreaux);
    }

    public Map<String, Integer> getLongueurPatrouilleParConditionConduites(IBusinessService.VehiculeFiltre filtre) {
        return this.vehiculesDal.getLongueurPatrouilleParConditionConduites(filtre);
    }

    public Map<String, List<Troncon>> getCategoriesRoute() {
        return this.referentielDal.getCategoriesRoute();
    }

    public Map<String, List<Troncon>> getTraficRoute() {
        return this.referentielDal.getTraficRoute();
    }

    public Map<String, Map<String, List<Troncon>>> getCaracteristiquesRoute() {
        return this.referentielDal.getCaracteristiquesRoute();
    }

    public Collection<TronconSuivi> getTronconsRecents(List<Integer> c) {
        return this.vehiculesDal.getTronconsRecents(c);
    }

    public Collection<TronconSuivi> getTronconsRecents(List<Integer> c, Timestamp minValidite) {
        return this.vehiculesDal.getTronconsRecents(c, minValidite);
    }

    public List<NiveauExploitation> getNiveauExploitation(List<FiltreJava> filtresJava) {
        return this.referentielDal.getNiveauExploitation(filtresJava);
    }

    public void importUtilisateurs(String fichier) {
        this.importDal.importUtilisateurs(fichier);
    }

    public List<CircuitExploitation> getCircuitExploitation(String d, String c, Date debut, Date fin) throws DAOException {
        return this.referentielDal.getCircuitExploitation(d, c, debut, fin);
    }

    public Localisation getLocalisationPatrouille(String idMCIG) {
        return this.vehiculesDal.getLocalisationPatrouille(idMCIG);
    }

    public List<LocalisationDonneesSaleuse> getLocalisationDonneesSaleusePatrouille(String idPatrouille) {
        return this.vehiculesDal.getLocalisationDonneesSaleusePatrouille(idPatrouille);
    }

    public void insertionReleveDebroussaillage(DonneesSynchro d, Releve r) {
        this.fauchageDal.insertionReleveDebroussaillage(d, r);
    }

    public List<Releve> getReleveDebroussaillage(Calendar dateDebut, Calendar dateFin) {
        return this.fauchageDal.getReleveDebroussaillage(dateDebut, dateFin);
    }

    public void importNiveauxExploitation(String fichier) {
        this.importDal.importNiveauxExploitation(fichier);
    }

    public void desactiverPosition(String mcigId) {
        this.vehiculesDal.desactiverPosition(mcigId);
    }

    public void anonymisation() {
        this.anonymisationDal.anonymisation();
    }

    public List<CircuitExploitation> getFrequenceCircuitExploitation(Date debut, Date fin) {
        return this.referentielDal.getFrequenceCircuitExploitation(debut, fin);
    }

    public List<CircuitExploitation> getCircuitsAnomalies(String division, String district, String departement, Date dateJourDebut, Date dateJourFin) {
        return this.referentielDal.getCircuitsAnomalies(division, district, departement, dateJourDebut, dateJourFin);
    }

    public List<Troncon> getCircuitTroncons(Circuit circuit) {
        return this.referentielDal.getCircuitTroncons(circuit);
    }

    public void creerCircuitTroncons(Circuit circuit) {
        int idCircuit = this.adminDal.creerCircuit(circuit);
        circuit.setId(String.valueOf(idCircuit));
        this.referentielDal.creerCircuitTroncons(circuit);
    }

    public void creerIntentionPatrouille(IntentionPatrouille ip) {
    }

    public void updateIntentionPatrouille(IntentionPatrouille ip) {
    }

    public List<IntentionPatrouille> getIntentionPatrouille(String delegation, String centre) {
        return null;
    }

    public void insertPosition(DonneesSynchro d, ValeurChampLocalisation v, int etat) {
    }

    public Map<Activite, List<Centre>> getCentresParActivite() {
        return null;
    }

    public void supprimerEvenement(Evenement evenement) {
    }

    public void annulerEvenement(IEvenementASauvegarder event) {
    }

    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles) {
        return null;
    }

    public Map<String, Map<String, Map<Integer, Integer>>> getNbPatrouillesParAnnee(int annee) {
        return null;
    }

    public Map<String, Map<String, Map<Integer, Integer>>> getNbAccidentsEtInterventionsParAnnee(IBusinessService.EvenementFiltre filtre) {
        return null;
    }

    public void effacerEvenementMission() {
    }

    public boolean supprimerAstreinte(long id) {
        return false;
    }

    public Long creerAstreinte(Astreinte object) {
        return null;
    }

    public Long updateAstreinte(Astreinte object) {
        return null;
    }

    public List<Astreinte> rechercheAstreintes(String delegation, String centre, Long timestamp) {
        return null;
    }

    public List<String> listeTypeAstreintes() {
        return null;
    }

    public Map<String, Map<String, Integer>> getNbAccidentsEtInterventionsParAnneeParAxe(IBusinessService.EvenementFiltre filtre) {
        return null;
    }

    public SyntheseTBDelaiDureeInterventionBean getDelaisDureesIntervention(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        return null;
    }

    public SyntheseAccidentologieBean getAccidentologie(IBusinessService.EvenementFiltre filtre, boolean annuel) {
        return null;
    }

    public List<NiveauService> getNiveauxService() {
        return null;
    }

    public List<SyntheseTableauBordFrequencePatrouilleBean> getFrequencePatrouilleTroncons(Circuit circuit, Timestamp dateDebut, int bufferSize, double ratioParcours) {
        return null;
    }

    public Rectangle2D getExtentCircuit(String circuitId) {
        return null;
    }

    public LinkedHashMap<String, List<Position>> getAccidentologieCoordonneesAccidents(IBusinessService.EvenementFiltre filtre) {
        return null;
    }

    public List<Troncon> getCircuitTroncons(Circuit circuit, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement) {
        return null;
    }

    public Map<String, List<ZoneSensible>> getZonesSensibles() {
        return null;
    }

    public Rectangle2D getExtentPatrouille(String id_patrouille) {
        return null;
    }

    public List<Troncon> getTroncons(String table) {
        return null;
    }

    public void miseAJourCoordonneesTroncon(String table, Troncon t) {
    }

    public void miseAJourCoordonneesTroncon(String table, List<Troncon> troncons) {
    }

    public void importZoneOmbre(String fichierCSV) {
    }

    public void miseAJourPRTroncon(String table, Troncon t) {
    }

    public List<TronconESVHBean> getEtatSurfaceVHTroncons(String idCircuit) {
        return null;
    }

    public void saveEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
    }

    public void updateEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
    }

    public void saveEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
    }

    public void updateEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
    }

    public void addEtatSurfaceVHPr(PrESVHBean prESVH) {
    }

    public void deleteEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
    }

    public List<TronconESVHBean> getTronconsVH(Circuit c) {
        return null;
    }

    public List<PrESVHBean> getEtatSurfaceVHPrs(String idCircuit) {
        return null;
    }

    public List<TronconESVHBean> getTronconsVHaRenouveler(String delegation, long ageMax) {
        return null;
    }

    public List<PrESVHBean> getPrsVHaRenouveler(String delegation, long ageMax) {
        return null;
    }

    public List<Restriction> getStylesPublication() {
        return null;
    }

    public void datePublicationMaj() {
    }

    public List<PrESVHBean> getEtatSurfaceVHPrs() {
        return null;
    }

    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        return null;
    }

    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        return null;
    }

    public Rectangle2D getExtentPatrouille(List<String> ids_patrouille) {
        return null;
    }

    public List<SynthesePatrouillesVHBean> getAnalysePatrouillesVH(Timestamp dateDebut, Timestamp dateFin) {
        return null;
    }

    public List<String> getSynthesePatrouilleRegroupeeIds(String idPatrouille, int codeMM) {
        return null;
    }

    public List<CircuitESVHBean> getDerniersCircuitsVHModifies(String delegation) {
        return null;
    }

    public void updateDateModificationAdmin(String donnees) {
    }

    public void remiseAZeroBarreauxVH(Date dateCourante, int nbMinutesValidites, ConstantesPrismCommun.EnumVHTypeCCH cch, String mcigId) {
    }

    public void miseAJourEvenementPrevisionnel(List<String> ret) {
    }

    public List<String> verificationEtatEvenementPrevisionnel() {
        return null;
    }

    public void saveEtatSurfaceVH(List<String> circuitIds, int etatSurface) {
    }

    public List<Circuit> getCircuitsVHActifs() {
        return null;
    }

    public List<BarreauVH> getBarreauxVH(int circuit, boolean sansCoordonnees) {
        return null;
    }

    public Map<String, List<Direction>> getDirections() {
        return null;
    }

    public void verifierEtatNiveauService() {
    }

    public List<Circuit> getListeCircuitsParEtatNiveauService(PrismCentralUser userConnecte, int etatNiveauService) {
        return null;
    }

    public void updateEtatSurfaceVHCircuits(List<String> circuits) {
    }

    public void pasDeChangementBarreauxVH(int circuit, String mcigId) {
    }

    public void remiseAZeroBarreauxVH(int circuit, String mcigId) {
    }

    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(Circuit circuit, Timestamp dateMin, int bufferSize, double ratioParcours, boolean tronconPreCalcules) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(List<Circuit> circuits, Timestamp dateMin, int bufferSize, double ratioParcours) {
        return null;
    }

    public void precalculEtatNiveauService() {
    }

    public boolean verificationMainCouranteEmbarque(PrismCentralUser user, MainCourante m) {
        return false;
    }

    public void creerMessageAlertePublication(MessageAlertePublication message) {
    }

    public void updateMessageAlertePublication(MessageAlertePublication message) {
    }

    public List<MessageAlertePublication> getMessagesAlertePublication() {
        return null;
    }

    public void deleteMessageAlertePublication(MessageAlertePublication message) {
    }

    public TreeMap<String, String> getModelesMessagePublicationAlerte() {
        return null;
    }

    public TreeMap<String, String> getModelesMessagePublicationSynthese() {
        return null;
    }

    public HashMap<String, String> getSavePublicationEvenement(Evenement e) {
        return null;
    }

    public void saveGetPublicationEvenement(Evenement e, String type1, String complement1, String valeur1, String type2, String complement2, String valeur2, String type3, String complement3, String valeur3, String type4, String complement4, String valeur4, String type5, String complement5, String valeur5) {
    }

    public void publierCopieBarreauxVH(String mcigId) {
    }

    public List<ConfigurationBean> getListConfigurationPublication() {
        return null;
    }

    public void updateConfigurationPublicationBean(ConfigurationBean config) {
    }

    public void miseAJourGeometryEvenement(Evenement evt) {
    }

    public Map<String, Map<?, ?>> getScoopConfiguration() {
        return null;
    }

    public void diffusionVH(String object, String message, ListeDestinataireMail liste) {
        this.mailService.diffusionVH(object, message, liste);
    }

    public boolean remiseAZeroBarreauxVHPublication(Date dateCourante, int nbMinutesValidites, ConstantesPrismCommun.EnumVHTypeCCH cch, String mcigId) {
        return false;
    }

    public boolean remiseAZeroSyntheseVHPublication(Date dateCourante, int nbMinutesValidites) {
        return false;
    }

    public List<Tunnel> getTunnels() {
        return null;
    }

    public List<ParametrePatrouille> getParametresPatrouille() {
        return null;
    }

    public void verifierReferentielMaj() {
    }

    public void miseAJourParametresPatrouille(DonneesSynchro d) {
    }

    public void pasDeChangementBarreauxVH(String delegation, String centre, int circuit, String mcigId) {
    }

    public void remiseAZeroBarreauxVH(String delegation, String centre, int circuit, String mcigId) {
    }

    public List<BarreauVH> getBarreauxVH(String delegation, String centre, int circuit, boolean sansCoordonnees) {
        return null;
    }

    public List<Partenaire> getListePartenaire(int type) throws SQLException {
        return null;
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees, int bufferSize) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(Timestamp dateMin, int bufferSize, int i, boolean tronconPreCalcules) {
        return null;
    }

    public List<String> getSchemaRoutierAxes(Delegation delegation, Centre centre) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(List<Centre> centres, Timestamp dateMin, int bufferSize, int i, boolean tronconPreCalcules, String axe) {
        return null;
    }

    public void precalculSchemaRoutier() {
    }

    public Map<String, Map<?, ?>> getIG4Configuration() {
        return null;
    }

    public void importTronconsPr(String table, String nomChamp, String fichierCSV) {
    }

    public String getPublicationValeurPeriode(Evenement e) {
        return null;
    }

    public Evenement getDernierEvenementActif(String idSit, String idEvt) {
        return null;
    }

    public PrismCentralUser loginLDAP(String login) {
        return null;
    }

    public int countUsersByProfile(int idProfil) {
        return 0;
    }

    public void deleteProfil(int idProfil) {
    }

    public Date getDateGenerationStatSchemaRoutier() {
        return null;
    }

    public Nature getNatureFromDescription(String codeDescription) {
        return null;
    }

    public String getUserConnectionType(String login) {
        return null;
    }

    public boolean verificationMainCourante(PrismCentralUser user, MainCourante m, int typeSupport) {
        return false;
    }

    public List<TypeUtilisateur> getTypesUtilisateur() {
        return null;
    }

    public EvenementTriListe getEvenementTriListe(String codeNature) {
        return null;
    }

    public Map<String, EvenementTriListe> getEvenementTriListe() {
        return null;
    }

    public void lancementTachesQuotidiennes() {
    }

    public void nouvelleAction(ActionCentral a) {
    }

    public PatrouilleSemaineList getPatrouilleSemaineBean(Timestamp debut, Timestamp fin) {
        return null;
    }

    public List<BarreauVH> getBarreauVHMisAJour(Date dateDerniereVerification) {
        return null;
    }

    public List<Patrouille> getPatrouilles(double lat, double lon, String delegation, String centre, int nbPatrouillesARechercher, Timestamp dateDebut, Timestamp dateFin) {
        return null;
    }

    public List<Localisation> getLocalisationsPatrouille(String idMCIG) {
        return null;
    }

    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouille, boolean lateralize) {
        return null;
    }

    public List<Patrouille> getPatrouilles(String idPatrouille) {
        return null;
    }

    public void deleteUtilisateur(int idUtilisateur) {
    }

    public void anonymisation(PrismCentralUser u) {
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees, boolean sansCoordonnees2) {
        return null;
    }

    public List<BarreauVH> getBarreauxVH(String lowerCase, String string, boolean sansCoordonnees, boolean sansCoordonnees2) {
        return null;
    }

    public Date getHistoriqueCCHDate(Date dateHistoriqueRecherche) {
        return null;
    }

    public List<BarreauVH> getHistoriqueCCHTroncon(Date datePublication) {
        return null;
    }

    public List<BarreauVH> getHistoriqueTronconVH(Date dateHistoriqueRecherche) {
        return null;
    }

    public boolean viserVehiculeEnIntervention(VehiculeEnIntervention v) {
        return false;
    }

    public boolean isEvenementHasPhoto(long idEvenement) {
        return false;
    }

    public SyntheseViseeBean getSyntheseViseeBean(Timestamp debut, Timestamp fin, int typePatrouille, String delegation, String centre) {
        return null;
    }

    public List<String> getCentresBulletin() {
        return null;
    }

    public void pausePatrouille(DonneesSynchro d, boolean ajoutCommentaire) {
    }

    public Collection<TronconSuivi> getTronconsSales(List<Integer> codeModuleMetier) {
        return null;
    }

    public Collection<TronconSuivi> getTronconsDeneiges(List<Integer> codeModuleMetier) {
        return null;
    }

    public Collection<TronconSuivi> getTronconsSalageDeneigement(Set<String> idPatrouilleSuivi) {
        return null;
    }

    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles, String adresseServeur) {
        return null;
    }

    public List<String> getListeCaracteristiquesRoute() {
        return null;
    }

    public List<FauchageExploitation> getFauchageExploitation(List<FiltreJava> filtresJava) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueFauchageBean> getStatistiqueFauchageTroncons(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe) {
        return null;
    }

    public Date getDateGenerationStatSchemaFauchage() {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueFauchageBean> getFauchageStatistiqueSchema(List<Centre> centres, Timestamp dateMin, Timestamp dateMax, int bufferSize, int ratio, String axe, boolean dateDernierPassageConnue) {
        return null;
    }

    public List<String> getNiveauxExploitation() {
        return null;
    }

    public BulletinMediaVH2 initBulletinMediaVH() {
        return null;
    }

    public PrismCentralUser getUtilisateur(int codeUtilisateur) {
        return null;
    }

    public long getMaxDateMiseAJourVH() {
        return 0L;
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, boolean force) {
        return false;
    }

    public boolean transmettreBarreauxSerpeVH(boolean selectionBarreauxParDelegation, List<BarreauVH> barreaux) {
        return false;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierTroncons(List<Centre> centres, Timestamp dateMin, int bufferSize, int i, boolean tronconPreCalcules, String axe, boolean dateDernierPassageConne) {
        return null;
    }

    public List<Ua> getUas() {
        return null;
    }

    public List<Ua> getUasScoop() {
        return null;
    }

    public void supprimerMarqueVehicule(MarqueVehicule typeVehicle) {
    }

    public void creerUa(Ua ua) {
    }

    public void updateUa(Ua ua) {
    }

    public void archiveUa(Ua ua) {
    }

    public Connection getConnectionForTransaction() throws DAOConfigurationException, SQLException {
        return null;
    }

    public Map<Integer, ModuleMetier> getScoopCorresModuleMetier() {
        return null;
    }

    public void importZoneOmbre(ZoneSensible zoneOmbrePrism) {
    }

    public void importBarreauxVH(BarreauVH barreauVh) {
    }

    public void previsionPatrouilleBarreauxVH(String delegation, String centre, int circuit, String mcigId) {
    }

    public void previsionPatrouilleBarreauxVH(int circuit, String mcigId) {
    }

    public void previsionPatrouilleBarreauxVH(String delegation, String centre, String mcigId) {
    }

    public BulletinMediaVH2 getDernierBulletinMediaVH() {
        return null;
    }

    public BulletinMediaVH2 getBulletinMediaVH(int id_bulletin) {
        return null;
    }

    public void enregistrerBulletinMediaVH2(BulletinMediaVH2 bulletin) {
    }

    public BulletinInforoute getDernierBulletinInforoute() {
        return null;
    }

    public List<String> getCentresBulletinOrdonnees() {
        return null;
    }

    public List<List<double[]>> localisationTroncon(String axe, String dptd, String prd, double abd, String dptf, String prf, double abf) {
        return null;
    }

    public List<Parametre> getParametres() {
        return null;
    }

    public void updateParametre(String k, String valeurString) {
    }

    public void deleteZonesOmbre() {
    }

    public void deleteBarreauxVH() {
    }

    public boolean exportationEvenementsInforoute(List<Partenaire> partenairesExternes, List<Partenaire> partenairesATraiter, List<EvenementInforoute> evtsInforoute) {
        return false;
    }

    public void miseAJourOrdreNature(List<Nature> natures) {
    }

    public void deleteCorrespondanceEvent(String[] ids) {
    }

    public void insertCorrespondanceEvent(List<NatureEtDescriptionScoop> listeCorres) {
    }

    public void deleteProfil(Profil profil) {
    }

    public void verifierDonneesVH() {
    }

    public ComposantBean getComposant(String nom, boolean withZoneRoutiere) {
        return null;
    }

    public boolean deleteComposant(String composant) {
        return false;
    }

    public Map<String, Map<?, ?>> getScoopConfigurationIHM() {
        return null;
    }

    public List<Partenaire> getListePartenaireExportEvenement(String nature) throws SQLException {
        return null;
    }

    public Commune getCommune(String commune) {
        return null;
    }

    public ApachePoiConvert getApachePoiConvert(String idConfig) {
        return null;
    }

    public List<Partenaire> getListePartenaireExportEvenementAxione(String nature) throws SQLException {
        return null;
    }

    public void exportEvenementAxione(Evenement evenement) throws Exception {
    }

    public Rectangle2D getExtentMcig(List<String> mcigId) {
        return null;
    }

    public File getIconHd(String code) {
        return null;
    }

    public List<String> getVehiculesEnInterventionActivites(VehiculeEnIntervention vehicule) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getModuleMetierSRStatistiqueSchema(ModuleMetier moduleMeiter, List<Centre> centres, Timestamp dateMin, Timestamp dateMax, int bufferSize, int ratio, String axe, boolean dateDernierPassageConnue) {
        return null;
    }

    public void arriveeDomicile(PrismCentralUser u, MapDescription m) {
    }

    public Map<String, Map<String, List<PrismAction>>> getListePrismActions() {
        return null;
    }

    public List<PrismAction> getPrismActions(String type, Evenement e) {
        return null;
    }

    public DescriptionNature getDescriptionFromCode(String codeDescription) {
        return null;
    }

    public Map<String, Integer> getNaturesMm() {
        return null;
    }

    public void visaIntervention(PrismCentralUser u, Evenement evenement) {
    }

    public List<String> getNiveauxExploitation(String string) {
        return null;
    }

    public Rectangle2D getExtentTroncons(List<String> tronconsId) {
        return null;
    }

    public Collection<? extends TronconSuivi> getTronconsSalageDeneigementActif(Set<String> patrouilles) {
        return null;
    }

    public List<NiveauServicePeriode> getNiveauxServicePeriodes(long id) {
        return null;
    }

    public List<SyntheseTableauBordFrequencePatrouilleV2Bean> getFrequencePatrouilleV2Troncons(Circuit circuit, Timestamp dateDebut, int bufferSize, double ratioParcours) {
        return null;
    }

    public boolean alerte(AlerteRequete req) {
        return false;
    }

    public void validationPointsPassage(MainCourante m, Map<ZoneSensible, Long> l) {
    }

    public Map<String, Long> getZonesValidees(String zone, long dateDebut, long dateFin) {
        return null;
    }

    public void precalculSchemaExploitation(String fonctionExploitation) {
    }

    public void setServletContext(Object sc) {
    }

    public List<BarreauVHHisto> getBarreauxVHHistorique(String delegation, String centre, int circuit, boolean b, Date value, Date value2) {
        return null;
    }

    public List<BarreauVHHisto> getBarreauxVHExtend(String delegation, String centre, Integer circuit, boolean b) {
        return null;
    }

    public List<BarreauVHHisto> getBarreauxVHHistorique(BarreauVH barreauVh, Date dateDebut, Date dateFin) {
        return null;
    }

    public Object getServletContext() {
        return null;
    }

    public List<String> getSchemaAxes(Delegation delegation, Centre centre, String tabble) {
        return null;
    }

    public Map<Integer, List<String>> getListeCategoriesNatureMm() {
        return null;
    }

    public Map<String, String> getListeCategoriesNature() {
        return null;
    }

    public List<Patrouille> getPatrouilles(List<Integer> modulesMetier, List<String> delegations, List<String> centres, Timestamp dateDebut, Timestamp dateFin) {
        return null;
    }

    public String getMCIGFromPatrouille(String patrouilleId) {
        return null;
    }

    public StatsCamionsVHBean getCamionsVH(Timestamp dateDebut, Timestamp dateFin, List<String> centres) {
        return null;
    }

    public Map<Integer, Integer> getNbAgents(List<Integer> listeKEventId) {
        return null;
    }

    public void updateBarreauVHDonnesExterne(List<BarreauVH> barreaux) {
    }

    public void updateUserPassword(String code, String newpwd, boolean hash) {
    }

    public String getDescriptionComposant(String nomComposant) {
        return null;
    }

    public HashMap<Integer, HashMap<String, Boolean>> getDestinatairesFonctionsMail(int idListeDestinataire) {
        return null;
    }

    public void updateDestinatairesFonctionsMail(int idListe, HashMap<Integer, HashMap<String, Boolean>> mapDiffusion) {
    }

    public void cancelVisaIntervention(PrismCentralUser u, Evenement evenement) {
    }

    public void updateBarreauVH(BarreauVH barreau, boolean force) {
    }

    public void updateBarreauVHCCH(BarreauVH barreau, boolean force) {
    }

    public Map<String, List<String>> getAstreintesCommune() {
        return null;
    }

    public Map<String, Map<String, List<String>>> getTronconsAffectation() {
        return null;
    }

    public Map<String, List<Troncon>> getTronconsCentre() {
        return null;
    }

    public List<FauchagePasseType> listeTypePasse() {
        return null;
    }

    public void creerFauchagePasse(FauchagePasse object) {
    }

    public void updateFauchagePasse(FauchagePasse object) {
    }

    public List<FauchagePasse> rechercheFauchage(String delegation, String centre) {
        return null;
    }

    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi, boolean lateralized) {
        return null;
    }

    public Evenement getDernierEvenementActifAvecRecalculTerritoire(Evenement evt) {
        return null;
    }

    public List<SynthesePatrouilleBean> getSynthesePatrouilleBean(Timestamp dateDebutValue, Timestamp dateFinValue, int typePatrouilleValue, String delegationValue, String centreValue) {
        return null;
    }

    public void associerEvenement(IEvenementASauvegarder event, String nouvelleSituation) {
    }

    public List<FauchageCircuitPasse> rechercheFauchageCircuitPasse(String delegation, String centre) {
        return null;
    }

    public List<InformationInterventionBean> getInformationIntervention(int keventid) {
        return null;
    }

    public void updateFauchageCircuitPasse(FauchageCircuitPasse object) {
    }

    public List<InformationInterventionBean> getInformationIntervention(Evenement e) {
        return null;
    }

    public boolean diffusionSynthesePatrouille(int deltaHeureAvant, List<Integer> codesModulesMetier) {
        return false;
    }

    public SyntheseViseeBean getSynthesePatrouilleBean(Timestamp dateDebutValue, Timestamp dateFinValue, List<Integer> typePatrouilleValue, String delegationValue, String centreValue) {
        return null;
    }

    public Troncon getSchemaRoutierTroncons(int codeTroncon) {
        return null;
    }

    public InfoTerritoire getTerritoireEvenementAxePr(Evenement evenement, IUtilisateur utilisateur, String axe, int pr, int abscisse, String dpt, boolean rechercheCentreGeometrie) throws RuntimeException {
        return null;
    }

    public Map<String, Map<String, Map<Integer, Map<String, Integer>>>> getStatsSimplePatrouillesParAnnee(int annee) {
        return null;
    }

    public String getLibelleCorrespondance(String code) {
        return null;
    }

    public InfoTerritoire getTerritoireEvenementGeometrieCentre(Evenement evenement, IUtilisateur utilisateur) throws RuntimeException {
        return null;
    }

    public SyntheseInterventionAgentBean getSyntheseInterventionAgentBean(Timestamp dateDebutValue, Timestamp dateFinValue, String delegationValue, String centreValue, String agentValue) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int i, Timestamp timestamp, Timestamp timestamp1, String s, String s1, String idCircuit) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int i, String s, String s1, String s2, String idCircui) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(Timestamp timestamp, Timestamp timestamp1, int i, String s, String s1) {
        return null;
    }

    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(List<Centre> list, Timestamp timestamp, int i, int i1, boolean b, String s, boolean b1) {
        return null;
    }

    public List<TronconStats> getRoadsAmplitude(String s) {
        return null;
    }

    public boolean diffusionEvenementsDepasses(String delegation, String centre) {
        return false;
    }

    public Map<String, Map<String, List<String>>> getReferentielCentre() {
        return null;
    }

    public byte[] getDocumentEvenement(String documentName) {
        return null;
    }
}

