/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.onedrive;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.onedrive.PrismOneDriveFile;
import com.geolocsystems.prismcentral.beans.onedrive.PrismOneDriveFolder;
import com.geolocsystems.prismcentral.onedrive.OneDriveFolder;
import com.geolocsystems.prismcentral.onedrive.Value;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Set;

public class OneDriveUtils {
    private static String SITE_ID = "";
    private static String CLIENT_ID = "";
    private static String AUTHORITY = "";
    private static String CLIENT_SECRET = "";
    private static Set<String> SCOPE = Collections.singleton("https://graph.microsoft.com/.default");
    private static String TOKEN = "";
    private static long TOKEN_VALIDITY = -1L;
    private static PrismOneDriveFolder rootFolder = new PrismOneDriveFolder();
    private static int VALIDITY_DELAY = 300000;
    private static int EXPLORE_LEVEL = -1;
    private static OneDriveUtils INSTANCE = null;

    private OneDriveUtils() {
        BusinessServiceDAO service = new BusinessServiceDAO();
        SITE_ID = service.getConfiguration().getString("OneDriveSiteId");
        CLIENT_ID = service.getConfiguration().getString("OneDriveClientId");
        AUTHORITY = "https://login.microsoftonline.com/" + service.getConfiguration().getString("OneDriveAuthorityId") + "/";
        CLIENT_SECRET = service.getConfiguration().getString("OneDriveClientSecret");
        VALIDITY_DELAY = service.getConfiguration().getInt("OneDriveValidityDelay", 1) * 1000 * 60;
        EXPLORE_LEVEL = service.getConfiguration().getInt("OneDriveExploreLevel", 0);
    }

    private static String getToken() {
        if (TOKEN_VALIDITY < System.currentTimeMillis()) {
            try {
                IAuthenticationResult authResult = OneDriveUtils.acquireToken();
                TOKEN = authResult.accessToken();
                TOKEN_VALIDITY = authResult.expiresOnDate().getTime();
                System.out.println(TOKEN_VALIDITY);
                System.out.println(System.currentTimeMillis());
                System.out.println(TOKEN_VALIDITY - System.currentTimeMillis());
            }
            catch (Exception e) {
                TOKEN = "";
                TOKEN_VALIDITY = -1L;
                e.printStackTrace();
            }
        }
        return TOKEN;
    }

    public static synchronized OneDriveUtils getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OneDriveUtils();
        }
        return INSTANCE;
    }

    public synchronized PrismOneDriveFolder getRoot(Boolean recursif) throws Exception {
        Log.debug("expire : " + rootFolder.getExpire() + " > ? " + System.currentTimeMillis());
        if (rootFolder.getExpire() > System.currentTimeMillis()) {
            Log.debug("recup cache");
        } else {
            Log.debug("recup cloud");
            rootFolder = this.getFolder(rootFolder, "", "", 0, 1, recursif);
        }
        return rootFolder;
    }

    public synchronized PrismOneDriveFolder getFolder(PrismOneDriveFolder folderRetour, String driveId, String folderId, int niveau, int nbRecursif, boolean recursif) throws Exception {
        String output;
        if (folderRetour == null) {
            folderRetour = new PrismOneDriveFolder();
        }
        String uri = "";
        uri = "".equals(driveId) ? "https://graph.microsoft.com/v1.0/sites/" + SITE_ID + "/drive/root/children" : "https://graph.microsoft.com/v1.0/sites/" + SITE_ID + "/drives/" + driveId + "/items/" + folderId + "/children";
        System.out.println(uri);
        URL url = new URL(uri);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + OneDriveUtils.getToken());
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.connect();
        BufferedReader br1 = null;
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        if (100 <= con.getResponseCode() && con.getResponseCode() <= 399) {
            br1 = new BufferedReader(new InputStreamReader(con.getInputStream()));
        } else {
            br1 = new BufferedReader(new InputStreamReader(con.getErrorStream()));
            error = true;
        }
        sb = new StringBuilder();
        while ((output = br1.readLine()) != null) {
            sb.append(output);
        }
        if (error) {
            Log.error(sb.toString());
            return folderRetour;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OneDriveFolder folder = (OneDriveFolder)mapper.readValue(sb.toString(), OneDriveFolder.class);
        folderRetour.setSiteId(SITE_ID);
        folderRetour.setFolderId(folderId);
        folderRetour.getFoldersMap().clear();
        folderRetour.getFilesMap().clear();
        for (Value value : folder.value) {
            if (value.folder != null) {
                String folderName = "";
                for (int i = 0; i < niveau; ++i) {
                    folderName = folderName + "-";
                }
                folderName = folderName + value.name + "(" + value.folder.childCount + ")";
                System.out.println(folderName);
                PrismOneDriveFolder childrenFolder = new PrismOneDriveFolder();
                if (value.folder.childCount > 0 && (EXPLORE_LEVEL == -1 || nbRecursif <= EXPLORE_LEVEL)) {
                    childrenFolder = this.getFolder(childrenFolder, value.parentReference.driveId, value.id, niveau + 1, nbRecursif + 1, recursif);
                }
                childrenFolder.setSiteId(SITE_ID);
                childrenFolder.setDriveId(value.parentReference.driveId);
                childrenFolder.setFolderName(value.name);
                childrenFolder.setFolderId(value.id);
                childrenFolder.setParentId(folderId);
                try {
                    String[] path = value.parentReference.path.split("root:/");
                    if (path.length > 1) {
                        childrenFolder.setPath("\\" + path[1].replace("/", "\\") + "\\" + value.name);
                        folderRetour.setPath("\\" + path[1].replace("/", "\\"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                folderRetour.getFoldersMap().put(value.id, childrenFolder);
            }
            if (value.file == null) continue;
            String fileName = "";
            for (int i = 0; i < niveau; ++i) {
                fileName = fileName + "-";
            }
            fileName = fileName + value.name + " : " + value.microsoftGraphDownloadUrl;
            PrismOneDriveFile childrenFile = new PrismOneDriveFile();
            childrenFile.setFileId(value.id);
            childrenFile.setFileName(value.name);
            childrenFile.setDownloadUrl(value.microsoftGraphDownloadUrl);
            childrenFile.setParentId(folderId);
            childrenFile.setLastModifiedDateTime(value.lastModifiedDateTime);
            System.out.println(fileName + " (" + value.lastModifiedDateTime + ")");
            folderRetour.getFilesMap().put(value.id, childrenFile);
        }
        folderRetour.setExpire(System.currentTimeMillis() + (long)VALIDITY_DELAY);
        return folderRetour;
    }

    public static PrismOneDriveFolder rechercheFolder(PrismOneDriveFolder folder, String folderId) {
        PrismOneDriveFolder retour = null;
        if (folderId.equals(folder.getFolderId())) {
            Log.debug("retour folder " + folder.getFolderId());
            return folder;
        }
        for (PrismOneDriveFolder children : folder.getFoldersMap().values()) {
            if (folderId.equals(children.getFolderId())) {
                if (children.getExpire() == 0L || children.getExpire() < System.currentTimeMillis()) {
                    Log.debug("recup cloud");
                    try {
                        children = OneDriveUtils.getInstance().getFolder(children, children.getDriveId(), children.getFolderId(), 1, 0, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Log.debug("recup cache");
                }
                return children;
            }
            if (children.getFoldersMap().size() <= 0 || (retour = OneDriveUtils.rechercheFolder(children, folderId)) == null) continue;
            return retour;
        }
        return retour;
    }

    public static String getPath(PrismOneDriveFolder folder) {
        String retour = "\\";
        retour = folder.getPath();
        return retour;
    }

    private static IAuthenticationResult acquireToken() throws Exception {
        IClientSecret credential = ClientCredentialFactory.createFromSecret((String)CLIENT_SECRET);
        ConfidentialClientApplication cca = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)CLIENT_ID, (IClientCredential)credential).authority(AUTHORITY)).build();
        ClientCredentialParameters parameters = ClientCredentialParameters.builder(SCOPE).build();
        return (IAuthenticationResult)cca.acquireToken(parameters).join();
    }

    public static boolean isValueValide(String valeur) {
        if (null == valeur || "".equals(valeur) || "|".equals(valeur)) {
            return false;
        }
        Log.debug("valeur : " + valeur.split("\\|").length + " : " + valeur);
        return valeur.split("\\|").length == 2;
    }

    public static String[] splitValueFrom(String valeur) {
        if (OneDriveUtils.isValueValide(valeur)) {
            String[] valeurs = valeur.split("\\|");
            return valeurs;
        }
        String[] retour = new String[]{"", ""};
        return retour;
    }

    public static String convertValueFrom(String driveId, String folderId) {
        if ("".equals(folderId)) {
            return "";
        }
        return driveId + "|" + folderId;
    }
}

