/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.mail;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.mail.Mail;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingDeque;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SendMailServiceThread
implements Runnable {
    private static SendMailServiceThread instance;
    private LinkedBlockingDeque<Mail> buffer = new LinkedBlockingDeque();

    public static SendMailServiceThread getInstance() {
        if (instance == null) {
            instance = new SendMailServiceThread();
            Thread t = new Thread(instance);
            t.start();
        }
        return instance;
    }

    public static boolean estTerminee() {
        return instance == null || SendMailServiceThread.getInstance().aFiniEnvoiMail();
    }

    public boolean aFiniEnvoiMail() {
        return this.buffer == null || this.buffer.isEmpty();
    }

    private SendMailServiceThread() {
    }

    public void sendMail(Mail o) {
        this.buffer.offer(o);
    }

    public static void stop(int attenteAvantKill) {
        if (instance != null) {
            instance.stopInstance(attenteAvantKill);
        }
    }

    public static void stop() {
        SendMailServiceThread.stop(60);
    }

    private void stopInstance(int attenteAvantKill) {
        int i = 1;
        while (!SendMailServiceThread.estTerminee() && i < attenteAvantKill) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ex) {
                Log.error("ERREUR THREAD FIN SLEEP", ex);
            }
            Log.info("Attente de la fin de l'envoi des mails..." + i++);
        }
        SendMailServiceThread.kill();
    }

    public static void kill() {
        instance = null;
    }

    @Override
    public void run() {
        Mail o;
        try {
            o = this.buffer.take();
        }
        catch (Throwable t) {
            o = null;
            Log.error("WTF ???", t);
        }
        while (o != null) {
            try {
                this.doSendMail(o);
                Log.debug("doSendMail OK");
            }
            catch (Throwable t) {
                Log.error("doSendMail KO", t);
            }
            try {
                o = this.buffer.take();
                Log.info("Mail restant \u00e0 envoyer " + this.buffer.size());
            }
            catch (Throwable t) {
                o = null;
                Log.error("WTF ???", t);
            }
        }
        Log.debug("arr\u00eat du service d'envoi de mail");
        instance = null;
    }

    private void doSendMail(Mail o) {
        try {
            IConfiguration config = ConfigurationFactory.getInstance();
            final String username = config.get("mail.smtp.username");
            final String password = config.get("mail.smtp.password");
            Properties props = new Properties();
            props.put("mail.smtp.auth", config.get("mail.smtp.auth"));
            props.put("mail.smtp.starttls.enable", config.get("mail.smtp.starttls.enable"));
            props.put("mail.smtp.ssl.trust", config.get("mail.smtp.ssl.trust"));
            props.put("mail.smtp.ssl.enable", config.get("mail.smtp.ssl"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.host", config.get("mail.smtp.host"));
            props.put("mail.smtp.port", config.get("mail.smtp.port"));
            Session session = null;
            session = username == null || username.equals("") ? Session.getDefaultInstance((Properties)props) : Session.getInstance((Properties)props, (Authenticator)new Authenticator(this){
                final /* synthetic */ SendMailServiceThread this$0;
                {
                    this.this$0 = this$0;
                }

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setSender((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)o.getTo()));
            message.setSubject(o.getObject(), "utf-8");
            message.setHeader("Content-Type", "text/plain; charset=UTF-8");
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)o.getBody(), "text/html; charset=utf-8");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)body);
            for (IFileAttachment attachment : o.getAttachments()) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachment.getFile())));
                part.setFileName(attachment.getFileName());
                mp.addBodyPart((BodyPart)part);
            }
            message.setContent((Multipart)mp);
            if (username == null || username.equals("")) {
                Transport.send((Message)message, (Address[])message.getAllRecipients());
            } else {
                Transport transport = session.getTransport("smtp");
                transport.connect(config.get("mail.smtp.host"), username, password);
                transport.sendMessage((Message)message, message.getAllRecipients());
                transport.close();
            }
        }
        catch (Throwable t) {
            Log.error("Erreur envoi mail", t);
            throw new RuntimeException(t);
        }
    }
}

