/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.mail;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.echanges.AlerteRequete;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.ListeDiffusion;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.data.IMailService;
import com.geolocsystems.prismcentral.mail.FicheEvenementAttachment;
import com.geolocsystems.prismcentral.mail.FileAttachment;
import com.geolocsystems.prismcentral.mail.Mail;
import com.geolocsystems.prismcentral.mail.SendMailServiceThread;
import com.geolocsystems.prismcentral.mail.SynthesePatrouilleAttachement;
import com.geolocsystems.prismcentral.mail.VHAttachment;
import com.geolocsystems.prismcentral.mail.i18n.MailI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;

public class MailService
implements IMailService {
    private IBusinessService businessService;
    private IExportService exportService;
    private DateFormat dateHeureFormat;
    private static final String NEWLINE = "\n";
    private static final String NEWLINEHTML = "<br>";
    private static final String BULLET = "\u2022 ";
    private static final String ESPACE = " ";
    private boolean ajouterCentreObjet = false;

    public MailService(IBusinessService businessService, IExportService exportService) {
        this.businessService = businessService;
        this.exportService = exportService;
        this.ajouterCentreObjet = businessService.getConfiguration().getBoolean("mail.evenement.objet.centre", false);
        Log.debug("[ENVOIE MAIL] AJOUTER CENTRE OBJET " + this.ajouterCentreObjet);
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateHeureFormat = new SimpleDateFormat(MailI18n.getString("format.dateheure"), locale);
    }

    public void testMessage(String email) {
        this.testMessage(email, null);
    }

    public void testMessage(String email, List<IFileAttachment> attachment) {
        Mail o = new Mail(email, "PRISM test", "ceci est un message de test\n" + new Date());
        if (attachment != null) {
            for (IFileAttachment file : attachment) {
                o.addAttachment(file);
            }
        }
        this.sendMail(o);
    }

    public void sendMessage(String email, String object, String body, List<File> attachment) {
        Mail o = new Mail(email, object, body);
        if (attachment != null) {
            for (File file : attachment) {
                o.addAttachment(new FileAttachment(file));
            }
        }
        this.sendMail(o);
    }

    public void sendMessageFileAttachment(String email, String object, String body, List<IFileAttachment> attachment) {
        Mail o = new Mail(email, object, body);
        if (attachment != null) {
            for (IFileAttachment file : attachment) {
                o.addAttachment(file);
            }
        }
        this.sendMail(o);
    }

    public void evenement(Evenement evt) {
        ListeDestinataireMail liste = this.getListeEvenement(evt);
        if (liste != null) {
            String etat;
            String object = null;
            String body = null;
            HashMap mapDiffusion = this.businessService.getDestinatairesFonctionsMail(liste.getId());
            Evenement e = this.businessService.getDernierEvenementActifAvecRecalculTerritoire(evt);
            Nature n = (Nature)this.businessService.getNatures().get(e.getValeurNature().getCode());
            if (e.isTermine()) {
                etat = "cloture_evt";
                object = MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.closed") + ")";
                body = MailI18n.getString("evt.closed.body");
                body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            } else if (e.isTraite()) {
                etat = "traitement_evt";
                object = MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.traite") + ")";
                body = MailI18n.getString("evt.traite.body");
                body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            } else if (e.getNumVersion() > 1) {
                etat = "modification_evt";
                object = MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.updated") + ")";
                body = MailI18n.getString("evt.updated.body");
                body = body + NEWLINE + MetierCommun.getDescriptionDetailleeEvenement((Evenement)e, (Nature)n);
            } else {
                etat = "creation_evt";
                object = MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.created") + ")";
                body = MailI18n.getString("evt.created.body");
                body = body + NEWLINE + MetierCommun.getDescriptionDetailleeEvenement((Evenement)e, (Nature)n);
            }
            FicheEvenementAttachment fiche = new FicheEvenementAttachment(this.exportService, this.businessService, e);
            fiche.getFile();
            if (this.ajouterCentreObjet) {
                Log.debug("[ENVOIE MAIL] ENVOIE EVENEMENT OBJET CENTRE " + e.getCei());
                if (!GLS.estVide((String)e.getCei())) {
                    object = "[" + e.getCei() + "] " + object;
                }
            }
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                boolean evenementOkDelegationCentre = this.estEvenementOkCentreDelegation(e, destinataire);
                boolean etatEvtDestOk = true;
                try {
                    if (mapDiffusion.containsKey(destinataire.getId())) {
                        etatEvtDestOk = (Boolean)((HashMap)mapDiffusion.get(destinataire.getId())).get(etat);
                    }
                }
                catch (Exception ex) {
                    Log.error("ERR GET ETAT MAIL EVT OK ", ex);
                }
                Log.debug("MAIL EVT OK DEL CENTRE " + destinataire.getMail() + "--" + evenementOkDelegationCentre + " - D " + destinataire.getDelegation() + " - " + destinataire.getCentre() + " E -" + e.getDistrict() + " - " + e.getCei());
                Log.debug("MAIL ETAT EVT OK DEST " + etatEvtDestOk);
                if (!evenementOkDelegationCentre || !etatEvtDestOk) continue;
                Mail mail = new Mail(destinataire.getMail(), object, body);
                mail.addAttachment(fiche);
                this.sendMail(mail);
            }
        }
        if (evt.getUrgence() > 0) {
            this.evenementUrgent(evt);
        }
        if (MetierCommun.estDDP((Evenement)evt)) {
            this.evenementDdp(evt);
        }
    }

    public void visaIntervention(PrismCentralUser u, Evenement e) {
        ListeDestinataireMail liste = this.getListeDiffusion("visa_intervention");
        if (liste != null && !e.isTermine()) {
            String object = null;
            String body = null;
            Nature n = (Nature)this.businessService.getNatures().get(e.getValeurNature().getCode());
            object = u.getNom() + " : " + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.intervention.visa") + ")";
            body = MailI18n.getString("evt.intervention.visa.body");
            body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            FicheEvenementAttachment fiche = new FicheEvenementAttachment(this.exportService, this.businessService, e);
            this.envoieMail(liste, body, body, object, body, fiche);
        }
    }

    public void cancelVisaIntervention(PrismCentralUser u, Evenement e) {
        ListeDestinataireMail liste = this.getListeDiffusion("cancel_visa_intervention");
        if (liste != null && !e.isTermine()) {
            String object = null;
            String body = null;
            Nature n = (Nature)this.businessService.getNatures().get(e.getValeurNature().getCode());
            object = u.getNom() + " : " + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.intervention.cancelvisa") + ")";
            body = MailI18n.getString("evt.intervention.cancelvisa.body");
            body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            FicheEvenementAttachment fiche = new FicheEvenementAttachment(this.exportService, this.businessService, e);
            this.envoieMail(liste, body, body, object, body, fiche);
        }
    }

    public void arriveeDomicile(PrismCentralUser u, MapDescription m) {
        ListeDestinataireMail liste = this.getListeDiffusion("arrivee_domicile");
        if (liste != null) {
            Evenement evt;
            String erf;
            String object = null;
            String body = null;
            Log.debug("Mail arriv\u00e9e domicile " + u + " -- " + MailI18n.getString("arriveedomicile"));
            StringBuffer sb = new StringBuffer();
            if (u != null) {
                object = u.getNom() + " : ";
                body = u.getNom();
            }
            object = object + MailI18n.getString("arriveedomicile");
            String tmp = m.getString("dateArriveeDomicile", null);
            if (!GLS.estVide((String)tmp)) {
                object = object + " \u00e0 " + tmp;
            }
            body = body + ESPACE + MailI18n.getString("suffixearriveedomicile");
            tmp = m.getString("dateDepartSite", null);
            if (!GLS.estVide((String)tmp)) {
                body = body + " d'o\u00f9 il est parti \u00e0 " + tmp + ".";
            }
            if (GLS.estVide((String)(erf = m.getString("codeEvenement", ""))) || (evt = this.businessService.getDernierEvenementActif(null, erf)) != null) {
                // empty if block
            }
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                boolean evenementOkDelegationCentre = this.estEvenementOkCentreDelegation(u.getDelegation(), u.getCentre(), destinataire);
                Log.debug("MAIL ARR DOM OK DEL CENTRE " + destinataire.getMail() + "--" + evenementOkDelegationCentre + " - D " + destinataire.getDelegation() + " - " + destinataire.getCentre());
                if (!evenementOkDelegationCentre) continue;
                Mail mail = new Mail(destinataire.getMail(), object, body);
                this.sendMail(mail);
            }
        }
    }

    private void envoieMail(ListeDestinataireMail liste, String delegation, String centre, String object, String body, IFileAttachment attach) {
        for (DestinataireMail destinataire : liste.getDestinataires()) {
            boolean evenementOkDelegationCentre = this.estEvenementOkCentreDelegation(delegation, centre, destinataire);
            Log.debug("MAIL EVT OK DEL CENTRE " + destinataire.getMail() + "--" + evenementOkDelegationCentre + " - D " + destinataire.getDelegation() + " - " + destinataire.getCentre() + " E -" + delegation + " - " + centre);
            if (!evenementOkDelegationCentre) continue;
            Mail mail = new Mail(destinataire.getMail(), object, body);
            if (attach != null) {
                mail.addAttachment(attach);
            }
            this.sendMail(mail);
        }
    }

    private boolean estEvenementOkCentreDelegation(Evenement e, DestinataireMail d) {
        return this.estEvenementOkCentreDelegation(e.getDistrict(), e.getCei(), d);
    }

    private boolean estEvenementOkCentreDelegation(String district, String cei, DestinataireMail d) {
        boolean etat = false;
        etat = GLS.estVide((String)district) && GLS.estVide((String)cei) ? true : (GLS.estVide((String)cei) ? GLS.estVide((String)d.getDelegation()) || GLS.egal((String)district, (String)d.getDelegation()) : (GLS.estVide((String)d.getDelegation()) ? true : (GLS.estVide((String)d.getCentre()) ? GLS.egal((String)district, (String)d.getDelegation()) : GLS.egal((String)district, (String)d.getDelegation()) && GLS.egal((String)cei, (String)d.getCentre()))));
        return etat;
    }

    public void evenementUrgent(Evenement e) {
        ListeDestinataireMail liste = this.getListeDiffusion("urgence");
        if (liste != null) {
            String object = null;
            String body = null;
            e.getUrgence();
            Nature n = (Nature)this.businessService.getNatures().get(e.getValeurNature().getCode());
            object = "[URGENCE] ";
            if (e.getNumVersion() > 1) {
                object = object + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.updated") + ")";
                body = MailI18n.getString("evt.updated.body");
                body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            } else {
                object = object + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.created") + ")";
                body = MailI18n.getString("evt.created.body");
                body = body + NEWLINE + MetierCommun.getDescriptionDetailleeEvenement((Evenement)e, (Nature)n);
            }
            FicheEvenementAttachment fiche = new FicheEvenementAttachment(this.exportService, this.businessService, e);
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                Mail mail = new Mail(destinataire.getMail(), object, body);
                mail.addAttachment(fiche);
                this.sendMail(mail);
            }
        }
    }

    public void evenementDdp(Evenement e) {
        ListeDestinataireMail liste = this.getListeDiffusion("ddp");
        if (liste != null) {
            String object = null;
            String body = null;
            Nature n = (Nature)this.businessService.getNatures().get(e.getValeurNature().getCode());
            object = "[DDP] ";
            if (e.getNumVersion() > 1) {
                object = object + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.updated") + ")";
                body = MailI18n.getString("evt.updated.body");
                body = body + NEWLINE + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n);
            } else {
                object = object + MetierCommun.getDescriptionEvenement((Evenement)e, (Nature)n) + " (" + MailI18n.getString("evt.created") + ")";
                body = MailI18n.getString("evt.created.body");
                body = body + NEWLINE + MetierCommun.getDescriptionDetailleeEvenement((Evenement)e, (Nature)n);
            }
            FicheEvenementAttachment fiche = new FicheEvenementAttachment(this.exportService, this.businessService, e);
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                Mail mail = new Mail(destinataire.getMail(), object, body);
                mail.addAttachment(fiche);
                this.sendMail(mail);
            }
        }
    }

    private ListeDestinataireMail getListeEvenement(Evenement e) {
        List descriptions = (List)this.businessService.getDescriptionsNatureMap().get(e.getValeurNature().getCode());
        String codeDescription = null;
        for (DescriptionNature descriptionNature : descriptions) {
            if (!descriptionNature.getLibelle().equals(e.getValeurNature().getDescription().getValeur())) continue;
            codeDescription = descriptionNature.getCode();
        }
        Integer id = (Integer)this.businessService.getDesciptionDiffusionEvt().get(codeDescription);
        if (id == null) {
            return null;
        }
        for (ListeDestinataireMail l : this.businessService.getListeDestinataireMails()) {
            if (l.getId() != id.intValue()) continue;
            return l;
        }
        return null;
    }

    public void vehiculeEnDiffuculte(VehiculeEnIntervention v) {
        ListeDestinataireMail liste = this.getListeDiffusion("message_alerte");
        if (liste != null) {
            String object = MailI18n.getString("diff.title");
            StringBuffer message = new StringBuffer(MailI18n.getString("diff.message"));
            message.append(NEWLINE).append(BULLET);
            message.append(MailI18n.getString("diff.code")).append(ESPACE).append(v.getCode());
            message.append(NEWLINE).append(BULLET);
            message.append(MailI18n.getString("diff.driver")).append(ESPACE).append(v.getChauffeur());
            if (v.getTelephone() != null) {
                message.append(NEWLINE).append(BULLET);
                message.append(MailI18n.getString("diff.phone")).append(ESPACE).append(v.getCode());
            }
            message.append(NEWLINE).append(BULLET);
            message.append(MailI18n.getString("diff.start")).append(ESPACE).append(this.dateHeureFormat.format(new Date(v.getDebutPatrouille()))).append(".");
            if (v.getAxe() != null) {
                message.append(NEWLINE).append(BULLET);
                message.append(MailI18n.getString("diff.position")).append(ESPACE).append(v.getAxe());
                message.append(ESPACE).append(MailI18n.getString("diff.atpr")).append(ESPACE);
                message.append(v.getPr()).append("+").append(v.getAbspr());
            }
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                this.sendMail(new Mail(destinataire.getMail(), object, message.toString()));
            }
        }
    }

    public boolean alerte(AlerteRequete req) {
        ListeDestinataireMail liste = this.getListeDiffusion("alerte");
        boolean ret = false;
        if (liste != null) {
            PrismCentralUser user;
            String object = "Alerte sur le secteur " + req.getAxe() + " / " + req.getCommune() + " du v\u00e9hicule " + req.getVehicule().getCode();
            StringBuffer message = new StringBuffer();
            message.append("Une alerte vient d'\u00eatre d\u00e9tect\u00e9e sur le v\u00e9hicule suivant :").append(NEWLINEHTML);
            message.append(NEWLINEHTML);
            message.append("D\u00e9signation : ").append(req.getVehicule().getCode()).append(NEWLINEHTML);
            message.append("Immatriculation : ").append(req.getVehicule().getImmatriculation()).append(NEWLINEHTML);
            message.append("Agents : ").append(req.getUtilisateur().getNom());
            if (!GLS.estVide((String)req.getMaincourante().getCodeAccompagnateur())) {
                message.append(", " + req.getMaincourante().getCodeAccompagnateur());
            }
            message.append(NEWLINEHTML);
            String tel = null;
            if (!GLS.estVide((String)req.getMaincourante().getTelephone())) {
                message.append("T\u00e9l\u00e9phone (SIM) : ").append("<a href=\"tel:" + req.getMaincourante().getTelephone() + "\">Appel du <b>" + req.getMaincourante().getTelephone() + "</b></a>").append(NEWLINEHTML);
                tel = req.getMaincourante().getTelephone();
            }
            if ((user = this.businessService.getUtilisateur(req.getMaincourante().getCodeUtilisateur())) != null && !GLS.estVide((String)user.getTelephone())) {
                message.append("T\u00e9l\u00e9phone (Agent) : ").append("<a href=\"tel:" + user.getTelephone() + "\">Appel du <b>" + user.getTelephone() + "</b></a>").append(NEWLINEHTML);
                if (tel == null) {
                    tel = user.getTelephone();
                }
            }
            if (tel == null) {
                tel = "";
            }
            message.append(NEWLINEHTML);
            message.append("L'alerte est la suivante : ").append(NEWLINEHTML);
            message.append(NEWLINEHTML);
            StringBuffer stringBuffer = message.append("Date : ");
            GLS.getDate();
            GLS.getDate();
            stringBuffer.append(GLSDate.toDateComplete((Calendar)GLSDate.toDate((long)req.getDate()))).append(NEWLINEHTML);
            if (!GLS.estVide((String)req.getCommune())) {
                message.append("Commune : ").append(req.getCommune()).append(NEWLINEHTML);
            }
            if (!GLS.estVide((String)req.getAxe())) {
                message.append("Axe : ").append(req.getAxe()).append(NEWLINEHTML);
                if (!GLS.estVide((String)req.getPr()) && !GLS.egal((String)req.getPr(), (String)"-1")) {
                    message.append("PR/ABS : ").append(req.getPr()).append(NEWLINEHTML);
                }
            }
            if (req.getPosition() != null) {
                message.append("Lat/Long : ").append(req.getPosition().getX() + " / " + req.getPosition().getY()).append(NEWLINEHTML);
            }
            message = new StringBuffer(GLS.getLibelleComposantPlusieursLigneAlignement((String)message.toString(), (String)"left"));
            StringBuffer messageCode = new StringBuffer();
            messageCode.append(NEWLINEHTML);
            messageCode.append(NEWLINEHTML);
            messageCode.append(NEWLINEHTML);
            messageCode.append("-------------------------------------------------------------------").append(NEWLINEHTML);
            messageCode.append("PROTOCOL:ROUTES 4.0").append(NEWLINEHTML);
            messageCode.append("GRPE:000").append(NEWLINEHTML);
            messageCode.append("USER:000").append(NEWLINEHTML);
            messageCode.append("MESSAGE:!").append(NEWLINEHTML);
            messageCode.append("UID:").append(this.getUID(req.getUtilisateur().getCode())).append(NEWLINEHTML);
            StringBuffer stringBuffer2 = messageCode.append("HORODATAGE:");
            GLS.getDate();
            GLS.getDate();
            stringBuffer2.append(GLSDate.toDateComplete((Calendar)GLSDate.toDate((long)req.getDate()))).append(NEWLINEHTML);
            if (req.getPosition() != null) {
                messageCode.append("GEOLOC:").append(String.valueOf(req.getPosition().getY()).replace(",", ".")).append(",").append(String.valueOf(req.getPosition().getX()).replace(",", ".")).append(NEWLINEHTML);
            } else {
                messageCode.append("GEOLOC:AUCUNE POSITION GPS").append(NEWLINEHTML);
            }
            try {
                OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS);
                messageCode.append("TIME:").append(now.toString()).append(NEWLINEHTML);
            }
            catch (Exception e) {
                StringBuffer stringBuffer3 = messageCode.append("TIME:");
                GLS.getDate();
                GLS.getDate();
                stringBuffer3.append(GLSDate.toDateDatexComplete((Calendar)GLSDate.toDate((long)req.getDate()))).append(NEWLINEHTML);
            }
            messageCode.append("ALARM:SOS").append(NEWLINEHTML);
            messageCode.append("CAPT:004").append(NEWLINEHTML);
            messageCode.append("TEL:").append(tel).append(NEWLINEHTML);
            messageCode.append("FIN:ROUTES 4.0").append(NEWLINEHTML);
            messageCode.append("-------------------------------------------------------------------");
            message.append(GLS.getLibelleComposantPlusieursLigneAlignement((String)messageCode.toString(), (String)"left"));
            boolean err = false;
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                try {
                    this.sendMail(new Mail(destinataire.getMail(), object, message.toString()));
                }
                catch (Throwable t) {
                    err = true;
                }
            }
            if (!err) {
                ret = true;
            }
        }
        return ret;
    }

    private String getUID(String text) {
        if (!GLS.estNumerique((String)text)) {
            try {
                byte[] myBytes = text.getBytes("UTF-8");
                String ret = DatatypeConverter.printHexBinary((byte[])myBytes);
                if (ret.length() <= 20) {
                    return ret;
                }
                return ret.substring(0, 20);
            }
            catch (Exception ex) {
                return "#" + text + "#";
            }
        }
        return text;
    }

    public void diffusionVH() {
        ListeDestinataireMail liste = this.getListeDiffusion("vh");
        if (liste != null) {
            VHAttachment vha = new VHAttachment(this.businessService);
            String object = !this.businessService.getConfiguration().containsKey((Object)"diffusionvh.object") ? MailI18n.getString("diffusionvh.object") : this.businessService.getConfiguration().getString("diffusionvh.object");
            String message = !this.businessService.getConfiguration().containsKey((Object)"diffusionvh.message") ? MailI18n.getString("diffusionvh.message") : this.businessService.getConfiguration().getString("diffusionvh.message");
            GLS.getDate();
            GLS.getDate();
            Calendar calendar = GLSDate.maintenant();
            GLS.getDate();
            GLS.getDate();
            String date = GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour, (DateFormat)GLSDate.formatHeure);
            object = object.replaceAll("%1", date);
            message = message.replaceAll("%1", date);
            ArrayList<File> l = new ArrayList<File>();
            l.add(vha.getFile());
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                this.sendMessage(destinataire.getMail(), object, message.toString(), l);
            }
        }
    }

    public void diffusionVH(String object, String message, ListeDestinataireMail liste) {
        if (liste != null) {
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                this.sendMessage(destinataire.getMail(), object, message.toString(), null);
            }
        }
    }

    private ListeDestinataireMail getListeDiffusion(String key) {
        ListeDiffusion liste = null;
        for (ListeDiffusion l : this.businessService.getListesDiffusions()) {
            if (!l.getChamp().equals(key)) continue;
            liste = l;
        }
        if (liste != null) {
            for (ListeDiffusion l : this.businessService.getListeDestinataireMails()) {
                if (l.getId() != liste.getListe()) continue;
                return l;
            }
        }
        return null;
    }

    public void bulletinVH(final File fileBulletin, final String fileName) {
        ListeDestinataireMail liste = this.getListeDiffusion("bulletin_vh");
        if (liste != null) {
            String object = "Bulletin VH - " + fileName;
            StringBuffer message = new StringBuffer("");
            IFileAttachment bulletin = new IFileAttachment(){
                final /* synthetic */ MailService this$0;
                {
                    this.this$0 = this$0;
                }

                public File getFile() {
                    return fileBulletin;
                }

                public String getFileName() {
                    return fileName;
                }
            };
            ArrayList<IFileAttachment> l = new ArrayList<IFileAttachment>();
            l.add(bulletin);
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                this.sendMessageFileAttachment(destinataire.getMail(), object, message.toString(), l);
            }
        }
    }

    public boolean diffusionEvenementsDepasses(String delegation, String centre) {
        if (this.businessService.getConfiguration().getBoolean("gestionDateButoir", false)) {
            ListeDestinataireMail liste = this.getListeDiffusion("evenements_depasses");
            if (liste != null) {
                List destinataires;
                IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.dateButoirPatrouillageDepassee((String)delegation, (String)centre);
                TreeMap<String, List<DestinataireMail>> mapDestinataireCentres = new TreeMap<String, List<DestinataireMail>>();
                TreeMap mapEvenementsDepassesCentres = new TreeMap();
                TreeMap<String, String> messagesCentres = new TreeMap<String, String>();
                ArrayList<Evenement> autresEvenementsDepasses = new ArrayList<Evenement>();
                List situations = this.businessService.getEvenements(f, null);
                for (Situation s : situations) {
                    for (Evenement e : s.getEvenements()) {
                        String c = e.getCei();
                        if (!GLS.estVide((String)c)) {
                            if (!mapEvenementsDepassesCentres.containsKey(c)) {
                                mapEvenementsDepassesCentres.put(c, new ArrayList());
                                mapDestinataireCentres.put(c, this.getListeDestinataires(c, liste));
                            }
                            ((List)mapEvenementsDepassesCentres.get(c)).add(e);
                            continue;
                        }
                        if (GLS.estVide(autresEvenementsDepasses)) {
                            mapDestinataireCentres.put("*", this.getListeDestinataires(c, liste));
                        }
                        autresEvenementsDepasses.add(e);
                    }
                }
                String object = !this.businessService.getConfiguration().containsKey((Object)"synthese.evenementsdepasses.objet") ? MailI18n.getString("synthese.evenementsdepasses.objet") : this.businessService.getConfiguration().getString("synthese.evenementsdepasses.objet");
                String message = !this.businessService.getConfiguration().containsKey((Object)"synthese.evenementsdepasses.message") ? MailI18n.getString("synthese.evenementsdepasses.message") : this.businessService.getConfiguration().getString("synthese.evenementsdepasses.message");
                if (this.businessService.getConfiguration().getBoolean("synthese.evenementsdepasses.tableau", true)) {
                    for (Object c : mapEvenementsDepassesCentres.keySet()) {
                        String messageCentre = this.toTableHTML((List)mapEvenementsDepassesCentres.get(c));
                        messagesCentres.put((String)c, messageCentre);
                    }
                }
                GLS.getDate();
                GLS.getDate();
                Calendar calendar = GLSDate.maintenant();
                GLS.getDate();
                GLS.getDate();
                String date = GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour, (DateFormat)GLSDate.formatHeure);
                object = object.replaceAll("%1", date);
                message = message.replaceAll("%1", date);
                Log.debug("mail : " + message);
                if (!mapEvenementsDepassesCentres.isEmpty()) {
                    for (String c : mapEvenementsDepassesCentres.keySet()) {
                        List destinataires2 = (List)mapDestinataireCentres.get(c);
                        if (GLS.estVide((List)destinataires2)) continue;
                        String messageCentre = message + (String)messagesCentres.get(c);
                        for (DestinataireMail destinataire : destinataires2) {
                            this.sendMessage(destinataire.getMail(), object, messageCentre.toString(), null);
                        }
                    }
                }
                if (!GLS.estVide(autresEvenementsDepasses) && !GLS.estVide((List)(destinataires = (List)mapDestinataireCentres.get("*")))) {
                    message = message + this.toTableHTML(autresEvenementsDepasses);
                    for (DestinataireMail destinataire : liste.getDestinataires()) {
                        this.sendMessage(destinataire.getMail(), object, message.toString(), null);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private List<DestinataireMail> getListeDestinataires(String cei, ListeDestinataireMail liste) {
        ArrayList<DestinataireMail> listeFiltrees = new ArrayList<DestinataireMail>();
        if (!GLS.estVide((String)cei)) {
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                if (!GLS.egal((String)cei, (String)destinataire.getCentre())) continue;
                listeFiltrees.add(destinataire);
            }
        } else {
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                if (!GLS.estVide((String)destinataire.getCentre())) continue;
                listeFiltrees.add(destinataire);
            }
        }
        return listeFiltrees;
    }

    public boolean diffusionSynthesePatrouille(int deltaHeureAvant, List<Integer> codesModulesMetier) {
        ListeDestinataireMail liste = this.getListeDiffusion("synthese_patrouille");
        if (liste != null) {
            SynthesePatrouilleAttachement spa = new SynthesePatrouilleAttachement(this.businessService, deltaHeureAvant, codesModulesMetier);
            if (spa == null) {
                Log.debug("Erreur de g\u00e9n\u00e9ration de SynthesePatrouilleAttachement");
                return false;
            }
            ArrayList<File> l = new ArrayList<File>();
            l.add(spa.getFile());
            SyntheseViseeBean synthese = spa.getSyntheseViseeBean();
            if (synthese == null || synthese.getPatrouilles().size() == 0) {
                Log.debug("Pas de patrouille");
                return true;
            }
            String object = !this.businessService.getConfiguration().containsKey((Object)"diffusionsynthesepatrouille.object") ? MailI18n.getString("diffusionsynthesepatrouille.object") : this.businessService.getConfiguration().getString("diffusionsynthesepatrouille.object");
            String message = !this.businessService.getConfiguration().containsKey((Object)"diffusionsynthesepatrouille.message") ? MailI18n.getString("diffusionsynthesepatrouille.message") : this.businessService.getConfiguration().getString("diffusionsynthesepatrouille.message");
            if (this.businessService.getConfiguration().getBoolean("diffusionsynthesepatrouille.tableau", true)) {
                message = message + synthese.toTableHTML();
            }
            message = !this.businessService.getConfiguration().containsKey((Object)"diffusionsynthesepatrouille.message.part2") ? message + MailI18n.getString("diffusionsynthesepatrouille.message.part2") : message + this.businessService.getConfiguration().getString("diffusionsynthesepatrouille.message.part2");
            GLS.getDate();
            GLS.getDate();
            Calendar calendar = GLSDate.maintenant();
            GLS.getDate();
            GLS.getDate();
            String date = GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour, (DateFormat)GLSDate.formatHeure);
            object = object.replaceAll("%1", date);
            message = message.replaceAll("%1", date);
            synthese.getDateDebut();
            synthese.getDateFin();
            message = synthese.getDateDebut().substring(0, 10).equals(synthese.getDateFin().substring(0, 10)) ? message.replaceAll("%2", synthese.getDateDebut().substring(11) + " et " + synthese.getDateFin().substring(11) + " ce jour") : message.replaceAll("%2", "le " + synthese.getDateDebut() + " et le " + synthese.getDateFin());
            message = this.businessService.getConfiguration().get((Object)"diffusionsynthesepatrouille.adresse.site") != null ? message.replaceAll("%3", (String)this.businessService.getConfiguration().get((Object)"diffusionsynthesepatrouille.adresse.site")) : message.replaceAll("%3", "");
            Log.debug("mail : " + message);
            for (DestinataireMail destinataire : liste.getDestinataires()) {
                this.sendMessage(destinataire.getMail(), object, message.toString(), l);
            }
            return true;
        }
        return false;
    }

    private void sendMail(Mail o) {
        SendMailServiceThread.getInstance().sendMail(o);
    }

    public void stopMailService() {
        SendMailServiceThread.getInstance();
        SendMailServiceThread.stop();
    }

    private String toTableHTML(List<Evenement> liste) {
        liste.sort(Comparator.comparingLong(Evenement::getDateCreation));
        String retour = "";
        retour = retour + "<table width='100%' border='1' align='center'>";
        retour = retour + "<tr align='center'>";
        retour = retour + "<td><b>Nature<b></td>";
        retour = retour + "<td><b>Axe<b></td>";
        retour = retour + "<td><b>PR + ABS<b></td>";
        retour = retour + "<td><b>Date d\u00e9but<b></td>";
        retour = retour + "<td><b>Date butoir<b></td>";
        retour = retour + "</tr>";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy - HH:mm");
        SimpleDateFormat dateFormatComplet = new SimpleDateFormat("dd/MM/yy - HH:mm");
        for (Evenement evt : liste) {
            ValeurChamp datePlanification;
            retour = retour + "<tr align='center'>";
            retour = retour + "<td>" + ((Nature)this.businessService.getNatures().get(evt.getValeurNature().getCode())).getLabel() + "</td>";
            retour = retour + "<td>" + evt.getLocalisation().getAxe() + "</td>";
            retour = retour + "<td>" + evt.getLocalisation().getPrDebut() + "+" + evt.getLocalisation().getAbsPrDebut() + "</td>";
            retour = retour + "<td>" + dateFormat.format(new Date(evt.getDateCreation())) + "</td>";
            try {
                datePlanification = MetierCommun.getValeurChamp((Evenement)evt, (String)"datePlanification");
            }
            catch (Exception ex) {
                Log.error("ERR DATE PLANIFICATION N'EXISTE PAS", ex);
                datePlanification = null;
            }
            if (datePlanification != null && MetierCommun.getValeurDateLong((ValeurChamp)datePlanification) != -1L) {
                String datePlanificationFormat = dateFormat.format(new Date(MetierCommun.getValeurDateLong((ValeurChamp)datePlanification)));
                retour = retour + "<td>" + datePlanificationFormat + "</td>";
            } else {
                retour = retour + "<td>" + dateFormat.format(new Date(evt.getDateFin())) + "</td>";
            }
            retour = retour + "</tr>";
        }
        retour = retour + "<tr align='center'>";
        retour = retour + "<td><b>Total<b></td>";
        retour = retour + "<td>" + liste.size() + "</td>";
        retour = retour + "</tr>";
        retour = retour + "</table>";
        return retour;
    }
}

