/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.mail;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.beans.NatureExport;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.mail.i18n.MailI18n;
import gls.outils.GLS;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class FicheEvenementAttachment
implements IFileAttachment {
    private Evenement e;
    private IExportService exportService;
    private IBusinessService businessService;
    private String filename;
    private File content;

    public FicheEvenementAttachment(IExportService exportService, IBusinessService businessService, Evenement e) {
        this.e = e;
        this.exportService = exportService;
        this.businessService = businessService;
        this.filename = e.getValeurNature().getCode().concat("-").concat(GLS.getString((String)e.getLocalisation().getAxe())).concat("-").concat(MailI18n.getString("evt.fiche.filename"));
        String nomFichier = businessService.getConfiguration().getString("mail.evenement.nomfichier", "initial");
        if ("codevenement".equals(nomFichier)) {
            this.filename = e.getCodeEvenement() + MailI18n.getString("evt.fiche.ext");
        }
    }

    private synchronized void generate() {
        try {
            int lu;
            Situation s = new Situation(this.e.getIdSituation());
            s.addEvenement(this.e);
            String codeValeurNature = this.e.getValeurNature().getCode();
            Nature nature = (Nature)this.businessService.getNatures().get(codeValeurNature);
            Log.debug("nature :" + nature);
            List natureExportList = this.businessService.getNatureExport(nature);
            Log.debug("natureExportList :" + natureExportList);
            NatureExport natureExport = null;
            for (NatureExport natureExp : natureExportList) {
                if (natureExp.getType() == null || !natureExp.getType().equals("birt")) continue;
                natureExport = natureExp;
            }
            Log.debug("naturesExport :" + natureExport);
            InputStream in = null;
            in = natureExport == null ? this.exportService.exportSituation(Arrays.asList(s), "PDF", null, null, null, null, null) : this.exportService.exportSituation(Arrays.asList(s), "PDF", null, null, natureExport.getType(), null, natureExport.getDocument());
            File f = File.createTempFile("evt", ".pdf");
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buffer = new byte[4096];
            while ((lu = in.read(buffer)) != -1) {
                output.write(buffer, 0, lu);
            }
            output.flush();
            output.close();
            in.close();
            this.content = f;
        }
        catch (Exception ex) {
            Log.error("erreur g\u00e9n\u00e9ration fiche \u00e9v\u00e9nement", ex);
        }
    }

    public File getFile() {
        if (this.content == null) {
            this.generate();
        }
        return this.content;
    }

    public String getFileName() {
        return this.filename;
    }
}

