/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.shp;

import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import com.geolocsystems.prismcentral.beans.Coordonnees;
import com.geolocsystems.prismcentral.beans.Localisation;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PatrouilleShapeWriter {
    public boolean writeLocalisation(String shapefileName, List<Localisation> localisations) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"POINT", (String)"the_geom:Point,Date:String");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        for (Localisation localisation : localisations) {
            List coordonnees = localisation.getCoordonnees();
            Coordinate coordinates = new Coordinate();
            coordinates = new Coordinate(((Coordonnees)coordonnees.get(0)).getX(), ((Coordonnees)coordonnees.get(0)).getY());
            Point point = geometryFactory.createPoint(coordinates);
            featureBuilder.add((Object)point);
            featureBuilder.add((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(localisation.getDateHeureLoc().getTime()));
            SimpleFeature feature = featureBuilder.buildFeature(null);
            collection.add(feature);
        }
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    public boolean writeReleve(String shapefileName, Patrouille patrouille, Collection<TronconSuivi> tronconsSuivi) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"LINE", (String)"the_geom:MultiLineString,id_patoruille:String,id_mcig:String,debut:String,fin:String");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        ArrayList<LineString> linestrings = new ArrayList<LineString>();
        for (TronconSuivi tronconSuivi : tronconsSuivi) {
            if (tronconSuivi.getX() == null) continue;
            int nbCoord = tronconSuivi.getX().length;
            Coordinate[] coordinates = new Coordinate[nbCoord];
            for (int i = 0; i < nbCoord; ++i) {
                coordinates[i] = new Coordinate((double)tronconSuivi.getX()[i], (double)tronconSuivi.getY()[i]);
            }
            LineString linestring = geometryFactory.createLineString(coordinates);
            linestrings.add(linestring);
        }
        MultiLineString multilinestring = geometryFactory.createMultiLineString(linestrings.toArray(new LineString[linestrings.size()]));
        featureBuilder.add((Object)multilinestring);
        featureBuilder.add((Object)patrouille.getId());
        featureBuilder.add((Object)patrouille.getMcig());
        featureBuilder.add((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(patrouille.getDebut())));
        featureBuilder.add((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(patrouille.getFin())));
        SimpleFeature feature = featureBuilder.buildFeature(null);
        collection.add(feature);
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    public boolean writeTroncon(String shapefileName, Collection<TronconSuivi> tronconsSuivi) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"LINE", (String)"the_geom:LineString,id_patoruille:String,id_troncon:String");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        for (TronconSuivi tronconSuivi : tronconsSuivi) {
            if (tronconSuivi.getX() == null) continue;
            int nbCoord = tronconSuivi.getX().length;
            Coordinate[] coordinates = new Coordinate[nbCoord];
            for (int i = 0; i < nbCoord; ++i) {
                coordinates[i] = new Coordinate((double)tronconSuivi.getX()[i], (double)tronconSuivi.getY()[i]);
            }
            LineString linestring = geometryFactory.createLineString(coordinates);
            featureBuilder.add((Object)linestring);
            featureBuilder.add((Object)tronconSuivi.getIdTronconSuivi());
            featureBuilder.add((Object)tronconSuivi.getIdPatrouille());
            SimpleFeature feature = featureBuilder.buildFeature(null);
            collection.add(feature);
        }
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    public boolean write(String shapefileName, List<TronconFauchage> tronconsFauchage) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"LINE", (String)"the_geom:LineString,id:Integer,prDebut:String,,prFin:String,Axe:String,sens:Integer");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        for (TronconFauchage tronconFauchage : tronconsFauchage) {
            int nbCoord = tronconFauchage.getX().length;
            Coordinate[] coordinates = new Coordinate[nbCoord];
            for (int i = 0; i < nbCoord; ++i) {
                coordinates[i] = new Coordinate((double)tronconFauchage.getX()[i], (double)tronconFauchage.getY()[i]);
            }
            LineString linestring = geometryFactory.createLineString(coordinates);
            featureBuilder.add((Object)linestring);
            featureBuilder.add((Object)tronconFauchage.getId());
            featureBuilder.add((Object)tronconFauchage.getPrDebut());
            featureBuilder.add((Object)tronconFauchage.getPrFin());
            featureBuilder.add((Object)tronconFauchage.getAxe());
            featureBuilder.add((Object)tronconFauchage.getSensNumerique());
            SimpleFeature feature = featureBuilder.buildFeature(null);
            collection.add(feature);
        }
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String shapefileName, SimpleFeatureType TYPE, SimpleFeatureCollection collection) throws MalformedURLException, IOException {
        File newFile = new File(shapefileName);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE);
        newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        if (featureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            featureStore.setTransaction((Transaction)transaction);
            try {
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                problem.printStackTrace();
                transaction.rollback();
            }
            finally {
                transaction.close();
            }
            return true;
        }
        System.out.println(typeName + " does not support read/write access");
        return false;
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("Location", Point.class);
        builder.length(15).add("Name", String.class);
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        return LOCATION;
    }
}

