/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.shp;

import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DebroussaillageShapeWriter {
    public boolean writeReleve(String shapefileName, List<Releve> tronconsReleve) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"LINE", (String)"the_geom:LineString,voie:String,CommuneDeb:String,AxeDebut:String,prDebut:String,CommuneFin:String,AxeFin:String,prFin:String,Date:String,Arbre:String,Cloture:String,Dense:String,largeur4m:String,largeur20m:String,znc:String,zad:String,zd:String,longueur:Integer");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        for (Releve tronconReleve : tronconsReleve) {
            if (tronconReleve.getX() == null) continue;
            int nbCoord = tronconReleve.getX().length;
            Coordinate[] coordinates = new Coordinate[nbCoord];
            for (int i = 0; i < nbCoord; ++i) {
                coordinates[i] = new Coordinate((double)tronconReleve.getX()[i], (double)tronconReleve.getY()[i]);
            }
            LineString linestring = geometryFactory.createLineString(coordinates);
            featureBuilder.add((Object)linestring);
            featureBuilder.add((Object)tronconReleve.getVoie());
            featureBuilder.add((Object)tronconReleve.getCommuneDebut());
            featureBuilder.add((Object)tronconReleve.getAxeDebut());
            featureBuilder.add((Object)tronconReleve.getPrDebut());
            featureBuilder.add((Object)tronconReleve.getCommuneFin());
            featureBuilder.add((Object)tronconReleve.getAxeFin());
            featureBuilder.add((Object)tronconReleve.getPrFin());
            featureBuilder.add((Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(tronconReleve.getDate().getTime()));
            featureBuilder.add((Object)tronconReleve.getArbre());
            featureBuilder.add((Object)tronconReleve.getCloture());
            featureBuilder.add((Object)tronconReleve.getDense());
            featureBuilder.add((Object)tronconReleve.getLargeur4m());
            featureBuilder.add((Object)tronconReleve.getLargeur20m());
            featureBuilder.add((Object)tronconReleve.getZnc());
            featureBuilder.add((Object)tronconReleve.getZad());
            featureBuilder.add((Object)tronconReleve.getZd());
            featureBuilder.add((Object)tronconReleve.getLongueur());
            SimpleFeature feature = featureBuilder.buildFeature(null);
            collection.add(feature);
        }
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    public boolean write(String shapefileName, List<TronconFauchage> tronconsFauchage) throws Exception {
        SimpleFeatureType TYPE = DataUtilities.createType((String)"LINE", (String)"centerline:LineString,id:Integer,prDebut:String,,prFin:String,Axe:String,sens:Integer");
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        for (TronconFauchage tronconFauchage : tronconsFauchage) {
            int nbCoord = tronconFauchage.getX().length;
            Coordinate[] coordinates = new Coordinate[nbCoord];
            for (int i = 0; i < nbCoord; ++i) {
                coordinates[i] = new Coordinate((double)tronconFauchage.getX()[i], (double)tronconFauchage.getY()[i]);
            }
            LineString linestring = geometryFactory.createLineString(coordinates);
            featureBuilder.add((Object)linestring);
            featureBuilder.add((Object)tronconFauchage.getId());
            featureBuilder.add((Object)tronconFauchage.getPrDebut());
            featureBuilder.add((Object)tronconFauchage.getPrFin());
            featureBuilder.add((Object)tronconFauchage.getAxe());
            featureBuilder.add((Object)tronconFauchage.getSensNumerique());
            SimpleFeature feature = featureBuilder.buildFeature(null);
            collection.add(feature);
        }
        return this.writeFile(shapefileName, TYPE, (SimpleFeatureCollection)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String shapefileName, SimpleFeatureType TYPE, SimpleFeatureCollection collection) throws MalformedURLException, IOException {
        File newFile = new File(shapefileName);
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", newFile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(TYPE);
        newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        if (featureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            featureStore.setTransaction((Transaction)transaction);
            try {
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                problem.printStackTrace();
                transaction.rollback();
            }
            finally {
                transaction.close();
            }
            newDataStore.dispose();
            return true;
        }
        System.out.println(typeName + " does not support read/write access");
        return false;
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("Location", Point.class);
        builder.length(15).add("Name", String.class);
        SimpleFeatureType LOCATION = builder.buildFeatureType();
        return LOCATION;
    }
}

