/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.json;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.ConstantesCSV;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.export.json.ChampJSON;
import com.geolocsystems.prismcentral.export.json.JSONComposantFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSONUtils {
    public static Map<String, String> getListeChamps(List<Situation> situations, Map<String, Nature> natures) {
        JSONComposantFactory factory = new JSONComposantFactory();
        LinkedHashMap<String, String> colonnes = new LinkedHashMap<String, String>();
        for (String s : ConstantesCSV.CHAMP_CSV_STATIC) {
            colonnes.put(s, s);
        }
        if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
            for (String s : ConstantesCSV.CHAMP_CSV_SYSTEME_DATE_HEURE_SEPARE) {
                colonnes.put(s, s);
            }
        } else {
            for (String s : ConstantesCSV.CHAMP_CSV_SYSTEME) {
                colonnes.put(s, s);
            }
        }
        for (Situation situation : situations) {
            for (Evenement evenement : situation.getEvenements()) {
                Nature n = (Nature)DeepCopy.copy((Object)natures.get(evenement.getValeurNature().getCode()));
                n.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                for (Champ c : listeChamp) {
                    boolean index = false;
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    for (ChampJSON champcsv : champscsv) {
                        if (colonnes.containsKey(champcsv.getCode())) continue;
                        Log.debug("Champs csv " + champcsv.getCode() + " -- " + champcsv.getLibelle());
                        if (GLS.estVide((String)champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), GLS.getLibelleChampEnClair((String)champcsv.getCode()));
                            continue;
                        }
                        if (!colonnes.containsValue(champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), champcsv.getLibelle());
                            continue;
                        }
                        colonnes.put(champcsv.getCode(), champcsv.getLibelle().concat(" (" + champcsv.getCode() + ")"));
                    }
                }
            }
        }
        return colonnes;
    }

    public static String getChaine(String valeur) {
        if (valeur == null) {
            return "\"\"";
        }
        return "\"" + valeur + "\"";
    }
}

