/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.json;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLabel;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentral.export.json.ChampJSON;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public class JSONComposantFactory
implements IComposantFactory {
    private static final String SEPARATEUR = "\";\"";
    private static final String ESPACE = " ";
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private DateFormat dateHeureFormat;

    public JSONComposantFactory() {
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateFormat = new SimpleDateFormat(ReportI18n.getString("format.date"), locale);
        this.heureFormat = new SimpleDateFormat(ReportI18n.getString("format.heure"), locale);
        this.dateHeureFormat = new SimpleDateFormat(ReportI18n.getString("format.dateheure"), locale);
    }

    public Object createView(ChampAlternat c) {
        throw new RuntimeException("not implemented");
    }

    public Object createView(ChampEntier c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        if (!c.isCheckbox() || c.isChecked()) {
            champCSV.setValeur(String.valueOf(c.getValeur()));
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDecimal c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        if (!c.isCheckbox() || c.isChecked()) {
            champCSV.setValeur(String.valueOf(c.getValeur()));
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDropListe c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur());
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampLabel c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur());
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampLocalisation c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        boolean axe = c.getAxe() != null;
        boolean sensPr = axe && c.getSensPr() != -1;
        int sensPrRapport = 0;
        switch (c.getSensPr()) {
            case -1: {
                sensPrRapport = 0;
                break;
            }
            case 1: {
                sensPrRapport = 1;
                break;
            }
            case 0: {
                sensPrRapport = 2;
                break;
            }
            case 2: {
                sensPrRapport = 3;
            }
        }
        boolean prDebut = sensPr && c.getPrDebut() != -1;
        boolean absPrDebut = prDebut && c.getAbsPrDebut() != -1;
        boolean prFin = sensPr && c.getPrFin() != -1;
        boolean absPrFin = prFin && c.getAbsPrFin() != -1;
        boolean adresseDebut = !GLS.estVide((String)c.getAdresseDebut());
        boolean deptDebut = !GLS.estVide((String)c.getDeptDebut());
        boolean deptFin = !GLS.estVide((String)c.getDeptFin());
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle("axe");
        champCSV.setCode("axe");
        champCSV.setValeur(axe ? c.getAxe() : "");
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        if (prDebut) {
            champCSV = new ChampJSON();
            champCSV.setLibelle("sensPR");
            champCSV.setCode("sensPR");
            champCSV.setValeur(sensPr ? "" + sensPrRapport : "");
            champsCSV.add(champCSV);
            if (deptDebut) {
                champCSV = new ChampJSON();
                champCSV.setLibelle("DeptDebut");
                champCSV.setCode("DeptDebut");
                champCSV.setValeur(deptDebut ? c.getDeptDebut() : "");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            }
            champCSV = new ChampJSON();
            champCSV.setLibelle("PRDebut");
            champCSV.setCode("PRDebut");
            champCSV.setValeur(prDebut ? "" + c.getPrDebut() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("AbsPRDebut");
            champCSV.setCode("AbsPRDebut");
            champCSV.setValeur(absPrDebut ? "" + c.getAbsPrDebut() : "");
            champsCSV.add(champCSV);
            if (deptFin) {
                champCSV = new ChampJSON();
                champCSV.setLibelle("DeptFin");
                champCSV.setCode("DeptFin");
                champCSV.setValeur(deptFin ? c.getDeptFin() : "");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            }
            champCSV = new ChampJSON();
            champCSV.setLibelle("PRFin");
            champCSV.setCode("PRFin");
            champCSV.setValeur(prFin ? "" + c.getPrFin() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("AbsPRFin");
            champCSV.setCode("AbsPRFin");
            champCSV.setValeur(absPrFin ? "" + c.getAbsPrFin() : "");
            champsCSV.add(champCSV);
        }
        champCSV = new ChampJSON();
        champCSV.setLibelle("Longueur");
        champCSV.setCode("Longueur");
        champCSV.setValeur(absPrFin ? "" + c.getLongueur() : "0");
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Commune");
        champCSV.setCode("Commune");
        champCSV.setValeur(c.getCommune() == null ? "" : c.getCommune());
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        if (adresseDebut) {
            champCSV = new ChampJSON();
            champCSV.setLibelle("AdresseDebut");
            champCSV.setCode("AdresseDebut");
            champCSV.setValeur(c.getAdresseDebut() == null ? "" : c.getAdresseDebut());
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("AdresseFin");
            champCSV.setCode("AdresseFin");
            champCSV.setValeur(c.getAdresseFin() == null ? "" : c.getAdresseFin());
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
        }
        champCSV = new ChampJSON();
        champCSV.setLibelle("CoordDebut_X");
        champCSV.setCode("CoordDebut_X");
        champCSV.setValeur(c.getPositionDebut() != null ? c.getPositionDebut().getX() + "" : "");
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("CoordDebut_Y");
        champCSV.setCode("CoordDebut_Y");
        champCSV.setValeur(c.getPositionDebut() != null ? c.getPositionDebut().getY() + "" : "");
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("CoordFin_X");
        champCSV.setCode("CoordFin_X");
        champCSV.setValeur(c.getPositionFin() != null ? c.getPositionFin().getX() + "" : "");
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("CoordFin_Y");
        champCSV.setCode("CoordFin_Y");
        champCSV.setValeur(c.getPositionFin() != null ? c.getPositionFin().getY() + "" : "");
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampChoixImageMultiple c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setCode(c.getNom());
        champCSV.setChaine(true);
        if (c.getValeurs().size() == 1) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle((String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            } else {
                champCSV.setLibelle(c.getLibelle() + " - " + (String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            }
        } else {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle(c.getNom());
            } else {
                champCSV.setLibelle(c.getLibelle());
            }
            String valeur = "";
            for (String item : c.getValeursSelectionnee()) {
                valeur = valeur + ESPACE + item;
            }
            if (c.getAutreValeur() != null) {
                valeur = valeur + ESPACE + c.getAutreValeur();
            }
            champCSV.setValeur(valeur);
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampMultiCheckBox c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setCode(c.getNom());
        champCSV.setChaine(true);
        if (c.getValeurs().size() == 1) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle((String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            } else {
                champCSV.setLibelle(c.getLibelle() + " - " + (String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            }
        } else {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle(c.getNom());
            } else {
                champCSV.setLibelle(c.getLibelle());
            }
            String valeur = "";
            for (String item : c.getValeursSelectionnee()) {
                valeur = valeur + ESPACE + item;
            }
            if (c.getAutreValeur() != null) {
                valeur = valeur + ESPACE + c.getAutreValeur();
            }
            champCSV.setValeur(valeur);
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampMultiple c) {
        ArrayList champsCSV = new ArrayList();
        for (Champ champ : c.getChamps()) {
            List champsTmp = (List)champ.getView((IComposantFactory)this);
            for (ChampJSON ccsv : champsTmp) {
                if (GLS.estVide((String)c.getLibelle())) {
                    ccsv.setLibelle(c.getNom() + " - " + ccsv.getLibelle());
                    continue;
                }
                if (c.getLibelle().contains(" - ")) continue;
                ccsv.setLibelle(c.getLibelle() + " - " + ccsv.getLibelle());
            }
            champsCSV.addAll(champsTmp);
        }
        return champsCSV;
    }

    public Object createView(ChampRadioBouton c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeurSelectionnee());
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampTexte c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur() == null ? "" : c.getValeur());
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampVraiFaux c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
        champCSV.setChaine(true);
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampVehiculeEnCause c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle("VehiculesLegers");
        champCSV.setCode("VehiculesLegers");
        champCSV.setValeur("" + c.getVl());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("PoidsLourds");
        champCSV.setCode("PoidsLourds");
        champCSV.setValeur("" + c.getPl());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("TransportsEnCommun");
        champCSV.setCode("TransportsEnCommun");
        champCSV.setValeur("" + c.getVtc());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Motos");
        champCSV.setCode("Motos");
        champCSV.setValeur("" + c.getMoto());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Velos");
        champCSV.setCode("Velos");
        champCSV.setValeur("" + c.getVelo());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("TransportMatiereDangereuse");
        champCSV.setCode("TransportMatiereDangereuse");
        champCSV.setValeur("" + c.getTmd());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("PietonsCycles");
        champCSV.setCode("PietonsCycles");
        champCSV.setValeur("" + c.getPietonCycle());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("CampingCars");
        champCSV.setCode("CampingCars");
        champCSV.setValeur("" + c.getCampingCar());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Deuxroues");
        champCSV.setCode("Deuxroues");
        champCSV.setValeur("" + c.getDeuxRoues());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Scooter");
        champCSV.setCode("Scooter");
        champCSV.setValeur("" + c.getScooter());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Caravane");
        champCSV.setCode("Caravane");
        champCSV.setValeur("" + c.getCaravane());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Train");
        champCSV.setCode("Train");
        champCSV.setValeur("" + c.getTrain());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Tramway");
        champCSV.setCode("Tramway");
        champCSV.setValeur("" + c.getTramway());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("EnginsAgricoles");
        champCSV.setCode("EnginsAgricoles");
        champCSV.setValeur("" + c.getEnginAgricole());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Animaux");
        champCSV.setCode("Animaux");
        champCSV.setValeur("" + c.getAnimaux());
        champsCSV.add(champCSV);
        champCSV = new ChampJSON();
        champCSV.setLibelle("Autres");
        champCSV.setCode("Autres");
        champCSV.setValeur("" + c.getAutres());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDate c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        if (c.isChecked() && c.getAnnee() != 3) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour());
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle(c.getLibelle());
            champCSV.setCode(c.getNom());
            champCSV.setValeur(this.dateFormat.format(cal.getTime()));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
        }
        return champsCSV;
    }

    public Object createView(ChampDateHeure c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        if (c.isChecked() && c.getAnnee() != 3) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle(c.getLibelle());
            champCSV.setCode(c.getNom());
            champCSV.setValeur(this.dateHeureFormat.format(cal.getTime()));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
        }
        return champsCSV;
    }

    public Object createView(ChampHeure c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(0, 0, 0, c.getHeure(), c.getMinute());
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle(c.getLibelle());
            champCSV.setCode(c.getNom());
            champCSV.setValeur(this.heureFormat.format(cal.getTime()));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
        }
        return champsCSV;
    }

    public void setChampLectureSeule(boolean lectureSeule) {
    }

    public Object createView(ChampPatrouilleProcedure c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        if (this.competenceVide(c)) {
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV.setChaine(true);
            champCSV = new ChampJSON();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV.setChaine(true);
            champCSV = new ChampJSON();
            champCSV.setLibelle("ActionImmediate");
            champCSV.setCode("ActionImmediate");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV.setChaine(true);
            champCSV = new ChampJSON();
            champCSV.setLibelle("MesurePrise");
            champCSV.setCode("MesurePrise");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV.setChaine(true);
            champCSV = new ChampJSON();
            champCSV.setLibelle("CompteRenduFait");
            champCSV.setCode("CompteRenduFait");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV.setChaine(true);
        } else if (this.competenceCg(c)) {
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur(c.getValeur().getCompetence());
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur(c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            if (c.getValeur().isUrgence()) {
                champCSV = new ChampJSON();
                champCSV.setLibelle("ActionImmediate");
                champCSV.setCode("ActionImmediate");
                champCSV.setValeur(c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
                champCSV = new ChampJSON();
                champCSV.setLibelle("MesurePrise");
                champCSV.setCode("MesurePrise");
                champCSV.setValeur(c.getValeur().getMesure());
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
                champCSV = new ChampJSON();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            } else {
                champCSV = new ChampJSON();
                champCSV.setLibelle("ActionImmediate");
                champCSV.setCode("ActionImmediate");
                champCSV.setValeur("");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
                champCSV = new ChampJSON();
                champCSV.setLibelle("MesurePrise");
                champCSV.setCode("MesurePrise");
                champCSV.setValeur("");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
                champCSV = new ChampJSON();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            }
        } else {
            ChampJSON champCSV = new ChampJSON();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur("");
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur(c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("ActionImmediate");
            champCSV.setCode("ActionImmediate");
            champCSV.setValeur(c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("MesurePrise");
            champCSV.setCode("MesurePrise");
            champCSV.setValeur(c.getValeur().getMesure());
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            champCSV = new ChampJSON();
            champCSV.setLibelle("CompteRenduFait");
            champCSV.setCode("CompteRenduFait");
            champCSV.setValeur("");
            champCSV.setChaine(true);
            champsCSV.add(champCSV);
            if (c.getValeur().getCompteRendu()) {
                champCSV = new ChampJSON();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur(c.getValeur().getCompetence());
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            } else {
                champCSV = new ChampJSON();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champCSV.setChaine(true);
                champsCSV.add(champCSV);
            }
        }
        return champsCSV;
    }

    private boolean competenceVide(ChampPatrouilleProcedure champ) {
        return champ.getValeur().getCompetence() == null || champ.getValeur().getCompetence().equals("");
    }

    private boolean competenceCg(ChampPatrouilleProcedure champ) {
        String competenceCg = champ.getCompetenceCg();
        String competenceSelect = champ.getValeur().getCompetence();
        boolean isCompetenceCg = competenceCg.equals(competenceSelect);
        return isCompetenceCg;
    }

    public Object createView(ChampChoixImage c) {
        ArrayList<ChampJSON> champsCSV = new ArrayList<ChampJSON>();
        ChampJSON champCSV = new ChampJSON();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeurSelectionnee());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampImages champImage) {
        return null;
    }

    public Object createView(ChampSignature champSignature) {
        return null;
    }

    public Object createView(ChampDocuments champDocuements) {
        return null;
    }

    public Object createView(ChampCoucheBox champCoucheBox) {
        return null;
    }

    public Object createView(ChampOneDrive champOneDrive) {
        return null;
    }
}

