/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.factory;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismbirtbean.SyntheseBilanInterventionBean;
import com.geolocsystems.prismbirtbean.SyntheseBilanInterventionCentreBean;
import com.geolocsystems.prismbirtbean.SyntheseBilanInterventionDelegationBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.util.Base64;

public class SyntheseBilanInterventionBeanFactory {
    IBusinessService service;
    private String KEY_DECLENCHEMENT_INTERVENTION = "declenchementIntervention";
    private String KEY_TYPE_INTERVENTION = "description";
    private String KEY_DEBUT_INTERVENTION = "dateDeclenchementIntervention";
    private String KEY_FIN_INTERVENTION = "dateFinIntervention";
    private final int JOUR_INDEFINI = -1;
    private final int JOUR_SEMAINE = 1;
    private final int JOUR_WEEKEND = 2;
    private final int JOUR_FERIE = 3;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public SyntheseBilanInterventionBeanFactory(IBusinessService service) {
        this.service = service;
    }

    public SyntheseBilanInterventionBean convert(List<Situation> listSituation) {
        SyntheseBilanInterventionBean retour = new SyntheseBilanInterventionBean();
        String declenchementInterventionDescription = this.service.getDescriptionComposant(this.KEY_DECLENCHEMENT_INTERVENTION);
        String declenchementInterventionDefault = "";
        ArrayList<Object> listeDeclenchementIntervention = new ArrayList<Object>();
        if (declenchementInterventionDescription != null && declenchementInterventionDescription.contains(":")) {
            declenchementInterventionDefault = declenchementInterventionDescription.split(":")[0];
            for (String declenchementIntervention : declenchementInterventionDescription.split(":")[1].split(";")) {
                listeDeclenchementIntervention.add(declenchementIntervention);
            }
        }
        ArrayList<Integer> listeKEventId = new ArrayList<Integer>();
        for (Situation situation : listSituation) {
            for (Evenement e : situation.getEvenements()) {
                listeKEventId.add(e.getkEventid());
            }
        }
        Map mapNbAgents = this.service.getNbAgents(listeKEventId);
        for (Situation situation : listSituation) {
            block11: for (Evenement e : situation.getEvenements()) {
                SyntheseBilanInterventionDelegationBean bilanDelegationBean;
                Nature n = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(e.getValeurNature().getCode())));
                n.chargerValeurs(e.getValeurNature());
                HashMap attributsEvenements = MetierCommun.convertirAttributs((Nature)n, (Evenement)e);
                String declenchementIntervention = (String)attributsEvenements.get(this.KEY_DECLENCHEMENT_INTERVENTION);
                String typeIntervention = (String)attributsEvenements.get(this.KEY_TYPE_INTERVENTION);
                long dureeIntervention = 0L;
                int typeJour = -1;
                try {
                    Date debutIntervention = null;
                    debutIntervention = ((String)attributsEvenements.get(this.KEY_DEBUT_INTERVENTION)).equals("") ? new Date(e.getDateCreation()) : this.sdf.parse((String)attributsEvenements.get(this.KEY_DEBUT_INTERVENTION));
                    Date finIntervention = null;
                    finIntervention = ((String)attributsEvenements.get(this.KEY_FIN_INTERVENTION)).equals("") ? debutIntervention : this.sdf.parse((String)attributsEvenements.get(this.KEY_FIN_INTERVENTION));
                    dureeIntervention = (finIntervention.getTime() - debutIntervention.getTime()) / 60L / 1000L;
                    Calendar dateDebut = Calendar.getInstance();
                    dateDebut.setTime(debutIntervention);
                    Calendar dateFin = Calendar.getInstance();
                    dateFin.setTime(finIntervention);
                    typeJour = this.typeJour(dateDebut);
                    if (dateDebut.get(1) != dateFin.get(1) || dateDebut.get(6) != dateFin.get(6)) {
                        Calendar dateTest = Calendar.getInstance();
                        dateTest.set(dateDebut.get(1), dateDebut.get(2), dateDebut.get(5), 0, 0, 0);
                        while (dateTest.getTimeInMillis() < dateFin.getTimeInMillis()) {
                            int typeJourTmp = this.typeJour(dateTest);
                            if (typeJourTmp < typeJour) {
                                typeJour = typeJourTmp;
                            }
                            dateTest.add(5, 1);
                        }
                    }
                }
                catch (Exception ex) {
                    Log.error(ex.getLocalizedMessage());
                }
                if (!retour.getBilanInterventionDelegation().containsKey(e.getDistrict())) {
                    retour.getBilanInterventionDelegation().put(e.getDistrict(), new SyntheseBilanInterventionDelegationBean());
                }
                if (!(bilanDelegationBean = (SyntheseBilanInterventionDelegationBean)retour.getBilanInterventionDelegation().get(e.getDistrict())).getBilanInterventionCentre().containsKey(e.getCei())) {
                    bilanDelegationBean.getBilanInterventionCentre().put(e.getCei(), new SyntheseBilanInterventionCentreBean());
                }
                SyntheseBilanInterventionCentreBean bilanCentreBean = (SyntheseBilanInterventionCentreBean)bilanDelegationBean.getBilanInterventionCentre().get(e.getCei());
                bilanCentreBean.addNbInterventions();
                bilanCentreBean.addDureeTotaleIntervention(dureeIntervention);
                if (listeDeclenchementIntervention.size() > 0) {
                    if (listeDeclenchementIntervention.contains(declenchementIntervention)) {
                        bilanCentreBean.addDeclenchementIntervention(declenchementIntervention);
                    } else {
                        bilanCentreBean.addDeclenchementIntervention(declenchementInterventionDefault);
                    }
                } else {
                    bilanCentreBean.addDeclenchementIntervention(declenchementIntervention);
                }
                bilanCentreBean.addTypeIntervention(typeIntervention);
                if (mapNbAgents.get(e.getkEventid()) != null) {
                    bilanCentreBean.addIntervenenants(((Integer)mapNbAgents.get(e.getkEventid())).intValue());
                } else {
                    bilanCentreBean.addIntervenenants(1);
                }
                switch (typeJour) {
                    case 1: {
                        bilanCentreBean.addInterventionSemaine();
                        continue block11;
                    }
                    case 2: {
                        bilanCentreBean.addInterventionWeekEnd();
                        continue block11;
                    }
                    case 3: {
                        bilanCentreBean.addInterventionJoursFeries();
                        continue block11;
                    }
                }
                Log.debug("JOUR INDEFINI " + e.getkEventid());
            }
        }
        retour.calculPourcentage();
        return retour;
    }

    private int typeJour(Calendar dateTest) {
        if (this.ferie(dateTest)) {
            return 3;
        }
        switch (dateTest.get(7)) {
            case 1: 
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private String imgToString(File img) throws Exception {
        Log.debug("imgToString : " + img.getName());
        FileInputStream fis = null;
        fis = new FileInputStream(img);
        Log.debug("imgToString : new FileInputStream OK");
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        Log.debug("imgToString : new ByteArrayOutputStream OK");
        int c = -1;
        while ((c = fis.read()) != -1) {
            bais.write(c);
        }
        Log.debug("imgToString : ByteArrayOutputStream write OK");
        fis.close();
        Log.debug("imgToString : fis.close OK");
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }

    public Calendar paques(int year) {
        if (year < 1583) {
            throw new IllegalStateException();
        }
        int n = year % 19;
        int c = year / 100;
        int u = year % 100;
        int s = c / 4;
        int t = c % 4;
        int p = (c + 8) / 25;
        int q = (c - p + 1) / 3;
        int e = (19 * n + c - s - q + 15) % 30;
        int b = u / 4;
        int d = u % 4;
        int L = (32 + 2 * t + 2 * b - e - d) % 7;
        int h = (n + 11 * e + 22 * L) / 451;
        int m = (e + L - 7 * h + 114) / 31;
        int j = (e + L - 7 * h + 114) % 31;
        Calendar retour = Calendar.getInstance();
        retour.set(1, year);
        retour.set(2, m - 1);
        retour.set(5, j + 1);
        return retour;
    }

    public boolean ferie(Calendar date) {
        int day = date.get(5);
        switch (date.get(2)) {
            case 0: {
                if (day != 1) break;
                return true;
            }
            case 4: {
                if (day != 1 && day != 8) break;
                return true;
            }
            case 6: {
                if (day != 14) break;
                return true;
            }
            case 7: {
                if (day != 15) break;
                return true;
            }
            case 10: {
                if (day != 1 && day != 11) break;
                return true;
            }
            case 11: {
                if (day != 25) break;
                return true;
            }
        }
        if (date.get(2) < 7) {
            Calendar paques = this.paques(date.get(1));
            Calendar lundiPaques = Calendar.getInstance();
            lundiPaques.set(paques.get(1), paques.get(2), paques.get(5));
            lundiPaques.add(5, 1);
            if (date.get(2) == lundiPaques.get(2) && date.get(5) == lundiPaques.get(5)) {
                return true;
            }
            Calendar jeudiAscension = Calendar.getInstance();
            jeudiAscension.set(paques.get(1), paques.get(2), paques.get(5));
            jeudiAscension.add(5, 39);
            if (date.get(2) == jeudiAscension.get(2) && date.get(5) == jeudiAscension.get(5)) {
                return true;
            }
            Calendar lundiPentecote = Calendar.getInstance();
            lundiPentecote.set(paques.get(1), paques.get(2), paques.get(5));
            lundiPentecote.add(5, 50);
            if (date.get(2) == lundiPentecote.get(2) && date.get(5) == lundiPentecote.get(5)) {
                return true;
            }
        }
        return false;
    }
}

