/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.factory;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismbirtbean.RapportEvenementBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.net.util.Base64;

public class RapportEvenementBeanFactory {
    IBusinessService service;

    public RapportEvenementBeanFactory(IBusinessService service) {
        this.service = service;
    }

    public List<RapportEvenementBean> convert(List<Situation> listSituation) {
        ArrayList<RapportEvenementBean> rapportEvenementBeans = new ArrayList<RapportEvenementBean>();
        for (Situation situation : listSituation) {
            for (Evenement evenement : situation.getEvenements()) {
                rapportEvenementBeans.add(this.convertToRapportEvenementBean(evenement));
            }
        }
        return rapportEvenementBeans;
    }

    private RapportEvenementBean convertToRapportEvenementBean(Evenement evenement) {
        RapportEvenementBean rapportEvenementBean = new RapportEvenementBean();
        Nature n = (Nature)DeepCopy.copy((Object)((Nature)this.service.getNatures().get(evenement.getValeurNature().getCode())));
        n.chargerValeurs(evenement.getValeurNature());
        HashMap attributsEvenements = MetierCommun.convertirAttributs((Nature)n, (Evenement)evenement);
        rapportEvenementBean.setCentre(evenement.getCei());
        rapportEvenementBean.setCodeNature(evenement.getValeurNature().getCode());
        rapportEvenementBean.setNature(n.getLabel());
        rapportEvenementBean.setDescription(evenement.getValeurNature().getDescription().getValeur());
        rapportEvenementBean.setCommune(evenement.getLocalisation().getCommune());
        rapportEvenementBean.setComplement((Map)attributsEvenements);
        rapportEvenementBean.setDateHeureEvt(new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date(evenement.getDateCreation())));
        rapportEvenementBean.setDelegation(evenement.getDistrict());
        rapportEvenementBean.setHorairesInterventions(new SimpleDateFormat("dd-MM-yyyy HH:mm").format(new Date(evenement.getDateCreation())));
        rapportEvenementBean.setNomAgent(evenement.getCodeUtilisateur());
        rapportEvenementBean.setNomAgentComplet(this.getNomAgentComplet(evenement.getCodeUtilisateur()));
        rapportEvenementBean.setPhotos(this.getPhotos(evenement));
        if (evenement.getLocalisation().getAbsPrDebut() >= 0) {
            rapportEvenementBean.setPr(evenement.getLocalisation().getPrDebut() + "+" + evenement.getLocalisation().getAbsPrDebut());
        } else {
            rapportEvenementBean.setPr(evenement.getLocalisation().getPrDebut() + "" + evenement.getLocalisation().getAbsPrDebut());
        }
        rapportEvenementBean.setRd(evenement.getLocalisation().getAxe());
        return rapportEvenementBean;
    }

    private String getNomAgentComplet(String codeUtilisateur) {
        PrismCentralUser utilisateur = this.service.getUtilisateur(codeUtilisateur);
        if (utilisateur != null) {
            return utilisateur.getNom();
        }
        return codeUtilisateur;
    }

    private List<String> getPhotos(Evenement evt) {
        File basedir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
        boolean indatabase = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"));
        File dir = new File(basedir, evt.getIdSituation() + File.separator + evt.getIdReference());
        ArrayList<String> photos = new ArrayList<String>();
        for (String filename : evt.getPhotos()) {
            if (indatabase) {
                byte[] data = this.service.getPhoto(filename);
                if (data == null) continue;
                photos.add(DatatypeConverter.printBase64Binary((byte[])data));
                continue;
            }
            File file = new File(dir, filename);
            if (file.exists()) {
                try {
                    photos.add(this.imgToString(file));
                }
                catch (Exception e) {
                    Log.error("erreur \u00e0 la conversion de l'image");
                    Log.error(e.toString(), e);
                }
                continue;
            }
            Log.error("image introuvable dans le r\u00e9pertoire : " + dir + filename);
        }
        return photos;
    }

    private String imgToString(File img) throws Exception {
        Log.debug("imgToString : " + img.getName());
        FileInputStream fis = null;
        fis = new FileInputStream(img);
        Log.debug("imgToString : new FileInputStream OK");
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        Log.debug("imgToString : new ByteArrayOutputStream OK");
        int c = -1;
        while ((c = fis.read()) != -1) {
            bais.write(c);
        }
        Log.debug("imgToString : ByteArrayOutputStream write OK");
        fis.close();
        Log.debug("imgToString : fis.close OK");
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }
}

