/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.csv;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActivitePeriode;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.ig4.Agent;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.ConstantesCSV;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.csv.CSVComposantFactory;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.CSV;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Nombre;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CSVUtils {
    public static String TYPE_OPERATION_CD34 = "Chantiers";

    public static Map<String, String> getListeChamps(IBusinessService service, List<Situation> situations, Map<String, Nature> natures) {
        CSVComposantFactory factory = new CSVComposantFactory(service);
        LinkedHashMap<String, String> colonnes = new LinkedHashMap<String, String>();
        for (String s : ConstantesCSV.CHAMP_CSV_STATIC) {
            colonnes.put(s, s);
        }
        if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
            for (String s : ConstantesCSV.CHAMP_CSV_SYSTEME_DATE_HEURE_SEPARE) {
                colonnes.put(s, s);
            }
        } else {
            for (String s : ConstantesCSV.CHAMP_CSV_SYSTEME) {
                colonnes.put(s, s);
            }
        }
        for (Situation situation : situations) {
            for (Evenement evenement : situation.getEvenements()) {
                Nature n = (Nature)DeepCopy.copy((Object)natures.get(evenement.getValeurNature().getCode()));
                n.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                for (Champ c : listeChamp) {
                    boolean index = false;
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    if (champscsv == null) continue;
                    for (ChampCSV champcsv : champscsv) {
                        if (colonnes.containsKey(champcsv.getCode())) continue;
                        Log.debug("Champs csv " + champcsv.getCode() + " -- " + champcsv.getLibelle());
                        if (GLS.estVide((String)champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), GLS.getLibelleChampEnClair((String)champcsv.getCode()));
                            continue;
                        }
                        if (!colonnes.containsValue(champcsv.getLibelle())) {
                            colonnes.put(champcsv.getCode(), champcsv.getLibelle());
                            continue;
                        }
                        colonnes.put(champcsv.getCode(), champcsv.getLibelle().concat(" (" + champcsv.getCode() + ")"));
                    }
                }
            }
        }
        return colonnes;
    }

    public static String genereCSV(List<Mission> missions) {
        StringBuffer s = new StringBuffer();
        for (Mission m : missions) {
            s.append(CSV.toCSV((String)m.getCentre()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeMission()));
            s.append(CSV.ajouterChampCSV((String)m.getDateDebut()));
            s.append(CSV.ajouterChampCSV((String)m.getHeureDebut()));
            s.append(CSV.ajouterChampCSV((String)m.getDateFin()));
            s.append(CSV.ajouterChampCSV((String)m.getHeureFin()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeAgent2()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeAgent3()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)m.getQuantiteOeuvre()));
            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
            s.append(CSV.ajouterChampCSV((String)m.getDureeTache()));
            s.append("\n");
        }
        return s.toString();
    }

    public static String genereCSVDIRSO(List<Mission> missions) {
        StringBuffer s = new StringBuffer();
        for (Mission m : missions) {
            if (GLS.estVide((List)m.getAgents()) || m.getType() != 5) continue;
            for (Agent agent : m.getAgents()) {
                s.append(CSV.toCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMission()));
                if (GLS.estVide((String)agent.getDepartBase())) {
                    s.append(CSV.ajouterChampCSV((String)m.getDateDebut()));
                    s.append(CSV.ajouterChampCSV((String)m.getHeureDebut()));
                } else {
                    GLSDate.instanceOf();
                    Calendar debut = GLSDate.toDate((String)agent.getDepartBase());
                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)debut, (DateFormat)GLSDate.formatDateJour)));
                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)debut, (DateFormat)GLSDate.formatHeure)));
                }
                if (GLS.estVide((String)agent.getRetourBase())) {
                    s.append(CSV.ajouterChampCSV((String)m.getDateFin()));
                    s.append(CSV.ajouterChampCSV((String)m.getHeureFin()));
                } else {
                    GLSDate.instanceOf();
                    Calendar fin = GLSDate.toDate((String)agent.getRetourBase());
                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)fin, (DateFormat)GLSDate.formatDateJour)));
                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)fin, (DateFormat)GLSDate.formatHeure)));
                }
                s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)m.getQuantiteOeuvre()));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)m.getDureeTache()));
                s.append(CSV.ajouterChampCSV((String)GLS.getString((String)agent.getRythme(), (String)"-1")));
                s.append(CSV.ajouterChampCSV((String)GLS.getString((String)agent.getModalite(), (String)"N")));
                s.append(CSV.ajouterChampCSV((String)m.getCodeEvenement()));
                s.append("\n");
            }
        }
        return s.toString();
    }

    public static String genereCSVCD34(List<Mission> missions) {
        StringBuffer s = new StringBuffer();
        for (Mission m : missions) {
            Agent agent;
            List autresVehicule = m.getAutresVehicules();
            if (!GLS.estVide((List)m.getAgents())) {
                Log.debug("Nb agents mission : " + m.getAgents().size());
            } else {
                Log.debug("Un agent");
            }
            if (!GLS.estVide((List)autresVehicule)) {
                Log.debug("Nb v\u00e9hicules mission : " + autresVehicule.size());
            } else {
                Log.debug("Un v\u00e9hicule");
            }
            if (m.getType() == 5) {
                if (!GLS.estVide((List)m.getAgents())) {
                    for (int i = 0; i < m.getAgents().size(); ++i) {
                        agent = (Agent)m.getAgents().get(i);
                        s.append(CSV.toCSV((String)(!GLS.estVide((String)m.getCodeEvenement()) ? m.getCodeEvenement() : m.getId())));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)m.getNatureActivite()) ? m.getNatureActivite() : "326")));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        s.append(CSV.ajouterChampCSV((String)agent.getDepartBase()));
                        s.append(CSV.ajouterChampCSV((String)agent.getArriveeSite()));
                        s.append(CSV.ajouterChampCSV((String)agent.getDepartSite()));
                        s.append(CSV.ajouterChampCSV((String)agent.getRetourBase()));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)(!GLS.estVide((String)m.getCodeEvenement()) ? m.getCodeEvenement() : m.getId())));
                            s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)m.getNatureActivite()) ? m.getNatureActivite() : "326")));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            s.append(CSV.ajouterChampCSV((String)agent.getDepartBase()));
                            s.append(CSV.ajouterChampCSV((String)agent.getArriveeSite()));
                            s.append(CSV.ajouterChampCSV((String)agent.getDepartSite()));
                            s.append(CSV.ajouterChampCSV((String)agent.getRetourBase()));
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                Log.error("ERREUR AUCUN AGENT ASSOCIE A L'INTERVENTION " + m.getId());
                s.append(CSV.toCSV((String)(!GLS.estVide((String)m.getCodeEvenement()) ? m.getCodeEvenement() : m.getId())));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)m.getNatureActivite()) ? m.getNatureActivite() : "326")));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                if (GLS.estVide((List)autresVehicule)) continue;
                for (String vehicule : autresVehicule) {
                    s.append(CSV.toCSV((String)(!GLS.estVide((String)m.getCodeEvenement()) ? m.getCodeEvenement() : m.getId())));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)m.getNatureActivite()) ? m.getNatureActivite() : "326")));
                    s.append(CSV.ajouterChampCSV((String)vehicule));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                }
                continue;
            }
            if (m.getType() == 2) {
                if (!GLS.estVide((List)m.getActivitesPeriode())) {
                    for (ActivitePeriode act : m.getActivitesPeriode()) {
                        if (!GLS.estVide((List)m.getAgents())) {
                            for (int i = 0; i < m.getAgents().size(); ++i) {
                                Agent agent2 = (Agent)m.getAgents().get(i);
                                s.append(CSV.toCSV((String)m.getId()));
                                s.append(CSV.ajouterChampCSV((String)agent2.getCode()));
                                s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent2.getCentre()) ? agent2.getCentre() : m.getCentre())));
                                s.append(CSV.ajouterChampCSV((String)act.getCode()));
                                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                                GLS.getDate();
                                Calendar c = GLSDate.toDate((long)act.getDebut());
                                GLS.getDate();
                                GLS.getDate();
                                m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate));
                                GLS.getDate();
                                GLS.getDate();
                                s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                                s.append(CSV.ajouterChampCSV((String)""));
                                s.append(CSV.ajouterChampCSV((String)""));
                                GLS.getDate();
                                c = GLSDate.toDate((long)act.getFin());
                                GLS.getDate();
                                GLS.getDate();
                                s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                                if (act.getLongueur() > 500.0f) {
                                    GLS.getNombre();
                                    m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(act.getLongueur() / 1000.0f), (int)1)));
                                } else {
                                    m.setKmsParcourus("0");
                                }
                                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                                s.append(CSV.ajouterChampCSV((String)""));
                                s.append(CSV.ajouterChampCSV((String)""));
                                s.append(CSV.ajouterChampCSV((String)""));
                                s.append("\n");
                                if (GLS.estVide((List)autresVehicule)) continue;
                                for (String vehicule : autresVehicule) {
                                    s.append(CSV.toCSV((String)m.getId()));
                                    s.append(CSV.ajouterChampCSV((String)agent2.getCode()));
                                    s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent2.getCentre()) ? agent2.getCentre() : m.getCentre())));
                                    s.append(CSV.ajouterChampCSV((String)act.getCode()));
                                    s.append(CSV.ajouterChampCSV((String)vehicule));
                                    GLS.getDate();
                                    c = GLSDate.toDate((long)act.getDebut());
                                    GLS.getDate();
                                    GLS.getDate();
                                    m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate));
                                    GLS.getDate();
                                    GLS.getDate();
                                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                                    s.append(CSV.ajouterChampCSV((String)""));
                                    s.append(CSV.ajouterChampCSV((String)""));
                                    GLS.getDate();
                                    c = GLSDate.toDate((long)act.getFin());
                                    GLS.getDate();
                                    GLS.getDate();
                                    s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                                    if (act.getLongueur() > 500.0f) {
                                        GLS.getNombre();
                                        m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(act.getLongueur() / 1000.0f), (int)1)));
                                    } else {
                                        m.setKmsParcourus("0");
                                    }
                                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                                    s.append(CSV.ajouterChampCSV((String)""));
                                    s.append(CSV.ajouterChampCSV((String)""));
                                    s.append(CSV.ajouterChampCSV((String)""));
                                    s.append("\n");
                                }
                            }
                            continue;
                        }
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                        s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                        s.append(CSV.ajouterChampCSV((String)act.getCode()));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        GLS.getDate();
                        Calendar c = GLSDate.toDate((long)act.getDebut());
                        GLS.getDate();
                        GLS.getDate();
                        m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate));
                        GLS.getDate();
                        GLS.getDate();
                        s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        GLS.getDate();
                        c = GLSDate.toDate((long)act.getFin());
                        GLS.getDate();
                        GLS.getDate();
                        s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                        if (act.getLongueur() > 500.0f) {
                            GLS.getNombre();
                            m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(act.getLongueur() / 1000.0f), (int)1)));
                        } else {
                            m.setKmsParcourus("0");
                        }
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)m.getId()));
                            s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                            s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                            s.append(CSV.ajouterChampCSV((String)act.getCode()));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            GLS.getDate();
                            c = GLSDate.toDate((long)act.getDebut());
                            GLS.getDate();
                            GLS.getDate();
                            m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate));
                            GLS.getDate();
                            GLS.getDate();
                            s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            GLS.getDate();
                            c = GLSDate.toDate((long)act.getFin());
                            GLS.getDate();
                            GLS.getDate();
                            s.append(CSV.ajouterChampCSV((String)GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDate)));
                            if (act.getLongueur() > 500.0f) {
                                GLS.getNombre();
                                m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(act.getLongueur() / 1000.0f), (int)1)));
                            } else {
                                m.setKmsParcourus("0");
                            }
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                if (!GLS.estVide((List)m.getAgents())) {
                    for (int i = 0; i < m.getAgents().size(); ++i) {
                        agent = (Agent)m.getAgents().get(i);
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((String)"15"));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)m.getId()));
                            s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                            s.append(CSV.ajouterChampCSV((String)"15"));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                s.append(CSV.toCSV((String)m.getId()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)"15"));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                if (GLS.estVide((List)autresVehicule)) continue;
                for (String vehicule : autresVehicule) {
                    s.append(CSV.toCSV((String)m.getId()));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((String)"15"));
                    s.append(CSV.ajouterChampCSV((String)vehicule));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                }
                continue;
            }
            if (m.getType() == 202) {
                if (!GLS.estVide((List)m.getAgents())) {
                    for (int i = 0; i < m.getAgents().size(); ++i) {
                        agent = (Agent)m.getAgents().get(i);
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((int)111));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)m.getId()));
                            s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                            s.append(CSV.ajouterChampCSV((int)111));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                s.append(CSV.toCSV((String)m.getId()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((int)111));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                if (GLS.estVide((List)autresVehicule)) continue;
                for (String vehicule : autresVehicule) {
                    s.append(CSV.toCSV((String)m.getId()));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((int)111));
                    s.append(CSV.ajouterChampCSV((String)vehicule));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                }
                continue;
            }
            if (m.getType() == 201) {
                if (!GLS.estVide((List)m.getAgents())) {
                    for (int i = 0; i < m.getAgents().size(); ++i) {
                        agent = (Agent)m.getAgents().get(i);
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((int)121));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)m.getId()));
                            s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                            s.append(CSV.ajouterChampCSV((int)121));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                s.append(CSV.toCSV((String)m.getId()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((int)121));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                if (GLS.estVide((List)autresVehicule)) continue;
                for (String vehicule : autresVehicule) {
                    s.append(CSV.toCSV((String)m.getId()));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((int)121));
                    s.append(CSV.ajouterChampCSV((String)vehicule));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                }
                continue;
            }
            if (m.getType() == 102) {
                if (!GLS.estVide((List)m.getAgents())) {
                    for (int i = 0; i < m.getAgents().size(); ++i) {
                        agent = (Agent)m.getAgents().get(i);
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((int)134));
                        s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                        if (GLS.estVide((List)autresVehicule)) continue;
                        for (String vehicule : autresVehicule) {
                            s.append(CSV.toCSV((String)m.getId()));
                            s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                            s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                            s.append(CSV.ajouterChampCSV((int)134));
                            s.append(CSV.ajouterChampCSV((String)vehicule));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append(CSV.ajouterChampCSV((String)""));
                            s.append("\n");
                        }
                    }
                    continue;
                }
                s.append(CSV.toCSV((String)m.getId()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((int)134));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                if (GLS.estVide((List)autresVehicule)) continue;
                for (String vehicule : autresVehicule) {
                    s.append(CSV.toCSV((String)m.getId()));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((int)134));
                    s.append(CSV.ajouterChampCSV((String)vehicule));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                }
                continue;
            }
            if (m.getType() == 3) {
                if (GLS.estVide((List)m.getAgents())) continue;
                for (int i = 0; i < m.getAgents().size(); ++i) {
                    agent = (Agent)m.getAgents().get(i);
                    s.append(CSV.toCSV((String)m.getId()));
                    s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                    s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                    s.append(CSV.ajouterChampCSV((int)126));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                    s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append(CSV.ajouterChampCSV((String)""));
                    s.append("\n");
                    if (GLS.estVide((List)autresVehicule)) continue;
                    for (String vehicule : autresVehicule) {
                        s.append(CSV.toCSV((String)m.getId()));
                        s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                        s.append(CSV.ajouterChampCSV((String)(!GLS.estVide((String)agent.getCentre()) ? agent.getCentre() : m.getCentre())));
                        s.append(CSV.ajouterChampCSV((int)126));
                        s.append(CSV.ajouterChampCSV((String)vehicule));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                        s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append(CSV.ajouterChampCSV((String)""));
                        s.append("\n");
                    }
                }
                continue;
            }
            s.append(CSV.toCSV((String)m.getId()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
            s.append(CSV.ajouterChampCSV((String)m.getCentre()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeMission()));
            s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
            s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
            s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
            s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append(CSV.ajouterChampCSV((String)""));
            s.append("\n");
            if (GLS.estVide((List)autresVehicule)) continue;
            for (String vehicule : autresVehicule) {
                s.append(CSV.toCSV((String)m.getId()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMission()));
                s.append(CSV.ajouterChampCSV((String)vehicule));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)TYPE_OPERATION_CD34));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
            }
        }
        return s.toString();
    }

    public static String genereCSVCD22(List<Mission> missions) {
        StringBuffer s = new StringBuffer();
        for (Mission m : missions) {
            if (m.getSupport() == 2) {
                s.append(CSV.toCSV((String)m.getCodeEvenement()));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)"SEER"));
                s.append(CSV.ajouterChampCSV((String)(m.getType() == 1 ? "2116" : "2216")));
                s.append(CSV.ajouterChampCSV((String)"0"));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)"02"));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                continue;
            }
            if (m.getType() == 1) {
                s.append(CSV.toCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)"2110"));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)"160"));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                continue;
            }
            if (m.getType() == 1000) {
                s.append(CSV.toCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)m.getCodeAgent()));
                s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                s.append(CSV.ajouterChampCSV((String)"2111"));
                s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                s.append(CSV.ajouterChampCSV((String)(m.getDateDebut() + " " + m.getHeureDebut())));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append(CSV.ajouterChampCSV((String)(m.getDateFin() + " " + m.getHeureFin())));
                s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                s.append(CSV.ajouterChampCSV((String)"160"));
                s.append(CSV.ajouterChampCSV((String)""));
                s.append("\n");
                continue;
            }
            if (m.getType() != 5) continue;
            if (!GLS.estVide((List)m.getAgents())) {
                for (int i = 0; i < m.getAgents().size(); ++i) {
                    Agent agent = (Agent)m.getAgents().get(i);
                    s.append(CSV.toCSV((String)m.getCodeEvenement()));
                    s.append(CSV.ajouterChampCSV((String)agent.getCode()));
                    s.append(CSV.ajouterChampCSV((String)m.getCentre()));
                    s.append(CSV.ajouterChampCSV((String)"2210"));
                    s.append(CSV.ajouterChampCSV((String)m.getCodeMateriel()));
                    s.append(CSV.ajouterChampCSV((String)agent.getDepartBase()));
                    s.append(CSV.ajouterChampCSV((String)agent.getArriveeSite()));
                    s.append(CSV.ajouterChampCSV((String)agent.getDepartSite()));
                    s.append(CSV.ajouterChampCSV((String)agent.getRetourBase()));
                    if (i == 0) {
                        s.append(CSV.ajouterChampCSV((String)m.getKmsParcourus()));
                    } else {
                        s.append(CSV.ajouterChampCSV((String)""));
                    }
                    s.append(CSV.ajouterChampCSV((String)m.getCategorieRoute()));
                    if (GLS.egal((String)m.getCategorieRoute(), (String)"11")) {
                        s.append(CSV.ajouterChampCSV((String)m.getTraficRoute()));
                    } else {
                        s.append(CSV.ajouterChampCSV((String)""));
                    }
                    s.append("\n");
                }
                continue;
            }
            Log.error("ERREUR AUCUN AGENT ASSOCIE A L'INTERVENTION " + m.getId());
        }
        return s.toString();
    }
}

