/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.apachepoi;

import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismbirtbean.RapportEvenementBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvert;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvertElement;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.factory.ApacheFactory;
import com.geolocsystems.prismcentral.export.factory.RapportEvenementBeanFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class APSituationExport {
    private IBusinessService businessService;
    private String document;
    private ApachePoiConvert convert;
    private List<RapportEvenementBean> rapportEvenementBeans;
    private boolean exportInPdf = false;

    public APSituationExport(IBusinessService services) {
        this.businessService = services;
    }

    public InputStream export(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        this.rapportEvenementBeans = new ArrayList<RapportEvenementBean>();
        String idConfig = (String)parametres.get("champs");
        this.document = document;
        this.exportInPdf = format.endsWith("PDF");
        this.convert = this.businessService.getApachePoiConvert(idConfig);
        if (this.convert.getObjets().contains(ApacheFactory.OBJET_EVENEMENT)) {
            this.rapportEvenementBeans = new RapportEvenementBeanFactory(this.businessService).convert(listSituation);
        }
        return this.runReport();
    }

    private InputStream runReport() {
        BufferedInputStream retour = null;
        String fileNameModele = this.document;
        Log.debug("fileNameModele :" + fileNameModele);
        ApacheFactory factory = new ApacheFactory();
        XSSFWorkbook workbook = null;
        try {
            String fileRetour;
            try {
                workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (workbook == null) {
                fileNameModele = "C:/Temp/" + this.document;
            }
            workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            RapportEvenementBean evenement = this.rapportEvenementBeans.get(0);
            for (ApachePoiConvertElement element : this.convert.getElements()) {
                XSSFSheet dataSheet = workbook.getSheetAt(element.getFeuille());
                String value = "";
                if (element.getChamp().equals("photos")) {
                    int index = 0;
                    int nbLigneEspace = 0;
                    int nbColonneEspace = 0;
                    for (String photo : evenement.getPhotos()) {
                        byte[] bytes = DatatypeConverter.parseBase64Binary((String)photo);
                        int pictureIdx = workbook.addPicture(bytes, 6);
                        XSSFCreationHelper helper = workbook.getCreationHelper();
                        XSSFDrawing drawing = dataSheet.createDrawingPatriarch();
                        XSSFClientAnchor anchor = new XSSFClientAnchor();
                        if (element.getPosition().equals((Object)"H")) {
                            anchor.setCol1(element.getColonne() + nbColonneEspace);
                            anchor.setRow1(element.getLigne());
                        } else {
                            anchor.setCol1(element.getColonne());
                            anchor.setRow1(element.getLigne() + nbLigneEspace);
                        }
                        ++index;
                        XSSFPicture pict = drawing.createPicture(anchor, pictureIdx);
                        pict.resize();
                        double height = pict.getImageDimension().getHeight();
                        double width = pict.getImageDimension().getWidth();
                        nbLigneEspace = (int)((double)nbLigneEspace + Math.ceil(height / 20.0));
                        nbColonneEspace = (int)((double)nbColonneEspace + Math.ceil(width / 80.0));
                    }
                    continue;
                }
                value = factory.convert(element, evenement);
                dataSheet.getRow(element.getLigne()).getCell(element.getColonne()).setCellValue(value);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            String dateHeure = sdf.format(new Date(System.currentTimeMillis()));
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            String fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".xlsx";
            FileOutputStream output = new FileOutputStream(fileDestination);
            workbook.write((OutputStream)output);
            ((OutputStream)output).close();
            workbook.close();
            if (this.exportInPdf && (fileRetour = this.exportInPdf(fileDestination, ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf")) != null) {
                fileDestination = fileRetour;
            }
            File outfile = new File(fileDestination);
            try {
                retour = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Done");
        }
        catch (FileNotFoundException e) {
            Log.error("FileNotFoundException", e);
        }
        catch (IOException e) {
            Log.error("IOException", e);
        }
        catch (Exception e) {
            Log.error("Exception", e);
        }
        workbook = null;
        System.out.println("End");
        return retour;
    }

    public String exportInPdf(String file, String fileName) {
        try {
            int timeout = 1;
            TimeUnit minutes = TimeUnit.MINUTES;
            Path tempScript = Files.createTempFile("script", ".vbs", new FileAttribute[0]);
            String pathVbsScript = this.businessService.getConfiguration().getString("ap.situation.vbs.pdf");
            System.out.println("Path for vbs script is: '" + pathVbsScript + "'");
            List<String> script = null;
            try {
                script = Files.readAllLines(new File(pathVbsScript).toPath());
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (script == null) {
                script = Files.readAllLines(new File("C:\\Temp\\VBA\\XLStoPDF.vbs").toPath());
            }
            String templateFile = file;
            templateFile = templateFile.replace("\\", "\\\\");
            String pdfFile = fileName;
            pdfFile = pdfFile.replace("\\", "\\\\");
            System.out.println("script is: " + script);
            for (int i = 0; i < script.size(); ++i) {
                script.set(i, script.get(i).replaceAll("XL_FILE", templateFile));
                script.set(i, script.get(i).replaceAll("PDF_FILE", pdfFile));
            }
            Files.write(tempScript, script, new OpenOption[0]);
            ProcessBuilder pb = new ProcessBuilder("wscript", tempScript.toString());
            Process process = pb.start();
            Boolean success = process.waitFor(timeout, minutes);
            if (!success.booleanValue()) {
                System.out.println("Error: Could not convert PDF within " + timeout + " " + (Object)((Object)minutes));
                process.destroy();
            } else {
                System.out.println("Process to run visual basic script for pdf conversion succeeded.");
            }
            return pdfFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

