/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.apachepoi;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.apachepoi.APFactory;
import com.geolocsystems.prismcentral.export.csv.CSVComposantFactory;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class APModelExport {
    private IBusinessService service;
    private String document;
    private List<Situation> listSituation;
    private boolean exportInPdf = false;
    private HashMap<String, ArrayList<CellCoordinates>> mapCode = new HashMap();

    public APModelExport(IBusinessService services) {
        this.service = services;
    }

    public InputStream export(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        this.listSituation = listSituation;
        this.document = document;
        this.exportInPdf = format.endsWith("PDF");
        return this.runReport();
    }

    private InputStream runReport() {
        BufferedInputStream retour = null;
        String fileNameModele = this.document;
        Log.debug("fileNameModele :" + fileNameModele);
        XSSFWorkbook workbook = null;
        try {
            String fileRetour;
            try {
                workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (workbook == null) {
                fileNameModele = "C:/Temp/" + this.document;
            }
            workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            Map natures = this.service.getNatures();
            CSVComposantFactory factory = new CSVComposantFactory(this.service);
            for (int indexSheet = 0; indexSheet < workbook.getNumberOfSheets(); ++indexSheet) {
                XSSFSheet sheet = workbook.getSheetAt(indexSheet);
                this.initMapCode(sheet);
                int index = 0;
                for (Situation situation : this.listSituation) {
                    for (Evenement evenement : situation.getEvenements()) {
                        Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                        n.chargerValeurs(evenement.getValeurNature());
                        List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                        HashMap<String, String> valeurs = new HashMap<String, String>();
                        for (Champ c : listeChamp) {
                            boolean indexChamp = false;
                            List champscsv = (List)c.getView((IComposantFactory)factory);
                            for (ChampCSV champcsv : champscsv) {
                                valeurs.put(champcsv.getCode(), champcsv.getValeur());
                                Log.debug("valeurs : " + champcsv.getCode() + ":" + champcsv.getValeur());
                            }
                        }
                        for (String code : this.mapCode.keySet()) {
                            for (CellCoordinates coord : this.mapCode.get(code)) {
                                if (sheet.getRow(coord.row + index) == null) {
                                    sheet.createRow(coord.row + index);
                                }
                                if (sheet.getRow(coord.row + index).getCell(coord.cell.intValue()) == null) {
                                    sheet.getRow(coord.row + index).createCell(coord.cell.intValue());
                                }
                                XSSFCell cell = sheet.getRow(coord.row + index).getCell(coord.cell.intValue());
                                if (coord.value.equals("")) {
                                    cell.setCellValue(APFactory.getValue(evenement, valeurs, code));
                                    continue;
                                }
                                if (coord.value.equals(APFactory.getValue(evenement, valeurs, code))) {
                                    cell.setCellValue("X");
                                    continue;
                                }
                                cell.setCellValue("");
                            }
                        }
                        ++index;
                    }
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            String dateHeure = sdf.format(new Date(System.currentTimeMillis()));
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            String fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".xlsx";
            FileOutputStream output = new FileOutputStream(fileDestination);
            workbook.write((OutputStream)output);
            ((OutputStream)output).close();
            workbook.close();
            if (this.exportInPdf && (fileRetour = this.exportInPdf(fileDestination, ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf")) != null) {
                fileDestination = fileRetour;
            }
            File outfile = new File(fileDestination);
            try {
                retour = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Done");
        }
        catch (FileNotFoundException e) {
            Log.error("FileNotFoundException", e);
        }
        catch (IOException e) {
            Log.error("IOException", e);
        }
        catch (Exception e) {
            Log.error("Exception", e);
        }
        workbook = null;
        System.out.println("End");
        return retour;
    }

    public String exportInPdf(String file, String fileName) {
        try {
            int timeout = 1;
            TimeUnit minutes = TimeUnit.MINUTES;
            Path tempScript = Files.createTempFile("script", ".vbs", new FileAttribute[0]);
            String pathVbsScript = this.service.getConfiguration().getString("ap.situation.vbs.pdf");
            System.out.println("Path for vbs script is: '" + pathVbsScript + "'");
            List<String> script = null;
            try {
                script = Files.readAllLines(new File(pathVbsScript).toPath());
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (script == null) {
                script = Files.readAllLines(new File("C:\\Temp\\VBA\\XLStoPDF.vbs").toPath());
            }
            String templateFile = file;
            templateFile = templateFile.replace("\\", "\\\\");
            String pdfFile = fileName;
            pdfFile = pdfFile.replace("\\", "\\\\");
            System.out.println("script is: " + script);
            for (int i = 0; i < script.size(); ++i) {
                script.set(i, script.get(i).replaceAll("XL_FILE", templateFile));
                script.set(i, script.get(i).replaceAll("PDF_FILE", pdfFile));
            }
            Files.write(tempScript, script, new OpenOption[0]);
            ProcessBuilder pb = new ProcessBuilder("wscript", tempScript.toString());
            Process process = pb.start();
            Boolean success = process.waitFor(timeout, minutes);
            if (!success.booleanValue()) {
                System.out.println("Error: Could not convert PDF within " + timeout + " " + (Object)((Object)minutes));
                process.destroy();
            } else {
                System.out.println("Process to run visual basic script for pdf conversion succeeded.");
            }
            return pdfFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void initMapCode(XSSFSheet sheet) {
        this.mapCode = new HashMap();
        for (String code : APFactory.codes) {
            ArrayList<CellCoordinates> liste = this.findCellCoordinates(sheet, code);
            this.mapCode.put(code, liste);
        }
    }

    private ArrayList<CellCoordinates> findCellCoordinates(XSSFSheet sheet, String cellContent) {
        ArrayList<CellCoordinates> retour = new ArrayList<CellCoordinates>();
        for (Row row : sheet) {
            for (Cell cell : row) {
                try {
                    if (cell.getRichStringCellValue().getString().trim().equals("[" + cellContent + "]")) {
                        retour.add(new CellCoordinates(cell.getRowIndex(), cell.getColumnIndex(), ""));
                        continue;
                    }
                    if (!cell.getRichStringCellValue().getString().trim().startsWith("[" + cellContent + ":")) continue;
                    String value = cell.getRichStringCellValue().getString().trim().split(":")[1].split("]")[0];
                    System.out.println("mapCode [" + cellContent + ":" + value + "] == " + cell.getRichStringCellValue().getString().trim() + " " + cell.getRowIndex() + "," + cell.getColumnIndex());
                    retour.add(new CellCoordinates(cell.getRowIndex(), cell.getColumnIndex(), value));
                }
                catch (Exception exception) {}
            }
        }
        return retour;
    }

    public class CellCoordinates {
        public Integer row;
        public Integer cell;
        public String value;

        public CellCoordinates(Integer r, Integer c, String v) {
            this.row = r;
            this.cell = c;
            this.value = v;
        }
    }
}

