/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SyntheseViseeExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    Integer[] idsEvenements;
    String idUtilisateur;
    private SyntheseViseeBean syntheseViseeBean;
    String fileDestination = "";
    File fileExport;
    BirtEngine birtEngine = null;

    public InputStream export(SyntheseViseeBean syntheseViseeBean, String format) {
        this.format = format;
        this.syntheseViseeBean = syntheseViseeBean;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("synthese.patrouille.visee.design"));
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap valeurs = new HashMap();
            task.getAppContext().put("syntheseViseeBean", this.syntheseViseeBean);
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            if ("PDF".equals(this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if ("ODT".equals(this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            this.fileExport = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(this.fileExport));
            }
            catch (FileNotFoundException e) {
                Log.error(e.getMessage(), e);
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

