/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseTableauBordPCBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordPCLineBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SyntheseTableauBordStatistiqueFauchageExport {
    private static IReportRunnable design = null;
    private IReportEngine birtReportEngine = null;
    private EngineConfig config = null;
    private String format;
    private List<SyntheseTableauBordStatistiqueFauchageBean> syntheseTableauBordFrequencePatrouille;
    private String imageFrequencePatrouille;
    private String dateMin;
    private boolean afficheHoraire;
    private String fileDestination = "";
    private BirtEngine birtEngine = null;

    public InputStream export(List<SyntheseTableauBordStatistiqueFauchageBean> syntheseTableauBordStatistiqueSchemaRoutier, String imageFrequencePatrouille, String format, String dateMin, boolean afficheHoraire) {
        this.format = format;
        this.syntheseTableauBordFrequencePatrouille = syntheseTableauBordStatistiqueSchemaRoutier;
        this.imageFrequencePatrouille = imageFrequencePatrouille;
        this.dateMin = dateMin;
        this.afficheHoraire = afficheHoraire;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("synthese.tableau.bord.frequence.patrouille.design"));
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            task.getAppContext().put("syntheseTableauBordFrequencePatrouille", this.syntheseTableauBordFrequencePatrouille);
            task.getAppContext().put("imageFrequencePatrouille", this.imageFrequencePatrouille);
            valeurs.put("dateMin", this.dateMin);
            valeurs.put("afficheHoraire", this.afficheHoraire);
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else if (IExportService.FORMATS.estXLS((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLS");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    private List<SyntheseTableauBordPCBean> returnDummySyntheseTableauBordPCList() {
        ArrayList<SyntheseTableauBordPCBean> retour = new ArrayList<SyntheseTableauBordPCBean>();
        int nbSecteurs = 3;
        for (int i = 0; i < nbSecteurs; ++i) {
            SyntheseTableauBordPCBean tableauBord = new SyntheseTableauBordPCBean();
            tableauBord.setNomGroupe("NomGroupe" + i);
            int nbCentres = this.numAleatoire(1, 10);
            ArrayList<SyntheseTableauBordPCLineBean> syntheseTableauBordPCLineList = new ArrayList<SyntheseTableauBordPCLineBean>();
            Integer[] totalParMois = new Integer[13];
            for (int k = 0; k < 13; ++k) {
                totalParMois[k] = 0;
            }
            for (int j = 0; j < nbCentres; ++j) {
                SyntheseTableauBordPCLineBean tableauBordPCLineBean = new SyntheseTableauBordPCLineBean();
                tableauBordPCLineBean.setNom("Nom" + j);
                int total = 0;
                Integer[] nbMois = new Integer[12];
                for (int k = 0; k < 12; ++k) {
                    int nb = this.numAleatoire(0, 25);
                    nbMois[k] = nb;
                    total += nb;
                }
                tableauBordPCLineBean.setNbMois(nbMois);
                tableauBordPCLineBean.setTotal(total);
                syntheseTableauBordPCLineList.add(tableauBordPCLineBean);
            }
            tableauBord.setSyntheseTableauBordPCLine(syntheseTableauBordPCLineList);
            retour.add(tableauBord);
        }
        return retour;
    }

    private int numAleatoire() {
        return this.numAleatoire(1, 999);
    }

    private int numAleatoire(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }
}

