/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouillesBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SynthesePatrouillesExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    String[] patrouilles;
    String idUtilisateur;
    private SynthesePatrouillesBean synthesePatrouilleBirt;
    String fileDestination = "";
    File fileExport;
    BirtEngine birtEngine = null;
    private String typeExport;

    public InputStream export(SynthesePatrouillesBean synthese, String format) {
        this.format = format;
        this.typeExport = this.typeExport;
        this.synthesePatrouilleBirt = synthese;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("design.path") + "/" + "fiches_synthese_patrouilles_tableau.rptdesign");
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            task.getAppContext().put("synthesePatrouillesBirt", this.synthesePatrouilleBirt);
            HashMap<String, String[]> valeurs = new HashMap<String, String[]>();
            List patrouillesBean = this.synthesePatrouilleBirt.getPatrouilles();
            this.patrouilles = new String[patrouillesBean.size() + 1];
            this.patrouilles[0] = this.getDataCSVExportEntete((SynthesePatrouilleBean)patrouillesBean.get(0));
            int cpt = 1;
            for (SynthesePatrouilleBean patrouilleBean : patrouillesBean) {
                this.patrouilles[cpt++] = this.getDataCSVExport(patrouilleBean);
            }
            valeurs.put("patrouilles", this.patrouilles);
            task.setParameterValues(valeurs);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)((BufferedImage)this.synthesePatrouilleBirt.getImagePatrouilles()), "png", bos);
            byte[] dataImageEvenement = bos.toByteArray();
            if (dataImageEvenement != null) {
                task.getAppContext().put("imageWMS", DatatypeConverter.printBase64Binary((byte[])dataImageEvenement));
            }
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            if ("PDF".equals(this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if ("ODT".equals(this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            this.fileExport = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(this.fileExport));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        return reponse;
    }

    private String getDataCSVExport(SynthesePatrouilleBean patrouilleBean) {
        Map lgStatus = patrouilleBean.getLongueurStatus();
        String result = "";
        for (String statut : lgStatus.keySet()) {
            result = result + (result.equals("") ? "" : ";") + statut + ";" + lgStatus.get(statut);
        }
        return patrouilleBean.getDateDebut() + " - " + patrouilleBean.getHeureDebut() + ";" + patrouilleBean.getDateFin() + " - " + patrouilleBean.getHeureFin() + ";" + patrouilleBean.getPatrouilleur() + ";" + patrouilleBean.getLongueurPatrouille() + ";" + result;
    }

    private String getDataCSVExportEntete(SynthesePatrouilleBean patrouilleBean) {
        Map lgStatus = patrouilleBean.getLongueurStatus();
        String result = "";
        for (String statut : lgStatus.keySet()) {
            result = result + (result.equals("") ? "" : ";") + statut;
        }
        result = "";
        return "Date d\u00e9but;Date fin;Patrouilleur;longueur totale;" + result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

