/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SynthesePatrouilleBirt;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.net.util.Base64;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SynthesePatrouilleExport {
    public static final String TOURNEE = "tournee";
    public static final String PATROUILLE = "patrouille";
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    Integer[] idsEvenements;
    String idUtilisateur;
    private SynthesePatrouilleBirt synthesePatrouilleBirt;
    String fileDestination = "";
    File fileExport;
    BirtEngine birtEngine = null;
    private String typeExport;

    public InputStream export(String typeExport, SynthesePatrouilleBirt synthesePatrouilleBirt, String format) {
        this.format = format;
        this.typeExport = typeExport;
        this.synthesePatrouilleBirt = synthesePatrouilleBirt;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            design = this.typeExport == null || this.typeExport.equals(PATROUILLE) ? this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("synthese.patrouille.design")) : this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("synthese.tournee.design"));
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap valeurs = new HashMap();
            Log.debug(this.synthesePatrouilleBirt.getSynthesePatrouilleLongueurTroncons());
            for (String codeTroncon : this.synthesePatrouilleBirt.getSynthesePatrouilleLongueurTroncons().keySet()) {
                Log.debug((String)this.synthesePatrouilleBirt.getListeLibelleCode().get(codeTroncon) + " : " + this.synthesePatrouilleBirt.getSynthesePatrouilleLongueurTroncons().get(codeTroncon) + " m");
            }
            task.getAppContext().put("synthesePatrouilleBirt", this.synthesePatrouilleBirt);
            task.getAppContext().put("synthesePatrouilleAdresse", ConfigurationFactory.getInstance().get("synthese.patrouille.adresse"));
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            if ("PDF".equals(this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if ("ODT".equals(this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            this.fileExport = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(this.fileExport));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    private String imgToString(File img) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(img);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        int c = -1;
        try {
            while ((c = fis.read()) != -1) {
                bais.write(c);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fis.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }
}

