/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseBilanInterventionBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordCentreBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SyntheseBilanInterventionExport {
    private static IReportRunnable design = null;
    private IReportEngine birtReportEngine = null;
    private EngineConfig config = null;
    private String format;
    private SyntheseBilanInterventionBean syntheseBilanIntervention;
    private String fileDestination = "";
    private BirtEngine birtEngine = null;
    private int annee;

    public Optional<InputStream> export(SyntheseBilanInterventionBean syntheseBilanIntervention, String format, int annee) {
        this.format = format;
        this.syntheseBilanIntervention = syntheseBilanIntervention;
        this.annee = annee;
        return Optional.ofNullable(this.exporter());
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            Log.debug("design : " + ConfigurationFactory.getInstance().get("synthese.bilan.intervention.design"));
            design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("synthese.bilan.intervention.design"));
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Integer> valeurs = new HashMap<String, Integer>();
            task.getAppContext().put("syntheseBilanIntervention", this.syntheseBilanIntervention);
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            valeurs.put("annee", this.annee);
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    private List<SyntheseTableauBordBean> returnDummySyntheseTableauBordList() {
        ArrayList<SyntheseTableauBordBean> retour = new ArrayList<SyntheseTableauBordBean>();
        int nbSecteurs = 3;
        for (int i = 0; i < nbSecteurs; ++i) {
            SyntheseTableauBordBean tableauBord = new SyntheseTableauBordBean();
            tableauBord.setNomSecteur("Secteur" + i);
            int nbCentres = this.numAleatoire(1, 10);
            ArrayList<SyntheseTableauBordCentreBean> syntheseTableauBordCentreList = new ArrayList<SyntheseTableauBordCentreBean>();
            Integer[] totalParMois = new Integer[13];
            for (int k = 0; k < 13; ++k) {
                totalParMois[k] = 0;
            }
            for (int j = 0; j < nbCentres; ++j) {
                SyntheseTableauBordCentreBean tableauBordCentre = new SyntheseTableauBordCentreBean();
                tableauBordCentre.setCentre("Centre" + j);
                int total = 0;
                Integer[] nbJoursPatrouilles = new Integer[12];
                int k = 0;
                while (k < 12) {
                    int nb = this.numAleatoire(0, 25);
                    nbJoursPatrouilles[k] = nb;
                    total += nb;
                    Integer[] integerArray = totalParMois;
                    int n = k++;
                    Integer.valueOf(integerArray[n] + nb);
                    integerArray = totalParMois;
                    Integer.valueOf(integerArray[12] + nb);
                }
                tableauBordCentre.setNbJoursPatrouilles(nbJoursPatrouilles);
                tableauBordCentre.setTotal(total);
                syntheseTableauBordCentreList.add(tableauBordCentre);
            }
            tableauBord.setTotalParMois(totalParMois);
            tableauBord.setSyntheseTableauBordCentreBean(syntheseTableauBordCentreList);
            retour.add(tableauBord);
        }
        return retour;
    }

    private int numAleatoire() {
        return this.numAleatoire(1, 999);
    }

    private int numAleatoire(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }
}

