/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.EvenementStatistiqueBean;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;

public class StatistiquesExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    Integer[] idsEvenements;
    String fileDestination = "";
    BirtEngine birtEngine = null;
    EvenementStatistiqueBean evenementStatistique;

    public InputStream export(EvenementStatistiqueBean evenementStatistique) {
        this.evenementStatistique = evenementStatistique;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        System.out.println("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            ArrayList<Long> tempsSousGroupe;
            ArrayList<Integer> traitesSousGroupe;
            ArrayList<Integer> valuesSousGroupe;
            ArrayList<String> keysSousGroupe;
            ArrayList<String> keysGroupe;
            ArrayList<Integer> values;
            ArrayList<String> keys;
            if (design == null) {
                design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.statistiques.design"));
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            valeurs.put("Agregation", this.evenementStatistique.getAgregation());
            valeurs.put("NbEvenements", this.evenementStatistique.getNbEvenements());
            valeurs.put("NbEvenementsTraites", this.evenementStatistique.getNbEvenementsTraites());
            valeurs.put("TempsTraitementEvenements", this.evenementStatistique.getTempsTraitementEvenements());
            if ("Centre".equals(this.evenementStatistique.getAgregation())) {
                valeurs.put("Cle", this.evenementStatistique.getCentre());
                keys = new ArrayList<String>();
                values = new ArrayList<Integer>();
                keysGroupe = new ArrayList();
                keysSousGroupe = new ArrayList<String>();
                valuesSousGroupe = new ArrayList<Integer>();
                traitesSousGroupe = new ArrayList<Integer>();
                tempsSousGroupe = new ArrayList<Long>();
                for (String key : this.evenementStatistique.getNbEvenementsParNature().keySet()) {
                    if (this.evenementStatistique.getLabelsNatures().containsKey(key)) {
                        keys.add(this.evenementStatistique.getLabelsNatures().get(key));
                    } else {
                        keys.add(key);
                    }
                    values.add(this.evenementStatistique.getNbEvenementsParNature().get(key));
                    for (String sousKey : this.evenementStatistique.getNbEvenementsParSousNature().get(key).keySet()) {
                        if (this.evenementStatistique.getLabelsNatures().containsKey(key)) {
                            keysGroupe.add(this.evenementStatistique.getLabelsNatures().get(key));
                        } else {
                            keysGroupe.add(key);
                        }
                        keysSousGroupe.add(sousKey);
                        valuesSousGroupe.add(this.evenementStatistique.getNbEvenementsParSousNature().get(key).get(sousKey));
                        traitesSousGroupe.add(this.evenementStatistique.getNbEvenementsTraiteParSousNature().get(key).get(sousKey));
                        try {
                            tempsSousGroupe.add(this.evenementStatistique.getTempsMoyenTraitementParSousNature().get(key).get(sousKey));
                        }
                        catch (Exception e) {
                            tempsSousGroupe.add(0L);
                        }
                    }
                }
                valeurs.put("EvenementsRegroupesKeys", keys.toArray());
                valeurs.put("EvenementsRegroupesValues", values.toArray());
                valeurs.put("EvenementsGroupesKeys", keysGroupe.toArray());
                valeurs.put("EvenementsSousGroupesKeys", keysSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesValues", valuesSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesTraites", traitesSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesTemps", tempsSousGroupe.toArray());
                valeurs.put("FiltresCles", this.evenementStatistique.getFiltres().keySet().toArray());
                valeurs.put("FiltresValeurs", this.evenementStatistique.getFiltres().values().toArray());
            }
            if ("Nature".equals(this.evenementStatistique.getAgregation())) {
                valeurs.put("Cle", this.evenementStatistique.getNature());
                keys = new ArrayList();
                values = new ArrayList();
                for (String key : this.evenementStatistique.getNbEvenementsParCentre().keySet()) {
                    if (key != null) {
                        keys.add(key);
                    } else {
                        keys.add(PrismI18n.getString("stats.statistiques.chart.autre"));
                    }
                    values.add(this.evenementStatistique.getNbEvenementsParCentre().get(key));
                }
                valeurs.put("EvenementsRegroupesKeys", keys.toArray());
                valeurs.put("EvenementsRegroupesValues", values.toArray());
                valeurs.put("FiltresCles", this.evenementStatistique.getFiltres().keySet().toArray());
                valeurs.put("FiltresValeurs", this.evenementStatistique.getFiltres().values().toArray());
            }
            if ("Axe".equals(this.evenementStatistique.getAgregation())) {
                valeurs.put("Cle", this.evenementStatistique.getAxe());
                keys = new ArrayList();
                values = new ArrayList();
                keysGroupe = new ArrayList<String>();
                keysSousGroupe = new ArrayList();
                valuesSousGroupe = new ArrayList();
                traitesSousGroupe = new ArrayList();
                tempsSousGroupe = new ArrayList();
                for (String key : this.evenementStatistique.getNbEvenementsParNature().keySet()) {
                    if (this.evenementStatistique.getLabelsNatures().containsKey(key)) {
                        keys.add(this.evenementStatistique.getLabelsNatures().get(key));
                    } else {
                        keys.add(key);
                    }
                    values.add(this.evenementStatistique.getNbEvenementsParNature().get(key));
                    for (String sousKey : this.evenementStatistique.getNbEvenementsParSousNature().get(key).keySet()) {
                        if (this.evenementStatistique.getLabelsNatures().containsKey(key)) {
                            keysGroupe.add(this.evenementStatistique.getLabelsNatures().get(key));
                        } else {
                            keysGroupe.add(key);
                        }
                        keysSousGroupe.add(sousKey);
                        valuesSousGroupe.add(this.evenementStatistique.getNbEvenementsParSousNature().get(key).get(sousKey));
                        traitesSousGroupe.add(this.evenementStatistique.getNbEvenementsTraiteParSousNature().get(key).get(sousKey));
                        if (this.evenementStatistique.getTempsMoyenTraitementParSousNature().get(key) == null) continue;
                        tempsSousGroupe.add(this.evenementStatistique.getTempsMoyenTraitementParSousNature().get(key).get(sousKey));
                    }
                }
                valeurs.put("EvenementsRegroupesKeys", keys.toArray());
                valeurs.put("EvenementsRegroupesValues", values.toArray());
                valeurs.put("EvenementsGroupesKeys", keysGroupe.toArray());
                valeurs.put("EvenementsSousGroupesKeys", keysSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesValues", valuesSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesTraites", traitesSousGroupe.toArray());
                valeurs.put("EvenementsSousGroupesTemps", tempsSousGroupe.toArray());
                valeurs.put("FiltresCles", this.evenementStatistique.getFiltres().keySet().toArray());
                valeurs.put("FiltresValeurs", this.evenementStatistique.getFiltres().values().toArray());
            }
            task.setParameterValues(valeurs);
            PDFRenderOption renderOption = new PDFRenderOption();
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf";
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.setOutputFormat("PDF");
            renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        System.out.println("fin runReport");
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

