/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import gls.outils.GLS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaRoutierTronconExport {
    private IBusinessService service;
    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> schemaRoutierTronconHisto = null;
    private String delegation;
    private String centre;
    private Date dateDebut;
    private Date dateFin;
    private HashMap<String, String> mapNomsCircuits;
    private Map<String, Object> parameters;
    private Font titleFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
    private Font headerFont = new Font(Font.FontFamily.HELVETICA, 10.0f, 0);
    private Font headerFontBold = new Font(Font.FontFamily.HELVETICA, 10.0f, 1);
    private Font commentFontNormal = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private Font commentFontBold = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private static float marginTop = 25.0f;
    private static float marginBottom = 25.0f;
    private static float marginLeft = 0.0f;
    private static float marginRight = 0.0f;

    public SchemaRoutierTronconExport(IBusinessService service) {
        this.service = service;
    }

    public InputStream export(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> listTroncon, String format, Map<String, Object> parameters, String delegation, String centre) {
        this.schemaRoutierTronconHisto = listTroncon;
        this.delegation = delegation;
        this.centre = centre;
        this.dateDebut = this.dateDebut;
        this.dateFin = this.dateFin;
        this.mapNomsCircuits = this.mapNomsCircuits;
        this.parameters = parameters;
        if (IExportService.FORMATS.estPDF((String)format)) {
            return this.exportPDF();
        }
        if (IExportService.FORMATS.estCSV((String)format)) {
            return this.exportCSV();
        }
        return null;
    }

    public InputStream export(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> listTroncon, Map<String, Object> parameters) {
        this.schemaRoutierTronconHisto = listTroncon;
        this.parameters = parameters;
        return this.exportPDF(listTroncon);
    }

    public List<String> getExportFormat() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String format : IExportService.FORMATS.getListe((int)4)) {
            formats.add(format);
        }
        return formats;
    }

    public String getFileName(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> listTroncon, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfFile = new SimpleDateFormat("yyyyMMdd");
        StringBuffer sbDate = new StringBuffer("HistoriqueBarreauVH");
        sbDate.append("_");
        sbDate.append(sdfFile.format(this.dateDebut.toString()));
        sbDate.append(".");
        sbDate.append(IExportService.FORMATS.getExtension((String)format));
        return sbDate.toString();
    }

    public InputStream exportCSV() {
        Boolean afficheEmetteur = true;
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbCriteresTitre = new StringBuffer();
        StringBuffer sbCriteresValue = new StringBuffer();
        sbContenu.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("global.delegation"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(this.delegation);
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("global.centre"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(this.centre);
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        if (this.dateDebut != null) {
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append(ReportI18n.getString("vh.historiqueCCH.datefiled.name.debut"));
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(sdf.format(this.dateDebut));
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append("\n");
        }
        if (this.dateFin != null) {
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append(ReportI18n.getString("vh.historiqueCCH.datefiled.name.fin"));
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(sdf.format(this.dateFin));
            sbCriteresTitre.append("\"");
            sbCriteresTitre.append("\n");
        }
        sbContenu.append(sbCriteresTitre);
        sbContenu.append("\n");
        sbContenu.append("\n");
        StringBuffer sbColumnsName = new StringBuffer();
        List tableColumns = (List)this.parameters.get("listeColumns");
        for (String tableColumn : tableColumns) {
            if (sbColumnsName.length() != 0) {
                sbColumnsName.append(";");
            }
            sbColumnsName.append("\"");
            sbColumnsName.append(this.parameters.get(tableColumn));
            sbColumnsName.append("\"");
        }
        sbContenu.append(sbColumnsName);
        sbContenu.append("\n");
        if (this.schemaRoutierTronconHisto != null) {
            for (SyntheseTableauBordStatistiqueSchemaRoutierBean schemaRoutierTroncon : this.schemaRoutierTronconHisto) {
                Iterator iterator = tableColumns.iterator();
                block14: while (iterator.hasNext()) {
                    String tableColumn;
                    switch (tableColumn = (String)iterator.next()) {
                        case "publie": {
                            this.rajoutChampsCSV(sbContenu, "", false);
                            continue block14;
                        }
                        case "circuit": {
                            this.rajoutChampsCSV(sbContenu, !GLS.estVide((String)schemaRoutierTroncon.getNomCircuit()) && this.mapNomsCircuits != null ? (GLS.estVide((String)this.mapNomsCircuits.get(schemaRoutierTroncon.getNomCircuit())) ? "" : this.mapNomsCircuits.get(schemaRoutierTroncon.getNomCircuit())) : "", false);
                            continue block14;
                        }
                        case "tronconId": {
                            this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getIdTroncon(), false);
                            continue block14;
                        }
                        case "libelle": {
                            this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getNomTroncon(), false);
                            continue block14;
                        }
                    }
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getCentre(), false);
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getDelegation(), false);
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getIdTroncon(), false);
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getNomTroncon(), false);
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getPrDebut(), false);
                    this.rajoutChampsCSV(sbContenu, schemaRoutierTroncon.getPrFin(), false);
                    Timestamp[] datesPassage = (Timestamp[])schemaRoutierTroncon.getParametres((Object)"dates_passage");
                    if (datesPassage == null) continue;
                    this.rajoutChampsCSV(sbContenu, Arrays.stream(datesPassage).map(d -> new SimpleDateFormat("dd-MM-yyyy").format((Date)d)).collect(Collectors.joining(",")), false);
                }
                sbContenu.append("\n");
            }
        }
        return new ByteArrayInputStream(sbContenu.toString().getBytes(Charset.forName("windows-1252")));
    }

    private void rajoutChampsCSV(StringBuffer sbContenu, String valeur, boolean dernierChamps) {
        sbContenu.append("\"");
        sbContenu.append(valeur);
        sbContenu.append("\"");
        if (!dernierChamps) {
            sbContenu.append(";");
        }
    }

    public InputStream exportPDF() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public InputStream exportPDF(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> barreaux) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContentHistorique(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void addMetaData(Document document) {
        document.addTitle("");
        document.addSubject("");
        document.addKeywords("");
        document.addAuthor("");
        document.addCreator("");
    }

    private void redimensionner(Image img, int largeur, int hauteur) {
        float width = img.getWidth();
        float height = img.getHeight();
        float newWidth = largeur;
        float newHeight = hauteur;
        if (width > height) {
            newHeight = height * newWidth / width;
            img.scaleAbsolute(newWidth, newHeight);
        } else {
            newWidth = width * newHeight / height;
            img.scaleAbsolute(newWidth, newHeight);
        }
    }

    private void addContent(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(ConfigurationFactory.getInstance().get("design.path") + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        texte = ReportI18n.getString("report.historique_BarreauVH.title");
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(texte, this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        PdfPTable table = null;
        float[] colsWidth = new float[]{1.0f, 1.0f};
        table = new PdfPTable(colsWidth);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        PdfPCell cell = new PdfPCell(new Phrase(ReportI18n.getString("global.critere"), this.headerFontBold));
        table.addCell(cell);
        table.addCell(new Phrase(ReportI18n.getString("global.valeur"), this.headerFontBold));
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.delegation"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.delegation);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.centre"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.centre);
        if (this.dateDebut != null) {
            cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.debut"), this.headerFont));
            table.addCell(cell);
            table.addCell(new Phrase(sdf.format(this.dateDebut), this.headerFont));
        }
        if (this.dateFin != null) {
            cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.fin"), this.headerFont));
            table.addCell(cell);
            table.addCell(new Phrase(sdf.format(this.dateFin), this.headerFont));
        }
        Paragraph paragrapheTable = new Paragraph();
        paragrapheTable.add((Element)table);
        this.addEmptyLine(entete, 1);
        entete.add((Element)paragrapheTable);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void addContentHistorique(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(ConfigurationFactory.getInstance().get("design.path") + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy ? HH:mm");
        String dateGeneration = this.parameters.get("dateHistorique") != null ? sdf.format(this.parameters.get("dateHistorique")) : sdf.format(GregorianCalendar.getInstance().getTime());
        texte = "";
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(texte + "\n ", this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void createTable(Paragraph contenu) throws BadElementException {
        Paragraph paragrapheTable = new Paragraph();
        PdfPTable table = null;
        List tableColumns = (List)this.parameters.get("listeColumns");
        float[] colsWidthTotal = new float[tableColumns.size()];
        int colNumber = 0;
        ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>();
        block33: for (String tableColumn : tableColumns) {
            PdfPCell cell = null;
            switch (tableColumn) {
                case "circuit": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    continue block33;
                }
                case "idGroupe": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    continue block33;
                }
                case "tronconId": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    continue block33;
                }
                case "libelle": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.0f;
                    continue block33;
                }
                case "majDate": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.7f;
                    continue block33;
                }
            }
            colsWidthTotal[colNumber++] = 1.0f;
        }
        float[] colsWidth = new float[colNumber];
        for (int i = 0; i < colNumber; ++i) {
            colsWidth[i] = colsWidthTotal[i];
        }
        table = new PdfPTable(colsWidth);
        table.setWidthPercentage(100.0f);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        for (PdfPCell cell : cells) {
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
        }
        table.setHeaderRows(1);
        if (this.schemaRoutierTronconHisto != null) {
            for (SyntheseTableauBordStatistiqueSchemaRoutierBean fauchageTroncoHisto : this.schemaRoutierTronconHisto) {
                Iterator iterator = tableColumns.iterator();
                while (iterator.hasNext()) {
                    String tableColumn;
                    switch (tableColumn = (String)iterator.next()) {
                        case "circuit": {
                            break;
                        }
                        case "idGroupe": {
                            break;
                        }
                        case "tronconId": {
                            break;
                        }
                        case "libelle": {
                            break;
                        }
                        case "majDate": {
                            break;
                        }
                        case "source": {
                            break;
                        }
                        case "axe": {
                            break;
                        }
                    }
                }
            }
        }
        paragrapheTable.add((Element)table);
        contenu.add((Element)paragrapheTable);
    }

    private void addCellCenter(PdfPTable table, Phrase phrase) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
    }

    private void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    public String getDelegation() {
        return this.delegation;
    }

    public void setDelegation(String delegation) {
        this.delegation = delegation;
    }

    public String getCentre() {
        return this.centre;
    }

    public void setCentre(String centre) {
        this.centre = centre;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    static class HeaderFooter
    extends PdfPageEventHelper {
        HeaderFooter() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
        }
    }
}

