/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.RapportEvenementBean;
import com.geolocsystems.prismbirtbean.SyntheseEvenementBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.util.Base64;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class RapportConstatExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    Integer[] idsEvenements;
    List<Integer> listIdEvenements;
    String idUtilisateur;
    private Map<String, Object> parametres;
    String fileDestination = "";
    BirtEngine birtEngine = null;
    List<SyntheseEvenementBean> syntheseEvenementBeanList;
    IBusinessService service = null;
    private String document = null;

    public RapportConstatExport(IBusinessService service) {
        this.service = service;
    }

    public InputStream export(List<RapportEvenementBean> rapportEvenementBeans, Map<String, Object> parametres, String document, String format) {
        Log.debug("export avec document : " + document);
        this.format = format;
        this.document = document;
        this.parametres = parametres;
        return this.runReportV2(rapportEvenementBeans);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    public InputStream runReportV2(List<RapportEvenementBean> rapportEvenementBeans) {
        Log.debug("runReport V2");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            if (design == null) {
                if (this.document != null) {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("design.path") + this.document);
                    Log.debug(ConfigurationFactory.getInstance().get("design.path") + this.document);
                } else {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.fiches.travail.v2.design"));
                    Log.debug(ConfigurationFactory.getInstance().get("stats.fiches.travail.v2.design"));
                }
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap valeurs = new HashMap();
            task.getAppContext().put("RapportEvenementBeans", rapportEvenementBeans);
            task.getAppContext().put("synthesePatrouilleAdresse", ConfigurationFactory.getInstance().get("synthese.patrouille.adresse"));
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else if (IExportService.FORMATS.estXLSX((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLSX");
            } else if (IExportService.FORMATS.estXLS((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLS");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            Log.debug("renderOption : " + renderOption);
            Log.debug("renderOption EmitterId : " + renderOption.getEmitterID());
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    private String imgToString(File img) throws Exception {
        Log.debug("imgToString : " + img.getName());
        FileInputStream fis = null;
        fis = new FileInputStream(img);
        Log.debug("imgToString : new FileInputStream OK");
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        Log.debug("imgToString : new ByteArrayOutputStream OK");
        int c = -1;
        while ((c = fis.read()) != -1) {
            bais.write(c);
        }
        Log.debug("imgToString : ByteArrayOutputStream write OK");
        fis.close();
        Log.debug("imgToString : fis.close OK");
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }
}

