/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.CommentaireMCIG;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.utils.transfert.ImageAppareilPhoto;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class McigExport {
    private static int MAX_LARGEUR_CARTE = 600;
    private static int MAX_HAUTEUR_CARTE = 600;
    private MCIG mcig = null;
    private Font titleFont = new Font(Font.FontFamily.HELVETICA, 18.0f, 1);
    private Font headerFont = new Font(Font.FontFamily.HELVETICA, 14.0f, 1);
    private Font commentFontNormal = new Font(Font.FontFamily.HELVETICA, 12.0f, 0);
    private Font commentFontBold = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
    private Font commentFontBoldBarre = new Font(Font.FontFamily.HELVETICA, 12.0f, 9);
    private Font commentFontBoldUnderline = new Font(Font.FontFamily.HELVETICA, 12.0f, 5);
    private static float marginTop = 25.0f;
    private static float marginBottom = 25.0f;
    private static float marginLeft = 10.0f;
    private static float marginRight = 10.0f;

    public InputStream export(List<MCIG> listMcig, String format) {
        this.mcig = listMcig.get(0);
        if (IExportService.FORMATS.estPDF((String)format)) {
            return this.exportPDF();
        }
        if (IExportService.FORMATS.estCSV((String)format)) {
            return this.exportCSV();
        }
        return null;
    }

    public List<String> getExportFormat() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String format : IExportService.FORMATS.getListe((int)2)) {
            formats.add(format);
        }
        return formats;
    }

    public String getFileName(List<MCIG> listMcig, String format) {
        this.mcig = listMcig.get(0);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfFile = new SimpleDateFormat("yyyyMMdd");
        try {
            StringBuffer sbDate = new StringBuffer("MainCourante");
            sbDate.append("_");
            sbDate.append(sdfFile.format(sdf.parse(this.mcig.getDateHeureDeb())));
            if (this.mcig.getSna() != null) {
                sbDate.append("_");
                sbDate.append(this.mcig.getSna());
            }
            sbDate.append(".");
            sbDate.append(IExportService.FORMATS.getExtension((String)format));
            return sbDate.toString();
        }
        catch (ParseException e) {
            return "MainCourante00000000" + format;
        }
    }

    public InputStream exportCSV() {
        Boolean afficheEmetteur = true;
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbCriteresTitre = new StringBuffer();
        StringBuffer sbCriteresValue = new StringBuffer();
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("mcig.mainCouranteDu"));
        sbCriteresTitre.append("\"");
        sbCriteresValue.append("\"");
        sbCriteresValue.append(((CommentaireMCIG)this.mcig.getCommentaireMcig().get(0)).getDateCom());
        sbCriteresValue.append("\"");
        if (this.mcig.getSna() != null) {
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(ReportI18n.getString("mcig.utilisateur"));
            sbCriteresTitre.append("\"");
            sbCriteresValue.append(";\"");
            sbCriteresValue.append(this.mcig.getNom());
            sbCriteresValue.append("\"");
            afficheEmetteur = false;
        }
        if (this.mcig.getEquipier() != null) {
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(ReportI18n.getString("mcig.equipier"));
            sbCriteresTitre.append("\"");
            sbCriteresValue.append(";\"");
            sbCriteresValue.append(this.mcig.getEquipier());
            sbCriteresValue.append("\"");
            afficheEmetteur = false;
        }
        if (this.mcig.getDelegation() != null) {
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(this.mcig.getLibelleDelegation());
            sbCriteresTitre.append("\"");
            sbCriteresValue.append(";\"");
            sbCriteresValue.append(this.mcig.getDelegation());
            sbCriteresValue.append("\"");
        }
        if (this.mcig.getCentre() != null) {
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(this.mcig.getLibelleCentre());
            sbCriteresTitre.append("\"");
            sbCriteresValue.append(";\"");
            sbCriteresValue.append(this.mcig.getCentre());
            sbCriteresValue.append("\"");
        }
        if (this.mcig.getProfil() != null) {
            sbCriteresTitre.append(";\"");
            sbCriteresTitre.append(ReportI18n.getString("mcig.profil"));
            sbCriteresTitre.append("\"");
            sbCriteresValue.append(";\"");
            sbCriteresValue.append(this.mcig.getProfil());
            sbCriteresValue.append("\"");
        }
        sbContenu.append(sbCriteresTitre);
        sbContenu.append("\n");
        sbContenu.append(sbCriteresValue);
        sbContenu.append("\n");
        sbContenu.append("\n");
        if (afficheEmetteur.booleanValue()) {
            sbContenu.append("\"" + ReportI18n.getString("mcig.date") + "\";\"" + ReportI18n.getString("mcig.heure") + "\";\"" + ReportI18n.getString("mcig.auteur") + "\";\"" + ReportI18n.getString("mcig.commentaire") + "\"");
        } else {
            sbContenu.append("\"" + ReportI18n.getString("mcig.date") + "\";\"" + ReportI18n.getString("mcig.heure") + "\";\"" + ReportI18n.getString("mcig.commentaire") + "\"");
        }
        for (CommentaireMCIG commentaire : this.mcig.getCommentaireMcig()) {
            sbContenu.append("\n");
            sbContenu.append("\"");
            try {
                sbContenu.append(GLSDate.formatDateJour.format(GLSDate.formatDateComplete.parse(commentaire.getDateHeureCom())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            sbContenu.append("\"");
            sbContenu.append(";");
            sbContenu.append("\"");
            try {
                sbContenu.append(GLSDate.formatHeure.format(GLSDate.formatDateComplete.parse(commentaire.getDateHeureCom())));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            sbContenu.append("\"");
            if (afficheEmetteur.booleanValue()) {
                sbContenu.append(";");
                sbContenu.append("\"");
                sbContenu.append(commentaire.getNom());
                sbContenu.append("\"");
            }
            sbContenu.append(";");
            sbContenu.append("\"");
            if (commentaire.getPhrComMcig() != null) {
                sbContenu.append(commentaire.getPhrComMcig().replace("\"", "\"\""));
            } else {
                sbContenu.append(commentaire.getPhrComMcig());
            }
            sbContenu.append("\"");
        }
        return new ByteArrayInputStream(sbContenu.toString().getBytes(Charset.forName("windows-1252")));
    }

    public InputStream exportPDF() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Document document = new Document(PageSize.A4.rotate(), marginLeft, marginRight, marginTop, marginBottom);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void addMetaData(Document document) {
        document.addTitle("");
        document.addSubject("");
        document.addKeywords("");
        document.addAuthor("");
        document.addCreator("");
    }

    private void addContent(Document document) throws DocumentException {
        float[] colsWidth;
        Paragraph contenu = new Paragraph();
        Paragraph entete = new Paragraph();
        this.addEmptyLine(entete, 1);
        String texte = "";
        texte = this.mcig.getIdEvenement() != null ? ReportI18n.getString("mcig.mainCourante") : ReportI18n.getString("mcig.mainCouranteDu") + " " + ((CommentaireMCIG)this.mcig.getCommentaireMcig().get(0)).getDateCom();
        Paragraph paragrapheTitre = new Paragraph(texte, this.titleFont);
        paragrapheTitre.setAlignment(1);
        entete.add((Element)paragrapheTitre);
        PdfPTable table = null;
        if (this.mcig.getSna() != null) {
            colsWidth = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            table = new PdfPTable(colsWidth);
            PdfPCell cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.utilisateur"), this.headerFont));
            table.addCell(cell);
        } else {
            colsWidth = new float[]{1.0f, 1.0f, 1.0f};
            table = new PdfPTable(colsWidth);
        }
        PdfPCell cell = new PdfPCell(new Phrase(this.mcig.getLibelleDelegation(), this.headerFont));
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(this.mcig.getLibelleCentre(), this.headerFont));
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.profil"), this.headerFont));
        table.addCell(cell);
        if (this.mcig.getSna() != null) {
            String s = this.mcig.getNom();
            if (!GLS.estVide((String)this.mcig.getEquipier())) {
                s = s + " - " + ReportI18n.getString("mcig.equipier") + " : " + this.mcig.getEquipier();
            }
            table.addCell(s);
        }
        table.addCell(this.mcig.getDelegation());
        table.addCell(this.mcig.getCentre());
        table.addCell(this.mcig.getProfil());
        Paragraph paragrapheTable = new Paragraph();
        paragrapheTable.add((Element)table);
        this.addEmptyLine(entete, 1);
        entete.add((Element)paragrapheTable);
        this.addEmptyLine(contenu, 2);
        document.add((Element)entete);
        document.add((Element)Chunk.NEXTPAGE);
        Paragraph paragrapheCarto = new Paragraph();
        this.addEmptyLine(paragrapheCarto, 1);
        this.addCarto(document);
        contenu = new Paragraph();
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void addCarto(Document document) {
        if (this.mcig.getImage() != null) {
            com.itextpdf.text.Image img = null;
            try {
                img = com.itextpdf.text.Image.getInstance((byte[])McigExport.getImagesBytes(this.mcig.getImage()));
                this.redimensionner(img, MAX_LARGEUR_CARTE, MAX_HAUTEUR_CARTE);
                img.setAbsolutePosition(marginLeft + 130.0f, document.top() - (float)MAX_HAUTEUR_CARTE + 100.0f);
                document.add((Element)img);
            }
            catch (Exception e) {
                Log.error("", e);
            }
            try {
                document.add((Element)Chunk.NEXTPAGE);
            }
            catch (Exception e) {
                Log.error("", e);
            }
        }
    }

    private void redimensionner(com.itextpdf.text.Image img, int largeur, int hauteur) {
        float width = img.getWidth();
        float height = img.getHeight();
        float newWidth = largeur;
        float newHeight = hauteur;
        if (width > height) {
            newHeight = height * newWidth / width;
            img.scaleAbsolute(newWidth, newHeight);
        } else {
            newWidth = width * newHeight / height;
            img.scaleAbsolute(newWidth, newHeight);
        }
    }

    public static byte[] getImagesBytes(Image img) {
        byte[] result = null;
        BufferedImage buf = ImageAppareilPhoto.toBufferedImage((Image)img, (int)6, (boolean)false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        try {
            ImageIO.write((RenderedImage)buf, "png", baos);
            baos.flush();
            result = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void createTable(Paragraph contenu) throws BadElementException {
        float[] colsWidth;
        Paragraph paragrapheTable = new Paragraph();
        PdfPTable table = null;
        if (this.mcig.getSna() == null || this.mcig.getIdEvenement() != null) {
            colsWidth = new float[]{2.0f, 1.0f, 2.0f, 9.0f};
            table = new PdfPTable(colsWidth);
        } else {
            colsWidth = new float[]{2.0f, 1.0f, 11.0f};
            table = new PdfPTable(colsWidth);
        }
        PdfPCell cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.date"), this.headerFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.heure"), this.headerFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        if (this.mcig.getSna() == null || this.mcig.getIdEvenement() != null) {
            cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.auteur"), this.headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
        }
        cell = new PdfPCell(new Phrase(ReportI18n.getString("mcig.commentaire"), this.headerFont));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
        table.setHeaderRows(1);
        for (CommentaireMCIG commentaire : this.mcig.getCommentaireMcig()) {
            String date = "";
            String heure = "";
            try {
                date = GLSDate.formatDateJour.format(GLSDate.formatDateComplete.parse(commentaire.getDateHeureCom()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                heure = GLSDate.formatHeure.format(GLSDate.formatDateComplete.parse(commentaire.getDateHeureCom()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            table.addCell(new Phrase(date, this.commentFontNormal));
            table.addCell(new Phrase(heure, this.commentFontNormal));
            if (this.mcig.getSna() == null || this.mcig.getIdEvenement() != null) {
                table.addCell(new Phrase(commentaire.getNom(), this.commentFontNormal));
            }
            String[] commentSplit = commentaire.getPhrComMcig().split("\u00a7");
            Phrase p = new Phrase();
            for (String phrcommentaireMCIG : commentSplit) {
                Chunk chunk;
                int index = phrcommentaireMCIG.indexOf("(+)");
                if (index != -1) {
                    phrcommentaireMCIG = phrcommentaireMCIG.replace("(+)", "");
                    chunk = new Chunk(phrcommentaireMCIG + "\n", this.commentFontBold);
                } else {
                    index = phrcommentaireMCIG.indexOf("(-)");
                    if (index != -1) {
                        phrcommentaireMCIG = phrcommentaireMCIG.replace("(-)", "");
                        chunk = new Chunk(phrcommentaireMCIG + "\n", this.commentFontBoldBarre);
                    } else {
                        index = phrcommentaireMCIG.indexOf("(*)");
                        if (index != -1) {
                            phrcommentaireMCIG = phrcommentaireMCIG.replace("(*)", "");
                            chunk = new Chunk(phrcommentaireMCIG + "\n", this.commentFontBold);
                            chunk.setUnderline(1.5f, -1.0f);
                        } else {
                            chunk = new Chunk(phrcommentaireMCIG + "\n", this.commentFontNormal);
                        }
                    }
                }
                p.add((Element)chunk);
            }
            PdfPCell cellComment = new PdfPCell(p);
            table.addCell(cellComment);
        }
        paragrapheTable.add((Element)table);
        contenu.add((Element)paragrapheTable);
    }

    private void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    static class HeaderFooter
    extends PdfPageEventHelper {
        HeaderFooter() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (document.getPageNumber() == 1) {
                ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)new Phrase(ReportI18n.getString("mcig.piedDePage")), (float)((document.left() + document.right()) / 2.0f), (float)(document.bottom() - marginBottom / 2.0f), (float)0.0f);
            }
            try {
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((String)(ConfigurationFactory.getInstance().get("design.path") + "images/logo.jpg"));
                float width = image.getWidth();
                float height = image.getHeight();
                float newWidth = 100.0f;
                float newHeight = 100.0f;
                if (width > height) {
                    newHeight = height * 100.0f / width;
                    image.scaleAbsolute(100.0f, newHeight);
                } else {
                    newWidth = width * 100.0f / height;
                    image.scaleAbsolute(newWidth, 100.0f);
                }
                image.setAbsolutePosition(0.0f, document.top() - newHeight + marginTop);
                document.add((Element)image);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }
}

