/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismbirtbean.SyntheseDescriptionEvenement;
import com.geolocsystems.prismbirtbean.SyntheseEvenementBean;
import com.geolocsystems.prismbirtbean.SyntheseEvenementHistoriseBean;
import com.geolocsystems.prismbirtbean.SyntheseHistoriqueEvenement;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentral.export.exception.MemoryException;
import com.geolocsystems.prismcentral.export.libreoffice.ReportComposantFactory;
import com.geolocsystems.prismcentraldata.util.ImageEvenement;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.net.util.Base64;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class FicheTravailExport {
    private static int MINIMUM_FREE_MEMORY = 50;
    private static final double DELTA_EVENEMENT_IMAGE = 0.025;
    private static final int EVENEMENT_IMAGE_WIDTH = 750;
    private static final int EVENEMENT_IMAGE_HEIGHT = 750;
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    Integer[] idsEvenements;
    List<Integer> listIdEvenements;
    String idUtilisateur;
    private Map<String, Object> parametres;
    String fileDestination = "";
    BirtEngine birtEngine = null;
    List<SyntheseEvenementBean> syntheseEvenementBeanList;
    List<SyntheseEvenementHistoriseBean> syntheseEvenementHistoriseBeanList;
    IBusinessService service = null;
    private String document = null;

    public FicheTravailExport(IBusinessService service) {
        this.service = service;
        MINIMUM_FREE_MEMORY = service.getConfiguration().getInt("minimumFreeMemory", 50);
    }

    public InputStream export(List<Integer> idsEvenements, Map<String, Object> parametres, String format) {
        Log.debug("export sans document");
        this.format = format;
        this.listIdEvenements = idsEvenements;
        this.idsEvenements = new Integer[idsEvenements.size()];
        for (int index = 0; index < idsEvenements.size(); ++index) {
            this.idsEvenements[index] = idsEvenements.get(index);
            Log.debug("idEvenement : " + idsEvenements.get(index));
        }
        this.parametres = parametres;
        return this.exporter();
    }

    public InputStream export(List<Integer> idsEvenements, Map<String, Object> parametres, String document, String format) {
        Log.debug("export avec document : " + document);
        this.format = format;
        this.listIdEvenements = idsEvenements;
        this.idsEvenements = new Integer[idsEvenements.size()];
        for (int index = 0; index < idsEvenements.size(); ++index) {
            this.idsEvenements[index] = idsEvenements.get(index);
            Log.debug("idEvenement : " + idsEvenements.get(index));
        }
        this.document = document;
        this.parametres = parametres;
        return this.exporter();
    }

    public InputStream exporter() {
        this.parametres.put("NbPhotosParLigne", this.service.getConfiguration().getInt("NbPhotosParLigne", 3));
        if (ConfigurationFactory.getInstance().getInt("fiche.travail.use.bean") == 1) {
            return this.runReportV2();
        }
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            if (design == null) {
                if (this.document != null) {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("design.path") + this.document);
                    System.out.println(ConfigurationFactory.getInstance().get("design.path") + this.document);
                } else {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.fiches.travail.design"));
                    System.out.println(ConfigurationFactory.getInstance().get("stats.fiches.travail.design"));
                }
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            valeurs.put("idEvenements", this.idsEvenements);
            valeurs.put("JDBCUrl", ConfigurationFactory.getInstance().get("jdbc.url"));
            valeurs.put("JDBCUser", ConfigurationFactory.getInstance().get("jdbc.username"));
            valeurs.put("JDBCPassword", ConfigurationFactory.getInstance().get("jdbc.password"));
            for (Map.Entry<String, Object> parametre : this.parametres.entrySet()) {
                if (parametre.getKey().equals("photosBirt")) {
                    valeurs.put(parametre.getKey(), parametre.getValue());
                    task.getAppContext().put("photosBirt", parametre.getValue());
                    continue;
                }
                valeurs.put(parametre.getKey(), parametre.getValue());
            }
            task.setParameterValues(valeurs);
            if ("PDF".equals(this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if ("ODT".equals(this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf";
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    public InputStream runReportV2() {
        Log.debug("runReport V2");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            if (design == null) {
                if (this.document != null) {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("design.path") + this.document);
                    System.out.println(ConfigurationFactory.getInstance().get("design.path") + this.document);
                } else {
                    design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.fiches.travail.v2.design"));
                    System.out.println(ConfigurationFactory.getInstance().get("stats.fiches.travail.v2.design"));
                }
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            Integer idEvenement = this.listIdEvenements.get(0);
            valeurs.put("idEvenement", idEvenement);
            valeurs.put("JDBCUrl", ConfigurationFactory.getInstance().get("jdbc.url"));
            valeurs.put("JDBCUser", ConfigurationFactory.getInstance().get("jdbc.username"));
            valeurs.put("JDBCPassword", ConfigurationFactory.getInstance().get("jdbc.password"));
            if (this.parametres.get("Historisee") != null && ((Boolean)this.parametres.get("Historisee")).booleanValue()) {
                Log.debug("Historis\u00e9e");
                this.syntheseEvenementHistoriseBeanList = this.getSyntheseEvenementHistoriseBeanList(this.listIdEvenements);
                this.syntheseEvenementBeanList = new ArrayList<SyntheseEvenementBean>();
                for (SyntheseEvenementHistoriseBean bean : this.syntheseEvenementHistoriseBeanList) {
                    this.syntheseEvenementBeanList.addAll(bean.getHistorique());
                }
                task.getAppContext().put("syntheseEvenementBean", this.syntheseEvenementBeanList);
            } else {
                this.syntheseEvenementBeanList = this.getSyntheseEvenementBeanList(this.listIdEvenements);
                task.getAppContext().put("syntheseEvenementBean", this.syntheseEvenementBeanList);
            }
            task.getAppContext().put("synthesePatrouilleAdresse", ConfigurationFactory.getInstance().get("synthese.patrouille.adresse"));
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            if (valeurs.get("imageWMS") != null) {
                task.getAppContext().put("imageWMS", valeurs.get("imageWMS"));
            }
            task.getAppContext().put("NbPhotosParLigne", this.parametres.get("NbPhotosParLigne"));
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf";
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    private List<SyntheseEvenementBean> getSyntheseEvenementBeanList(List<Integer> listIdEvenements) throws MemoryException {
        ArrayList<SyntheseEvenementBean> syntheseEvenementBeanList = new ArrayList<SyntheseEvenementBean>();
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byIds(listIdEvenements);
        List situations = this.service.getEvenements(filtre, null);
        Map natures = this.service.getNatures();
        ReportComposantFactory factory = new ReportComposantFactory();
        File basedir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
        boolean indatabase = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy - HH:mm");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        SimpleDateFormat sdfHeure2 = new SimpleDateFormat("HH:mm:ss");
        int numEvt = 1;
        boolean taillePhotos = false;
        boolean nbPhotos = false;
        for (Situation s : situations) {
            for (Evenement evt : s.getEvenements()) {
                String sTemp;
                boolean ajoutePhoto;
                Nature n;
                SyntheseEvenementBean syntheseEvenementBean;
                block30: {
                    syntheseEvenementBean = new SyntheseEvenementBean();
                    n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evt.getValeurNature().getCode())));
                    n.chargerValeurs(evt.getValeurNature());
                    syntheseEvenementBean.setTypeEvenement(n.getLabel());
                    syntheseEvenementBean.setIdEvenement(evt.getCodeEvenement());
                    syntheseEvenementBean.setCentre(evt.getCei());
                    syntheseEvenementBean.setDelegation(evt.getDistrict());
                    syntheseEvenementBean.setLocalisation(this.getLocalisationTextuelle(evt));
                    String altitude = Math.round(evt.getLocalisation().getPositionDebut().getAltitude()) + " m";
                    syntheseEvenementBean.setAltitude(altitude);
                    syntheseEvenementBean.setCommune(evt.getLocalisation().getCommune());
                    syntheseEvenementBean.setDateCreation(dateFormat.format(new Date(evt.getDateCreation())));
                    syntheseEvenementBean.setDateDerniereModification(dateFormat.format(new Date(evt.getDateMaj())));
                    syntheseEvenementBean.setDateCrea(sdfDate.format(new Date(evt.getDateCreation())));
                    syntheseEvenementBean.setHeureCrea(sdfHeure2.format(new Date(evt.getDateCreation())));
                    syntheseEvenementBean.setSta(evt.getDateCreation());
                    syntheseEvenementBean.setLongitude(evt.getLocalisation().getPositionDebut().getY());
                    syntheseEvenementBean.setLatitude(evt.getLocalisation().getPositionDebut().getX());
                    ajoutePhoto = true;
                    try {
                        double deltaImage;
                        String champs = (String)this.parametres.get("champs");
                        Log.debug("Champ Image ?");
                        if (champs == null || !champs.contains("image")) break block30;
                        Log.debug("Champ Image OK");
                        ImageEvenement imageEvement = new ImageEvenement();
                        try {
                            deltaImage = Double.parseDouble(ConfigurationFactory.getInstance().get("image.delta.evt." + evt.getValeurNature().getCode()));
                        }
                        catch (Exception eMissingKey) {
                            deltaImage = 0.025;
                        }
                        int imageWidth = this.service.getConfiguration().getInt("evenementImageWidth", 750);
                        int imageHeight = this.service.getConfiguration().getInt("evenementImageHeight", 750);
                        BufferedImage imageimageEvementStream = (BufferedImage)imageEvement.getImage(evt, deltaImage, imageWidth, imageHeight);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)imageimageEvementStream, "png", bos);
                        byte[] dataImageEvenement = bos.toByteArray();
                        String imageLocalisationBase64 = Base64.encodeBase64URLSafeString((byte[])dataImageEvenement);
                        syntheseEvenementBean.setImageLocalisation(imageLocalisationBase64);
                    }
                    catch (Exception e3) {
                        Log.error("Erreur lors de la g\u00e9n\u00e9ration de l'image de l'\u00e9v\u00e9nement");
                    }
                }
                ValeurChamp vc = null;
                try {
                    vc = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"commentaire");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (vc != null && (sTemp = ((ValeurChampTexte)vc).getValeur()) != null) {
                    sTemp = sTemp.replaceAll("\r", "");
                    sTemp = sTemp.replaceAll("\n", "<BR>");
                    syntheseEvenementBean.setCommentaire(sTemp);
                }
                Log.debug("Recup photo");
                File dir = new File(basedir, evt.getIdSituation() + File.separator + evt.getIdReference());
                ArrayList<String> photos = new ArrayList<String>();
                for (String filename : evt.getPhotos()) {
                    if (indatabase) {
                        byte[] data = this.service.getPhoto(filename);
                        if (data != null) {
                            photos.add(DatatypeConverter.printBase64Binary((byte[])data));
                        }
                    } else {
                        File file = new File(dir, filename);
                        if (file.exists()) {
                            try {
                                photos.add(this.imgToString(file));
                            }
                            catch (Exception e) {
                                Log.error("erreur \u00e0 la conversion de l'image");
                                Log.error(e.toString(), e);
                            }
                        } else {
                            Log.error("image introuvable dans le r\u00e9pertoire : " + dir + filename);
                        }
                    }
                    if (Runtime.getRuntime().freeMemory() >= (long)(MINIMUM_FREE_MEMORY * 1000 * 1000)) continue;
                    ajoutePhoto = false;
                    break;
                }
                if (ajoutePhoto) {
                    syntheseEvenementBean.setPhotos(photos);
                }
                Map champsMap = MetierCommun.getChamps((List)n.getChamps());
                List champs = MetierCommun.getChampsFiltresTest((List)n.getChamps(), (Map)champsMap);
                ArrayList<SyntheseDescriptionEvenement> listeDescriptionEvenement = new ArrayList<SyntheseDescriptionEvenement>();
                for (Champ c : champs) {
                    SyntheseDescriptionEvenement descriptionEvenement;
                    String value = (String)c.getView((IComposantFactory)factory);
                    if (GLS.estVide((String)value)) continue;
                    if (GLS.estVide((String)c.getLibelle())) {
                        descriptionEvenement = new SyntheseDescriptionEvenement();
                        descriptionEvenement.setCle("");
                        descriptionEvenement.setValeur(value == null ? "" : value);
                        listeDescriptionEvenement.add(descriptionEvenement);
                        continue;
                    }
                    if (c.getLibelle().equals("Localisation") || c.getNom().equals("commentaire")) continue;
                    descriptionEvenement = new SyntheseDescriptionEvenement();
                    descriptionEvenement.setCle(c.getLibelle());
                    descriptionEvenement.setValeur(value == null ? "" : value);
                    listeDescriptionEvenement.add(descriptionEvenement);
                }
                syntheseEvenementBean.setDescriptions(listeDescriptionEvenement);
                IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.getVersions((Evenement)evt);
                List versions = ((Situation)this.service.getEvenements(f, null).get(0)).getEvenements();
                Collections.sort(versions, new Comparator<Evenement>(){

                    @Override
                    public int compare(Evenement e1, Evenement e2) {
                        return e2.getNumVersion() - e1.getNumVersion();
                    }
                });
                ArrayList<SyntheseHistoriqueEvenement> listeSyntheseHistoriqueEvenement = new ArrayList<SyntheseHistoriqueEvenement>();
                for (Evenement version : versions) {
                    SyntheseHistoriqueEvenement historiqueEvenement = new SyntheseHistoriqueEvenement();
                    historiqueEvenement.setAuteur(this.service.getUtilisateur(version.getCodeUtilisateur()).getNom());
                    long date = version.getDateMaj();
                    historiqueEvenement.setTime(date + "");
                    historiqueEvenement.setDate(sdfDate.format(new Date(date)));
                    historiqueEvenement.setHeure(sdfHeure.format(new Date(date)));
                    if (version.isTermine()) {
                        if (version.isAnnule()) {
                            historiqueEvenement.setEtat(PrismI18n.getString("evenement.etat.annule"));
                        } else {
                            historiqueEvenement.setEtat(PrismI18n.getString("evenement.etat.cloture"));
                        }
                    } else if (version.getNumVersion() == 1) {
                        historiqueEvenement.setEtat(PrismI18n.getString("evenement.etat.creation"));
                    } else if (version.isProgramme()) {
                        historiqueEvenement.setEtat(PrismI18n.getString("evenement.etat.modification") + " / " + PrismI18n.getString("evenement.etat.programme"));
                    } else {
                        historiqueEvenement.setEtat(PrismI18n.getString("evenement.etat.modification"));
                    }
                    listeSyntheseHistoriqueEvenement.add(historiqueEvenement);
                }
                syntheseEvenementBean.setHistoriques(listeSyntheseHistoriqueEvenement);
                syntheseEvenementBeanList.add(syntheseEvenementBean);
            }
        }
        Collections.sort(syntheseEvenementBeanList);
        for (SyntheseEvenementBean synthese : syntheseEvenementBeanList) {
            synthese.setNumEvt("" + numEvt);
            ++numEvt;
        }
        return syntheseEvenementBeanList;
    }

    private List<SyntheseEvenementHistoriseBean> getSyntheseEvenementHistoriseBeanList(List<Integer> listIdEvenements) throws MemoryException {
        ArrayList<SyntheseEvenementHistoriseBean> syntheseEvenementHistoriseBeanList = new ArrayList<SyntheseEvenementHistoriseBean>();
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byIds(listIdEvenements);
        List situations = this.service.getEvenements(filtre, null);
        Map natures = this.service.getNatures();
        ReportComposantFactory factory = new ReportComposantFactory();
        File basedir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
        boolean indatabase = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy - HH:mm");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        HashMap<String, String> photosMemorisees = new HashMap<String, String>();
        for (Situation s : situations) {
            SyntheseEvenementHistoriseBean syntheseEvenementHistoriseBean = new SyntheseEvenementHistoriseBean();
            ArrayList<SyntheseEvenementBean> syntheseEvenementBeanList = new ArrayList<SyntheseEvenementBean>();
            for (Evenement evt : s.getEvenements()) {
                IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.getVersions((Evenement)evt);
                List versions = ((Situation)this.service.getEvenements(f, null).get(0)).getEvenements();
                Collections.sort(versions, new Comparator<Evenement>(){

                    @Override
                    public int compare(Evenement e1, Evenement e2) {
                        return e1.getNumVersion() - e2.getNumVersion();
                    }
                });
                boolean ajoutePhoto = true;
                for (Evenement version : versions) {
                    SyntheseEvenementBean syntheseEvenementBean = new SyntheseEvenementBean();
                    Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(version.getValeurNature().getCode())));
                    n.chargerValeurs(version.getValeurNature());
                    syntheseEvenementBean.setTypeEvenement(n.getLabel());
                    syntheseEvenementBean.setIdEvenement(version.getCodeEvenement());
                    syntheseEvenementBean.setCentre(version.getCei());
                    syntheseEvenementBean.setDelegation(version.getDistrict());
                    syntheseEvenementBean.setLocalisation(this.getLocalisationTextuelle(version));
                    String altitude = Math.round(version.getLocalisation().getPositionDebut().getAltitude()) + " m";
                    syntheseEvenementBean.setAltitude(altitude);
                    syntheseEvenementBean.setCommune(version.getLocalisation().getCommune());
                    syntheseEvenementBean.setDateCreation(dateFormat.format(new Date(version.getDateCreation())));
                    syntheseEvenementBean.setDateDerniereModification(dateFormat.format(new Date(version.getDateMaj())));
                    try {
                        String champs = (String)this.parametres.get("champs");
                        if (champs != null && champs.contains("image")) {
                            ImageEvenement imageEvement = new ImageEvenement();
                            int imageWidth = this.service.getConfiguration().getInt("evenementImageWidth", 750);
                            int imageHeight = this.service.getConfiguration().getInt("evenementImageHeight", 750);
                            BufferedImage imageimageEvementStream = (BufferedImage)imageEvement.getImage(version, 0.025, imageWidth, imageHeight);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ImageIO.write((RenderedImage)imageimageEvementStream, "png", bos);
                            byte[] dataImageEvenement = bos.toByteArray();
                            if (dataImageEvenement != null) {
                                syntheseEvenementBean.setImageLocalisation(DatatypeConverter.printBase64Binary((byte[])dataImageEvenement));
                            }
                        }
                    }
                    catch (Exception e3) {
                        Log.error("Erreur lors de la g\u00e9n\u00e9ration de l'image de l'\u00e9v\u00e9nement");
                        Log.error(e3.getLocalizedMessage());
                    }
                    ValeurChamp vc = null;
                    try {
                        vc = MetierCommun.getValeurChamp((List)version.getValeurNature().getValeurs(), (String)"commentaire");
                    }
                    catch (Exception e) {
                        Log.debug("Champ commentaire nom pr\u00e9sent");
                    }
                    if (vc != null && ((ValeurChampTexte)vc).getValeur() != null) {
                        String sTemp = ((ValeurChampTexte)vc).getValeur();
                        sTemp = sTemp.replaceAll("\r", "");
                        sTemp = sTemp.replaceAll("\n", "<BR>");
                        syntheseEvenementBean.setCommentaire(sTemp);
                    }
                    File dir = new File(basedir, version.getIdSituation() + File.separator + version.getIdReference());
                    ArrayList<String> photos = new ArrayList<String>();
                    for (String filename : version.getPhotos()) {
                        String photo;
                        if (photosMemorisees.get(filename) != null) {
                            photos.add((String)photosMemorisees.get(filename));
                        } else if (indatabase) {
                            byte[] data = this.service.getPhoto(filename);
                            if (data != null) {
                                photo = DatatypeConverter.printBase64Binary((byte[])data);
                                photos.add(photo);
                                photosMemorisees.put(filename, photo);
                            }
                        } else {
                            File file = new File(dir, filename);
                            if (file.exists()) {
                                try {
                                    photo = this.imgToString(file);
                                    photos.add(photo);
                                    photosMemorisees.put(filename, photo);
                                }
                                catch (Exception e) {
                                    Log.error("erreur \u00e0 la conversion de l'image");
                                    Log.error(e.toString(), e);
                                }
                            } else {
                                Log.error("image introuvable dans le r\u00e9pertoire : " + dir + filename);
                            }
                        }
                        if (Runtime.getRuntime().freeMemory() >= (long)(MINIMUM_FREE_MEMORY * 1000 * 1000)) continue;
                        ajoutePhoto = false;
                        break;
                    }
                    if (ajoutePhoto) {
                        syntheseEvenementBean.setPhotos(photos);
                    }
                    Map champsMap = MetierCommun.getChamps((List)n.getChamps());
                    List champs = MetierCommun.getChampsFiltresTest((List)n.getChamps(), (Map)champsMap);
                    ArrayList<SyntheseDescriptionEvenement> listeDescriptionEvenement = new ArrayList<SyntheseDescriptionEvenement>();
                    for (Champ c : champs) {
                        SyntheseDescriptionEvenement descriptionEvenement;
                        String value = (String)c.getView((IComposantFactory)factory);
                        if (GLS.estVide((String)value)) continue;
                        if (GLS.estVide((String)c.getLibelle())) {
                            descriptionEvenement = new SyntheseDescriptionEvenement();
                            descriptionEvenement.setCle("");
                            descriptionEvenement.setValeur(value == null ? "" : value);
                            listeDescriptionEvenement.add(descriptionEvenement);
                            continue;
                        }
                        if (c.getLibelle().equals("Localisation") || c.getLibelle().equals("Commentaire")) continue;
                        descriptionEvenement = new SyntheseDescriptionEvenement();
                        descriptionEvenement.setCle(c.getLibelle());
                        descriptionEvenement.setValeur(value == null ? "" : value);
                        listeDescriptionEvenement.add(descriptionEvenement);
                    }
                    syntheseEvenementBean.setDescriptions(listeDescriptionEvenement);
                    syntheseEvenementBean.setAuteur(this.service.getUtilisateur(version.getCodeUtilisateur()).getNom());
                    if (version.isTermine()) {
                        if (version.isAnnule()) {
                            syntheseEvenementBean.setEtat(PrismI18n.getString("evenement.etat.annule"));
                        } else {
                            syntheseEvenementBean.setEtat(PrismI18n.getString("evenement.etat.cloture"));
                        }
                    } else if (version.getNumVersion() == 1) {
                        syntheseEvenementBean.setEtat(PrismI18n.getString("evenement.etat.creation"));
                    } else if (version.isProgramme()) {
                        syntheseEvenementBean.setEtat(PrismI18n.getString("evenement.etat.modification") + " / " + PrismI18n.getString("evenement.etat.programme"));
                    } else {
                        syntheseEvenementBean.setEtat(PrismI18n.getString("evenement.etat.modification"));
                    }
                    syntheseEvenementBean.setVersion("" + version.getNumVersion());
                    syntheseEvenementBean.setDescription(n.getLabel());
                    syntheseEvenementBeanList.add(syntheseEvenementBean);
                }
                syntheseEvenementHistoriseBean.setHistorique(syntheseEvenementBeanList);
            }
            syntheseEvenementHistoriseBeanList.add(syntheseEvenementHistoriseBean);
        }
        return syntheseEvenementHistoriseBeanList;
    }

    private String imgToString(File img) throws Exception {
        Log.debug("imgToString : " + img.getName());
        FileInputStream fis = null;
        fis = new FileInputStream(img);
        Log.debug("imgToString : new FileInputStream OK");
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        Log.debug("imgToString : new ByteArrayOutputStream OK");
        int c = -1;
        while ((c = fis.read()) != -1) {
            bais.write(c);
        }
        Log.debug("imgToString : ByteArrayOutputStream write OK");
        fis.close();
        Log.debug("imgToString : fis.close OK");
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }

    private String getLocalisationTextuelle(Evenement evt) {
        String localisation = "";
        int sensPrRapport = 0;
        switch (evt.getLocalisation().getSensPr()) {
            case -1: {
                sensPrRapport = 0;
                break;
            }
            case 1: {
                sensPrRapport = 1;
                break;
            }
            case 0: {
                sensPrRapport = 2;
                break;
            }
            case 2: {
                sensPrRapport = 3;
            }
        }
        ValeurChampLocalisation loc = evt.getLocalisation();
        if (!GLS.estVide((String)loc.getVoie()) && Voie.isTunnel((String)loc.getVoie())) {
            PointParticulier pp;
            localisation = loc.getVoie();
            if (loc.getPointParticulier() != -1 && (pp = MetierCommun.getPointParticulier((int)loc.getPointParticulier(), (List)this.service.getTunnels())) != null) {
                try {
                    localisation = loc.getVoie() + " : ";
                    localisation = localisation + MetierCommun.getTunnel((int)pp.getTunnel(), (List)this.service.getTunnels()).getLibelle();
                    localisation = localisation + "<br />" + MetierCommun.getTube((int)pp.getTube(), (List)this.service.getTunnels()).getLibelle();
                    localisation = localisation + "<br />" + pp.getLibelle();
                }
                catch (Exception ex) {
                    Log.error("ERREUR AFFICH VISU TUNNEL", ex);
                }
            }
            return localisation;
        }
        String libelleSens = evt.getLocalisation().getDirection();
        if (null == libelleSens || libelleSens.equals("")) {
            libelleSens = "Sens " + "Ind\u00e9fini".toLowerCase();
        }
        if (evt.getLocalisation().getPrDebut() == -1) {
            localisation = this.service.getConfiguration().getString("format.export.localisation.sens.axe");
            if (localisation != null) {
                localisation = localisation.replace("%AXE%", evt.getLocalisation().getAxe() != null ? evt.getLocalisation().getAxe() : "");
                localisation = localisation.replace("%SENS%", "" + libelleSens);
                localisation = "-1".equals(evt.getLocalisation().getDeptDebut()) ? localisation.replace("%DEP_DEB%", "") : localisation.replace("%DEP_DEB%", evt.getLocalisation().getDeptDebut());
            } else {
                localisation = evt.getLocalisation().getAxe() + ", " + libelleSens;
            }
        } else if (evt.getLocalisation().getPrFin() == -1) {
            localisation = this.service.getConfiguration().getString("format.export.localisation.sens.pr.deb");
            if (localisation != null) {
                localisation = localisation.replace("%AXE%", evt.getLocalisation().getAxe() != null ? evt.getLocalisation().getAxe() : "");
                localisation = localisation.replace("%SENS%", "" + libelleSens);
                localisation = "-1".equals(evt.getLocalisation().getDeptDebut()) ? localisation.replace("%DEP_DEB%", "") : localisation.replace("%DEP_DEB%", evt.getLocalisation().getDeptDebut());
                localisation = localisation.replace("%PR_DEB%", "" + evt.getLocalisation().getPrDebut());
                localisation = localisation.replace("%ABS_DEB%", "" + evt.getLocalisation().getAbsPrDebut());
            } else {
                localisation = evt.getLocalisation().getAxe() + " PR " + evt.getLocalisation().getPrDebut() + " Abs " + evt.getLocalisation().getAbsPrDebut() + ", " + libelleSens;
            }
        } else {
            localisation = this.service.getConfiguration().getString("format.export.localisation.sens.pr.deb.et.fin");
            if (localisation != null) {
                localisation = localisation.replace("%AXE%", evt.getLocalisation().getAxe() != null ? evt.getLocalisation().getAxe() : "");
                localisation = localisation.replace("%SENS%", "" + libelleSens);
                localisation = "-1".equals(evt.getLocalisation().getDeptDebut()) ? localisation.replace("%DEP_DEB%", "") : localisation.replace("%DEP_DEB%", evt.getLocalisation().getDeptDebut());
                localisation = localisation.replace("%PR_DEB%", "" + evt.getLocalisation().getPrDebut());
                localisation = localisation.replace("%ABS_DEB%", "" + evt.getLocalisation().getAbsPrDebut());
                localisation = "-1".equals(evt.getLocalisation().getDeptFin()) ? localisation.replace("%DEP_FIN%", "") : localisation.replace("%DEP_FIN%", evt.getLocalisation().getDeptFin());
                localisation = localisation.replace("%PR_FIN%", "" + evt.getLocalisation().getPrFin());
                localisation = localisation.replace("%ABS_FIN%", "" + evt.getLocalisation().getAbsPrFin());
            } else {
                localisation = evt.getLocalisation().getAxe() + " du PR " + evt.getLocalisation().getPrDebut() + " Abs " + evt.getLocalisation().getAbsPrDebut() + " au PR " + evt.getLocalisation().getPrFin() + " Abs " + evt.getLocalisation().getAbsPrFin() + ", " + libelleSens;
            }
        }
        return localisation;
    }
}

