/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseDescriptionEvenement;
import com.geolocsystems.prismbirtbean.SyntheseEvenementBean;
import com.geolocsystems.prismbirtbean.SyntheseHistoriqueEvenement;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.util.Base64;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class FicheSyntheseEvenement {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String format;
    Integer[] idsEvenements;
    String idUtilisateur;
    private Map<String, Object> parametres;
    String fileDestination = "";
    BirtEngine birtEngine = null;
    List<SyntheseEvenementBean> syntheseEvenementBeanList;

    public InputStream export(List<Integer> idsEvenements, Map<String, Object> parametres, String format) {
        this.format = format;
        this.idsEvenements = new Integer[idsEvenements.size()];
        for (int index = 0; index < idsEvenements.size(); ++index) {
            this.idsEvenements[index] = idsEvenements.get(index);
        }
        this.parametres = parametres;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            if (design == null) {
                design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.fiches.travail.design"));
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            this.syntheseEvenementBeanList = new ArrayList<SyntheseEvenementBean>();
            this.syntheseEvenementBeanList.add(this.returnDummySyntheseEvenementBean());
            task.getAppContext().put("syntheseEvenementBean", this.syntheseEvenementBeanList);
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            for (Map.Entry<String, Object> parametre : this.parametres.entrySet()) {
                if (parametre.getKey().equals("photosBirt")) {
                    valeurs.put(parametre.getKey(), parametre.getValue());
                    task.getAppContext().put("photosBirt", parametre.getValue());
                    continue;
                }
                valeurs.put(parametre.getKey(), parametre.getValue());
            }
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = ConfigurationFactory.getInstance().get("dir.tmp") + "/" + System.nanoTime() + ".pdf";
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    private SyntheseEvenementBean returnDummySyntheseEvenementBean() {
        SyntheseEvenementBean retour = new SyntheseEvenementBean();
        retour.setLocalisation("RD" + this.numAleatoire() + " PR" + this.numAleatoire() + " Abs" + this.numAleatoire());
        retour.setAltitude(this.numAleatoire(0, 1000) + " m");
        retour.setCommune("commune sur test");
        retour.setDateCreation(this.numAleatoire(1, 30) + "/" + this.numAleatoire(1, 12) + "/17 - " + this.numAleatoire(0, 23) + ":" + this.numAleatoire(0, 59));
        retour.setDateDerniereModification(this.numAleatoire(1, 30) + "/" + this.numAleatoire(1, 12) + "/17 - " + this.numAleatoire(0, 23) + ":" + this.numAleatoire(0, 59));
        retour.setCommentaire("Commentaire");
        ArrayList<SyntheseDescriptionEvenement> syntheseDescriptionEvenementList = new ArrayList<SyntheseDescriptionEvenement>();
        int nbDescription = 10;
        for (int i = 0; i < nbDescription; ++i) {
            SyntheseDescriptionEvenement descriptionEvenement = new SyntheseDescriptionEvenement();
            descriptionEvenement.setCle("cle" + i);
            descriptionEvenement.setValeur("valeur" + i);
            syntheseDescriptionEvenementList.add(descriptionEvenement);
        }
        retour.setDescriptions(syntheseDescriptionEvenementList);
        ArrayList<SyntheseHistoriqueEvenement> syntheseHistoriqueEvenementList = new ArrayList<SyntheseHistoriqueEvenement>();
        int nbHistorique = 10;
        for (int i = 0; i < nbHistorique; ++i) {
            SyntheseHistoriqueEvenement historiqueEvenement = new SyntheseHistoriqueEvenement();
            historiqueEvenement.setAuteur("Auteur");
            historiqueEvenement.setDate(this.numAleatoire(1, 30) + "/" + this.numAleatoire(1, 12) + "/17");
            historiqueEvenement.setHeure(this.numAleatoire(0, 23) + ":" + this.numAleatoire(0, 59));
            historiqueEvenement.setEtat("Etat");
            syntheseHistoriqueEvenementList.add(historiqueEvenement);
        }
        retour.setDescriptions(syntheseDescriptionEvenementList);
        ArrayList<String> photos = new ArrayList<String>();
        photos.add(this.imgToString(new File("C:/WORK/test.jpg")));
        photos.add(this.imgToString(new File("C:/WORK/test.jpg")));
        retour.setPhotos(photos);
        return retour;
    }

    private int numAleatoire() {
        return this.numAleatoire(1, 999);
    }

    private int numAleatoire(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    private String imgToString(File img) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(img);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        int c = -1;
        try {
            while ((c = fis.read()) != -1) {
                bais.write(c);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fis.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }
}

