/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BulletinVH;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;

public class BulletinVHExport {
    BulletinVH bulletin;
    private static IReportRunnable design1 = null;
    private static IReportRunnable design2 = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String nomCT = "";
    int idBulletin = 0;
    int numSituation = 0;
    String fileDestination = "";
    String fileName = "";
    BirtEngine birtEngine = null;

    public BulletinVHExport(int idBulletin, int numSituation, String nomCT) {
        this.nomCT = nomCT;
        this.idBulletin = idBulletin;
        this.numSituation = numSituation;
    }

    public void exporter() {
        this.runReport();
        this.sendReport();
    }

    public void runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        this.birtReportEngine = birtEngine.getBirtEngine();
        IReportRunnable design = null;
        try {
            String mois;
            Log.debug("debut Try");
            if (design1 == null) {
                design1 = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("vh.bulletin.design1"));
            }
            if (design2 == null) {
                design2 = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("vh.bulletin.design2"));
            }
            design = !"".equals(this.nomCT) ? design1 : design2;
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            if (!"".equals(this.nomCT)) {
                valeurs.put("idCt", this.nomCT);
                valeurs.put("idBulletin", this.idBulletin);
            } else {
                valeurs.put("idBulletin", this.idBulletin);
            }
            valeurs.put("JDBCUrl", ConfigurationFactory.getInstance().get("jdbc.url"));
            valeurs.put("JDBCUser", ConfigurationFactory.getInstance().get("jdbc.username"));
            valeurs.put("JDBCPassword", ConfigurationFactory.getInstance().get("jdbc.password"));
            task.setParameterValues(valeurs);
            Log.debug("valeurs put");
            PDFRenderOption renderOption = new PDFRenderOption();
            Calendar cal = Calendar.getInstance();
            String jour = Integer.valueOf(cal.get(5)).toString();
            if (jour.length() < 2) {
                jour = "0" + jour;
            }
            if ((mois = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                mois = "0" + mois;
            }
            String dateJour = cal.get(1) + mois + jour;
            String anneeVH = "";
            anneeVH = cal.get(2) > 6 ? cal.get(1) + "-" + (cal.get(1) + 1) : cal.get(1) - 1 + "-" + cal.get(1);
            this.fileDestination = "";
            if (this.nomCT.equals("")) {
                this.fileDestination = ConfigurationFactory.getInstance().get("vh.bulletin.chemin-global") + "/" + anneeVH + "/" + dateJour + "/" + dateJour + "_" + this.numSituation + ".pdf";
                this.fileName = "global-" + dateJour + "_" + this.numSituation + ".pdf";
            } else {
                this.fileDestination = ConfigurationFactory.getInstance().get("vh.bulletin.chemin-ctcg") + this.nomCT + "/" + anneeVH + "/" + dateJour + "/" + dateJour + "_" + this.numSituation + ".pdf";
                this.fileName = "cei_" + this.nomCT + "-" + dateJour + "_" + this.numSituation + ".pdf";
            }
            Log.debug("bulletin vh " + this.fileDestination + " -- " + this.fileName);
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.setOutputFormat("PDF");
            renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            Log.debug("task.run");
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    public void sendReport() {
        MailService mailService = new MailService(new BusinessServiceDAO(), null);
        Log.debug("envois du bulletin vh");
        mailService.bulletinVH(new File(this.fileDestination), this.fileName);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design1 = null;
        design2 = null;
        this.birtReportEngine = null;
    }
}

