/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;

public class BulletinMediaVHExport {
    BulletinMediaVH bulletin;
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    int idBulletin = 0;
    Timestamp dateBulletin;
    String fileDestination = "";
    String fileName = "";
    BirtEngine birtEngine = null;
    private String destinataires;

    public BulletinMediaVHExport(int idBulletin, Timestamp dateBulletin, String destinataires) {
        this.idBulletin = idBulletin;
        this.dateBulletin = dateBulletin;
        this.destinataires = destinataires;
    }

    public void exporter() {
        this.runReport();
        this.sendReport();
    }

    private String getBulletinDestinataires() {
        return this.destinataires;
    }

    public void runReport() {
        BirtEngine birtEngine = new BirtEngine();
        this.birtReportEngine = birtEngine.getBirtEngine();
        IReportRunnable design = null;
        try {
            if (design == null) {
                design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("vh.bulletin.media.design"));
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            valeurs.put("idBulletin", this.idBulletin);
            valeurs.put("JDBCUrl", ConfigurationFactory.getInstance().get("jdbc.url"));
            valeurs.put("JDBCUser", ConfigurationFactory.getInstance().get("jdbc.username"));
            valeurs.put("JDBCPassword", ConfigurationFactory.getInstance().get("jdbc.password"));
            task.setParameterValues(valeurs);
            PDFRenderOption renderOption = new PDFRenderOption();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssS");
            String dateHeure = sdf.format(new Date(this.dateBulletin.getTime()));
            this.fileDestination = "";
            this.fileName = "bulletinMedia-" + dateHeure + ".pdf";
            this.fileDestination = ConfigurationFactory.getInstance().get("vh.bulletin.media.chemin") + this.fileName;
            Log.debug("bulletin media vh " + this.fileDestination);
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.setOutputFormat("PDF");
            renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
    }

    public void sendReport() {
        MailService mailService = new MailService(new BusinessServiceDAO(), null);
        Log.info("envois du bulletin media vh " + this.fileDestination);
        mailService.bulletinVH(new File(this.fileDestination), this.fileName);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

