/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import gls.outils.GLS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BarreauVHExport {
    private List<BarreauVHHisto> barreauxVHHisto = null;
    private String delegation;
    private String centre;
    private Date dateDebut;
    private Date dateFin;
    private HashMap<String, String> mapNomsCircuits;
    private Map<String, Object> parameters;
    private Font titleFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
    private Font headerFont = new Font(Font.FontFamily.HELVETICA, 10.0f, 0);
    private Font headerFontBold = new Font(Font.FontFamily.HELVETICA, 10.0f, 1);
    private Font commentFontNormal = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private Font commentFontBold = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private static float marginTop = 25.0f;
    private static float marginBottom = 25.0f;
    private static float marginLeft = 0.0f;
    private static float marginRight = 0.0f;

    public InputStream export(List<BarreauVHHisto> listBarreauVH, String format, Map<String, Object> parameters, String delegation, String centre, Date dateDebut, Date dateFin, HashMap<String, String> mapNomsCircuits) {
        this.barreauxVHHisto = listBarreauVH;
        this.delegation = delegation;
        this.centre = centre;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.mapNomsCircuits = mapNomsCircuits;
        this.parameters = parameters;
        if (IExportService.FORMATS.estPDF((String)format)) {
            return this.exportPDF();
        }
        if (IExportService.FORMATS.estCSV((String)format)) {
            return this.exportCSV();
        }
        return null;
    }

    public InputStream export(List<BarreauVHHisto> listBarreauVH, Map<String, Object> parameters) {
        this.barreauxVHHisto = listBarreauVH;
        this.parameters = parameters;
        return this.exportPDF(listBarreauVH);
    }

    public List<String> getExportFormat() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String format : IExportService.FORMATS.getListe((int)4)) {
            formats.add(format);
        }
        return formats;
    }

    public String getFileName(List<BarreauVHHisto> listBarreauVH, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfFile = new SimpleDateFormat("yyyyMMdd");
        StringBuffer sbDate = new StringBuffer("HistoriqueBarreauVH");
        sbDate.append("_");
        sbDate.append(sdfFile.format(this.dateDebut.toString()));
        sbDate.append(".");
        sbDate.append(IExportService.FORMATS.getExtension((String)format));
        return sbDate.toString();
    }

    public InputStream exportCSV() {
        Boolean afficheEmetteur = true;
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbCriteresTitre = new StringBuffer();
        StringBuffer sbCriteresValue = new StringBuffer();
        sbContenu.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("global.delegation"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(this.delegation);
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("global.centre"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(this.centre);
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("vh.historiqueCCH.datefiled.name.debut"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(sdf.format(this.dateDebut));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(ReportI18n.getString("vh.historiqueCCH.datefiled.name.fin"));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append(";\"");
        sbCriteresTitre.append(sdf.format(this.dateFin));
        sbCriteresTitre.append("\"");
        sbCriteresTitre.append("\n");
        sbContenu.append(sbCriteresTitre);
        sbContenu.append("\n");
        sbContenu.append("\n");
        StringBuffer sbColumnsName = new StringBuffer();
        List tableColumns = (List)this.parameters.get("listeColumns");
        for (String tableColumn : tableColumns) {
            if (sbColumnsName.length() != 0) {
                sbColumnsName.append(";");
            }
            sbColumnsName.append("\"");
            sbColumnsName.append(this.parameters.get(tableColumn));
            sbColumnsName.append("\"");
        }
        sbContenu.append(sbColumnsName);
        sbContenu.append("\n");
        if (this.barreauxVHHisto != null) {
            for (BarreauVHHisto barreauVHHisto : this.barreauxVHHisto) {
                Iterator iterator = tableColumns.iterator();
                while (iterator.hasNext()) {
                    String tableColumn;
                    switch (tableColumn = (String)iterator.next()) {
                        case "publie": {
                            this.rajoutChampsCSV(sbContenu, "", false);
                            break;
                        }
                        case "circuit": {
                            this.rajoutChampsCSV(sbContenu, !GLS.estVide((String)barreauVHHisto.getCircuit()) && this.mapNomsCircuits != null ? (GLS.estVide((String)this.mapNomsCircuits.get(barreauVHHisto.getCircuit())) ? "" : this.mapNomsCircuits.get(barreauVHHisto.getCircuit())) : "", false);
                            break;
                        }
                        case "idGroupe": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getIdGroupe(), false);
                            break;
                        }
                        case "tronconId": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getId(), false);
                            break;
                        }
                        case "libelle": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getDescription(), false);
                            break;
                        }
                        case "cch": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getCch(), false);
                            break;
                        }
                        case "cch2": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getCch2(), false);
                            break;
                        }
                        case "tendanceCC": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getTendanceCC(), false);
                            break;
                        }
                        case "meteo": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getMeteo(), false);
                            break;
                        }
                        case "temperature": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getTemperature(), false);
                            break;
                        }
                        case "vent": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getVent(), false);
                            break;
                        }
                        case "etatChaussee": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getEtatChaussee(), false);
                            break;
                        }
                        case "equipements": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getEquipements(), false);
                            break;
                        }
                        case "traitement": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getTraitement(), false);
                            break;
                        }
                        case "commentaireInterne": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getCommentaireInterne(), false);
                            break;
                        }
                        case "commentaire": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getCommentaire(), false);
                            break;
                        }
                        case "majDate": {
                            this.rajoutChampsCSV(sbContenu, sdf.format(barreauVHHisto.getMajDate()), false);
                            break;
                        }
                        case "auteur": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getUtilisateur(), false);
                            break;
                        }
                        case "source": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getTypePoste() == 1 ? "Embarqu\u00e9" : "Fixe", false);
                            break;
                        }
                        case "axe": {
                            this.rajoutChampsCSV(sbContenu, barreauVHHisto.getAxe(), false);
                            break;
                        }
                    }
                }
                sbContenu.append("\n");
            }
        }
        return new ByteArrayInputStream(sbContenu.toString().getBytes(Charset.forName("windows-1252")));
    }

    private void rajoutChampsCSV(StringBuffer sbContenu, String valeur, boolean dernierChamps) {
        sbContenu.append("\"");
        sbContenu.append(valeur);
        sbContenu.append("\"");
        if (!dernierChamps) {
            sbContenu.append(";");
        }
    }

    public InputStream exportPDF() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public InputStream exportPDF(List<BarreauVHHisto> barreaux) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContentHistorique(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void addMetaData(Document document) {
        document.addTitle("");
        document.addSubject("");
        document.addKeywords("");
        document.addAuthor("");
        document.addCreator("");
    }

    private void redimensionner(Image img, int largeur, int hauteur) {
        float width = img.getWidth();
        float height = img.getHeight();
        float newWidth = largeur;
        float newHeight = hauteur;
        if (width > height) {
            newHeight = height * newWidth / width;
            img.scaleAbsolute(newWidth, newHeight);
        } else {
            newWidth = width * newHeight / height;
            img.scaleAbsolute(newWidth, newHeight);
        }
    }

    private void addContent(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(ConfigurationFactory.getInstance().get("design.path") + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        texte = ReportI18n.getString("report.historique_BarreauVH.title");
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(texte, this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        PdfPTable table = null;
        float[] colsWidth = new float[]{1.0f, 1.0f};
        table = new PdfPTable(colsWidth);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        PdfPCell cell = new PdfPCell(new Phrase(ReportI18n.getString("global.critere"), this.headerFontBold));
        table.addCell(cell);
        table.addCell(new Phrase(ReportI18n.getString("global.valeur"), this.headerFontBold));
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.delegation"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.delegation);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.centre"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.centre);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.debut"), this.headerFont));
        table.addCell(cell);
        table.addCell(new Phrase(sdf.format(this.dateDebut), this.headerFont));
        cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.fin"), this.headerFont));
        table.addCell(cell);
        table.addCell(new Phrase(sdf.format(this.dateFin), this.headerFont));
        Paragraph paragrapheTable = new Paragraph();
        paragrapheTable.add((Element)table);
        this.addEmptyLine(entete, 1);
        entete.add((Element)paragrapheTable);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void addContentHistorique(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(ConfigurationFactory.getInstance().get("design.path") + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
        String dateGeneration = this.parameters.get("dateHistorique") != null ? sdf.format(this.parameters.get("dateHistorique")) : sdf.format(GregorianCalendar.getInstance().getTime());
        texte = ReportI18n.getString("report.historique_BarreauVH.journee.title") + this.barreauxVHHisto.get(0).getLibelle() + " - " + dateGeneration;
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(texte + "\n ", this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void createTable(Paragraph contenu) throws BadElementException {
        Paragraph paragrapheTable = new Paragraph();
        PdfPTable table = null;
        List tableColumns = (List)this.parameters.get("listeColumns");
        float[] colsWidthTotal = new float[tableColumns.size()];
        int colNumber = 0;
        ArrayList<PdfPCell> cells = new ArrayList<PdfPCell>();
        for (String tableColumn : tableColumns) {
            PdfPCell cell = null;
            switch (tableColumn) {
                case "publie": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.4f;
                    break;
                }
                case "circuit": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    break;
                }
                case "idGroupe": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    break;
                }
                case "tronconId": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    break;
                }
                case "libelle": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.0f;
                    break;
                }
                case "cch": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.4f;
                    break;
                }
                case "cch2": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.4f;
                    break;
                }
                case "tendanceCC": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.2f;
                    break;
                }
                case "meteo": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.8f;
                    break;
                }
                case "temperature": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.3f;
                    break;
                }
                case "vent": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.8f;
                    break;
                }
                case "etatChaussee": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.8f;
                    break;
                }
                case "equipements": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.8f;
                    break;
                }
                case "traitement": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.0f;
                    break;
                }
                case "commentaireInterne": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.5f;
                    break;
                }
                case "commentaire": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.5f;
                    break;
                }
                case "majDate": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.7f;
                    break;
                }
                case "auteur": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 1.0f;
                    break;
                }
                case "source": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.4f;
                    break;
                }
                case "axe": {
                    cell = new PdfPCell(new Phrase((String)this.parameters.get(tableColumn), this.commentFontBold));
                    cells.add(cell);
                    colsWidthTotal[colNumber++] = 0.5f;
                    break;
                }
            }
        }
        float[] colsWidth = new float[colNumber];
        for (int i = 0; i < colNumber; ++i) {
            colsWidth[i] = colsWidthTotal[i];
        }
        table = new PdfPTable(colsWidth);
        table.setWidthPercentage(100.0f);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        for (PdfPCell cell : cells) {
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            table.addCell(cell);
        }
        table.setHeaderRows(1);
        if (this.barreauxVHHisto != null) {
            for (BarreauVHHisto barreauVHHisto : this.barreauxVHHisto) {
                Iterator iterator = tableColumns.iterator();
                while (iterator.hasNext()) {
                    String tableColumn;
                    switch (tableColumn = (String)iterator.next()) {
                        case "publie": {
                            this.addCellCenter(table, new Phrase("", this.commentFontNormal));
                            break;
                        }
                        case "circuit": {
                            this.addCellCenter(table, new Phrase(!GLS.estVide((String)barreauVHHisto.getCircuit()) && this.mapNomsCircuits != null ? this.mapNomsCircuits.get(barreauVHHisto.getCircuit()) : "", this.commentFontNormal));
                            break;
                        }
                        case "idGroupe": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getIdGroupe(), this.commentFontNormal));
                            break;
                        }
                        case "tronconId": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getId(), this.commentFontNormal));
                            break;
                        }
                        case "libelle": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getDescription(), this.commentFontNormal));
                            break;
                        }
                        case "cch": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getCch(), this.commentFontNormal));
                            break;
                        }
                        case "cch2": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getCch2(), this.commentFontNormal));
                            break;
                        }
                        case "tendanceCC": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getTendanceCC(), this.commentFontNormal));
                            break;
                        }
                        case "meteo": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getMeteo(), this.commentFontNormal));
                            break;
                        }
                        case "temperature": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getTemperature(), this.commentFontNormal));
                            break;
                        }
                        case "vent": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getVent(), this.commentFontNormal));
                            break;
                        }
                        case "etatChaussee": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getEtatChaussee(), this.commentFontNormal));
                            break;
                        }
                        case "equipements": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getEquipements(), this.commentFontNormal));
                            break;
                        }
                        case "traitement": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getTraitement(), this.commentFontNormal));
                            break;
                        }
                        case "commentaireInterne": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getCommentaireInterne(), this.commentFontNormal));
                            break;
                        }
                        case "commentaire": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getCommentaire(), this.commentFontNormal));
                            break;
                        }
                        case "majDate": {
                            this.addCellCenter(table, new Phrase(sdf.format(barreauVHHisto.getMajDate()), this.commentFontNormal));
                            break;
                        }
                        case "auteur": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getUtilisateur(), this.commentFontNormal));
                            break;
                        }
                        case "source": {
                            try {
                                Image image = Image.getInstance((String)(barreauVHHisto.getTypePoste() == 1 ? (String)this.parameters.get("patrouilleur") : (String)this.parameters.get("fixe")));
                                float newWidth = 10.0f;
                                float newHeight = 10.0f;
                                image.scaleAbsolute(newWidth, newHeight);
                                PdfPCell cell = new PdfPCell(image);
                                cell.setHorizontalAlignment(1);
                                cell.setVerticalAlignment(5);
                                table.addCell(cell);
                            }
                            catch (Exception e) {
                                this.addCellCenter(table, new Phrase(barreauVHHisto.getTypePoste() == 1 ? "Embarqu\u00e9" : "Fixe", this.commentFontNormal));
                            }
                            break;
                        }
                        case "axe": {
                            this.addCellCenter(table, new Phrase(barreauVHHisto.getAxe(), this.commentFontNormal));
                            break;
                        }
                    }
                }
            }
        }
        paragrapheTable.add((Element)table);
        contenu.add((Element)paragrapheTable);
    }

    private void addCellCenter(PdfPTable table, Phrase phrase) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
    }

    private void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    public String getDelegation() {
        return this.delegation;
    }

    public void setDelegation(String delegation) {
        this.delegation = delegation;
    }

    public String getCentre() {
        return this.centre;
    }

    public void setCentre(String centre) {
        this.centre = centre;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    static class HeaderFooter
    extends PdfPageEventHelper {
        HeaderFooter() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
        }
    }
}

