/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.beans;

import cartoj.Enregistrement;
import cartoj.ICouche;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.DonneesSaleuse;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.google.common.hash.Hashing;
import gls.geometry.GeoPoint;
import gls.geometry.GeoPositionnement;
import gls.localisation.LocalisationInfo;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.fichier.Fichier;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import prism.commun.PositionGPS;
import prism.commun.Utilisateur;

public class Util {
    public static PositionGPS conversionPosition(DonneesSynchro donneesSynchro, ValeurChampLocalisation localisation, Utilisateur utilisateur) throws Exception {
        if (donneesSynchro != null && donneesSynchro.getPosition() != null) {
            PositionGPS positionGps = new PositionGPS();
            if (localisation != null && localisation.getPositionDebut() != null && localisation.getPositionDebut().getX() != 0.0f && localisation.getPositionDebut().getY() != 0.0f) {
                positionGps.setAltitude(donneesSynchro.getPosition().getAltitude());
                positionGps.setX(localisation.getPositionDebut().getX());
                positionGps.setY(localisation.getPositionDebut().getY());
                if (localisation.getPrDebut() != -1) {
                    positionGps.setAbscissePr(localisation.getAbsPrDebut());
                    positionGps.setPr(localisation.getPrDebut());
                } else {
                    positionGps.setAbscissePr(-1);
                    positionGps.setPr(-1);
                }
                if (localisation.getAxe() != null) {
                    positionGps.setAxe(localisation.getAxe());
                }
                positionGps.setCommune(localisation.getCommune());
                if (LocalisationInfo.estLocalisableParAdresse) {
                    positionGps.setAdresse(localisation.getAdresseDebut());
                }
            } else {
                try {
                    positionGps.setAxe("");
                    positionGps.setPr(-1);
                    positionGps.setAbscissePr(-1);
                    positionGps.setAdresse("");
                    GeoPoint point = new GeoPoint();
                    point.setX(donneesSynchro.getPosition().getX());
                    point.setY(donneesSynchro.getPosition().getY());
                    point.toUTM();
                    positionGps.setX((float)point.getX());
                    positionGps.setY((float)point.getY());
                    if (!point.isNull()) {
                        Enregistrement commune = Recherche.rechercherPremierEnregistrementDistance((ICouche)LocalisationInfo.getCoucheCommuneZone(), (GeoPoint)point, (int)1);
                        if (commune == null) {
                            GeoPositionnement posCommune = Recherche.rechercherObjetPlusProche((ICouche)LocalisationInfo.getCoucheCommuneZone(), (GeoPoint)point, (int)10000);
                            if (posCommune != null) {
                                commune = posCommune.getTroncon().getTroncon();
                                positionGps.setCommune(commune.getValeur(0));
                            }
                        } else {
                            positionGps.setCommune(commune.getValeur(0));
                        }
                    }
                }
                catch (Exception e) {
                    Log.error("Erreur recup x/y commune donnees synchro", e);
                }
            }
            if (donneesSynchro.getVh() != null) {
                positionGps.setCc(donneesSynchro.getVh().getCc());
            }
            if (donneesSynchro.getVh() != null && donneesSynchro.getVh().getDonneeSaleuse() != null) {
                positionGps.setDonneesSaleuse(Util.conversionDonneesSaleuse(donneesSynchro.getVh().getDonneeSaleuse()));
            }
            positionGps.setIdPatrouille(donneesSynchro.getMainCourrante().getIdPatrouille());
            positionGps.setMcig(donneesSynchro.getMainCourrante().getId());
            GLS.getDate();
            positionGps.setDate(GLSDate.toDateDatexComplete((long)donneesSynchro.getDate()));
            positionGps.setUtilisateur(utilisateur);
            positionGps.setId(MetierCommun.instanceOf().genereIdentifiantUniquePosition(donneesSynchro.getMainCourrante().getCodeUtilisateur()));
            return positionGps;
        }
        throw new Exception("ERREUR POSITION NON LOCALISEE");
    }

    public static prism.commun.DonneesSaleuse conversionDonneesSaleuse(DonneesSaleuse dAndroid) {
        prism.commun.DonneesSaleuse d = new prism.commun.DonneesSaleuse();
        try {
            d.setDebitSaumure(dAndroid.getDebitSaumure());
            d.setDebitSel(dAndroid.getDebitSel());
            d.setDebitSelDoubleTremie(dAndroid.getDebitSelDoubleTremie());
            d.setKmParcouru(dAndroid.getKmParcouru());
            d.setKmSale(dAndroid.getKmSale());
            d.setLameBaissee(dAndroid.getLameBaissee());
            d.setLargeurTravail(dAndroid.getLargeurTravail());
            d.setTauxHumidite(dAndroid.getTauxHumidite());
            d.setTemperature(dAndroid.getTemperature());
            d.setTemperatureAir(dAndroid.getTemperatureAir());
            d.setTemperatureSol(dAndroid.getTemperatureSol());
            d.setVitesseCamion(dAndroid.getVitesseCamion());
            d.setVitesseCamion(dAndroid.getVitesseCamion());
            d.setEmbrayageSaleuse((float)dAndroid.getEmbrayageSaleuse());
            d.setEmbrayageSaumure((float)dAndroid.getEmbrayageSaumure());
            d.setTemperatureRose(dAndroid.getTemperaturePointRose());
        }
        catch (Exception e) {
            Log.error("", e);
            d = null;
        }
        return d;
    }

    public static String getHashPhoto(byte[] bPhoto) {
        return Hashing.md5().hashBytes(bPhoto).toString();
    }

    public static void sauvegarderPhotos(IBusinessService service, Evenement e, List<Object> photos) {
        Log.debug("Ecriture photos evenement " + e.getIdReference());
        if (photos != null && !photos.isEmpty()) {
            Vector<byte[]> photosPrism = new Vector<byte[]>();
            for (Object photo : photos) {
                if (photo == null || !(photo instanceof byte[])) continue;
                photosPrism.add((byte[])photo);
            }
            if (!GLS.estVide(photosPrism)) {
                String cheminImage = null;
                if (!Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"))) {
                    cheminImage = MetierCommun.getCheminPhotosEvenement((String)ConfigurationFactory.getInstance().get("photo.repertoire"), (Evenement)e);
                    Fichier.verifierDossier((String)cheminImage);
                }
                try {
                    ArrayList<String> nomPhotosSauvegarde = new ArrayList<String>();
                    for (int i = 0; i < photos.size(); ++i) {
                        byte[] bPhoto;
                        if (Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"))) {
                            bPhoto = (byte[])photosPrism.get(i);
                            String hash = Hashing.md5().hashBytes(bPhoto).toString();
                            if (service.isPhotoExist((String)e.getPhotos().get(i))) {
                                Log.debug("Nom de photo d\u00e9j\u00e0 existant en base");
                                nomPhotosSauvegarde.add((String)e.getPhotos().get(i));
                                continue;
                            }
                            if (service.isPhotoExist(hash)) {
                                Log.debug("Photo avec le m\u00eame hash d\u00e9j\u00e0 existant en base, utilisation de l'enregistrement existant");
                                nomPhotosSauvegarde.add(hash);
                                continue;
                            }
                            Log.debug("Conversion et enregistrement photo en base");
                            ByteArrayInputStream in = new ByteArrayInputStream(bPhoto);
                            BufferedImage bImageFromConvert = ImageIO.read(in);
                            ByteArrayOutputStream stream = new ByteArrayOutputStream(4096);
                            ImageIO.write((RenderedImage)bImageFromConvert, "jpg", stream);
                            byte[] imageFinale = stream.toByteArray();
                            stream = null;
                            bImageFromConvert = null;
                            String hashFinal = Hashing.md5().hashBytes(imageFinale).toString();
                            service.sauvegarderPhoto(hashFinal, imageFinale);
                            nomPhotosSauvegarde.add(hashFinal);
                            continue;
                        }
                        bPhoto = (byte[])photosPrism.get(i);
                        ByteArrayInputStream in = new ByteArrayInputStream(bPhoto);
                        BufferedImage bImageFromConvert = ImageIO.read(in);
                        String nomPhoto = Fichier.getNom((String)((String)e.getPhotos().get(i)));
                        if (!Fichier.existe((String)cheminImage.concat(nomPhoto).concat(".jpeg"))) {
                            String hash = Hashing.md5().hashBytes(bPhoto).toString();
                            nomPhoto = hash + ".jpeg";
                        } else {
                            nomPhoto = nomPhoto + ".jpeg";
                        }
                        String nom = cheminImage.concat(nomPhoto);
                        Log.debug("Nom photo " + nom);
                        Log.debug("Byte convert photo " + bImageFromConvert);
                        ImageIO.write((RenderedImage)bImageFromConvert, "jpg", new File(nom));
                        nomPhotosSauvegarde.add(nomPhoto);
                    }
                    e.setPhotos(nomPhotosSauvegarde);
                }
                catch (Throwable ex) {
                    Log.error("ERREUR ECRITURE IMAGE", ex);
                }
            }
        }
    }
}

