/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Document;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampImages;
import com.google.common.hash.Hashing;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static HashMap<String, String> convertirAttributsExtraireImage(Nature n, Evenement e, Map<String, byte[]> imagesExtraites, Map<String, byte[]> documentExtraits) {
        HashMap<String, String> mapValeurs = new HashMap<String, String>();
        List champsFiltres = MetierCommun.getChampsFiltres((Nature)n);
        for (Champ c : champsFiltres) {
            try {
                List values = c.valueOf();
                if (values == null) continue;
                for (String[] value : values) {
                    String hashes;
                    if (c.aImage()) {
                        List imagesByte = ((ValeurChampImages)c.getValeurChamp()).getValeurs();
                        hashes = "";
                        for (byte[] imageByte : imagesByte) {
                            String hash = Hashing.md5().hashBytes(imageByte).toString();
                            imagesExtraites.put(hash, imageByte);
                            hashes = hashes + (hashes.equals("") ? "" : ";") + hash;
                        }
                        mapValeurs.put(value[0], hashes);
                        continue;
                    }
                    if (c.aDocument()) {
                        List documents = ((ValeurChampDocuments)c.getValeurChamp()).getValeurs();
                        hashes = "";
                        for (Document document : documents) {
                            byte[] documentByte = document.getContenu();
                            String hash = Hashing.md5().hashBytes(documentByte).toString();
                            documentExtraits.put(hash, documentByte);
                            hashes = hashes + (hashes.equals("") ? "" : ";") + hash;
                        }
                        mapValeurs.put(value[0], hashes);
                        continue;
                    }
                    mapValeurs.put(value[0], value[1]);
                }
            }
            catch (Exception exception) {
            }
        }
        return mapValeurs;
    }

    public static HashMap<String, String> convertirAttributsExtraireImage2(Nature n, Evenement e, Map<String, byte[]> imagesExtraites, Map<String, Document> documentExtraits) {
        HashMap<String, String> mapValeurs = new HashMap<String, String>();
        List champsFiltres = MetierCommun.getChampsFiltres((Nature)n);
        for (Champ c : champsFiltres) {
            Utils.convertirAttributsExtraireImageChamp(c, mapValeurs, imagesExtraites, documentExtraits);
        }
        return mapValeurs;
    }

    public static void convertirAttributsExtraireImageChamp(Champ c, Map<String, String> mapValeurs, Map<String, byte[]> imagesExtraites, Map<String, Document> documentExtraits) {
        try {
            if (c instanceof ChampMultiple) {
                for (Champ cc : ((ChampMultiple)c).getChamps()) {
                    Utils.convertirAttributsExtraireImageChamp(cc, mapValeurs, imagesExtraites, documentExtraits);
                }
            } else {
                List values = c.valueOf();
                if (values != null) {
                    for (String[] value : values) {
                        String hashes;
                        if (c.aImage()) {
                            List imagesByte = ((ValeurChampImages)c.getValeurChamp()).getValeurs();
                            hashes = "";
                            for (byte[] imageByte : imagesByte) {
                                String hash = Hashing.md5().hashBytes(imageByte).toString();
                                imagesExtraites.put(hash, imageByte);
                                hashes = hashes + (hashes.equals("") ? "" : ";") + hash;
                            }
                            mapValeurs.put(value[0], hashes);
                            continue;
                        }
                        if (c.aDocument()) {
                            List documents = ((ValeurChampDocuments)c.getValeurChamp()).getValeurs();
                            hashes = "";
                            for (Document document : documents) {
                                byte[] documentByte = document.getContenu();
                                String hash = Hashing.md5().hashBytes(documentByte).toString();
                                documentExtraits.put(hash, document);
                                hashes = hashes + (hashes.equals("") ? "" : ";") + hash;
                            }
                            mapValeurs.put(value[0], hashes);
                            continue;
                        }
                        mapValeurs.put(value[0], value[1]);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

