/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActivitePeriode;
import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampEntier;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampHeure;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBirt;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleEvenementBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleInterventionVHBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleReseauBean;
import com.geolocsystems.prismbirtbean.SyntheseViseeBean;
import com.geolocsystems.prismbirtbean.SyntheseViseeBeanCumul;
import com.geolocsystems.prismbirtbean.SyntheseViseeBeanPatrouille;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.McigDAOJDBC;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.Localisation;
import com.geolocsystems.prismcentral.beans.LocalisationDonneesSaleuse;
import com.geolocsystems.prismcentral.beans.SynthesePatrouillesVHBean;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.TronconSuiviComplet;
import com.geolocsystems.prismcentral.beans.Util;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentral.service.ExportService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.geometry.Geometry;
import gls.localisation.LocalisationInfo;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.sql.SQL;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.net.util.Base64;
import org.postgis.LineString;
import org.postgis.PGbox2d;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.Polygon;
import org.postgresql.util.PGobject;
import prism.commun.DonneesSaleuse;
import prism.commun.PositionGPS;

public class VehiculeDAOJDBC
implements IVehiculeDAO {
    private static final String SQL_VEHICULE_INTERVENTION = "select ST_Transform(l.coordonnees,4326) as geom,p.id as id_patrouille, l.altitude, l.pr,l.abscisse_pr,l.adresse,l.commune,p.date_visa,p.utilisateur_visa,l.axe, l.date_heure_loc,p.parametres, p.debut as debut_patrouille,u.nom, v.code as code_vehicule,v.immatriculation,v.numero_telephone,p.type as code_module_metier, cch,m.mcig_id,m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,u.centre,u.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail,l.vitesse_vehicule,l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.temperature_rose,l.humidite_air,l.emb_sau,l.emb_sal, p.fin as fin_patrouille,  p.equipier, p.id_circuit, p.code_vehicule, p.parametres,m.telephone  FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id  and l.id_patrouille = p.id and m.id_utilisateur = u.id_utilisateur  and p.code_vehicule = v.code  and v.id_marque_vehicule = mv.id and u.mse = ? ";
    private static final String SQL_VEHICULE_INTERVENTION_CAPVITESSE = "select ST_Transform(l.coordonnees,4326) as geom,p.id as id_patrouille, l.altitude, l.pr,l.abscisse_pr,l.adresse,l.commune,p.date_visa,p.utilisateur_visa,l.axe, l.date_heure_loc,p.parametres, p.debut as debut_patrouille,u.nom, v.code as code_vehicule,v.immatriculation,v.numero_telephone,p.type as code_module_metier, cch,m.mcig_id,m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,u.centre,u.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail,l.vitesse_vehicule,l.cap, l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.temperature_rose,l.humidite_air,l.emb_sau,l.emb_sal, p.fin as fin_patrouille,  p.equipier, p.id_circuit, p.code_vehicule, p.parametres,m.telephone  FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id  and l.id_patrouille = p.id and m.id_utilisateur = u.id_utilisateur  and p.code_vehicule = v.code  and v.id_marque_vehicule = mv.id and u.mse = ? ";
    private static final String SQL_NB_VEHICULE_INTERVENTION_HISTORIQUE = "select p.id as id_patrouille,l.altitude, l.pr,l.abscisse_pr,l.adresse,l.commune,l.axe, l.date_heure_loc,p.debut as debut_patrouille,u.nom, v.code as code_vehicule,v.immatriculation,v.numero_telephone,p.type as code_module_metier, cch,m.mcig_id,m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,u.centre,u.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail,l.vitesse_vehicule,l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.temperature_rose,l.humidite_air,l.emb_sau,l.emb_sal,p.fin as fin_patrouille,  p.equipier, p.id_circuit, p.code_vehicule  FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id AND l.id_patrouille = p.id AND m.id_utilisateur = u.id_utilisateur AND p.code_vehicule = v.code AND v.id_marque_vehicule = mv.id AND u.mse = ? AND (p.id, l.date_heure_loc) in (SELECT distinct(p2.id), max(l2.date_heure_loc) FROM localisation l2, patrouille p2 WHERE p2.id = l2.id_patrouille and l2.date_heure_loc BETWEEN ? AND ? GROUP by p2.id)";
    private static final String SQL_NB_VEHICULE_INTERVENTION_HISTORIQUE_WITH_LOC = "select ST_Transform(l.coordonnees,4326) as geom, p.id as id_patrouille, l.altitude, l.pr,l.abscisse_pr,l.adresse,l.commune,l.axe, l.date_heure_loc,p.debut as debut_patrouille,u.nom, v.code as code_vehicule,v.immatriculation,v.numero_telephone,p.type as code_module_metier, cch,m.mcig_id,m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,u.centre,u.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail,l.vitesse_vehicule,l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.temperature_rose,l.humidite_air,l.emb_sau,l.emb_sal,p.fin as fin_patrouille,  p.equipier, p.id_circuit, p.code_vehicule, p.date_visa, p.utilisateur_visa, p.parametres  FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id AND l.id_patrouille = p.id AND m.id_utilisateur = u.id_utilisateur AND p.code_vehicule = v.code AND v.id_marque_vehicule = mv.id AND u.mse = ? AND (p.id, l.date_heure_loc,l.id) in (SELECT distinct(p2.id), max(l2.date_heure_loc),max(l2.id) FROM localisation l2, patrouille p2 WHERE p2.id = l2.id_patrouille and l2.date_heure_loc BETWEEN ? AND ? AND p2.fin is not null GROUP by p2.id)";
    private static final String SQL_NB_VEHICULE_INTERVENTION_HISTORIQUE_REGROUPE = "select string_agg(p.id,';') as ids_patrouille, date_trunc('day',p.debut) as debut_patrouille, u.id_utilisateur,v.code as code_vehicule, p.type as code_module_metier FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id AND l.id_patrouille = p.id AND m.id_utilisateur = u.id_utilisateur AND p.code_vehicule = v.code AND v.id_marque_vehicule = mv.id AND u.mse = 'cd74' AND (p.id, l.date_heure_loc) in (SELECT distinct(p2.id), max(l2.date_heure_loc) FROM localisation l2, patrouille p2 WHERE p2.id = l2.id_patrouille and l2.date_heure_loc BETWEEN ? AND ? GROUP by p2.id)";
    private static final String SQL_DETAIL_INTERVENTION_PATROUILLE_REGROUPE = "select ST_Transform(l.coordonnees,4326) as geom, p.id as id_patrouille, l.altitude, l.pr,l.abscisse_pr,l.adresse,l.commune,l.axe, l.date_heure_loc,p.debut as debut_patrouille,u.nom, v.code as code_vehicule,v.immatriculation,v.numero_telephone,p.type as code_module_metier, cch,m.mcig_id,m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,u.centre,u.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail,l.vitesse_vehicule,l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.temperature_rose,l.humidite_air,l.emb_sau,l.emb_sal,p.fin as fin_patrouille,  p.equipier, p.id_circuit, p.code_vehicule  FROM prism.localisation l,prism.mcig m, prism.patrouille p, prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id AND l.id_patrouille = p.id AND m.id_utilisateur = u.id_utilisateur AND p.code_vehicule = v.code AND v.id_marque_vehicule = mv.id AND p.id IN ?";
    private static final String SQL_LONGUEUR_CONDITION_CONDUITE_HISTORIQUE_DEBUT = "SELECT cch, SUM(longueur) as longueur FROM vh.evenement_vh v WHERE v.id_patrouille = ANY(select p.id AS id_patrouille FROM prism.localisation l,prism.mcig m, prism.patrouille p,prism.vehicule v,prism.utilisateur u,prism.marque_vehicule mv WHERE l.mcig_id = m.mcig_id AND l.id_patrouille = p.id AND m.id_utilisateur = u.id_utilisateur AND p.code_vehicule = v.code AND v.id_marque_vehicule = mv.id AND u.mse = ? AND (p.id, l.date_heure_loc) in (SELECT distinct(p2.id), max(l2.date_heure_loc) FROM localisation l2, patrouille p2 WHERE p2.id = l2.id_patrouille and l2.date_heure_loc BETWEEN ? AND ? GROUP by p2.id)";
    private static final String SQL_ACTIVITES_PATROUILLES = "SELECT id_patrouille,cch, longueur,date,date_fin FROM vh.evenement_vh v where id_patrouille = ?";
    private static final String SQL_LONGUEUR_CONDITION_CONDUITE_HISTORIQUE_FIN = ") group by cch";
    private static final String SQL_VEHICULE_TRAJET_LATERALIZE = "select v.id,v.id_patrouille as idp, cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, longueur, date from vh.evenement_vh  v where v.id_patrouille = ANY(?) order by v.date asc;";
    private static final String SQL_VEHICULE_TRAJET = "select v.id,v.id_patrouille as idp, cch, st_transform(coordonnees,4326) as coord, longueur, date from vh.evenement_vh  v where v.id_patrouille = ANY(?) order by v.date asc;";
    private static final String SQL_VEHICULE_TRAJET_RECENT = "select cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, v.date_fin, v.id, v.longueur, v.date from vh.evenement_vh v inner join patrouille p on p.id = v.id_patrouille where date_fin > now() AND cch <> 'NR' ";
    private static final String SQL_VEHICULE_TRAJET_RECENT_AVEC_DATE_VALIDITE = "select cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, v.date_fin, v.id, v.longueur, v.date from vh.evenement_vh v inner join patrouille p on p.id = v.id_patrouille where date_fin > ? AND cch <> 'NR' ";
    private static final String SQL_VEHICULE_TRAJET_SEUL = "select cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, longueur, date from vh.evenement_vh  v where v.id_patrouille = ? order by v.date asc;";
    private static final String SQL_VEHICULE_TRAJET_SEUL_NO_LATERALIZE = "select cch, st_transform((ST_SimplifyPreserveTopology(coordonnees,0.05)),4326) as coord, longueur,date from vh.evenement_vh  v where v.id_patrouille = ? order by v.date asc;";
    private static final String CLASSEMENT_TRONCONS_RECENTS = " order by v.date asc;";
    private static final String SQL_LOCALISATION_PATROUILLE = "SELECT coordonnees, date_heure_loc, etat_loc, mcig_id, type, axe, pr, abscisse_pr, id, cch, debit_sel, debit_saumure, largeur_travail, vitesse_vehicule, km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air, altitude, id_patrouille, commune, adresse FROM localisation WHERE mcig_id = ?";
    private static final String SQL_LOCALISATION_DONNEES_SALEUSE_LATERALIZE = "SELECT st_transform(lateralize_line(st_simplify(coordonnees,0.05), 20, 1),4326) as coord, date_heure_loc, etat_loc, mcig_id, type, axe, pr, abscisse_pr, id, cch, debit_sel, debit_saumure, largeur_travail, km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air, altitude, id_patrouille, commune, adresse, sens_pr, emb_sal, emb_sau, temperature_rose FROM prism.localisation WHERE id_patrouille = ? ORDER BY date_heure_loc ASC;";
    private static final String SQL_LOCALISATION_DONNEES_SALEUSE = "SELECT st_transform(coordonnees,4326) as coord, date_heure_loc, etat_loc, mcig_id, type, axe, pr, abscisse_pr, id, cch, debit_sel, debit_saumure, largeur_travail, km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air, altitude, id_patrouille, commune, adresse, sens_pr, emb_sal, emb_sau, temperature_rose FROM prism.localisation WHERE id_patrouille = ? ORDER BY date_heure_loc ASC;";
    private static final String SQL_INFORMATIONS_PATROUILLE = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, v.immatriculation, p.id, u.nom, u.centre, u.delegation, p.date_visa, uv.centre as centre_visa, uv.nom as nom_visa, p.equipier, c.delegation as delegation_circuit, c.centre as centre_circuit, c.nom as nom_circuit, p.parametres FROM prism.patrouille p LEFT JOIN prism.utilisateur uv on uv.sna = p.utilisateur_visa LEFT JOIN prism.circuit c on c.id = p.id_circuit LEFT JOIN prism.vehicule v on v.code = p.code_vehicule, prism.mcig m, prism.utilisateur u WHERE u.id_utilisateur = m.id_utilisateur AND m.mcig_id = p.mcig_id AND p.id = ?";
    private static final String SQL_INFORMATIONS_PATROUILLE_REGROUPEE = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, v.immatriculation, p.code_vehicule, p.id, u.nom, u.centre, u.delegation, p.date_visa, uv.centre as centre_visa, uv.nom as nom_visa, p.equipier, c.delegation as delegation_circuit, c.centre as centre_circuit, c.nom as nom_circuit, p.parametres FROM prism.patrouille p LEFT JOIN prism.utilisateur uv on uv.sna = p.utilisateur_visa LEFT JOIN prism.circuit c on c.id = p.id_circuit LEFT JOIN prism.vehicule v on v.code = p.code_vehicule, prism.mcig m, prism.utilisateur u WHERE u.id_utilisateur = m.id_utilisateur AND m.mcig_id = p.mcig_id AND p.id IN\t( SELECT p2.id FROM patrouille p1, patrouille p2, mcig m1, mcig m2\tWHERE p1.id = ? AND p1.mcig_id = m1.mcig_id AND p2.mcig_id = m2.mcig_id AND p1.type = p2.type AND m1.id_utilisateur = m2.id_utilisateur AND p1.code_vehicule = p2.code_vehicule AND date_trunc('day',p1.debut) = date_trunc('day',p2.debut)) ORDER BY p.debut ASC";
    private static final String SQL_IDS_PATROUILLE_REGROUPEE = "SELECT p2.id FROM patrouille p1, patrouille p2, mcig m1, mcig m2 WHERE p1.id = ? AND p1.mcig_id = m1.mcig_id AND p2.mcig_id = m2.mcig_id AND m1.id_utilisateur = m2.id_utilisateur AND p1.code_vehicule = p2.code_vehicule AND date_trunc('day',p1.debut) = date_trunc('day',p2.debut) AND p2.type = p1.type ORDER BY p2.debut ASC";
    private static final String SQL_EVENEMENTS_PATROUILLE = "SELECT k_eventid, dob, snm, erf, forevent, inp, mst, phr, sta, sto, sur, vnm, datexl01, datexl02, datexl03, datexl04, datexl05, datexl09, datexl11, datexl12, datexltv, datexlol, datexlol1, datexlot, lnp, nlq, que, ari, cfi, fin, etat, valope, valopedate, can, mcig_id, source, positionnement, envoiauto, coordonnees, positionbretelle, evenementserpe, mot, prdeb, prfin, distanceprdeb, distanceprfin, typeevenement, sens, route, appel, donneescomplementaires, listecoordonnees, cei, district, commune, commentaireinterne, departement, description, direction, nature, lu, id_patrouille, id_utilisateur, erreur, photos, code_evenement, adresse_debut, adresse_fin, programme, zone_routiere, code, libelle, active, code_categorie, code_module_metier, indice FROM prism.evenement e, prism.nature_perso n WHERE n.code = e.nature AND id_patrouille = ?";
    private static final String SQL_LONGUEUR_PATROUILLE_LOCALISATION = "SELECT ST_LENGTH(ST_MakeLine(coordonnees ORDER BY id asc, date_heure_loc ASC)) as longueur FROM localisation WHERE id_patrouille = ? GROUP BY id_patrouille";
    private static final String SQL_LONGUEUR_PATROUILLE_EVENEMENT_VH = "SELECT sum(longueur) as longueur FROM vh.evenement_vh WHERE id_patrouille = ? GROUP BY id_patrouille";
    private static final String SQL_NB_PATROUILLES_BY_YEAR = "SELECT p.delegation, p.centre, date_part('month',p.jour) as mois, COUNT(p.nb_patrouilles_circuit) as nb_patrouilles FROM ( SELECT DISTINCT 1 as nb_patrouilles_circuit, date_trunc('day',pat.debut) as jour, u.delegation, u.centre FROM patrouille pat, mcig m, utilisateur u, vh.evenement_vh evh WHERE date_part('year',pat.debut) = ? AND pat.id_circuit >= 0 AND pat.type = ? AND pat.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND u.mse = ? AND u.centre IS NOT null AND u.delegation IS NOT NULL AND evh.mcig_id = m.mcig_id GROUP BY delegation, centre, jour order by jour, delegation, centre ) p GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC";
    private static final String SQL_NB_PATROUILLES_BY_YEAR_SGR = "SELECT c.delegation, c.centre, date_part('month',p.jour) as mois, COUNT(p.nb_patrouilles_circuit) as nb_patrouilles FROM (SELECT DISTINCT 1 as nb_patrouilles_circuit, date_trunc('day',pat.debut) as jour, pat.id_circuit FROM patrouille pat WHERE date_part('year',pat.debut) = ? AND id_circuit > 0) p, circuit c WHERE c.zone_routiere = ? AND c.id = p.id_circuit GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC;";
    private static final String SQL_NB_PATROUILLES_BY_YEAR_OLD = "SELECT u.delegation, u.centre, date_part('month',p.debut) as mois, COUNT(p.id) as nb_patrouilles FROM patrouille p, mcig m, utilisateur u WHERE p.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND u.mse = ? AND date_part('year',p.debut) = ? AND u.centre IS NOT null AND u.delegation IS NOT NULL GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC;";
    private static final String SQL_INFORMATIONS_PATROUILLES_BY_DATES = "SELECT date_trunc('day',p.debut) as jour, p.type, m.id_utilisateur, p.code_vehicule, p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, p.id, u.nom, u.centre, u.delegation, ST_LENGTH(ST_MakeLine(l.coordonnees ORDER BY l.id ASC, l.Date_heure_loc ASC)) as longueur, (SELECT COUNT(DISTINCT e1.k_eventid) FROM prism.evenement e1 WHERE e1.nature = 'intervh' AND p.id = e1.id_patrouille AND e1.vnm = 1) as declenchementESH, (SELECT COUNT(ae2.valeur) FROM prism.evenement e2, attribut_evenement ae2 WHERE ae2.k_eventid = e2.k_eventid AND e2.nature = 'etatvh' AND ae2.valeur != '0' AND ae2.champ = 'selResiduel' AND p.id = e2.id_patrouille) as sobo FROM prism.patrouille p, prism.mcig m, prism.utilisateur u, prism.localisation l WHERE l.id_patrouille = p.id AND u.id_utilisateur = m.id_utilisateur AND m.mcig_id = p.mcig_id AND p.debut BETWEEN ? AND ? AND p.type = ? GROUP BY jour, p.type, m.id_utilisateur, p.code_vehicule, p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, p.id, u.nom, u.centre, u.delegation ORDER BY jour ASC, p.type ASC, u.nom ASC, p.code_vehicule";
    private static final String SQL_PATROUILLES_RECHERCHE = "SELECT p.id,p.debut,p.fin,p.mcig_id,type FROM vh.evenement_vh v, prism.patrouille p  WHERE v.id_patrouille = p.id AND st_intersects(v.coordonnees, st_buffer(st_transform(st_setsrid(st_makepoint(?,?), 4326), 32630), 25)) AND date > ? AND date < ?  group by p.id, p.debut, p.fin, p.mcig_id, p.type  ORDER BY p.debut DESC ";
    private static final String SQL_PATROUILLES_RECHERCHE_IDS = "SELECT * FROM vh.evenement_vh v, prism.patrouille p WHERE v.id_patrouille = p.id  AND p.id IN (?) ORDER BY date DESC";
    private static final String SQL_PATROUILLES_RECHERCHE_FOR_EVENT_ID = "SELECT * FROM vh.evenement_vh v, prism.patrouille p WHERE v.id_patrouille = p.id  AND p.id IN (SELECT distinct(id_patrouille) FROM prism.evenement WHERE k_eventid = ?) ORDER BY date DESC";
    private static final String SQL_LOCALISATIONS_PATROUILLE = "SELECT st_transform(coordonnees, 4326) as coordonnees, date_heure_loc, etat_loc, mcig_id, type, axe, pr, abscisse_pr, id, cch, debit_sel, debit_saumure, largeur_travail, vitesse_vehicule, km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air, altitude, id_patrouille, commune, adresse FROM localisation WHERE mcig_id = ?";
    private static final String SQL_GET_TITLE_PATROUILLE_BIRT = "select valeur from configuration where champ = 'titre.patrouille.synthese'";
    private static final String SQL_GET_CODE_MODULE_METIER_PATROUILLE = "SELECT type FROM patrouille p WHERE p.id = ?";
    private DAOFactory daoFactory;
    private IBusinessService businessService;
    private IPhotoDAO photoDao;
    private boolean conversionCapDistance = false;
    private IReferentielDAO refDAO = null;
    private float polylineVitesse = -1.0f;
    private boolean wazeActif = false;
    private String SQL_PATROUILLES_UPDATE_VISER = "UPDATE prism.patrouille SET date_visa=?,utilisateur_visa=? WHERE id=ANY(?) RETURNING id";

    public VehiculeDAOJDBC(DAOFactory daoFactory, IBusinessService businessService) {
        this.daoFactory = daoFactory;
        this.businessService = businessService;
        this.photoDao = daoFactory.getPhotoDAO();
        if (businessService == null) {
            this.refDAO = DAOFactory.getInstance().getReferentielDAO(DAOFactory.getInstance().getIconDAO());
        }
        try {
            this.conversionCapDistance = businessService != null ? businessService.getConfiguration().getBoolean("position.capdistance", false) : this.refDAO.getConfiguration().getBoolean("position.capdistance", false);
        }
        catch (Exception e) {
            this.conversionCapDistance = false;
        }
        try {
            if (businessService != null) {
                this.polylineVitesse = businessService.getConfiguration().getFloat("publication.waze.polyline.vitesse", 50.0f);
                this.wazeActif = !"".equals(businessService.getConfiguration().getString("publication.waze.polyline.vitesse", ""));
            } else {
                this.polylineVitesse = this.refDAO.getConfiguration().getFloat("publication.waze.polyline.vitesse", 50.0f);
                this.wazeActif = !"".equals(this.refDAO.getConfiguration().getString("publication.waze.polyline.vitesse", ""));
            }
        }
        catch (Exception e) {
            this.polylineVitesse = 50.0f;
            this.wazeActif = false;
        }
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre) {
        return this.getVehiculesEnIntervention(filtre, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<VehiculeEnIntervention> getVehiculesEnIntervention(List<String> idsPatrouille) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles) {
        return this.getSynthesePatrouilleBirt(idPatrouille, type, regroupementPatrouilles);
    }

    public String getTitleSynthesePatrouilleBirtTitle(int codeMM) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        String retour;
        block6: {
            retour = "";
            String req = SQL_GET_TITLE_PATROUILLE_BIRT;
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                if (!rs.next()) break block6;
                String titres = rs.getString("valeur");
                if (titres != "" && titres.contains(":")) {
                    String[] listeTitres;
                    for (String keyTitre : listeTitres = titres.split(";")) {
                        String[] values = keyTitre.split(":");
                        if (Integer.valueOf(values[0]) != codeMM) continue;
                        retour = values[1];
                    }
                    break block6;
                }
                retour = titres;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    public int getModuleMetierPatrouille(String idPatrouille) {
        int retour = 0;
        String req = SQL_GET_CODE_MODULE_METIER_PATROUILLE;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            if (rs.next()) {
                retour = rs.getInt("type");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public SynthesePatrouilleBirt getSynthesePatrouilleBirt(String idPatrouille, String type, boolean regroupementPatrouilles, String adresseServeur) {
        Log.debug("getSynthesePatrouilleBirt");
        int codeMM = 0;
        String titre = "";
        if (type == "patrouille") {
            codeMM = 1;
            titre = "Fiche de Synth\u00e8se de Patrouille";
        } else {
            codeMM = 0;
            titre = "FICHE SYNTHETIQUE DE TOURNEE D'ITINERAIRE";
        }
        codeMM = this.getModuleMetierPatrouille(idPatrouille);
        if (!this.getTitleSynthesePatrouilleBirtTitle(codeMM).equals("")) {
            titre = this.getTitleSynthesePatrouilleBirtTitle(codeMM);
        }
        HashMap<Object, Object> synthesePatrouilleLongueurTroncons = new HashMap();
        if (regroupementPatrouilles) {
            SynthesePatrouilleBean synthesePatrouille = this.getSynthesePatrouilleBeanRegroupee(idPatrouille, codeMM);
            List<String> idsPatrouilles = this.getSynthesePatrouilleRegroupeeIds(idPatrouille, codeMM);
            ArrayList<SynthesePatrouilleReseauBean> synthesePatrouilleReseauList = new ArrayList<SynthesePatrouilleReseauBean>();
            ArrayList<SynthesePatrouilleInterventionVHBean> synthesePatrouilleInterventionVHList = new ArrayList<SynthesePatrouilleInterventionVHBean>();
            ArrayList<SynthesePatrouilleEvenementBean> synthesePatrouilleEvenementList = new ArrayList<SynthesePatrouilleEvenementBean>();
            synthesePatrouilleLongueurTroncons = this.getSynthesePatrouilleLongueurTroncons(idsPatrouilles);
            for (String idPat : idsPatrouilles) {
                if (type == "patrouille") {
                    synthesePatrouilleReseauList.addAll(this.getSynthesePatrouilleReseau(idPat));
                    List<SynthesePatrouilleInterventionVHBean> list = this.getSynthesePatrouilleInterventionVH(idPat);
                    for (SynthesePatrouilleInterventionVHBean interVH : list) {
                        boolean exist = false;
                        for (SynthesePatrouilleInterventionVHBean interVHExistante : synthesePatrouilleInterventionVHList) {
                            if (!interVHExistante.getErf().equals(interVH.getErf())) continue;
                            exist = true;
                        }
                        if (exist) continue;
                        synthesePatrouilleInterventionVHList.add(interVH);
                    }
                    continue;
                }
                synthesePatrouilleEvenementList.addAll(this.getSynthesePatrouilleEvenement(idPat, adresseServeur));
            }
            String commentaires = "";
            if (type == "patrouille") {
                for (SynthesePatrouilleReseauBean synthesePatrouilleReseauBean : synthesePatrouilleReseauList) {
                    if (synthesePatrouilleReseauBean.getCommentaire() == null || synthesePatrouilleReseauBean.getCommentaire().equals("")) continue;
                    if (commentaires != "") {
                        commentaires = commentaires + "<br>";
                    }
                    commentaires = commentaires + synthesePatrouilleReseauBean.getCommentaire();
                }
                for (SynthesePatrouilleInterventionVHBean synthesePatrouilleInterventionVHBean : synthesePatrouilleInterventionVHList) {
                    if (synthesePatrouilleInterventionVHBean.getCommentaire() == null || synthesePatrouilleInterventionVHBean.getCommentaire().equals("")) continue;
                    if (commentaires != "") {
                        commentaires = commentaires + "<br>";
                    }
                    commentaires = commentaires + synthesePatrouilleInterventionVHBean.getCommentaire();
                }
            } else {
                for (SynthesePatrouilleEvenementBean synthesePatrouilleEvenementBean : synthesePatrouilleEvenementList) {
                    if (synthesePatrouilleEvenementBean.getCommentaire() == null || synthesePatrouilleEvenementBean.getCommentaire().equals("")) continue;
                    if (commentaires != "") {
                        commentaires = commentaires + "<br>";
                    }
                    commentaires = commentaires + synthesePatrouilleEvenementBean.getCommentaire();
                }
            }
            synthesePatrouille.setCommentairesEvenements(commentaires);
            Log.debug("return new SynthesePatrouilleBirt regroupementPatrouilles");
            return new SynthesePatrouilleBirt(synthesePatrouille, synthesePatrouilleReseauList, synthesePatrouilleInterventionVHList, synthesePatrouilleEvenementList, synthesePatrouilleLongueurTroncons, titre);
        }
        SynthesePatrouilleBean synthesePatrouille = this.getSynthesePatrouilleBean(idPatrouille);
        List<Object> synthesePatrouilleReseauList = new ArrayList();
        List<Object> synthesePatrouilleInterventionVHList = new ArrayList();
        List<Object> synthesePatrouilleEvenementList = new ArrayList();
        ArrayList<String> idsPatrouilles = new ArrayList<String>();
        idsPatrouilles.add(idPatrouille);
        synthesePatrouilleLongueurTroncons = this.getSynthesePatrouilleLongueurTroncons(idsPatrouilles);
        String commentaires = "";
        if (type == "patrouille") {
            synthesePatrouilleReseauList = this.getSynthesePatrouilleReseau(idPatrouille);
            synthesePatrouilleInterventionVHList = this.getSynthesePatrouilleInterventionVH(idPatrouille);
            for (SynthesePatrouilleReseauBean synthesePatrouilleReseauBean : synthesePatrouilleReseauList) {
                if (synthesePatrouilleReseauBean.getCommentaire() == null || synthesePatrouilleReseauBean.getCommentaire().equals("")) continue;
                if (commentaires != "") {
                    commentaires = commentaires + ", ";
                }
                commentaires = commentaires + synthesePatrouilleReseauBean.getCommentaire();
            }
            for (SynthesePatrouilleInterventionVHBean synthesePatrouilleInterventionVHBean : synthesePatrouilleInterventionVHList) {
                if (synthesePatrouilleInterventionVHBean.getCommentaire() == null || synthesePatrouilleInterventionVHBean.getCommentaire().equals("")) continue;
                if (commentaires != "") {
                    commentaires = commentaires + ", ";
                }
                commentaires = commentaires + synthesePatrouilleInterventionVHBean.getCommentaire();
            }
        } else {
            synthesePatrouilleEvenementList = this.getSynthesePatrouilleEvenement(idPatrouille, adresseServeur);
            for (SynthesePatrouilleEvenementBean synthesePatrouilleEvenementBean : synthesePatrouilleEvenementList) {
                if (synthesePatrouilleEvenementBean.getCommentaire() == null || synthesePatrouilleEvenementBean.getCommentaire().equals("")) continue;
                if (commentaires != "") {
                    commentaires = commentaires + ", ";
                }
                commentaires = commentaires + synthesePatrouilleEvenementBean.getCommentaire();
            }
        }
        synthesePatrouille.setCommentairesEvenements(commentaires);
        Log.debug("return new SynthesePatrouilleBirt");
        return new SynthesePatrouilleBirt(synthesePatrouille, synthesePatrouilleReseauList, synthesePatrouilleInterventionVHList, synthesePatrouilleEvenementList, synthesePatrouilleLongueurTroncons, titre);
    }

    public HashMap<String, Integer> getSynthesePatrouilleLongueurTroncons(List<String> idsPatrouilles) {
        HashSet<String> idsPatrouillesSet = new HashSet<String>();
        idsPatrouillesSet.addAll(idsPatrouilles);
        Collection<TronconSuivi> tronconsSuivi = this.getTronconsPatrouilles(idsPatrouillesSet);
        Iterator<TronconSuivi> it = tronconsSuivi.iterator();
        ArrayList<String> listeCodes = new ArrayList<String>();
        HashMap<String, Integer> longueurTroncons = new HashMap<String, Integer>();
        while (it.hasNext()) {
            TronconSuivi troncon = it.next();
            if (!listeCodes.contains(troncon.getCode())) {
                listeCodes.add(troncon.getCode());
                longueurTroncons.put(troncon.getCode(), troncon.getLongueur());
                continue;
            }
            longueurTroncons.put(troncon.getCode(), longueurTroncons.get(troncon.getCode()) + troncon.getLongueur());
        }
        Collections.sort(listeCodes);
        return longueurTroncons;
    }

    @Override
    public List<String> getSynthesePatrouilleRegroupeeIds(String idPatrouille, int codeMM) {
        ArrayList<String> idsPatrouille = new ArrayList<String>();
        String req = SQL_IDS_PATROUILLE_REGROUPEE;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            while (rs.next()) {
                idsPatrouille.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return idsPatrouille;
    }

    /*
     * Exception decompiling
     */
    public SynthesePatrouilleBean getSynthesePatrouilleBeanRegroupee(String idPatrouille, int codeMM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String SetTextVisa(ResultSet rs) {
        String retour = "";
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        try {
            if (rs.getTimestamp("date_visa") != null) {
                Timestamp dateVisa = rs.getTimestamp("date_visa");
                if (rs.getString("centre_visa") != null) {
                    retour = this.businessService.getConfiguration().getString("texteViseeCentreRenseigne");
                    retour = retour.replace("%CENTRE_VISA%", rs.getString("centre_visa"));
                    retour = retour.replace("%DATE_VISA%", sdfDate.format(new Date(dateVisa.getTime())));
                    retour = retour.replace("%HEURE_VISA%", sdfHeure.format(new Date(dateVisa.getTime())));
                    retour = rs.getString("nom_visa") != null ? retour.replace("%UTILISATEUR_VISA%", rs.getString("nom_visa")) : retour.replace("%UTILISATEUR_VISA%", "");
                } else {
                    retour = this.businessService.getConfiguration().getString("texteViseeDateRenseignee");
                    retour = retour.replace("%DATE_VISA%", sdfDate.format(new Date(dateVisa.getTime())));
                    retour = retour.replace("%HEURE_VISA%", sdfHeure.format(new Date(dateVisa.getTime())));
                    retour = rs.getString("nom_visa") != null ? retour.replace("%UTILISATEUR_VISA%", rs.getString("nom_visa")) : retour.replace("%UTILISATEUR_VISA%", "");
                }
            } else {
                retour = this.businessService.getConfiguration().getString("texteViseeNonRenseigne");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            retour = "Vis\u00e9e par<br><br>le";
        }
        return retour;
    }

    public SynthesePatrouilleBean getSynthesePatrouilleBean(String idPatrouille) {
        SynthesePatrouilleBean synthesePatrouille;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block14: {
            String req = SQL_INFORMATIONS_PATROUILLE;
            connection = null;
            pstm = null;
            rs = null;
            synthesePatrouille = new SynthesePatrouilleBean();
            try {
                Timestamp dateFin;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, idPatrouille);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                if (!rs.next()) break block14;
                synthesePatrouille = new SynthesePatrouilleBean();
                SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
                SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
                long duree = -1L;
                Timestamp dateDebut = rs.getTimestamp("debut");
                if (dateDebut != null) {
                    synthesePatrouille.setDateDebut(sdfDate.format(new Date(dateDebut.getTime())));
                    synthesePatrouille.setHeureDebut(sdfHeure.format(new Date(dateDebut.getTime())));
                }
                if ((dateFin = rs.getTimestamp("fin")) != null) {
                    synthesePatrouille.setDateFin(sdfDate.format(new Date(dateFin.getTime())));
                    synthesePatrouille.setHeureFin(sdfHeure.format(new Date(dateFin.getTime())));
                    duree = dateFin.getTime() - dateDebut.getTime();
                }
                if (duree != -1L) {
                    int heures = (int)Math.floor(duree / 3600000L);
                    long reste = duree - (long)(heures * 3600000);
                    int minutes = (int)Math.floor(reste / 60000L);
                    String heuresTxt = heures < 10 ? "0" + heures : "" + heures;
                    String minutesTxt = minutes < 10 ? "0" + minutes : "" + minutes;
                    synthesePatrouille.setDureePatrouille(heuresTxt + ":" + minutesTxt);
                } else {
                    synthesePatrouille.setDureePatrouille("-");
                }
                if (rs.getString("immatriculation") != null) {
                    synthesePatrouille.setVehicule(rs.getString("immatriculation"));
                } else {
                    synthesePatrouille.setVehicule(rs.getString("code_vehicule"));
                }
                synthesePatrouille.setPatrouilleur(rs.getString("nom"));
                synthesePatrouille.setCerd(rs.getString("centre"));
                synthesePatrouille.setArrondissement(rs.getString("delegation"));
                if (!PrismI18n.getString("commentaire.aucunEquipier").equals(rs.getString("equipier"))) {
                    synthesePatrouille.setAccompagnateur(rs.getString("equipier"));
                }
                synthesePatrouille.setLongueurPatrouille(this.getLongueurPatrouille(connection, rs.getString("id")));
                synthesePatrouille.setTexteVisa(this.SetTextVisa(rs));
                synthesePatrouille = this.getInformationsCircuit(rs, synthesePatrouille);
                try {
                    Array array = rs.getArray("parametres");
                    if (!rs.wasNull()) {
                        MapDescription m = MapDescription.newMap();
                        m.add(MapDescription.parse((String[])((String[])array.getArray())));
                        Log.debug("cfa : " + m.getString("cfa", ""));
                        synthesePatrouille.setCommentaires(m.getString("cfa", ""));
                        Log.debug("q-sel : " + m.getString("q-sel", ""));
                        synthesePatrouille.setSel(m.getString("q-sel", ""));
                        Log.debug("q-saumure : " + m.getString("q-saumure", ""));
                        synthesePatrouille.setSaumure(m.getString("q-saumure", ""));
                        synthesePatrouille.getVehicules().addAll(this.getAutresVehicules(m));
                    }
                }
                catch (Exception e) {
                    Log.error("Erreur parametres vehicules intervention", e);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return synthesePatrouille;
    }

    private ArrayList<String> getAutresVehicules(MapDescription m) {
        ArrayList<String> retour = new ArrayList<String>();
        for (String key : m.getCles()) {
            Log.debug("key : " + key);
            if (!key.startsWith("autre-vehicule")) continue;
            retour.add(m.getString(key, ""));
        }
        Log.debug("vehicules : " + retour);
        return retour;
    }

    public SynthesePatrouilleBean getInformationsCircuit(ResultSet rs, SynthesePatrouilleBean synthesePatrouille) throws SQLException {
        if (rs.getString("nom_circuit") != null) {
            if (rs.getString("centre_circuit") != null) {
                synthesePatrouille.setCerd(rs.getString("centre_circuit"));
            } else {
                synthesePatrouille.setCerd("");
            }
            if (rs.getString("delegation_circuit") != null) {
                synthesePatrouille.setArrondissement(rs.getString("delegation_circuit"));
            } else {
                synthesePatrouille.setArrondissement("");
            }
            synthesePatrouille.setNomCircuit(rs.getString("nom_circuit"));
        }
        return synthesePatrouille;
    }

    public int getLongueurPatrouille(Connection connection, String id_patrouille) {
        String req = SQL_LONGUEUR_PATROUILLE_EVENEMENT_VH;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        int longueur = 0;
        try {
            pstm = connection.prepareStatement(req);
            pstm.setString(1, id_patrouille);
            rs = pstm.executeQuery();
            if (rs.next()) {
                longueur = (int)Math.round(rs.getDouble("longueur") / 1000.0);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(rs);
                DAOUtil.close(pstm);
                throw throwable;
            }
        }
        DAOUtil.close(rs);
        DAOUtil.close(pstm);
        return longueur;
    }

    public List<SynthesePatrouilleEvenementBean> getSynthesePatrouilleEvenement(String idPatrouille) {
        return this.getSynthesePatrouilleEvenement(idPatrouille, "");
    }

    public List<SynthesePatrouilleEvenementBean> getSynthesePatrouilleEvenement(String idPatrouille, String adresseServeur) {
        Log.debug("getSynthesePatrouilleEvenement " + idPatrouille);
        ArrayList<SynthesePatrouilleEvenementBean> retour = new ArrayList<SynthesePatrouilleEvenementBean>();
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.moduleMetier(null, null, null);
        HashMap<String, String> photosMemorisees = new HashMap<String, String>();
        filtre.idPatrouille = idPatrouille;
        filtre.etat = -1;
        filtre.termines = -1;
        List situations = this.businessService.getEvenements(filtre, null);
        Map natures = this.businessService.getNatures();
        File basedir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
        boolean indatabase = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"));
        Log.debug("URL SERVEUR " + adresseServeur);
        String urlConfig = this.businessService.getConfiguration().getString("adresse.servlet.fiche.evt");
        adresseServeur = urlConfig != null ? ("".equals(adresseServeur) || urlConfig.substring(0, 4).equals("http") ? urlConfig : adresseServeur + urlConfig) : "";
        Log.debug("URL SERVLET " + adresseServeur);
        Boolean modeTraite = this.businessService.getConfiguration().getBoolean("export.type.evenement.mode.traite", false);
        for (Situation situation : situations) {
            Iterator iterator = situation.getEvenements().iterator();
            while (iterator.hasNext()) {
                Evenement evenement;
                Evenement evt = evenement = (Evenement)iterator.next();
                SynthesePatrouilleEvenementBean synthesePatrouilleEvenement = new SynthesePatrouilleEvenementBean();
                String localisation = this.businessService.getConfiguration().getString("format.export.localisation");
                if (localisation != null) {
                    if (evt.getLocalisation().getAxe() != null) {
                        localisation = localisation.replace("%AXE%", evt.getLocalisation().getAxe());
                    }
                    localisation = localisation.replace("%AXE%", "");
                    localisation = "-1".equals(evt.getLocalisation().getDeptDebut()) ? localisation.replace("%DEP_DEB%", "") : localisation.replace("%DEP_DEB%", evt.getLocalisation().getDeptDebut());
                    localisation = localisation.replace("%PR_DEB%", "" + evt.getLocalisation().getPrDebut());
                    localisation = localisation.replace("%ABS_DEB%", "" + evt.getLocalisation().getAbsPrDebut());
                } else {
                    localisation = evt.getLocalisation().getAxe() + " PR " + evt.getLocalisation().getPrDebut() + " Abs " + evt.getLocalisation().getAbsPrDebut();
                }
                SimpleDateFormat sdfHeure = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                sdfHeure = this.businessService.getConfiguration().getString("format.export.date.heure") != null ? new SimpleDateFormat(this.businessService.getConfiguration().getString("format.export.date.heure")) : new SimpleDateFormat("HH:mm");
                synthesePatrouilleEvenement.setLocalisation(localisation);
                synthesePatrouilleEvenement.setHeure(sdfHeure.format(new Date(evt.getDateMaj())));
                synthesePatrouilleEvenement.setTypeEvenement(((Nature)natures.get(evt.getValeurNature().getCode())).getLabel());
                File dir = new File(basedir, evt.getIdSituation() + File.separator + evt.getIdReference());
                ArrayList<String> photos = new ArrayList<String>();
                for (String filename : evt.getPhotos()) {
                    String photo;
                    if (photosMemorisees.get(filename) != null) {
                        photos.add((String)photosMemorisees.get(filename));
                        continue;
                    }
                    if (indatabase) {
                        byte[] data = this.photoDao.getPhoto(filename);
                        if (data == null) continue;
                        photo = DatatypeConverter.printBase64Binary((byte[])data);
                        photos.add(photo);
                        photosMemorisees.put(filename, photo);
                        continue;
                    }
                    File file = new File(dir, filename);
                    if (file.exists()) {
                        try {
                            photo = this.imgToString(file);
                            photos.add(photo);
                            photosMemorisees.put(filename, photo);
                        }
                        catch (Exception e) {
                            Log.error("erreur \u00e0 la conversion de l'image");
                            Log.error(e.toString(), e);
                        }
                        continue;
                    }
                    Log.error("image introuvable dans le r\u00e9pertoire : " + dir + filename);
                }
                synthesePatrouilleEvenement.setPhotos(photos);
                if (modeTraite.booleanValue()) {
                    if (evt.isTraite()) {
                        synthesePatrouilleEvenement.setType("Trait\u00e9");
                    } else {
                        synthesePatrouilleEvenement.setType("Non trait\u00e9");
                    }
                } else if (evt.isTermine()) {
                    synthesePatrouilleEvenement.setType("Cloture");
                } else if (evt.getNumVersion() == 1) {
                    synthesePatrouilleEvenement.setType("Cr\u00e9ation");
                } else {
                    synthesePatrouilleEvenement.setType("Modification");
                }
                ValeurChamp vc = null;
                try {
                    vc = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"commentaire");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (vc != null) {
                    synthesePatrouilleEvenement.setObservation(((ValeurChampTexte)vc).getValeur());
                }
                try {
                    ValeurChampTexte vcCommentaire = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"commentaire");
                    if (vcCommentaire != null) {
                        synthesePatrouilleEvenement.setCommentaire(vcCommentaire.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.businessService.getConfiguration().getString("adresse.servlet.fiche.evt") != null) {
                    synthesePatrouilleEvenement.setLien(adresseServeur + evt.getkEventid());
                }
                retour.add(synthesePatrouilleEvenement);
            }
        }
        return retour;
    }

    public List<SynthesePatrouilleInterventionVHBean> getSynthesePatrouilleInterventionVH(String idPatrouille) {
        ArrayList<SynthesePatrouilleInterventionVHBean> retour = new ArrayList<SynthesePatrouilleInterventionVHBean>();
        ArrayList<String> nature = new ArrayList<String>();
        nature.add("intervh");
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byNatures(null, null, nature);
        filtre.idPatrouille = idPatrouille;
        filtre.termines = -1;
        filtre.vnmMax = true;
        filtre.creeParPatrouille = false;
        List situations = this.businessService.getEvenements(filtre, null);
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        for (Situation situation : situations) {
            for (Evenement evenement : situation.getEvenements()) {
                Evenement evt = this.businessService.getDernierEvenementActif(evenement);
                SynthesePatrouilleInterventionVHBean synthesePatrouilleIntevention = new SynthesePatrouilleInterventionVHBean();
                synthesePatrouilleIntevention.setErf(evt.getIdReference());
                try {
                    String vehiculesTxt = "";
                    ValeurChampMultiCheckBox vcVehicules = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"vehicules");
                    for (Object vehicules : vcVehicules.getValeursSelectionnee()) {
                        if (!vehiculesTxt.equals("")) {
                            vehiculesTxt = vehiculesTxt + " ";
                        }
                        vehiculesTxt = vehiculesTxt + (String)vehicules;
                    }
                    synthesePatrouilleIntevention.setVehicule(vehiculesTxt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Object vehicules;
                    List valeurs = evt.getValeurNature().getValeurs();
                    String chauffeursTxt = "";
                    ValeurChampMultiCheckBox vcChauffeur = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"chauffeurEsh");
                    vehicules = vcChauffeur.getValeursSelectionnee().iterator();
                    while (vehicules.hasNext()) {
                        String chauffeur = (String)vehicules.next();
                        if (!chauffeursTxt.equals("")) {
                            chauffeursTxt = chauffeursTxt + " ";
                        }
                        chauffeursTxt = chauffeursTxt + chauffeur;
                    }
                    synthesePatrouilleIntevention.setChauffeur(chauffeursTxt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    String accompagnateursTxt = "";
                    ValeurChampMultiCheckBox vcAccompagnateur = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"accompagnateurEsh");
                    for (String accompagnateur : vcAccompagnateur.getValeursSelectionnee()) {
                        if (!accompagnateursTxt.equals("")) {
                            accompagnateursTxt = accompagnateursTxt + " ";
                        }
                        accompagnateursTxt = accompagnateursTxt + accompagnateur;
                    }
                    synthesePatrouilleIntevention.setAccompagnateur(accompagnateursTxt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    synthesePatrouilleIntevention.setHeureAppel(sdfHeure.format(new Date(evt.getDateCreation())));
                    ValeurChampHeure vcHeureDepart = (ValeurChampHeure)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"heureDepart");
                    if (vcHeureDepart.getHeure() > -1) {
                        synthesePatrouilleIntevention.setHeureDepart(vcHeureDepart.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampHeure vcHeureArrivee = (ValeurChampHeure)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"heureArrivee");
                    if (vcHeureArrivee.getHeure() > -1) {
                        synthesePatrouilleIntevention.setHeureArrivee(vcHeureArrivee.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    String circuitsTxt = "";
                    ValeurChampMultiCheckBox vcCircuits = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"circuits");
                    for (String circuits : vcCircuits.getValeursSelectionnee()) {
                        if (!circuitsTxt.equals("")) {
                            circuitsTxt = circuitsTxt + " ";
                        }
                        circuitsTxt = circuitsTxt + circuits;
                    }
                    synthesePatrouilleIntevention.setNumCircuitOuRd(circuitsTxt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampCollectionChoixUnique vcSaumure = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"saumure");
                    if ("Oui".equals(vcSaumure.getValeur())) {
                        synthesePatrouilleIntevention.setSaumure("X");
                    } else if ("Partiel".equals(vcSaumure.getValeur())) {
                        synthesePatrouilleIntevention.setSaumure("");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChamp vcSalage = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"salage");
                    if (vcSalage instanceof ValeurChampCollectionChoixUnique) {
                        if ("Total".equals(((ValeurChampCollectionChoixUnique)vcSalage).getValeur())) {
                            synthesePatrouilleIntevention.setSalageTotal("X");
                        }
                        if ("Partiel".equals(((ValeurChampCollectionChoixUnique)vcSalage).getValeur())) {
                            synthesePatrouilleIntevention.setSalagePartiel("X");
                        }
                        if ("Saumure".equals(((ValeurChampCollectionChoixUnique)vcSalage).getValeur())) {
                            synthesePatrouilleIntevention.setSaumure("X");
                        }
                        if ("Pr\u00e9-curatif".equals(((ValeurChampCollectionChoixUnique)vcSalage).getValeur())) {
                            synthesePatrouilleIntevention.setPrecuratif("X");
                        }
                    } else {
                        if (((ValeurChampMultiCheckBox)vcSalage).getValeursSelectionnee().contains("Total")) {
                            synthesePatrouilleIntevention.setSalageTotal("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcSalage).getValeursSelectionnee().contains("Partiel")) {
                            synthesePatrouilleIntevention.setSalagePartiel("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcSalage).getValeursSelectionnee().contains("Saumure")) {
                            synthesePatrouilleIntevention.setSaumure("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcSalage).getValeursSelectionnee().contains("Pr\u00e9-curatif")) {
                            synthesePatrouilleIntevention.setPrecuratif("X");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampCollectionChoixUnique vcDeneigement = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"deneigement");
                    if ("Oui".equals(vcDeneigement.getValeur())) {
                        synthesePatrouilleIntevention.setDeneigement("X");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampTexte vcCommentaire = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"commentaire");
                    if (vcCommentaire != null) {
                        synthesePatrouilleIntevention.setCommentaire(vcCommentaire.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                retour.add(synthesePatrouilleIntevention);
            }
        }
        return retour;
    }

    public List<SynthesePatrouilleReseauBean> getSynthesePatrouilleReseau(String idPatrouille) {
        ArrayList<SynthesePatrouilleReseauBean> retour = new ArrayList<SynthesePatrouilleReseauBean>();
        ArrayList<String> nature = new ArrayList<String>();
        nature.add("etatvh");
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byNatures(null, null, nature);
        filtre.idPatrouille = idPatrouille;
        filtre.termines = -1;
        List situations = this.businessService.getEvenements(filtre, null);
        for (Situation situation : situations) {
            for (Evenement evt : situation.getEvenements()) {
                Object object;
                SynthesePatrouilleReseauBean synthesePatrouilleReseau = new SynthesePatrouilleReseauBean();
                String localisation = evt.getLocalisation().getAxe() + " PR " + evt.getLocalisation().getPrDebut() + " Abs " + evt.getLocalisation().getAbsPrDebut();
                SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
                synthesePatrouilleReseau.setLocalisation(localisation);
                synthesePatrouilleReseau.setHeure(sdfHeure.format(new Date(evt.getDateMaj())));
                try {
                    ValeurChampMultiCheckBox vcEtatChaussees = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"etatChaussees");
                    object = vcEtatChaussees.getValeursSelectionnee().iterator();
                    while (object.hasNext()) {
                        String etatChaussee;
                        switch (etatChaussee = (String)object.next()) {
                            case "S\u00e8che": {
                                synthesePatrouilleReseau.setEcSeche("X");
                                break;
                            }
                            case "Humide": {
                                synthesePatrouilleReseau.setEcHumide("X");
                                break;
                            }
                            case "Mouill\u00e9e": {
                                synthesePatrouilleReseau.setEcMouille("X");
                                break;
                            }
                            case "Neige": {
                                synthesePatrouilleReseau.setEcNeige("X");
                                break;
                            }
                            case "Neige fondante": {
                                synthesePatrouilleReseau.setEcNeigeFondante("X");
                                break;
                            }
                            case "Givre": {
                                synthesePatrouilleReseau.setEcGivre("X");
                                break;
                            }
                            case "Verglas": {
                                synthesePatrouilleReseau.setEcVerglas("X");
                                break;
                            }
                            case "Cong\u00e8res": {
                                synthesePatrouilleReseau.setEcCongeres("X");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampEntier vcSel = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"selResiduel");
                    if (vcSel.isChecked()) {
                        synthesePatrouilleReseau.setSelResiduel("" + vcSel.getValeur());
                    } else {
                        synthesePatrouilleReseau.setSelResiduel("");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChamp vcTempAir = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"temperatureAir");
                    if (vcTempAir instanceof ValeurChampEntier) {
                        if (((ValeurChampEntier)vcTempAir).isChecked()) {
                            synthesePatrouilleReseau.setTempAir("" + ((ValeurChampEntier)vcTempAir).getValeur());
                        } else {
                            synthesePatrouilleReseau.setTempAir("");
                        }
                    } else if (((ValeurChampDecimal)vcTempAir).isChecked()) {
                        synthesePatrouilleReseau.setTempAir(String.format("%.1f", ((ValeurChampDecimal)vcTempAir).getValeur()));
                    } else {
                        synthesePatrouilleReseau.setTempAir("");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChamp vcTempRosee = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"temperatureRosee");
                    if (vcTempRosee instanceof ValeurChampEntier) {
                        if (((ValeurChampEntier)vcTempRosee).isChecked()) {
                            synthesePatrouilleReseau.setTempRose("" + ((ValeurChampEntier)vcTempRosee).getValeur());
                        } else {
                            synthesePatrouilleReseau.setTempRose(null);
                        }
                    } else if (((ValeurChampDecimal)vcTempRosee).isChecked()) {
                        synthesePatrouilleReseau.setTempRose(String.format("%.1f", ((ValeurChampDecimal)vcTempRosee).getValeur()));
                    } else {
                        synthesePatrouilleReseau.setTempRose(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChamp vcTempRoute = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"temperatureSol");
                    if (vcTempRoute instanceof ValeurChampEntier) {
                        if (((ValeurChampEntier)vcTempRoute).isChecked()) {
                            synthesePatrouilleReseau.setTempRoute("" + ((ValeurChampEntier)vcTempRoute).getValeur());
                        } else {
                            synthesePatrouilleReseau.setTempRoute(null);
                        }
                    } else if (((ValeurChampDecimal)vcTempRoute).isChecked()) {
                        synthesePatrouilleReseau.setTempRoute(String.format("%.1f", ((ValeurChampDecimal)vcTempRoute).getValeur()));
                    } else {
                        synthesePatrouilleReseau.setTempRoute(null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampMultiCheckBox vcMeteo = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"meteo");
                    object = vcMeteo.getValeursSelectionnee().iterator();
                    while (object.hasNext()) {
                        String meteo;
                        switch (meteo = (String)object.next()) {
                            case "Ciel couvert": {
                                synthesePatrouilleReseau.setMeteoCouvert("X");
                                break;
                            }
                            case "Ciel d\u00e9gag\u00e9": {
                                synthesePatrouilleReseau.setMeteoDegage("X");
                                break;
                            }
                            case "Pluie": {
                                synthesePatrouilleReseau.setMeteoPluie("X");
                                break;
                            }
                            case "Neige": {
                                synthesePatrouilleReseau.setMeteoNeige("X");
                                break;
                            }
                            case "Brouillard": {
                                synthesePatrouilleReseau.setMeteoBrouillard("X");
                                break;
                            }
                            case "Vent": {
                                synthesePatrouilleReseau.setMeteoVent("X");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChamp vcConditionCirculation = MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"conditionCirculation");
                    if (vcConditionCirculation instanceof ValeurChampCollectionChoixUnique) {
                        switch (((ValeurChampCollectionChoixUnique)vcConditionCirculation).getValeur()) {
                            case "C1 normale": {
                                synthesePatrouilleReseau.setCrC1("X");
                                break;
                            }
                            case "C2 d\u00e9licate": {
                                synthesePatrouilleReseau.setCrC2("X");
                                break;
                            }
                            case "C3 difficile": {
                                synthesePatrouilleReseau.setCrC3("X");
                                break;
                            }
                            case "C4 impraticable": {
                                synthesePatrouilleReseau.setCrC4("X");
                            }
                        }
                    } else {
                        if (((ValeurChampMultiCheckBox)vcConditionCirculation).getValeursSelectionnee().contains("C1 normale")) {
                            synthesePatrouilleReseau.setCrC1("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcConditionCirculation).getValeursSelectionnee().contains("C2 d\u00e9licate")) {
                            synthesePatrouilleReseau.setCrC2("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcConditionCirculation).getValeursSelectionnee().contains("C3 difficile")) {
                            synthesePatrouilleReseau.setCrC3("X");
                        }
                        if (((ValeurChampMultiCheckBox)vcConditionCirculation).getValeursSelectionnee().contains("C4 impraticable")) {
                            synthesePatrouilleReseau.setCrC4("X");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampDecimal vcHumidite = (ValeurChampDecimal)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"humidite");
                    if (vcHumidite != null) {
                        synthesePatrouilleReseau.setHumidite(vcHumidite.getValeur() + "");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampTexte vcCommentaire = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"commentaire");
                    if (vcCommentaire != null) {
                        synthesePatrouilleReseau.setCommentaire(vcCommentaire.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    ValeurChampCollectionChoixUnique vcPointParticulier = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evt.getValeurNature().getValeurs(), (String)"pointParticulier");
                    if (vcPointParticulier != null) {
                        synthesePatrouilleReseau.setPointParticulier(vcPointParticulier.getValeur());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                retour.add(synthesePatrouilleReseau);
            }
        }
        return retour;
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnInterventionRecente(IBusinessService.VehiculeFiltre filtre) {
        String tableLocalisation = this.businessService.getConfiguration().getString("tableLocalisationVehiculePasBouge", "localisation");
        String req = "SELECT l.id_patrouille,p.debut as debut_patrouille,p.type as code_module_metier,v.immatriculation,v.numero_telephone,axe,pr,abscisse_pr,adresse,l.commune,p.date_visa,p.utilisateur_visa,cch,debit_sel, debit_saumure,largeur_travail,vitesse_vehicule,km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air,emb_sal,emb_sau,temperature_rose,altitude ,  st_transform(coordonnees, 4326) as geom, l.date_heure_loc, c.delegation,c.centre, c.nom, p.equipier, p.id_circuit, p.code_vehicule, m.arret,m.difficulte,mv.icone_vehicule,mv.nom as nom_marque_vehicule,m.mcig_id,p.fin as fin_patrouille, p.parametres,m.telephone  from " + tableLocalisation + " l, utilisateur c, mcig m, patrouille p, vehicule v, marque_vehicule mv WHERE l.id_patrouille = p.id and l.mcig_id = m.mcig_id  and c.id_utilisateur = m.id_utilisateur and p.code_vehicule = v.code  and v.id_marque_vehicule = mv.id  and c.mse = ?  and l.etat_loc = 1 ";
        ArrayList<VehiculeEnIntervention> pps = new ArrayList();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        if (!GLS.estVide((List)filtre.codeModuleMetier)) {
            req = filtre.afficheModulesHerites ? req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))" : req + " AND p.type = ANY(?) ";
        }
        if (filtre.centre != null) {
            req = req + " AND c.centre=?";
        }
        if (filtre.delegation != null) {
            req = req + " AND c.delegation=?";
        }
        req = req + " ORDER BY p.debut desc";
        Log.debug("requette vehicule : " + req);
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            int indexParam = 2;
            if (!GLS.estVide((List)filtre.codeModuleMetier)) {
                Array a = connection.createArrayOf("int", filtre.codeModuleMetier.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
                if (filtre.afficheModulesHerites) {
                    pstm.setArray(indexParam, a);
                    ++indexParam;
                }
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam, filtre.centre);
                ++indexParam;
            }
            if (filtre.delegation != null) {
                pstm.setString(indexParam, filtre.delegation);
                ++indexParam;
            }
            rs = pstm.executeQuery();
            pps = this.parseVehiculesEnIntervention(rs);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre) {
        return this.getVehiculesEnInterventionHistorique(filtre, false);
    }

    private List<VehiculeEnIntervention> parseVehiculesEnIntervention(ResultSet rs) throws SQLException {
        return this.parseVehiculesEnIntervention(rs, true);
    }

    private List<VehiculeEnIntervention> parseVehiculesEnIntervention(ResultSet rs, boolean avecGeometry) throws SQLException {
        ArrayList<VehiculeEnIntervention> pps = new ArrayList<VehiculeEnIntervention>();
        while (rs.next()) {
            boolean difficulte;
            VehiculeEnIntervention v = new VehiculeEnIntervention();
            if (avecGeometry) {
                Point geom = (Point)((PGgeometry)rs.getObject("geom")).getGeometry();
                v.setX(geom.x);
                v.setY(geom.y);
                try {
                    Point geomold = (Point)((PGgeometry)rs.getObject("geomold")).getGeometry();
                    v.setXOld(geomold.x);
                    v.setYOld(geomold.y);
                }
                catch (Exception e) {
                    v.setXOld(-1000.0);
                    v.setYOld(-1000.0);
                }
            }
            v.setIdPatrouille(rs.getString("id_patrouille"));
            v.setIdsPatrouillesAgreg(new ArrayList());
            v.getIdsPatrouillesAgreg().add(v.getIdPatrouille());
            v.setAltitude(rs.getDouble("altitude"));
            if (LocalisationInfo.estLocalisableParPrpk && rs.getObject("pr") != null) {
                int pr = rs.getInt("pr");
                if (pr > -1) {
                    v.setPr(pr);
                    v.setAbspr(rs.getInt("abscisse_pr"));
                }
            } else {
                v.setPr(-1);
                v.setAbspr(-1);
            }
            if (LocalisationInfo.estLocalisableParAdresse && rs.getObject("adresse") != null) {
                v.setAdresse(rs.getString("adresse"));
            }
            v.setIdCircuit(rs.getString("id_circuit"));
            v.setCch(rs.getString("cch"));
            v.setEquipier(rs.getString("equipier"));
            v.setAxe(rs.getString("axe"));
            v.setCommune(rs.getString("commune"));
            v.setDatePosition(rs.getTimestamp("date_heure_loc").getTime());
            v.setDebutPatrouille(rs.getTimestamp("debut_patrouille").getTime());
            Timestamp finPatrouille = rs.getTimestamp("fin_patrouille");
            v.setFinPatrouille(finPatrouille == null ? -1L : finPatrouille.getTime());
            v.setChauffeur(rs.getString("nom"));
            v.setCode(rs.getString("code_vehicule"));
            v.setImmatriculation(rs.getString("immatriculation"));
            v.setTelephone(rs.getString("numero_telephone"));
            if (GLS.estVide((String)v.getTelephone())) {
                try {
                    v.setTelephone(rs.getString("telephone"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            v.setModuleMetier(rs.getInt("code_module_metier"));
            boolean arret = rs.getInt("arret") == 1;
            boolean bl = difficulte = rs.getInt("difficulte") == 1;
            if (finPatrouille == null) {
                v.setEtat(arret ? 1 : (difficulte ? 2 : 0));
            } else {
                v.setEtat(9);
            }
            v.setIconeMarque(rs.getInt("icone_vehicule"));
            v.setNomMarque(rs.getString("nom_marque_vehicule"));
            v.setCentre(rs.getString("centre"));
            v.setDelegation(rs.getString("delegation"));
            v.setMcigId(rs.getString("mcig_id"));
            v.setDebitSel(this.getIntNull(rs, "debit_sel"));
            v.setDebitSaumure(this.getIntNull(rs, "debit_saumure"));
            v.setLargeurTravail(this.getDoubleNull(rs, "largeur_travail"));
            v.setVitesse(this.getIntNull(rs, "vitesse_vehicule"));
            v.setKmParcouru(this.getDoubleNull(rs, "km_parcouru"));
            v.setKmSale(this.getDoubleNull(rs, "km_sale"));
            v.setLameBaissee(this.getIntNull(rs, "position_lame"));
            v.setTemperatureSol(this.getDoubleNull(rs, "temperature_sol"));
            v.setTemperatureAir(this.getDoubleNull(rs, "temperature_air"));
            v.setTemperatureRose(this.getDoubleNull(rs, "temperature_rose"));
            v.setHumiditeAir(this.getDoubleNull(rs, "humidite_air"));
            v.setEmbrayageSaleuse(this.getDoubleNull(rs, "emb_sal"));
            v.setEmbrayageSaumure(this.getDoubleNull(rs, "emb_sau"));
            if (rs.getObject("date_visa") != null) {
                v.setDatePatrouilleVisee(Long.valueOf(rs.getTimestamp("date_visa").getTime()));
            }
            if (rs.getObject("utilisateur_visa") != null) {
                v.setViseePar(rs.getString("utilisateur_visa"));
            }
            try {
                Array array = rs.getArray("parametres");
                if (!rs.wasNull() && array != null) {
                    MapDescription m = MapDescription.newMap();
                    m.add(MapDescription.parse((String[])((String[])array.getArray())));
                    v.setParametres(m);
                }
            }
            catch (Exception e) {
                Log.error("Erreur parametres vehicules intervention", e);
            }
            if (this.conversionCapDistance) {
                try {
                    v.setCap(this.getDoubleNull(rs, "cap"));
                }
                catch (Exception e) {
                    Log.error("Erreur cap manquant", e);
                }
            }
            if (this.wazeActif) {
                if (v.getParametres() != null && GLS.estDansLaListe((String[])ConstantesPrismCommun.TYPE_EXPORT_WAZE_INCIDENTS_MM, (String)("" + v.getModuleMetier()))) {
                    Calendar dateDepartSite;
                    Calendar dateArriveeSite = GLSDate.toDate((String)v.getParametres().getString("dateArriveeSite", null), (DateFormat)GLSDate.formatDateComplete);
                    if (dateArriveeSite == null) {
                        dateArriveeSite = GLSDate.toDate((String)v.getParametres().getString("dateArriveeSite", null), (DateFormat)GLSDate.formatDate);
                    }
                    if ((dateDepartSite = GLSDate.toDate((String)v.getParametres().getString("dateDepartSite", null), (DateFormat)GLSDate.formatDateComplete)) == null) {
                        dateDepartSite = GLSDate.toDate((String)v.getParametres().getString("dateDepartSite", null), (DateFormat)GLSDate.formatDate);
                    }
                    v.setDateArriveeSite(dateArriveeSite);
                    if ((dateArriveeSite != null && dateDepartSite == null || dateArriveeSite != null && dateDepartSite != null && dateArriveeSite.after(dateDepartSite)) && v.getEtat() != 9) {
                        v.setWazeFluxIncidents(true);
                    } else {
                        v.setWazeFluxIncidents(false);
                    }
                }
                if (GLS.estDansLaListe((String[])ConstantesPrismCommun.TYPE_EXPORT_WAZE_ESH_MM, (String)("" + v.getModuleMetier()))) {
                    v.setWazeFluxESH(v.getEtat() != 9);
                }
            }
            pps.add(v);
        }
        return pps;
    }

    private List<VehiculeEnIntervention> parseVehiculesEnInterventionHisto(ResultSet rs) throws SQLException {
        ArrayList<VehiculeEnIntervention> pps = new ArrayList<VehiculeEnIntervention>();
        Vector<String> listeCodeParc = new Vector<String>();
        while (rs.next()) {
            boolean difficulte;
            String codeParc = rs.getString("code_vehicule");
            if (GLS.estDejaParcouru(listeCodeParc, (String)codeParc)) continue;
            listeCodeParc.add(codeParc);
            VehiculeEnIntervention v = new VehiculeEnIntervention();
            Point geom = (Point)((PGgeometry)rs.getObject("geom")).getGeometry();
            v.setX(geom.x);
            v.setY(geom.y);
            v.setIdPatrouille(rs.getString("id_patrouille"));
            v.setIdsPatrouillesAgreg(new ArrayList());
            v.getIdsPatrouillesAgreg().add(v.getIdPatrouille());
            v.setAltitude(rs.getDouble("altitude"));
            if (rs.getObject("pr") != null) {
                v.setPr(rs.getInt("pr"));
                v.setAbspr(rs.getInt("abscisse_pr"));
            } else {
                v.setPr(-1);
                v.setAbspr(-1);
            }
            v.setIdCircuit(rs.getString("id_circuit"));
            v.setCch(rs.getString("cch"));
            v.setEquipier(rs.getString("equipier"));
            v.setAxe(rs.getString("axe"));
            v.setCommune(rs.getString("commune"));
            v.setDatePosition(rs.getTimestamp("date_heure_loc").getTime());
            v.setDebutPatrouille(rs.getTimestamp("debut_patrouille").getTime());
            Timestamp finPatrouille = rs.getTimestamp("fin_patrouille");
            v.setFinPatrouille(finPatrouille == null ? -1L : finPatrouille.getTime());
            v.setChauffeur(rs.getString("nom"));
            v.setCode(rs.getString("code_vehicule"));
            v.setImmatriculation(rs.getString("immatriculation"));
            v.setTelephone(rs.getString("numero_telephone"));
            v.setModuleMetier(rs.getInt("code_module_metier"));
            boolean arret = rs.getInt("arret") == 1;
            boolean bl = difficulte = rs.getInt("difficulte") == 1;
            v.setEtat(arret ? 1 : (difficulte ? 2 : 0));
            v.setIconeMarque(rs.getInt("icone_vehicule"));
            v.setNomMarque(rs.getString("nom_marque_vehicule"));
            v.setCentre(rs.getString("centre"));
            v.setDelegation(rs.getString("delegation"));
            v.setMcigId(rs.getString("mcig_id"));
            v.setDebitSel(this.getIntNull(rs, "debit_sel"));
            v.setDebitSaumure(this.getIntNull(rs, "debit_saumure"));
            v.setLargeurTravail(this.getDoubleNull(rs, "largeur_travail"));
            v.setVitesse(this.getIntNull(rs, "vitesse_vehicule"));
            v.setKmParcouru(this.getDoubleNull(rs, "km_parcouru"));
            v.setKmSale(this.getDoubleNull(rs, "km_sale"));
            v.setLameBaissee(this.getIntNull(rs, "position_lame"));
            v.setTemperatureSol(this.getDoubleNull(rs, "temperature_sol"));
            v.setTemperatureAir(this.getDoubleNull(rs, "temperature_air"));
            v.setHumiditeAir(this.getDoubleNull(rs, "humidite_air"));
            v.setTemperatureRose(this.getDoubleNull(rs, "temperature_rose"));
            v.setEmbrayageSaleuse(this.getDoubleNull(rs, "emb_sal"));
            v.setEmbrayageSaumure(this.getDoubleNull(rs, "emb_sau"));
            pps.add(v);
        }
        return pps;
    }

    private int getIntNull(ResultSet rs, String string) throws SQLException {
        int ret = rs.getInt(string);
        if (rs.wasNull()) {
            ret = -1000;
        }
        return ret;
    }

    private double getDoubleNull(ResultSet rs, String string) throws SQLException {
        double ret = rs.getDouble(string);
        if (rs.wasNull()) {
            ret = -1000.0;
        }
        return ret;
    }

    @Override
    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi, boolean latreralized) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = latreralized ? SQL_VEHICULE_TRAJET_LATERALIZE : SQL_VEHICULE_TRAJET;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode(rs.getString("cch"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setDate(rs.getTimestamp("date"));
                    t.setIdTronconSuivi(rs.getString("id"));
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    if (rs.getObject("idp") != null) {
                        t.setIdPatrouille(rs.getString("idp"));
                    }
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    @Override
    public Collection<TronconSuivi> getTronconsPatrouilles(Set<String> idPatrouilleSuivi) {
        return this.getTronconsPatrouilles(idPatrouilleSuivi, true);
    }

    @Override
    public Collection<TronconSuivi> getTronconsRecents(List<Integer> codeMM) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        String req = SQL_VEHICULE_TRAJET_RECENT;
        if (!GLS.estVide(codeMM)) {
            req = req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))";
        }
        req = req + CLASSEMENT_TRONCONS_RECENTS;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            if (!GLS.estVide(codeMM)) {
                Array a = connection.createArrayOf("int", codeMM.toArray());
                pstm.setArray(1, a);
                pstm.setArray(2, a);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                TronconSuivi t = new TronconSuivi();
                t.setCode(rs.getString("cch"));
                t.setLongueur(rs.getInt("longueur"));
                t.setDateFinValidite(rs.getTimestamp("date_fin"));
                t.setIdTronconSuivi(rs.getString("id"));
                t.setDate(rs.getTimestamp("date"));
                LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                float[][] f = Geometry.getLineToFloat((LineString)geom);
                t.setX(f[0]);
                t.setY(f[1]);
                ts.add(t);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ts;
    }

    @Override
    public Collection<TronconSuivi> getTronconsRecents(List<Integer> codeMM, Timestamp minValidite) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        String req = SQL_VEHICULE_TRAJET_RECENT_AVEC_DATE_VALIDITE;
        if (!GLS.estVide(codeMM)) {
            req = req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))";
        }
        req = req + CLASSEMENT_TRONCONS_RECENTS;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setTimestamp(1, minValidite);
            if (!GLS.estVide(codeMM)) {
                Array a = connection.createArrayOf("int", codeMM.toArray());
                pstm.setArray(2, a);
                pstm.setArray(3, a);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                TronconSuivi t = new TronconSuivi();
                t.setCode(rs.getString("cch"));
                t.setLongueur(rs.getInt("longueur"));
                t.setDateFinValidite(rs.getTimestamp("date_fin"));
                t.setIdTronconSuivi(rs.getString("id"));
                t.setDate(rs.getTimestamp("date"));
                LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                float[][] f = Geometry.getLineToFloat((LineString)geom);
                t.setX(f[0]);
                t.setY(f[1]);
                ts.add(t);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ts;
    }

    public void debutPatrouille(DonneesSynchro d) throws Exception {
        this.debutPatrouille(d, true);
    }

    @Override
    public void debutPatrouille(DonneesSynchro d, boolean ajouterCommentaire) throws Exception {
        String requete = "";
        requete = "insert into patrouille (id,id_circuit,equipier,code_vehicule,type,mcig_id,debut,fin) values (?,?,?,?,?,?,?,?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, d.getMainCourrante().getIdPatrouille());
            pstm.setInt(2, GLS.getInt((String)d.getMainCourrante().getIdCircuit()));
            pstm.setString(3, d.getMainCourrante().getCodeAccompagnateur());
            pstm.setString(4, d.getMainCourrante().getCodeVehicule());
            pstm.setInt(5, d.getMainCourrante().getCodeModuleMetier());
            pstm.setString(6, d.getMainCourrante().getId());
            pstm.setTimestamp(7, new Timestamp(d.getDate()));
            pstm.setNull(8, 93);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (ajouterCommentaire) {
            this.businessService.ajoutCommentaire(d.getMainCourrante(), MetierCommun.genereCommentaire((String)this.genereCommentaireDebutPatrouille(d), (long)d.getDate(), null, (int)-1));
        }
        if (d.getParametres() != null && !d.getParametres().isEmpty()) {
            this.miseAJourParametresPatrouille(d);
        }
    }

    @Override
    public void reprisePatrouille(DonneesSynchro d, boolean ajouterCommentaire) {
        String requete = "";
        requete = "update patrouille set fin = null where id = ? and not fin is null";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, d.getMainCourrante().getIdPatrouille());
            pstm.execute();
            if (ajouterCommentaire) {
                String commentaire = this.genereCommentaireReprisePatrouille(d);
                this.businessService.ajoutCommentaire(d.getMainCourrante(), MetierCommun.genereCommentaire((String)commentaire, (long)d.getDate(), null, (int)-1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public MapDescription getParametresPatrouille(String idPatrouille) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        MapDescription m = MapDescription.newMap();
        if (idPatrouille != null) {
            block5: {
                String req = "select parametres from prism.patrouille where id = ?";
                try {
                    Array array;
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(req, 1004, 1007);
                    pstm.setString(1, idPatrouille);
                    rs = pstm.executeQuery();
                    if (!rs.first() || (array = rs.getArray("parametres")) == null) break block5;
                    m.add(MapDescription.parse((String[])((String[])array.getArray())));
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, rs);
                        throw throwable;
                    }
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return m;
    }

    @Override
    public MapDescription miseAJourParametresPatrouille(DonneesSynchro d) {
        MapDescription m;
        block23: {
            block22: {
                String dateFin;
                String dateDebut;
                boolean debut = false;
                boolean fin = false;
                if (d.getParametres() == null || d.getParametres().isEmpty()) break block22;
                m = this.getParametresPatrouille(d.getMainCourrante().getIdPatrouille());
                m.add(d.getParametres());
                String requete = "";
                requete = "update patrouille set parametres = ?";
                long dateDebutLong = -1L;
                long dateFinLong = -1L;
                if (m.containsKey("dateAppel")) {
                    try {
                        requete = requete + ", debut = ?";
                        dateDebut = m.getString("dateAppel", "");
                        Log.debug("Mise \u00e0 jour date d\u00e9but activit\u00e9 " + d.getMainCourrante().getIdPatrouille() + " " + dateDebut);
                        GLS.getDate();
                        dateDebutLong = GLSDate.toDateEnMilliseconde((String)dateDebut);
                        debut = true;
                    }
                    catch (Exception e) {
                        Log.error("Erreur mise jour date debut activit\u00e9 1 ", e);
                    }
                }
                if (m.containsKey("dateFinActivite")) {
                    try {
                        requete = requete + ", fin = ?";
                        dateFin = m.getString("dateFinActivite", "");
                        Log.debug("Mise \u00e0 jour date fin activit\u00e9 1 " + d.getMainCourrante().getIdPatrouille() + " " + dateFin);
                        GLS.getDate();
                        dateFinLong = GLSDate.toDateEnMilliseconde((String)dateFin);
                        fin = true;
                    }
                    catch (Exception e) {
                        Log.error("Erreur mise jour date fin activit\u00e9 1 ", e);
                        fin = false;
                    }
                }
                if (!debut && m.containsKey("hda")) {
                    try {
                        requete = requete + ", debut = ?";
                        dateDebut = m.getString("hda", "");
                        if (!GLS.estVide((String)dateDebut)) {
                            Log.debug("Mise \u00e0 jour date d\u00e9but activit\u00e9 2 " + d.getMainCourrante().getIdPatrouille() + " " + dateDebut);
                            GLS.getDate();
                            dateDebutLong = GLSDate.toDateEnMilliseconde((String)dateDebut);
                            debut = true;
                        } else {
                            Log.error("Mise \u00e0 jour date d\u00e9but activit\u00e9 2 -- date vide");
                        }
                    }
                    catch (Exception e) {
                        Log.error("Erreur mise jour date debut activit\u00e9 2 ", e);
                        debut = false;
                    }
                }
                if (!fin && m.containsKey("hfa")) {
                    try {
                        requete = requete + ", fin = ?";
                        dateFin = m.getString("hfa", "");
                        if (!GLS.estVide((String)dateFin)) {
                            Log.debug("Mise \u00e0 jour date fin activit\u00e9 2 " + d.getMainCourrante().getIdPatrouille() + " " + dateFin);
                            GLS.getDate();
                            dateFinLong = GLSDate.toDateEnMilliseconde((String)dateFin);
                            fin = true;
                        } else {
                            Log.error("Mise \u00e0 jour date fin activit\u00e9 2 -- date vide");
                        }
                    }
                    catch (Exception e) {
                        Log.error("Erreur mise jour date fin activit\u00e9 2 ", e);
                        fin = false;
                    }
                }
                requete = requete + " where id = ?";
                Connection connection = null;
                PreparedStatement pstm = null;
                ResultSet rs = null;
                try {
                    int i = 1;
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(requete);
                    pstm.setArray(i++, connection.createArrayOf("text", m.valuesOf()));
                    if (debut) {
                        pstm.setTimestamp(i++, new Timestamp(dateDebutLong));
                    }
                    if (fin) {
                        pstm.setTimestamp(i++, new Timestamp(dateFinLong));
                    }
                    pstm.setString(i++, d.getMainCourrante().getIdPatrouille());
                    Log.debug("Mise \u00e0 jour param\u00e8tres patrouille " + pstm);
                    pstm.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, rs);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, rs);
                break block23;
            }
            m = null;
        }
        return m;
    }

    @Override
    public void finPatrouille(DonneesSynchro d, boolean ajouterCommentaire) {
        String requete = "";
        requete = "update patrouille set fin = ? where mcig_id = ? and fin is null";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, new Timestamp(d.getDate()));
            pstm.setString(2, d.getMainCourrante().getId());
            pstm.execute();
            if (ajouterCommentaire) {
                String commentaire = this.genereCommentaireFinPatrouille(d);
                this.businessService.ajoutCommentaire(d.getMainCourrante(), MetierCommun.genereCommentaire((String)commentaire, (long)d.getDate(), null, (int)-1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (d.getParametres() != null && !d.getParametres().isEmpty()) {
            MapDescription m = this.miseAJourParametresPatrouille(d);
            try {
                if (d.getMainCourrante().getCodeModuleMetier() == 5 && d.getParametres().containsKey(MetierCommun.getChampAgentInterventionArriveeDomicile())) {
                    this.businessService.arriveeDomicile(this.businessService.getUtilisateur(d.getMainCourrante().getCodeUtilisateur()), m);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void pausePatrouille(DonneesSynchro d, boolean ajouterCommentaire) {
        String requete = "";
        requete = "update patrouille set fin = ? where mcig_id = ? and fin is null";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, new Timestamp(d.getDate()));
            pstm.setString(2, d.getMainCourrante().getId());
            pstm.execute();
            if (ajouterCommentaire) {
                String commentaire = this.genereCommentairePausePatrouille(d);
                this.businessService.ajoutCommentaire(d.getMainCourrante(), MetierCommun.genereCommentaire((String)commentaire, (long)d.getDate(), null, (int)-1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (d.getParametres() != null && !d.getParametres().isEmpty()) {
            this.miseAJourParametresPatrouille(d);
        }
    }

    private String genereCommentaireDebutPatrouille(DonneesSynchro d) {
        List autresVehicules;
        StringBuffer texte = new StringBuffer();
        Circuit c = (Circuit)this.businessService.getListeCircuit().get(d.getMainCourrante().getIdCircuit());
        String libelle = ((ModuleMetier)this.businessService.getModulesMetiers().get(d.getMainCourrante().getCodeModuleMetier())).getLibelle();
        texte.append(PrismI18n.getString("commentaire.debutActivite") + " : " + libelle);
        if (!(c == null || GLS.estVide((String)c.getNom()) || GLS.egal((String)c.getNom(), (String)PrismI18n.getString("commentaire.sansCircuit")) || c.isArchive() || GLS.egal((String)c.getId(), (String)"0"))) {
            texte.append(" " + PrismI18n.getString("commentaire.surCircuit") + " " + c.getNom());
        }
        if (!GLS.estVide((String)d.getMainCourrante().getCodeVehicule())) {
            texte.append(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE);
            texte.append(PrismI18n.getString("commentaire.vehicule"));
            texte.append(" : ");
            try {
                int i = MetierCommun.getIndiceObjetListe((List)this.businessService.getListeVehicule(), (Object)d.getMainCourrante().getCodeVehicule());
                if (i == -1) {
                    texte.append(d.getMainCourrante().getCodeVehicule());
                } else {
                    texte.append(this.businessService.getListeVehicule().get(i));
                }
            }
            catch (Exception e) {
                texte.append(d.getMainCourrante().getCodeVehicule());
            }
        }
        if (!GLS.estVide((List)(autresVehicules = MetierCommun.getChampsAutresVehicule((Map)d.getParametres())))) {
            texte.append(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE);
            texte.append(PrismI18n.getString("commentaire.autreVehicule"));
            texte.append(" : ");
            ArrayList<String> l = new ArrayList<String>();
            for (String v : autresVehicules) {
                try {
                    int i = MetierCommun.getIndiceObjetListe((List)this.businessService.getListeVehicule(), (Object)v);
                    if (i == -1) {
                        l.add(v);
                        continue;
                    }
                    l.add(((Vehicule)this.businessService.getListeVehicule().get(i)).toString());
                }
                catch (Exception e) {
                    l.add(v);
                }
            }
            texte.append(MetierCommun.getString(l, (String)", "));
        }
        if (!GLS.estVide((String)d.getMainCourrante().getCodeAccompagnateur())) {
            texte.append(McigDAOJDBC.CHAR_SEPARATEUR_COMMENTAIRE);
            texte.append(PrismI18n.getString("commentaire.equipier"));
            texte.append(" : ");
            texte.append(d.getMainCourrante().getCodeAccompagnateur());
        }
        return texte.toString();
    }

    private String genereCommentaireFinPatrouille(DonneesSynchro d) {
        StringBuffer texte = new StringBuffer();
        ModuleMetier mm = (ModuleMetier)this.businessService.getModulesMetiers().get(d.getMainCourrante().getCodeModuleMetier());
        String libelle = mm.getLibelle();
        String bilanActivite = this.genereCommentaireBilanActivite(this.getTronconsBilanActivite(mm.getNom(), d.getMainCourrante().getIdPatrouille()));
        if (!GLS.estVide((String)bilanActivite)) {
            texte.append(bilanActivite);
        }
        texte.append(PrismI18n.getString("commentaire.finActivite") + " : " + libelle);
        return texte.toString();
    }

    private String genereCommentaireBilanActivite(List<Troncon> troncons) {
        StringBuffer texte = new StringBuffer();
        if (!GLS.estVide(troncons)) {
            Log.debug("Troncons bilan fin activit\u00e9 " + troncons.size());
            texte.append(PrismI18n.getString("commentaire.finActivite.bilanLineaire"));
            for (Troncon t : troncons) {
                if (GLS.estVide((String)t.getAxe())) continue;
                texte.append(t.getClassification() + " - " + t.getAxe() + " DU PR" + t.getPrDebut() + "+" + t.getAbscissePrDebut() + " AU PR" + t.getPrFin() + "+" + t.getAbscissePrFin());
                texte.append("\u00a7");
            }
        } else {
            Log.debug("Aucun trconcon bilan fin activit\u00e9 ");
        }
        return texte.toString();
    }

    private List<Troncon> getTronconsBilanActivite(String codeModuleMetier, String idPatrouille) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        if (this.businessService.getConfiguration().getBoolean("mct.bilanLineaire", false)) {
            Log.debug("Bilan fin patrouille activ\u00e9");
            String[] listeMmBilan = this.businessService.getConfiguration().getTableauString("mct.bilanLineaire.mm", ConstantesPrismCommun.CONFIG_MCT_BILAN_LINEAIRE_ACTIVITE_MM_DEFAUT);
            String[] listeCchBilan = this.businessService.getConfiguration().getTableauString("mct.bilanLineaire.cch".concat(".").concat(codeModuleMetier), null);
            Log.debug("Bilan fin patrouille activ\u00e9 mm + " + GLS.getString((String[])listeMmBilan) + " - cch " + GLS.getString((String[])listeCchBilan));
            if (MetierCommun.estDedans((String[])listeMmBilan, (Object)codeModuleMetier)) {
                for (Troncon troncon : this.daoFactory.getStatsDAO().getRoadsAmplitude(idPatrouille)) {
                    if (!GLS.estVide((String[])listeCchBilan) && !MetierCommun.estDedans((String[])listeCchBilan, (Object)troncon.getClassification())) continue;
                    troncons.add(troncon);
                }
            }
        }
        return troncons;
    }

    private String genereCommentairePausePatrouille(DonneesSynchro d) {
        StringBuffer texte = new StringBuffer();
        String libelle = ((ModuleMetier)this.businessService.getModulesMetiers().get(d.getMainCourrante().getCodeModuleMetier())).getLibelle();
        texte.append(PrismI18n.getString("commentaire.pauseActivite") + " : " + libelle);
        return texte.toString();
    }

    private String genereCommentaireReprisePatrouille(DonneesSynchro d) {
        StringBuffer texte = new StringBuffer();
        String libelle = ((ModuleMetier)this.businessService.getModulesMetiers().get(d.getMainCourrante().getCodeModuleMetier())).getLibelle();
        texte.append(PrismI18n.getString("commentaire.repriseActivite") + " : " + libelle);
        return texte.toString();
    }

    @Override
    public void updateVehiculesEnDifficultes() {
        if (this.businessService.getConfiguration().getBoolean("gestionVehiculeDifficulte", false)) {
            MailService mailService = new MailService(this.businessService, new ExportService(this.businessService));
            long dureeMaxInactivite = this.businessService.getConfiguration().getInt("dureeMaxInactiviteVehicule", 60);
            long dureeMaxSuppressionVehicule = this.businessService.getConfiguration().getInt("dureeMaxSuppressionVehicule", 180);
            String[] listeMm = this.businessService.getConfiguration().getTableauString("gestionVehiculeDifficulte.mm", null);
            Log.info("V\u00e9rification des v\u00e9hicules en difficult\u00e9 - Max inactivit\u00e9 (mn) = " + dureeMaxInactivite + " - Max suppression v\u00e9hicule (mn) = " + dureeMaxSuppressionVehicule + " -- [LISTE MM" + listeMm + "]");
            IBusinessService.VehiculeFiltre f = IBusinessService.VehiculeFiltre.encours();
            if (!GLS.estVide((String[])listeMm)) {
                for (String mm : listeMm) {
                    f.ajouterCodeMm(GLS.getInt((String)mm));
                }
            }
            List<VehiculeEnIntervention> vehicules = this.getVehiculesEnIntervention(f);
            long now = System.currentTimeMillis();
            long ageMax = dureeMaxInactivite * 60L * 1000L;
            long ageObsolete = dureeMaxSuppressionVehicule * 60L * 1000L;
            for (VehiculeEnIntervention v : vehicules) {
                boolean enDifficulte = false;
                long age = now - v.getDatePosition();
                if (age > ageObsolete) {
                    this.setVehiculeObsolete(v);
                } else if (age > ageMax) {
                    enDifficulte = true;
                    if (v.getEtat() != 2) {
                        mailService.vehiculeEnDiffuculte(v);
                    }
                    Log.debug("vehicule inactif ! " + v.getCode());
                } else if (v.getEtat() != 1 && this.pasBougeDepuisDelais(v)) {
                    if (v.getEtat() == 0) {
                        Log.debug("nouveau v\u00e9hicule en difficult\u00e9" + v.getCode());
                        enDifficulte = true;
                        mailService.vehiculeEnDiffuculte(v);
                    } else {
                        Log.debug("v\u00e9hicule reste en difficult\u00e9" + v.getCode());
                        enDifficulte = true;
                    }
                }
                this.setVehiculeEnDifficulte(v, enDifficulte);
            }
        } else {
            Log.debug("gestion vehicule difficulte desactiv\u00e9e");
        }
    }

    private boolean pasBougeDepuisDelais(VehiculeEnIntervention v) {
        boolean ret;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            int distanceMaxImmobilisation = this.businessService.getConfiguration().getInt("distanceMaxImmobilisationVehicule", 100);
            long dureeMaxImmobilisation = this.businessService.getConfiguration().getInt("dureeMaxImmobilisationVehicule", 15);
            long dateLimite = v.getDatePosition() - dureeMaxImmobilisation * 1000L * 60L;
            Log.debug("V\u00e9rification v\u00e9hicule en difficult\u00e9 - Distance max immobilisation (m) = " + distanceMaxImmobilisation + " - Dur\u00e9e max immobilisation (mn) = " + dureeMaxImmobilisation);
            String tableLocalisation = this.businessService.getConfiguration().getString("tableLocalisationVehiculePasBouge", "localisation");
            String req = "SELECT date_heure_loc,st_distance(coordonnees,st_transform(st_geomfromtext(?,4326),?)) as dist FROM " + tableLocalisation + " WHERE id_patrouille=? AND date_heure_loc <= ? ORDER BY date_heure_loc DESC LIMIT 1";
            connection = null;
            pstm = null;
            rs = null;
            ret = false;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, "POINT(" + v.getX() + " " + v.getY() + ")");
                pstm.setInt(2, ConfigurationFactory.getInstance().getInt("bdd.projection"));
                pstm.setString(3, v.getIdPatrouille());
                pstm.setTimestamp(4, new Timestamp(dateLimite));
                long d1 = System.currentTimeMillis();
                rs = pstm.executeQuery();
                long d2 = System.currentTimeMillis();
                Log.debug("Pas boug\u00e9 " + (d2 - d1) + " ms - " + pstm.toString());
                if (rs.next()) {
                    ret = rs.getDouble("dist") < (double)distanceMaxImmobilisation;
                    Log.debug("position trouv\u00e9e. Distance parcourue : " + rs.getDouble("dist") + " - Max immobilisation : " + distanceMaxImmobilisation);
                    break block6;
                }
                Log.debug("pas de position trouv\u00e9e avant la date");
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (ret) {
            Log.debug("Le v\u00e9hicule n'a pas boug\u00e9 depuis longtemps : " + v.getCode());
        }
        return ret;
    }

    private void setVehiculeEnDifficulte(VehiculeEnIntervention v, boolean etat) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("UPDATE prism.mcig SET difficulte=?,arret=? WHERE mcig_id=?");
            pstm.setInt(1, etat ? 1 : 0);
            int arret = etat ? 0 : (v.getEtat() == 1 ? 1 : 0);
            pstm.setInt(2, arret);
            pstm.setString(3, v.getMcigId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    private void setVehiculeObsolete(VehiculeEnIntervention v) {
        this.desactiverPosition(v.getMcigId());
    }

    @Override
    public void desactiverPosition(String mcigId) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("UPDATE prism.localisation SET etat_loc=0 WHERE etat_loc = 1 and mcig_id=?");
            pstm.setString(1, mcigId);
            pstm.execute();
            Log.info("Position v\u00e9hicule (mcig : " + mcigId + ") obsol\u00e8te");
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    public Collection<PGobject> getTronconsPatrouillesPGObject(Set<String> idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<PGobject> ts = new ArrayList<PGobject>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = SQL_VEHICULE_TRAJET;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode(rs.getString("cch"));
                    t.setDate(rs.getTimestamp("date"));
                    ts.add((PGobject)rs.getObject("coord"));
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, Date dateHisto) {
        ArrayList<VehiculeEnIntervention> pps = new ArrayList();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String tableLocalisation = this.businessService.getConfiguration().getString("tableLocalisationVehiculePasBouge", "localisation");
        String req = "SELECT commune, axe,pr,abscisse_pr,cch,debit_sel, debit_saumure,largeur_travail,vitesse_vehicule,km_parcouru, km_sale, position_lame, temperature_sol, temperature_air, humidite_air,altitude ,  coordonnees as geom,  l.date_heure_loc, c.delegation, c.nom, p.equipier, p.code_vehicule, m.arret,  p.debut as debut_patrouille, p.fin as fin_patrouille,  p.id_circuit, p.id as id_patrouille, v.immatriculation,v.numero_telephone,p.type as code_module_metier,m.difficulte,m.telephone  mv.icone_vehicule,mv.nom as nom_marque_vehicule,  c.centre,c.delegation, l.debit_sel, l.debit_saumure,l.largeur_travail, l.vitesse_vehicule,l.km_parcouru,l.km_sale,l.position_lame,l.temperature_sol,l.temperature_air,l.humidite_air,  m.mcig_id  from localisation l, utilisateur c, mcig m, patrouille p, vehicule v, marque_vehicule mv WHERE l.id_patrouille = p.id and l.mcig_id = m.mcig_id  and c.id_utilisateur = m.id_utilisateur and p.code_vehicule = v.code  and v.id_marque_vehicule = mv.id  and c.mse = ?  AND ((l.etat_loc = 1) OR  (l.id_patrouille = p.id and (p.code_vehicule, l.date_heure_loc) in ( SELECT distinct(p.code_vehicule), max(date_heure_loc) from " + tableLocalisation + " l, patrouille p where etat_loc = 0  \tand p.id = l.id_patrouille ";
        if (!GLS.estVide((List)filtre.codeModuleMetier)) {
            req = filtre.afficheModulesHerites ? req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))" : req + " AND p.type = ANY(?) ";
        }
        req = dateHisto == null ? req + " \tand  p.code_vehicule not in (select code_vehicule from patrouille p1, localisation l1 where p1.id = l1.id_patrouille and l1.etat_loc = 1)" : req + " and l.date_heure_loc <=  ? ";
        req = req + " \tand l.date_heure_loc >  (CAST(? as timestamp) -  CAST(textcat(text((select valeur from prism.configuration where champ = 'tempsValiditeInformationVehicule'  and zone_routiere = ? )), text(' hours')) as interval)) GROUP by code_vehicule)))";
        req = req + " order by p.debut desc";
        Log.debug("requette vehicule : " + req);
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            int indexParam = 2;
            if (!GLS.estVide((List)filtre.codeModuleMetier)) {
                Array a = connection.createArrayOf("int", filtre.codeModuleMetier.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
                if (filtre.afficheModulesHerites) {
                    pstm.setArray(indexParam, a);
                    ++indexParam;
                }
            }
            if (dateHisto == null) {
                pstm.setTimestamp(indexParam, new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
                pstm.setString(++indexParam, ConfigurationFactory.getInstance().get("zoneroutiere"));
                ++indexParam;
            } else {
                pstm.setTimestamp(indexParam, new Timestamp(dateHisto.getTime()));
                pstm.setTimestamp(++indexParam, new Timestamp(dateHisto.getTime()));
                pstm.setString(++indexParam, ConfigurationFactory.getInstance().get("zoneroutiere"));
                ++indexParam;
            }
            rs = pstm.executeQuery();
            pps = this.parseVehiculesEnInterventionHisto(rs);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    @Override
    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules) {
        return this.getTronconsCompletsPatrouilles(codeVehicules, null);
    }

    @Override
    public Vector<TronconSuiviComplet> getTronconsCompletsPatrouilles(List<String> codeVehicules, Date dateHisto) {
        Vector<TronconSuiviComplet> listeEvenements = new Vector<TronconSuiviComplet>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        StringBuffer listeVehicule = new StringBuffer("");
        if (codeVehicules != null && codeVehicules.size() > 0) {
            boolean first = true;
            listeVehicule.append(" and p.code_vehicule in (");
            for (String codeV : codeVehicules) {
                if (!first) {
                    listeVehicule.append(",");
                } else {
                    first = false;
                }
                listeVehicule.append("'");
                listeVehicule.append(codeV);
                listeVehicule.append("'");
            }
            listeVehicule.append(") ");
        }
        String requete = "SELECT vh.evenement_vh.id,vh.evenement_vh.date,vh.evenement_vh.date_fin,vh.evenement_vh.cch,vh.evenement_vh.axe,vh.evenement_vh.prDebut,vh.evenement_vh.prFin,vh.evenement_vh.abscissePrDebut,vh.evenement_vh.abscissePrFin,  vh.evenement_vh.etat,vh.evenement_vh.longueur,vh.evenement_vh.sens,vh.evenement_vh.mcig_id,vh.evenement_vh.zone_routiere,vh.evenement_vh.id_circuit,vh.evenement_vh.indice,vh.evenement_vh.seuil_salage,vh.evenement_vh.deneigement,  vh.evenement_vh.id_patrouille,vh.evenement_vh.coordonnees, vh.evenement_vh.coordonnees as coordonneesBis FROM vh.evenement_vh, patrouille p  WHERE ";
        requete = dateHisto == null ? requete + "vh.evenement_vh.etat >= 1 AND p.id = vh.evenement_vh.id_patrouille " + listeVehicule.toString() + " and vh.evenement_vh.date  >  (now() -  interval '12 hour') " : requete + " p.id = vh.evenement_vh.id_patrouille " + listeVehicule.toString() + " and vh.evenement_vh.date  >  (CAST(? as timestamp) -  interval '12 hour')  and vh.evenement_vh.date  <=  ? ";
        requete = requete + " ORDER BY vh.evenement_vh.date asc";
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            if (dateHisto != null) {
                pstm.setTimestamp(1, new Timestamp(dateHisto.getTime()));
                pstm.setTimestamp(2, new Timestamp(dateHisto.getTime()));
            }
            rs = pstm.executeQuery();
            String CHAMP_ID = "id";
            String CHAMP_DATE = "date";
            String CHAMP_DATE_FIN = "date_fin";
            String CHAMP_AXE = "axe";
            String CHAMP_PR_DEBUT = "prDebut";
            String CHAMP_PR_FIN = "prFin";
            String CHAMP_ABSCISSE_PR_DEBUT = "abscissePrDebut";
            String CHAMP_ABSCISSE_PR_FIN = "abscissePrFin";
            String CHAMP_SENS = "sens";
            String CHAMP_CCH = "cch";
            String CHAMP_LONGUEUR = "longueur";
            String CHAMP_ZONE_ROUTIERE = "zone_routiere";
            String CHAMP_MCIG = "mcig_id";
            String CHAMP_ETAT = "etat";
            String CHAMP_ID_CIRCUIT = "id_circuit";
            String CHAMP_SEUIL_SALAGE = "seuil_salage";
            String CHAMP_DENEIGEMENT = "deneigement";
            String CHAMP_INDICE = "indice";
            String CHAMP_ID_PATROUILLE = "id_patrouille";
            while (rs.next()) {
                TronconSuiviComplet evenement = new TronconSuiviComplet();
                if (rs.getObject(CHAMP_DATE) != null) {
                    evenement.setDateDebut(rs.getTimestamp(CHAMP_DATE).getTime());
                }
                if (rs.getObject(CHAMP_DATE_FIN) != null) {
                    evenement.setDateFin(rs.getTimestamp(CHAMP_DATE_FIN).getTime());
                }
                evenement.setCch(rs.getString(CHAMP_CCH));
                if (rs.getObject(CHAMP_PR_DEBUT) != null) {
                    evenement.setPrDebut(rs.getInt(CHAMP_PR_DEBUT));
                }
                evenement.setId(rs.getString(CHAMP_ID));
                evenement.setAxe(rs.getString(CHAMP_AXE));
                if (rs.getObject(CHAMP_PR_FIN) != null) {
                    evenement.setPrFin(rs.getInt(CHAMP_PR_FIN));
                }
                if (rs.getObject(CHAMP_ABSCISSE_PR_DEBUT) != null) {
                    evenement.setDistancePrDebut((long)rs.getInt(CHAMP_ABSCISSE_PR_DEBUT));
                }
                if (rs.getObject(CHAMP_ABSCISSE_PR_FIN) != null) {
                    evenement.setDistancePrFin((long)rs.getInt(CHAMP_ABSCISSE_PR_FIN));
                }
                if (rs.getObject(CHAMP_ETAT) != null) {
                    evenement.setEtat(rs.getInt(CHAMP_ETAT));
                }
                evenement.setLongueur(rs.getInt(CHAMP_LONGUEUR));
                if (rs.getObject(CHAMP_SENS) != null) {
                    evenement.setSens(rs.getInt(CHAMP_SENS));
                }
                evenement.setMcig(rs.getString(CHAMP_MCIG));
                evenement.setZoneRoutiere(rs.getString(CHAMP_ZONE_ROUTIERE));
                if (rs.getObject(CHAMP_ID_CIRCUIT) != null) {
                    evenement.setIdCircuit(rs.getInt(CHAMP_ID_CIRCUIT));
                }
                if (rs.getObject(CHAMP_INDICE) != null) {
                    evenement.setIndice(rs.getInt(CHAMP_INDICE));
                }
                if (rs.getObject(CHAMP_SEUIL_SALAGE) != null) {
                    evenement.setSeuilSalage(rs.getInt(CHAMP_SEUIL_SALAGE));
                }
                if (rs.getObject(CHAMP_DENEIGEMENT) != null) {
                    evenement.setDeneigement(rs.getInt(CHAMP_DENEIGEMENT));
                }
                evenement.setIdPatrouille(rs.getString(CHAMP_ID_PATROUILLE));
                evenement.setCoordonnees(Geometry.getPointsToString((LineString)SQL.getChampGeometryLine((Object)rs.getObject("coordonneesBis"))));
                listeEvenements.add(evenement);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return listeEvenements;
    }

    @Override
    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null) {
            String req = SQL_VEHICULE_TRAJET_SEUL;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, idPatrouilleSuivi);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode(rs.getString("cch"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setDate(rs.getTimestamp("date"));
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    @Override
    public Collection<TronconSuivi> getTronconPatrouille(String idPatrouilleSuivi, boolean lateralize) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null) {
            String req = lateralize ? SQL_VEHICULE_TRAJET_SEUL : SQL_VEHICULE_TRAJET_SEUL_NO_LATERALIZE;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, idPatrouilleSuivi);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode(rs.getString("cch"));
                    t.setDate(rs.getTimestamp("date"));
                    t.setLongueur(rs.getInt("longueur"));
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    @Override
    public Localisation getLocalisationPatrouille(String mcig_id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Localisation loc = new Localisation();
        if (mcig_id != null) {
            String req = SQL_LOCALISATION_PATROUILLE;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, mcig_id);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Point geom = (Point)((PGgeometry)rs.getObject("coordonnees")).getGeometry();
                    loc.addCoordonnees(geom.x, geom.y);
                    loc.setDateHeureLoc(rs.getTimestamp("date_heure_loc"));
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return loc;
    }

    @Override
    public Map<String, Integer> getLongueurPatrouilleParConditionConduites(IBusinessService.VehiculeFiltre filtre) {
        HashMap<String, Integer> retour = new HashMap<String, Integer>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_LONGUEUR_CONDITION_CONDUITE_HISTORIQUE_DEBUT;
        if (!GLS.estVide((List)filtre.codeModuleMetier)) {
            req = req + " AND p.type=ANY(?)";
        }
        if (filtre.centre != null) {
            req = req + " AND u.centre=?";
        }
        if (filtre.delegation != null) {
            req = req + " AND u.delegation=?";
        }
        req = req + SQL_LONGUEUR_CONDITION_CONDUITE_HISTORIQUE_FIN;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            pstm.setTimestamp(2, filtre.dateMin);
            pstm.setTimestamp(3, filtre.dateMax);
            int indexParam = 4;
            if (!GLS.estVide((List)filtre.codeModuleMetier)) {
                Array a = connection.createArrayOf("int", filtre.codeModuleMetier.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam, filtre.centre);
                ++indexParam;
            }
            if (filtre.delegation != null) {
                pstm.setString(indexParam, filtre.delegation);
                ++indexParam;
            }
            Log.debug("requette vehicule : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                retour.put(rs.getString("cch"), rs.getInt("longueur"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<ActivitePeriode> getActivitesPatrouille(String idPatrouille) {
        ArrayList<ActivitePeriode> activitesPeriode = new ArrayList<ActivitePeriode>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_ACTIVITES_PATROUILLES;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            Log.debug("ACTIVITES PAR PERIODE -- " + pstm.toString());
            while (rs.next()) {
                ActivitePeriode act = new ActivitePeriode();
                act.setCode(rs.getString("cch"));
                act.setLongueur(rs.getInt("longueur"));
                act.setDebut(rs.getTimestamp("date").getTime());
                act.setFin(rs.getTimestamp("date_fin").getTime());
                activitesPeriode.add(act);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return activitesPeriode;
    }

    @Override
    public List<LocalisationDonneesSaleuse> getLocalisationDonneesSaleusePatrouille(String idPatrouille) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<LocalisationDonneesSaleuse> listeLocalisation = new ArrayList<LocalisationDonneesSaleuse>();
        if (idPatrouille != null) {
            String req = SQL_LOCALISATION_DONNEES_SALEUSE;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, idPatrouille);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    LocalisationDonneesSaleuse loc = new LocalisationDonneesSaleuse();
                    Point geom = (Point)((PGgeometry)rs.getObject("coord")).getGeometry();
                    loc.addCoordonnees(geom.x, geom.y);
                    try {
                        loc.setAxe(rs.getString("axe"));
                        loc.setPr(GLS.getString((Object)rs.getObject("pr")));
                        loc.setAbs(GLS.getString((Object)rs.getObject("abscisse_pr")));
                        loc.setCommune(rs.getString("commune"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    loc.setCch(rs.getString("cch"));
                    loc.setDateHeureLoc(rs.getTimestamp("date_heure_loc"));
                    loc.setDebitSel(this.getIntNull(rs, "debit_sel"));
                    loc.setDebitSaumure(this.getIntNull(rs, "debit_saumure"));
                    loc.setLargeurTravail((float)this.getDoubleNull(rs, "largeur_travail"));
                    loc.setKmParcouru((float)this.getDoubleNull(rs, "km_parcouru"));
                    loc.setKmSale((float)this.getDoubleNull(rs, "km_sale"));
                    loc.setTemperatureAir((float)this.getDoubleNull(rs, "temperature_air"));
                    loc.setTemperatureSol((float)this.getDoubleNull(rs, "temperature_sol"));
                    loc.setTauxHumidite((float)this.getDoubleNull(rs, "humidite_air"));
                    loc.setLameBaissee(this.getIntNull(rs, "position_lame"));
                    loc.setTemperaturePointRose((float)this.getDoubleNull(rs, "temperature_rose"));
                    loc.setEmbrayageSaleuse((int)this.getDoubleNull(rs, "emb_sal"));
                    loc.setEmbrayageSaumure((int)this.getDoubleNull(rs, "emb_sau"));
                    listeLocalisation.add(loc);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return listeLocalisation;
    }

    public static String getChampGeometryPoint(PositionGPS positionGPS, int epsg) {
        if (positionGPS != null) {
            return VehiculeDAOJDBC.getChampGeometryPoint(positionGPS.getX(), positionGPS.getY(), epsg);
        }
        return "null";
    }

    public static String getChampGeometryPoint(double x, double y, int epsg) {
        return "GeometryFromText('POINT(" + x + " " + y + ")'," + epsg + ")";
    }

    public void inactivationPosition(String idMainCourante) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        if (idMainCourante != null) {
            try {
                connection = this.daoFactory.getConnection();
                String tableLocalisation = this.businessService.getConfiguration().getString("tableLocalisationVehiculePasBouge", "localisation");
                String requete = "update " + tableLocalisation + " set etat_loc = 0 where etat_loc = 1 AND mcig_id = ?";
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, idMainCourante);
                Log.debug(pstm);
                rs = pstm.executeQuery();
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void insertPosition(DonneesSynchro d, ValeurChampLocalisation v, int etat) {
        PositionGPS positionGPS;
        try {
            positionGPS = Util.conversionPosition(d, v, null);
        }
        catch (Exception e) {
            positionGPS = null;
        }
        try {
            this.inactivationPosition(d.getMainCourrante().getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        DonneesSaleuse donneesSaleuse = positionGPS.getDonneesSaleuse();
        String requete = donneesSaleuse == null ? "insert into localisation (ID,COORDONNEES, DATE_HEURE_LOC, ETAT_LOC, MCIG_ID,TYPE,AXE,PR,ABSCISSE_PR,SENS_PR,ADRESSE,COMMUNE,CCH,ALTITUDE,ID_PATROUILLE) values (" + SQL.getStringSQL((String)positionGPS.getId()) + "," + VehiculeDAOJDBC.getChampGeometryPoint(positionGPS, 4326) + ", to_timestamp('" + positionGPS.getDate() + "', 'YYYYMMDDHH24MISS'), " + etat + ", '" + positionGPS.getMcig() + "'," + positionGPS.getType() + "," + SQL.getStringSQL((String)positionGPS.getAxe()) + "," + SQL.getIntSQL((int)positionGPS.getPr()) + "," + SQL.getIntSQL((int)positionGPS.getAbscissePr()) + "," + SQL.getIntSQL((int)positionGPS.getSensPr()) + "," + SQL.getIntSQL((String)positionGPS.getAdresse()) + "," + SQL.getStringSQL((String)positionGPS.getCommune()) + "," + SQL.getStringSQL((String)positionGPS.getCc()) + "," + positionGPS.getAltitude() + "," + SQL.getStringSQL((String)positionGPS.getIdPatrouille()) + ")" : "insert into localisation (ID,COORDONNEES, DATE_HEURE_LOC, ETAT_LOC, MCIG_ID,TYPE,AXE,PR,ABSCISSE_PR,SENS_PR,ADRESSE,cch,altitude,id_patrouille,debit_sel, debit_saumure,largeur_travail, vitesse_vehicule,km_parcouru,km_sale,position_lame,temperature_sol,temperature_air,humidite_air,emb_sal,emb_sau,temperature_rose) values (" + SQL.getStringSQL((String)positionGPS.getId()) + "," + VehiculeDAOJDBC.getChampGeometryPoint(positionGPS, 4326) + ", to_timestamp('" + positionGPS.getDate() + "', 'YYYYMMDDHH24MISS'), " + etat + ", '" + positionGPS.getMcig() + "'," + positionGPS.getType() + "," + SQL.getStringSQL((String)positionGPS.getAxe()) + "," + SQL.getIntSQL((int)positionGPS.getPr()) + "," + SQL.getIntSQL((int)positionGPS.getAbscissePr()) + "," + SQL.getIntSQL((int)positionGPS.getSensPr()) + "," + SQL.getIntSQL((String)positionGPS.getAdresse()) + "," + SQL.getStringSQL((String)positionGPS.getCc()) + "," + positionGPS.getAltitude() + "," + SQL.getStringSQL((String)positionGPS.getIdPatrouille()) + "," + donneesSaleuse.getDebitSel() + "," + donneesSaleuse.getDebitSaumure() + "," + donneesSaleuse.getLargeurTravail() + "," + donneesSaleuse.getVitesseCamion() + "," + donneesSaleuse.getKmParcouru() + "," + donneesSaleuse.getKmSale() + "," + donneesSaleuse.getLameBaissee() + "," + donneesSaleuse.getTemperatureSol() + "," + donneesSaleuse.getTemperatureAir() + "," + donneesSaleuse.getTauxHumidite() + "," + donneesSaleuse.getEmbrayageSaleuse() + "," + donneesSaleuse.getEmbrayageSaumure() + "," + donneesSaleuse.getTemperatureRose() + ")";
        Log.debug(requete);
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getNbPatrouillesParAnnee(Integer annee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        LinkedHashMap<String, Map<String, Map<Integer, Integer>>> retour = new LinkedHashMap<String, Map<String, Map<Integer, Integer>>>();
        String req = SQL_NB_PATROUILLES_BY_YEAR;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
            pstm.setInt(1, annee);
            pstm.setInt(2, 0);
            pstm.setString(3, zr);
            Log.debug("requette : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                String delegation = rs.getString("delegation");
                String centre = rs.getString("centre");
                int mois = rs.getInt("mois");
                int nbPatrouilles = rs.getInt("nb_patrouilles");
                Map mapCentre = new LinkedHashMap();
                if (retour.containsKey(delegation)) {
                    mapCentre = (Map)retour.get(delegation);
                }
                Map<Integer, Integer> mapMois = new HashMap<Integer, Integer>();
                if (mapCentre.containsKey(centre)) {
                    mapMois = (Map)mapCentre.get(centre);
                }
                mapMois.put(mois - 1, nbPatrouilles);
                mapCentre.put(centre, mapMois);
                retour.put(delegation, mapCentre);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public Rectangle2D getExtentPatrouille(String id_patrouille) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Rectangle2D rectangle2D;
            String requete = "SELECT (ST_Expand(extent,GREATEST(ST_XMax(extent) - ST_XMin(extent), ST_YMax(extent) - ST_YMin(extent))*0.10)) as extent FROM (SELECT ST_Extent(coordonnees) as extent from prism.localisation where id_patrouille = ?) as foo";
            connection = null;
            pstm = null;
            rs = null;
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                pstm.setString(1, id_patrouille);
                rs = pstm.executeQuery();
                if (!rs.first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block4;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public Rectangle2D getExtentPatrouille(List<String> ids_patrouille) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Rectangle2D rectangle2D;
            String requete = "SELECT (ST_Expand(extent,GREATEST(ST_XMax(extent) - ST_XMin(extent), ST_YMax(extent) - ST_YMin(extent))*0.10)) as extent FROM (SELECT ST_Extent(coordonnees) as extent from prism.localisation where id_patrouille = ANY(?)) as foo";
            connection = null;
            pstm = null;
            rs = null;
            Log.debug("ids_patrouille " + ids_patrouille);
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                pstm.setArray(1, connection.createArrayOf("text", ids_patrouille.toArray()));
                Log.debug("getExtentPatrouille " + pstm);
                rs = pstm.executeQuery();
                if (!rs.first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block4;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnIntervention(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        ArrayList<VehiculeEnIntervention> pps = new ArrayList();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_VEHICULE_INTERVENTION;
        if (this.conversionCapDistance) {
            req = SQL_VEHICULE_INTERVENTION_CAPVITESSE;
        }
        if (!GLS.estVide((List)filtre.codeModuleMetier)) {
            req = filtre.afficheModulesHerites ? req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))" : req + " AND p.type = ANY(?) ";
        }
        if (filtre.agents != null) {
            req = req + " AND m.id_utilisateur =ANY(?) ";
        } else {
            if (filtre.centre != null) {
                req = req + " AND u.centre=? ";
            }
            if (filtre.delegation != null) {
                req = req + " AND u.delegation=? ";
            }
        }
        if (filtre.vehicule != null) {
            req = req + " AND v.code = ANY(?)";
        }
        if (filtre.patrouillesVisees != null) {
            req = filtre.patrouillesVisees != false ? req + " AND not p.date_visa is null " : req + " AND p.date_visa is null ";
        }
        if (filtre.dateMin != null && filtre.dateMax != null) {
            req = req + " AND (p.id, l.date_heure_loc, l.id) in (SELECT distinct(p2.id), max(l2.date_heure_loc),max(l2.id) FROM localisation l2, patrouille p2 WHERE p2.id = l2.id_patrouille and l2.date_heure_loc BETWEEN ? AND ? GROUP by p2.id)";
            filtre.dateMin.setHours(0);
            filtre.dateMin.setMinutes(0);
            filtre.dateMin.setSeconds(0);
            filtre.dateMax.setHours(23);
            filtre.dateMax.setMinutes(59);
            filtre.dateMax.setSeconds(59);
        } else {
            req = filtre.termine == 0 ? req + " AND (p.fin is null) AND etat_loc = 1" : req + " AND (p.id, l.date_heure_loc, l.id) in (SELECT distinct(p2.id), max(l2.date_heure_loc),max(l2.id) FROM localisation l2 inner join patrouille p2 on p2.id = l2.id_patrouille GROUP BY p2.id) ";
        }
        req = req + " ORDER BY p.debut desc LIMIT 100";
        if (filtre.addPositionPrecedenteAvecVitesse) {
            req = "select ST_Transform(p2.coordonnees,4326) as geomold, r1.* from (" + req;
            req = req + ") r1 left join prism.localisation p2 on p2.mcig_id = r1.mcig_id and p2.id = (select id from prism.localisation l where l.mcig_id = r1.mcig_id and l.vitesse_vehicule >= " + this.polylineVitesse + " and l.date_heure_loc > r1.date_heure_loc - interval '7 day' and l.date_heure_loc < r1.date_heure_loc ORDER BY l.date_heure_loc desc limit 1)";
        }
        try {
            Array a;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req, 1004, 1007);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            int indexParam = 2;
            if (!GLS.estVide((List)filtre.codeModuleMetier)) {
                a = connection.createArrayOf("int", filtre.codeModuleMetier.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
                if (filtre.afficheModulesHerites) {
                    pstm.setArray(indexParam, a);
                    ++indexParam;
                }
            }
            if (filtre.agents != null) {
                a = connection.createArrayOf("int", filtre.agents.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
            } else {
                if (filtre.centre != null) {
                    pstm.setString(indexParam, filtre.centre);
                    ++indexParam;
                }
                if (filtre.delegation != null) {
                    pstm.setString(indexParam, filtre.delegation);
                    ++indexParam;
                }
            }
            if (filtre.vehicule != null) {
                a = connection.createArrayOf("text", filtre.vehicule.toArray());
                pstm.setArray(indexParam++, a);
            }
            if (filtre.dateMin != null && filtre.dateMax != null) {
                pstm.setTimestamp(indexParam, filtre.dateMin);
                pstm.setTimestamp(++indexParam, filtre.dateMax);
                ++indexParam;
            }
            Log.debug("requette vehicule : " + pstm);
            rs = pstm.executeQuery();
            pps = this.parseVehiculesEnIntervention(rs);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    @Override
    public List<VehiculeEnIntervention> getVehiculesEnInterventionHistorique(IBusinessService.VehiculeFiltre filtre, boolean regroupementPatrouille) {
        ArrayList<VehiculeEnIntervention> pps = new ArrayList();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_NB_VEHICULE_INTERVENTION_HISTORIQUE_WITH_LOC;
        if (!GLS.estVide((List)filtre.codeModuleMetier)) {
            req = filtre.afficheModulesHerites ? req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))" : req + " AND p.type = ANY(?) ";
        }
        if (filtre.centre != null) {
            req = req + " AND u.centre=?";
        }
        if (filtre.delegation != null) {
            req = req + " AND u.delegation=?";
        }
        if (filtre.vehicule != null) {
            req = req + " AND v.code = ANY(?)";
        }
        if (filtre.agents != null) {
            req = req + " AND m.id_utilisateur =ANY(?)";
        }
        if (filtre.patrouillesVisees != null) {
            req = filtre.patrouillesVisees != false ? req + " AND not p.date_visa is null " : req + " AND p.date_visa is null ";
        }
        if (filtre.dateMin != null) {
            filtre.dateMin.setHours(0);
            filtre.dateMin.setMinutes(0);
            filtre.dateMin.setSeconds(0);
        }
        if (filtre.dateMax != null) {
            filtre.dateMax.setHours(23);
            filtre.dateMax.setMinutes(59);
            filtre.dateMax.setSeconds(59);
        }
        req = req + " ORDER BY p.debut desc LIMIT 100";
        try {
            Array a;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            if (filtre.dateMin != null) {
                pstm.setTimestamp(2, filtre.dateMin);
            } else {
                pstm.setTimestamp(2, new Timestamp(1L));
            }
            if (filtre.dateMin != null) {
                pstm.setTimestamp(3, filtre.dateMax);
            } else {
                pstm.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            }
            int indexParam = 4;
            if (!GLS.estVide((List)filtre.codeModuleMetier)) {
                a = connection.createArrayOf("int", filtre.codeModuleMetier.toArray());
                pstm.setArray(indexParam, a);
                ++indexParam;
                if (filtre.afficheModulesHerites) {
                    pstm.setArray(indexParam, a);
                    ++indexParam;
                }
            }
            if (filtre.centre != null) {
                pstm.setString(indexParam, filtre.centre);
                ++indexParam;
            }
            if (filtre.delegation != null) {
                pstm.setString(indexParam, filtre.delegation);
                ++indexParam;
            }
            if (filtre.vehicule != null) {
                a = connection.createArrayOf("text", filtre.vehicule.toArray());
                pstm.setArray(indexParam++, a);
            }
            if (filtre.agents != null) {
                a = connection.createArrayOf("int", filtre.agents.toArray());
                pstm.setArray(indexParam++, a);
            }
            Log.debug("requette vehicule : " + pstm);
            rs = pstm.executeQuery();
            pps = this.parseVehiculesEnIntervention(rs, true);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    @Override
    public List<SynthesePatrouillesVHBean> getAnalysePatrouillesVH(Timestamp dateDebut, Timestamp dateFin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        LinkedHashMap<String, SynthesePatrouillesVHBean> mapSynthesePatrouilles = new LinkedHashMap<String, SynthesePatrouillesVHBean>();
        String req = SQL_INFORMATIONS_PATROUILLES_BY_DATES;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            pstm.setInt(3, 1);
            Log.debug("requette vehicule : " + pstm);
            rs = pstm.executeQuery();
            SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
            while (rs.next()) {
                String jour = rs.getString("jour");
                int moduleMetier = rs.getInt("type");
                int idUtilisateur = rs.getInt("id_utilisateur");
                String codeVehicule = rs.getString("code_vehicule");
                String hash = jour + moduleMetier + idUtilisateur + codeVehicule;
                SynthesePatrouillesVHBean bean = (SynthesePatrouillesVHBean)mapSynthesePatrouilles.get(hash);
                if (bean == null) {
                    bean = new SynthesePatrouillesVHBean();
                    bean.arrondissement = rs.getString("delegation");
                    bean.cerd = rs.getString("centre");
                    bean.datePatrouille = rs.getString("jour").substring(0, 10);
                    bean.patrouilleur = rs.getString("nom");
                    bean.equipier = rs.getString("equipier");
                    bean.vehiculeUtilise = rs.getString("code_vehicule");
                    bean.declenchementESH = rs.getInt("declenchementESH");
                    bean.sobo = rs.getInt("sobo");
                    if (rs.getTimestamp("debut") != null) {
                        bean.heureDebutPatrouille = sdfHeure.format(rs.getTimestamp("debut"));
                    }
                    if (rs.getTimestamp("fin") != null) {
                        bean.heureFinPatrouille = sdfHeure.format(rs.getTimestamp("fin"));
                    }
                    if (rs.getTimestamp("debut") != null && rs.getTimestamp("fin") != null) {
                        bean.dureePatrouille = rs.getTimestamp("fin").getTime() - rs.getTimestamp("debut").getTime();
                    }
                    bean.distancePatrouille = rs.getLong("longueur");
                } else {
                    bean.heureFinPatrouille = rs.getTimestamp("fin") != null ? sdfHeure.format(rs.getTimestamp("fin")) : "";
                    bean.dureePatrouille = rs.getTimestamp("fin") == null || bean.dureePatrouille == -1L ? -1L : (bean.dureePatrouille += rs.getTimestamp("fin").getTime() - rs.getTimestamp("debut").getTime());
                    bean.distancePatrouille += rs.getLong("longueur");
                }
                mapSynthesePatrouilles.put(hash, bean);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        ArrayList<SynthesePatrouillesVHBean> retour = new ArrayList<SynthesePatrouillesVHBean>(mapSynthesePatrouilles.values());
        return retour;
    }

    @Override
    public List<Patrouille> getPatrouilles(double lat, double lon, String delegation, String centre, int nbPatrouillesARechercher, Timestamp dateDebut, Timestamp dateFin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Patrouille> patrouilles = new ArrayList<Patrouille>();
        String req = SQL_PATROUILLES_RECHERCHE;
        if (nbPatrouillesARechercher != -1) {
            req = req + " LIMIT " + nbPatrouillesARechercher;
        }
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setDouble(1, lon);
            pstm.setDouble(2, lat);
            pstm.setTimestamp(3, dateDebut);
            pstm.setTimestamp(4, dateFin);
            Log.debug("requette recherche patrouielle : " + pstm);
            rs = pstm.executeQuery();
            SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
            while (rs.next()) {
                Patrouille p = new Patrouille();
                p.setId(rs.getString("id"));
                p.setDebut(rs.getTimestamp("debut").getTime());
                if (rs.getTimestamp("fin") != null) {
                    p.setFin(rs.getTimestamp("fin").getTime());
                }
                p.setMcig(rs.getString("mcig_id"));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ModuleMetier", rs.getString("type"));
                p.setParametres(params);
                patrouilles.add(p);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouilles;
    }

    @Override
    public List<Localisation> getLocalisationsPatrouille(String mcig_id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Localisation> localisations = new ArrayList<Localisation>();
        if (mcig_id != null) {
            String req = SQL_LOCALISATIONS_PATROUILLE;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, mcig_id);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Localisation l = new Localisation();
                    Point geom = (Point)((PGgeometry)rs.getObject("coordonnees")).getGeometry();
                    l.addCoordonnees(geom.x, geom.y);
                    l.setDateHeureLoc(rs.getTimestamp("date_heure_loc"));
                    localisations.add(l);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return localisations;
    }

    @Override
    public List<Patrouille> getPatrouilles(String k_eventid) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Patrouille> patrouilles = new ArrayList<Patrouille>();
        String req = SQL_PATROUILLES_RECHERCHE_FOR_EVENT_ID;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setInt(1, Integer.valueOf(k_eventid));
            Log.debug("requette recherche patrouille : " + pstm);
            rs = pstm.executeQuery();
            SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
            while (rs.next()) {
                Patrouille p = new Patrouille();
                p.setId(rs.getString("id_patrouille"));
                p.setDebut(rs.getTimestamp("debut").getTime());
                if (rs.getTimestamp("fin") != null) {
                    p.setFin(rs.getTimestamp("fin").getTime());
                }
                p.setMcig(rs.getString("mcig_id"));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ModuleMetier", rs.getString("type"));
                p.setParametres(params);
                patrouilles.add(p);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouilles;
    }

    @Override
    public boolean viserVehiculeEnIntervention(VehiculeEnIntervention v) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = this.SQL_PATROUILLES_UPDATE_VISER;
        boolean ret = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setTimestamp(1, new Timestamp(v.getDatePatrouilleVisee()));
            pstm.setString(2, v.getViseePar());
            if (v.getIdsPatrouillesAgreg() != null) {
                Array array = connection.createArrayOf("text", v.getIdsPatrouillesAgreg().toArray());
                pstm.setArray(3, array);
            } else {
                pstm.setString(3, v.getIdPatrouille());
            }
            Log.debug("requette Viser patrouille : " + pstm);
            rs = pstm.executeQuery();
            int num = 0;
            while (rs.next()) {
                ++num;
            }
            if (num == v.getIdsPatrouillesAgreg().size()) {
                ret = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ret;
    }

    @Override
    public SyntheseViseeBean getSyntheseViseeBean(Timestamp debut, Timestamp fin, int typePatrouille, String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        SyntheseViseeBean syntheseViseeBean = new SyntheseViseeBean();
        ArrayList<SyntheseViseeBeanPatrouille> patrouilleBeanList = new ArrayList<SyntheseViseeBeanPatrouille>();
        String req = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, v.immatriculation, p.id, u.nom, u.centre, u.delegation, p.date_visa, uv.centre as centre_visa FROM prism.patrouille p LEFT JOIN prism.utilisateur uv on uv.sna = p.utilisateur_visa LEFT JOIN prism.vehicule v on p.code_vehicule = v.code, prism.mcig m, prism.utilisateur u WHERE u.id_utilisateur = m.id_utilisateur ";
        if (delegation != null) {
            req = req + " AND u.delegation = ?";
        }
        if (centre != null) {
            req = req + " AND u.centre = ?";
        }
        req = req + " AND m.mcig_id = p.mcig_id AND p.id IN\t( SELECT p2.id FROM patrouille p1, patrouille p2, mcig m1, mcig m2\tWHERE p1.debut ";
        req = fin != null ? req + "BETWEEN ? AND ?" : req + " > ?";
        req = req + " AND p1.mcig_id = m1.mcig_id AND p2.mcig_id = m2.mcig_id AND m1.id_utilisateur = m2.id_utilisateur AND p1.code_vehicule = p2.code_vehicule AND date_trunc('day',p1.debut) = date_trunc('day',p2.debut)) ";
        if (typePatrouille != -1) {
            req = req + " AND p.type = ? ";
        }
        req = req + "ORDER BY p.type, u.id_utilisateur ASC, p.code_vehicule ASC, p.debut ASC";
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfDateCompare = new SimpleDateFormat("yyyyMMddMM");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        ArrayList<String> dates = new ArrayList<String>();
        ArrayList<String> cerd = new ArrayList<String>();
        ArrayList<String> delegations = new ArrayList<String>();
        ArrayList<String> vehicules = new ArrayList<String>();
        ArrayList<String> patrouilleurs = new ArrayList<String>();
        double dureeTotale = 0.0;
        long longueurTotale = 0L;
        int nbVisa = 0;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            int index = 1;
            if (delegation != null) {
                pstm.setString(index++, delegation);
            }
            if (centre != null) {
                pstm.setString(index++, centre);
            }
            pstm.setTimestamp(index++, debut);
            if (fin != null) {
                pstm.setTimestamp(index++, fin);
            }
            if (typePatrouille != -1) {
                pstm.setInt(index++, typePatrouille);
            }
            Log.debug("requette synthese visee : " + pstm);
            rs = pstm.executeQuery();
            boolean first = true;
            double dureePrec = 0.0;
            long longueurPrec = 0L;
            SyntheseViseeBeanPatrouille patrouilleBean = new SyntheseViseeBeanPatrouille();
            Log.debug("requette synthese debut recup\u00e9ration");
            double dureeMin = this.businessService.getConfiguration().getDouble("config.duree.patrouille.min", 0.0) * 60000.0;
            int longueurMin = this.businessService.getConfiguration().getInt("config.longueur.patrouille.min", 0);
            Log.debug("dur\u00e9e min : " + dureeMin);
            Log.debug("longueur min : " + longueurMin);
            while (rs.next()) {
                Timestamp dateFin;
                double duree = 0.0;
                long longueur = 0L;
                Timestamp dateDebut = rs.getTimestamp("debut");
                syntheseViseeBean.getIdsPatrouilles().add(rs.getString("id"));
                if (!first && (!sdfDate.format(new Date(dateDebut.getTime())).equals(patrouilleBean.getDate()) || rs.getString("immatriculation") != null && !rs.getString("immatriculation").equals(patrouilleBean.getVehicule()) || rs.getString("immatriculation") == null && !rs.getString("code_vehicule").equals(patrouilleBean.getVehicule()) || !rs.getString("nom").equals(patrouilleBean.getPatrouilleur()) || rs.getInt("type") != patrouilleBean.getTypePatrouille())) {
                    if (patrouilleBean.getDuree() >= dureeMin && Integer.valueOf(patrouilleBean.getLongueur()) >= longueurMin) {
                        patrouilleBeanList.add(patrouilleBean);
                        if (!dates.contains(patrouilleBean.getDate())) {
                            dates.add(patrouilleBean.getDate());
                        }
                        if (!cerd.contains(patrouilleBean.getCerd())) {
                            cerd.add(patrouilleBean.getCerd());
                        }
                        if (!delegations.contains(patrouilleBean.getDelegation())) {
                            delegations.add(patrouilleBean.getDelegation());
                        }
                        if (!vehicules.contains(patrouilleBean.getVehicule())) {
                            vehicules.add(patrouilleBean.getVehicule());
                        }
                        if (!patrouilleurs.contains(patrouilleBean.getPatrouilleur())) {
                            patrouilleurs.add(patrouilleBean.getPatrouilleur());
                        }
                        dureeTotale += dureePrec;
                        longueurTotale += longueurPrec;
                        if (!patrouilleBean.getVisa().equals("")) {
                            ++nbVisa;
                        }
                    }
                    dureePrec = 0.0;
                    longueurPrec = 0L;
                    patrouilleBean = new SyntheseViseeBeanPatrouille();
                    first = true;
                }
                if (first && dateDebut != null) {
                    patrouilleBean.setDate(sdfDate.format(new Date(dateDebut.getTime())));
                    patrouilleBean.setDateCompare(sdfDateCompare.format(new Date(dateDebut.getTime())));
                    patrouilleBean.setHeureDebut(sdfHeure.format(new Date(dateDebut.getTime())));
                }
                if ((dateFin = rs.getTimestamp("fin")) != null) {
                    duree = dateFin.getTime() - dateDebut.getTime();
                    patrouilleBean.setHeureFin(sdfHeure.format(new Date(dateFin.getTime())));
                } else {
                    duree = -1.0;
                }
                if (duree != -1.0 && dureePrec != -1.0) {
                    duree += dureePrec;
                }
                patrouilleBean.setDuree(duree);
                if (rs.getString("immatriculation") != null) {
                    patrouilleBean.setVehicule(rs.getString("immatriculation"));
                } else {
                    patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                }
                patrouilleBean.setPatrouilleur(rs.getString("nom"));
                if (rs.getString("centre") == null) {
                    patrouilleBean.setCerd("");
                } else {
                    patrouilleBean.setCerd(rs.getString("centre"));
                }
                if (rs.getString("delegation") == null) {
                    patrouilleBean.setDelegation("");
                } else {
                    patrouilleBean.setDelegation(rs.getString("delegation"));
                }
                patrouilleBean.setTypePatrouille(rs.getInt("type"));
                longueur = this.getLongueurPatrouille(connection, rs.getString("id"));
                patrouilleBean.setLongueur("" + (longueur += longueurPrec));
                if (rs.getTimestamp("date_visa") != null) {
                    patrouilleBean.setVisa(sdfDate.format(new Date(rs.getTimestamp("date_visa").getTime())));
                }
                dureePrec = duree;
                longueurPrec = longueur;
                first = false;
            }
            Log.debug("requette synthese fin recup\u00e9ration");
            if (!first && patrouilleBean.getDuree() >= dureeMin && Integer.valueOf(patrouilleBean.getLongueur()) >= longueurMin) {
                patrouilleBeanList.add(patrouilleBean);
                if (!dates.contains(patrouilleBean.getDate())) {
                    dates.add(patrouilleBean.getDate());
                }
                if (!cerd.contains(patrouilleBean.getCerd())) {
                    cerd.add(patrouilleBean.getCerd());
                }
                if (!delegations.contains(patrouilleBean.getDelegation())) {
                    delegations.add(patrouilleBean.getDelegation());
                }
                if (!vehicules.contains(patrouilleBean.getVehicule())) {
                    vehicules.add(patrouilleBean.getVehicule());
                }
                if (!patrouilleurs.contains(patrouilleBean.getPatrouilleur())) {
                    patrouilleurs.add(patrouilleBean.getPatrouilleur());
                }
                dureeTotale += dureePrec;
                longueurTotale += longueurPrec;
                dureePrec = 0.0;
                longueurPrec = 0L;
                if (!patrouilleBean.getVisa().equals("")) {
                    ++nbVisa;
                }
            }
            syntheseViseeBean.setPatrouilles(patrouilleBeanList);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        ArrayList patrouilles = syntheseViseeBean.getPatrouilles();
        Collections.sort(patrouilles);
        syntheseViseeBean.setPatrouilles(patrouilles);
        SyntheseViseeBeanCumul cumul = new SyntheseViseeBeanCumul();
        cumul.setDate("" + dates.size());
        cumul.setCerd("" + cerd.size());
        cumul.setDelegation("" + delegations.size());
        cumul.setVehicule("" + vehicules.size());
        cumul.setPatrouilleur("" + patrouilleurs.size());
        if (dureeTotale > 0.0) {
            cumul.setDuree(dureeTotale);
        } else {
            cumul.setDuree(0.0);
        }
        if (longueurTotale > 0L) {
            cumul.setLongueur("" + longueurTotale);
        } else {
            cumul.setLongueur("-");
        }
        if (patrouilles.size() > 0) {
            int pourcentage = nbVisa * 100 / patrouilles.size();
            cumul.setVisa(nbVisa + " (" + pourcentage + "%)");
        } else {
            cumul.setVisa("-");
        }
        syntheseViseeBean.setCumul(cumul);
        return syntheseViseeBean;
    }

    private String imgToString(File img) throws Exception {
        Log.debug("imgToString : " + img.getName());
        FileInputStream fis = null;
        fis = new FileInputStream(img);
        Log.debug("imgToString : new FileInputStream OK");
        ByteArrayOutputStream bais = new ByteArrayOutputStream((int)img.length());
        Log.debug("imgToString : new ByteArrayOutputStream OK");
        int c = -1;
        while ((c = fis.read()) != -1) {
            bais.write(c);
        }
        Log.debug("imgToString : ByteArrayOutputStream write OK");
        fis.close();
        Log.debug("imgToString : fis.close OK");
        return Base64.encodeBase64URLSafeString((byte[])bais.toByteArray());
    }

    @Override
    public Collection<TronconSuivi> getTronconsSales(List<Integer> codeMM) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        String req = "select cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, v.date_fin, v.id, v.longueur from vh.evenement_vh v inner join patrouille p on p.id = v.id_patrouille where date_fin > now() AND deneigement = 1 ";
        if (!GLS.estVide(codeMM)) {
            req = req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))";
        }
        req = req + CLASSEMENT_TRONCONS_RECENTS;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            if (!GLS.estVide(codeMM)) {
                Array a = connection.createArrayOf("int", codeMM.toArray());
                pstm.setArray(1, a);
                pstm.setArray(2, a);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                TronconSuivi t = new TronconSuivi();
                t.setCode(rs.getString("cch"));
                t.setLongueur(rs.getInt("longueur"));
                t.setDateFinValidite(rs.getTimestamp("date_fin"));
                t.setIdTronconSuivi(rs.getString("id"));
                LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                float[][] f = Geometry.getLineToFloat((LineString)geom);
                t.setX(f[0]);
                t.setY(f[1]);
                ts.add(t);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ts;
    }

    @Override
    public Collection<TronconSuivi> getTronconsDeneiges(List<Integer> codeMM) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        String req = "select seuil_salage, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, v.date_fin, v.id, v.longueur from vh.evenement_vh v inner join patrouille p on p.id = v.id_patrouille where date_fin > now() AND  seuil_salage > 0 ";
        if (!GLS.estVide(codeMM)) {
            req = req + " AND p.type in (select mmp.code from prism.module_metier_perso mmp where mmp.code = ANY(?) or mmp.module_herite = ANY(?))";
        }
        req = req + CLASSEMENT_TRONCONS_RECENTS;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            if (!GLS.estVide(codeMM)) {
                Array a = connection.createArrayOf("int", codeMM.toArray());
                pstm.setArray(1, a);
                pstm.setArray(2, a);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                TronconSuivi t = new TronconSuivi();
                t.setCode(rs.getString("seuil_salage"));
                t.setLongueur(rs.getInt("longueur"));
                t.setDateFinValidite(rs.getTimestamp("date_fin"));
                t.setIdTronconSuivi(rs.getString("id"));
                LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                float[][] f = Geometry.getLineToFloat((LineString)geom);
                t.setX(f[0]);
                t.setY(f[1]);
                ts.add(t);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ts;
    }

    @Override
    public Collection<TronconSuivi> getTronconsSalageDeneigement(Set<String> idPatrouilleSuivi) {
        ArrayList<TronconSuivi> tsd = new ArrayList<TronconSuivi>();
        Collection<TronconSuivi> ts = this.getTronconsSalage(idPatrouilleSuivi);
        Collection<TronconSuivi> td = this.getTronconsDeneigement(idPatrouilleSuivi);
        for (TronconSuivi tsTemp : ts) {
            if ("S0".equalsIgnoreCase(tsTemp.getCode())) {
                boolean found = false;
                for (TronconSuivi tdTemp : td) {
                    if (!tdTemp.getIdTronconSuivi().equals(tsTemp.getIdTronconSuivi())) continue;
                    found = true;
                }
                if (found) continue;
                tsd.add(tsTemp);
                continue;
            }
            tsd.add(tsTemp);
        }
        tsd.addAll(td);
        return tsd;
    }

    @Override
    public Collection<TronconSuivi> getTronconsSalageDeneigementActif(Set<String> idPatrouilleSuivi) {
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        ts.addAll(this.getTronconsSalageEtDenegementActif(idPatrouilleSuivi));
        return ts;
    }

    private Collection<TronconSuivi> getTronconsSalage(Set<String> idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = "SELECT v.id,v.id_patrouille as idp, cch, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,5), 20, 1),4326) as coord, longueur FROM vh.evenement_vh  v WHERE v.id_patrouille = ANY(?)  order by v.date asc";
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode(rs.getString("cch"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setIdTronconSuivi(rs.getString("id"));
                    if (rs.getObject("idp") != null) {
                        t.setIdPatrouille(rs.getString("idp"));
                    }
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    private Collection<TronconSuivi> getTronconsDeneigement(Set<String> idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = "select v.id,v.id_patrouille as idp, deneigement, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,5), 50, 1),4326) as coord, longueur from vh.evenement_vh  v where v.id_patrouille = ANY(?) AND deneigement = 1 order by v.date asc;";
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode("d" + rs.getString("deneigement"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setIdTronconSuivi(rs.getString("id"));
                    if (rs.getObject("idp") != null) {
                        t.setIdPatrouille(rs.getString("idp"));
                    }
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    private Collection<TronconSuivi> getTronconsSalageActif(Set<String> idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = "SELECT v.id,v.id_patrouille as idp, seuil_salage, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,5), 20, 1),4326) as coord, longueur FROM vh.evenement_vh  v WHERE v.id_patrouille = ANY(?) AND seuil_salage is not null AND seuil_salage > 0 order by v.date asc";
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    t.setCode("s" + rs.getString("seuil_salage"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setIdTronconSuivi(rs.getString("id"));
                    if (rs.getObject("idp") != null) {
                        t.setIdPatrouille(rs.getString("idp"));
                    }
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    private Collection<TronconSuivi> getTronconsSalageEtDenegementActif(Set<String> idPatrouilleSuivi) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconSuivi> ts = new ArrayList<TronconSuivi>();
        if (idPatrouilleSuivi != null && idPatrouilleSuivi.size() > 0) {
            String req = "SELECT v.id,v.id_patrouille as idp, seuil_salage, deneigement, st_transform(lateralize_line(ST_SimplifyPreserveTopology(coordonnees,0.05), 20, 1),4326) as coord, longueur FROM vh.evenement_vh  v WHERE v.id_patrouille = ANY(?) order by v.date asc";
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", idPatrouilleSuivi.toArray()));
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconSuivi t = new TronconSuivi();
                    String salage = rs.getString("seuil_salage");
                    String denegement = rs.getString("deneigement");
                    t.setCode("s" + (salage != null ? salage : "0") + "d" + (denegement != null ? denegement : "0"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setIdTronconSuivi(rs.getString("id"));
                    if (rs.getObject("idp") != null) {
                        t.setIdPatrouille(rs.getString("idp"));
                    }
                    LineString geom = (LineString)((PGgeometry)rs.getObject("coord")).getGeometry();
                    float[][] f = Geometry.getLineToFloat((LineString)geom);
                    t.setX(f[0]);
                    t.setY(f[1]);
                    ts.add(t);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return ts;
    }

    @Override
    public List<String> getVehiculesEnInterventionActivites(VehiculeEnIntervention vehicule) {
        String REQUETE = "SELECT distinct(cch) FROM vh.evenement_vh WHERE id_patrouille = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<String> taches = new ArrayList<String>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE);
            pstm.setString(1, vehicule.getIdPatrouille());
            rs = pstm.executeQuery();
            while (rs.next()) {
                taches.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return taches;
    }

    public List<SynthesePatrouilleBean> getSynthesePatrouilleBeanTMP(Timestamp dateDebut, Timestamp dateFin, int typePatrouille, String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<SynthesePatrouilleBean> patrouillesBeanList = new ArrayList<SynthesePatrouilleBean>();
        String req = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, p.id, u.nom, u.centre, u.delegation, u.centre, cch, sum(longueur) as lgStatut FROM prism.patrouille p, vh.evenement_vh vh, prism.utilisateur u, prism.mcig  m WHERE p.id = vh.id_patrouille AND p.mcig_id = m.mcig_id AND u.id_utilisateur = m.id_utilisateur";
        if (delegation != null) {
            req = req + " AND u.delegation = ?";
        }
        if (centre != null) {
            req = req + " AND u.centre = ?";
        }
        req = req + " AND p.debut ";
        req = dateFin != null ? req + "BETWEEN ? AND ?" : req + " > ?";
        if (typePatrouille != -1) {
            req = req + " AND p.type = ? ";
        }
        req = req + "GROUP BY p.id, p.debut, p.fin, p.type, p.code_vehicule, u.nom, u.centre, u.delegation, u.centre, cch ";
        req = req + "ORDER BY p.debut ASC";
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfDateCompare = new SimpleDateFormat("yyyyMMddMM");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        ArrayList dates = new ArrayList();
        ArrayList cerd = new ArrayList();
        ArrayList vehicules = new ArrayList();
        ArrayList patrouilleurs = new ArrayList();
        long dureeTotale = 0L;
        long longueurTotale = 0L;
        boolean nbVisa = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            int index = 1;
            if (delegation != null) {
                pstm.setString(index++, delegation);
            }
            if (centre != null) {
                pstm.setString(index++, centre);
            }
            pstm.setTimestamp(index++, dateDebut);
            if (dateFin != null) {
                pstm.setTimestamp(index++, dateFin);
            }
            if (typePatrouille != -1) {
                pstm.setInt(index++, typePatrouille);
            }
            Log.debug("requette synthese patrouille : " + pstm);
            rs = pstm.executeQuery();
            HashMap<String, SynthesePatrouilleBean> mapPatrouilles = new HashMap<String, SynthesePatrouilleBean>();
            while (rs.next()) {
                Timestamp timestampFin;
                String patrouilleId = rs.getString("id");
                SynthesePatrouilleBean patrouilleBean = (SynthesePatrouilleBean)mapPatrouilles.get(patrouilleId);
                if (patrouilleBean == null) {
                    patrouilleBean = new SynthesePatrouilleBean();
                    patrouilleBean.setPatrouilleId(patrouilleId);
                    mapPatrouilles.put(patrouilleId, patrouilleBean);
                }
                patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                Timestamp timestampDebut = rs.getTimestamp("debut");
                if (timestampDebut != null) {
                    patrouilleBean.setDateDebut(sdfDate.format(new Date(timestampDebut.getTime())));
                    patrouilleBean.setHeureDebut(sdfHeure.format(new Date(timestampDebut.getTime())));
                }
                if ((timestampFin = rs.getTimestamp("fin")) != null) {
                    patrouilleBean.setDateFin(sdfDate.format(new Date(timestampFin.getTime())));
                    patrouilleBean.setHeureFin(sdfHeure.format(new Date(timestampFin.getTime())));
                    new String();
                    patrouilleBean.setDureePatrouille(String.valueOf(timestampFin.getTime() - timestampDebut.getTime()));
                }
                patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                patrouilleBean.setPatrouilleur(rs.getString("nom"));
                if (rs.getString("delegation") == null) {
                    patrouilleBean.setArrondissement("");
                } else {
                    patrouilleBean.setArrondissement(rs.getString("delegation"));
                }
                if (rs.getString("centre") == null) {
                    patrouilleBean.setCerd("");
                } else {
                    patrouilleBean.setCerd(rs.getString("centre"));
                }
                patrouilleBean.setLongueurPatrouille(this.getLongueurPatrouille(connection, rs.getString("id")));
                HashMap<String, Integer> mapLgStatut = patrouilleBean.getLongueurStatus();
                if (mapLgStatut == null) {
                    mapLgStatut = new HashMap<String, Integer>();
                }
                mapLgStatut.put(rs.getString("cch"), rs.getInt("lgStatut"));
                patrouilleBean.setLongueurStatus(mapLgStatut);
            }
            for (SynthesePatrouilleBean patrouilleBean : mapPatrouilles.values()) {
                patrouillesBeanList.add(patrouilleBean);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouillesBeanList;
    }

    @Override
    public List<SynthesePatrouilleBean> getSynthesePatrouilleBean(Timestamp dateDebut, Timestamp dateFin, int typePatrouille, String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<SynthesePatrouilleBean> patrouillesBeanList = new ArrayList<SynthesePatrouilleBean>();
        String req = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, p.id, u.nom, u.centre, u.delegation, u.centre FROM prism.patrouille p,  prism.utilisateur u, prism.mcig  m WHERE  p.mcig_id = m.mcig_id AND u.id_utilisateur = m.id_utilisateur";
        if (delegation != null) {
            req = req + " AND u.delegation = ?";
        }
        if (centre != null) {
            req = req + " AND u.centre = ?";
        }
        req = req + " AND p.debut ";
        req = dateFin != null ? req + "BETWEEN ? AND ?" : req + " > ?";
        if (typePatrouille != -1) {
            req = req + " AND p.type = ? ";
        }
        req = req + "GROUP BY p.id, p.debut, p.fin, p.type, p.code_vehicule, u.nom, u.centre, u.delegation, u.centre  ";
        req = req + "ORDER BY p.debut ASC";
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfDateCompare = new SimpleDateFormat("yyyyMMddMM");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        ArrayList dates = new ArrayList();
        ArrayList cerd = new ArrayList();
        ArrayList vehicules = new ArrayList();
        ArrayList patrouilleurs = new ArrayList();
        long dureeTotale = 0L;
        long longueurTotale = 0L;
        boolean nbVisa = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            int index = 1;
            if (delegation != null) {
                pstm.setString(index++, delegation);
            }
            if (centre != null) {
                pstm.setString(index++, centre);
            }
            pstm.setTimestamp(index++, dateDebut);
            if (dateFin != null) {
                pstm.setTimestamp(index++, dateFin);
            }
            if (typePatrouille != -1) {
                pstm.setInt(index++, typePatrouille);
            }
            Log.debug("requette synthese patrouille : " + pstm);
            rs = pstm.executeQuery();
            HashMap<String, SynthesePatrouilleBean> mapPatrouilles = new HashMap<String, SynthesePatrouilleBean>();
            while (rs.next()) {
                Timestamp timestampFin;
                String patrouilleId = rs.getString("id");
                SynthesePatrouilleBean patrouilleBean = (SynthesePatrouilleBean)mapPatrouilles.get(patrouilleId);
                if (patrouilleBean == null) {
                    patrouilleBean = new SynthesePatrouilleBean();
                    patrouilleBean.setPatrouilleId(patrouilleId);
                    mapPatrouilles.put(patrouilleId, patrouilleBean);
                }
                patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                Timestamp timestampDebut = rs.getTimestamp("debut");
                if (timestampDebut != null) {
                    patrouilleBean.setDateDebut(sdfDate.format(new Date(timestampDebut.getTime())));
                    patrouilleBean.setHeureDebut(sdfHeure.format(new Date(timestampDebut.getTime())));
                }
                if ((timestampFin = rs.getTimestamp("fin")) != null) {
                    patrouilleBean.setDateFin(sdfDate.format(new Date(timestampFin.getTime())));
                    patrouilleBean.setHeureFin(sdfHeure.format(new Date(timestampFin.getTime())));
                    new String();
                    patrouilleBean.setDureePatrouille(String.valueOf(timestampFin.getTime() - timestampDebut.getTime()));
                }
                patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                patrouilleBean.setPatrouilleur(rs.getString("nom"));
                if (rs.getString("delegation") == null) {
                    patrouilleBean.setArrondissement("");
                } else {
                    patrouilleBean.setArrondissement(rs.getString("delegation"));
                }
                if (rs.getString("centre") == null) {
                    patrouilleBean.setCerd("");
                } else {
                    patrouilleBean.setCerd(rs.getString("centre"));
                }
                String requeteDetail = "SELECT * FROM fauchage.get_stats_fauchage_patrouille(?, 25,1) group by id_troncon,axe,longueur";
                connection = this.daoFactory.getConnection();
                PreparedStatement pstmDetail = connection.prepareStatement(requeteDetail);
                pstmDetail.setString(1, patrouilleId);
                ResultSet rsDetail = pstmDetail.executeQuery();
                int longueurPatrouille = 0;
                HashMap<String, Integer> mapDetail = new HashMap<String, Integer>();
                while (rsDetail.next()) {
                    String axe = rsDetail.getString(2);
                    Integer lg = rsDetail.getInt(3);
                    longueurPatrouille += lg.intValue();
                    mapDetail.put(axe, lg);
                }
                patrouilleBean.setLongueurPatrouille(longueurPatrouille);
                patrouilleBean.setLongueurStatus(mapDetail);
            }
            for (SynthesePatrouilleBean patrouilleBean : mapPatrouilles.values()) {
                patrouillesBeanList.add(patrouilleBean);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouillesBeanList;
    }

    @Override
    public SyntheseViseeBean getSynthesePatrouilleBean(Timestamp debut, Timestamp fin, List<Integer> typePatrouille, String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        SyntheseViseeBean syntheseViseeBean = new SyntheseViseeBean();
        ArrayList<SyntheseViseeBeanPatrouille> patrouilleBeanList = new ArrayList<SyntheseViseeBeanPatrouille>();
        String req = "SELECT p.debut, p.fin, p.type, p.id_circuit, p.mcig_id, p.equipier, p.code_vehicule, v.immatriculation, p.id, u.nom, u.centre, u.delegation, p.date_visa, uv.centre as centre_visa FROM prism.patrouille p LEFT JOIN prism.utilisateur uv on uv.sna = p.utilisateur_visa LEFT JOIN prism.vehicule v on p.code_vehicule = v.code, prism.mcig m, prism.utilisateur u WHERE u.id_utilisateur = m.id_utilisateur ";
        if (delegation != null) {
            req = req + " AND u.delegation = ?";
        }
        if (centre != null) {
            req = req + " AND u.centre = ?";
        }
        req = req + " AND m.mcig_id = p.mcig_id AND p.id IN\t( SELECT p2.id FROM patrouille p1, patrouille p2, mcig m1, mcig m2\tWHERE p1.debut ";
        req = fin != null ? req + "BETWEEN ? AND ?" : req + " > ?";
        req = req + " AND p1.mcig_id = m1.mcig_id AND p2.mcig_id = m2.mcig_id AND m1.id_utilisateur = m2.id_utilisateur AND p1.code_vehicule = p2.code_vehicule AND date_trunc('day',p1.debut) = date_trunc('day',p2.debut)) ";
        if (typePatrouille.size() > 0) {
            req = req + " AND p.type = ANY(?) ";
        }
        req = req + "ORDER BY p.type, u.id_utilisateur ASC, p.code_vehicule ASC, p.debut ASC";
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfDateCompare = new SimpleDateFormat("yyyyMMddMM");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        ArrayList<String> dates = new ArrayList<String>();
        ArrayList<String> cerd = new ArrayList<String>();
        ArrayList<String> delegationList = new ArrayList<String>();
        ArrayList<String> vehicules = new ArrayList<String>();
        ArrayList<String> patrouilleurs = new ArrayList<String>();
        double dureeTotale = 0.0;
        long longueurTotale = 0L;
        int nbVisa = 0;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            int index = 1;
            if (delegation != null) {
                pstm.setString(index++, delegation);
            }
            if (centre != null) {
                pstm.setString(index++, centre);
            }
            pstm.setTimestamp(index++, debut);
            if (fin != null) {
                pstm.setTimestamp(index++, fin);
            }
            if (!GLS.estVide(typePatrouille)) {
                Array a = connection.createArrayOf("int", typePatrouille.toArray());
                pstm.setArray(index++, a);
            }
            Log.debug("requette synthese visee : " + pstm);
            rs = pstm.executeQuery();
            boolean first = true;
            double dureePrec = 0.0;
            long longueurPrec = 0L;
            SyntheseViseeBeanPatrouille patrouilleBean = new SyntheseViseeBeanPatrouille();
            Log.debug("requette synthese debut recup\u00e9ration");
            while (rs.next()) {
                Timestamp dateFin;
                double duree = 0.0;
                long longueur = 0L;
                Timestamp dateDebut = rs.getTimestamp("debut");
                if (!first && (!sdfDate.format(new Date(dateDebut.getTime())).equals(patrouilleBean.getDate()) || rs.getString("immatriculation") != null && !rs.getString("immatriculation").equals(patrouilleBean.getVehicule()) || rs.getString("immatriculation") == null && !rs.getString("code_vehicule").equals(patrouilleBean.getVehicule()) || !rs.getString("nom").equals(patrouilleBean.getPatrouilleur()) || rs.getInt("type") != patrouilleBean.getTypePatrouille())) {
                    patrouilleBeanList.add(patrouilleBean);
                    if (!dates.contains(patrouilleBean.getDate())) {
                        dates.add(patrouilleBean.getDate());
                    }
                    if (!delegationList.contains(patrouilleBean.getDelegation())) {
                        delegationList.add(patrouilleBean.getDelegation());
                    }
                    if (!cerd.contains(patrouilleBean.getCerd())) {
                        cerd.add(patrouilleBean.getCerd());
                    }
                    if (!vehicules.contains(patrouilleBean.getVehicule())) {
                        vehicules.add(patrouilleBean.getVehicule());
                    }
                    if (!patrouilleurs.contains(patrouilleBean.getPatrouilleur())) {
                        patrouilleurs.add(patrouilleBean.getPatrouilleur());
                    }
                    dureeTotale += dureePrec;
                    longueurTotale += longueurPrec;
                    dureePrec = 0.0;
                    longueurPrec = 0L;
                    if (!patrouilleBean.getVisa().equals("")) {
                        ++nbVisa;
                    }
                    patrouilleBean = new SyntheseViseeBeanPatrouille();
                    first = true;
                }
                if (first && dateDebut != null) {
                    patrouilleBean.setDate(sdfDate.format(new Date(dateDebut.getTime())));
                    patrouilleBean.setDateCompare(sdfDateCompare.format(new Date(dateDebut.getTime())));
                    patrouilleBean.setHeureDebut(sdfHeure.format(new Date(dateDebut.getTime())));
                }
                if ((duree = (dateFin = rs.getTimestamp("fin")) != null ? (double)(dateFin.getTime() - dateDebut.getTime()) : -1.0) != -1.0) {
                    if (dureePrec != -1.0) {
                        duree += dureePrec;
                    }
                    patrouilleBean.setDuree(duree);
                    patrouilleBean.setDuree(duree);
                } else {
                    patrouilleBean.setDuree(-1.0);
                }
                if (rs.getString("immatriculation") != null) {
                    patrouilleBean.setVehicule(rs.getString("immatriculation"));
                } else {
                    patrouilleBean.setVehicule(rs.getString("code_vehicule"));
                }
                patrouilleBean.setPatrouilleur(rs.getString("nom"));
                if (rs.getString("centre") == null) {
                    patrouilleBean.setCerd("");
                } else {
                    patrouilleBean.setCerd(rs.getString("centre"));
                }
                if (rs.getString("delegation") == null) {
                    patrouilleBean.setDelegation("");
                } else {
                    patrouilleBean.setDelegation(rs.getString("delegation"));
                }
                patrouilleBean.setTypePatrouille(rs.getInt("type"));
                longueur = this.getLongueurPatrouille(connection, rs.getString("id"));
                patrouilleBean.setLongueur("" + (longueur += longueurPrec));
                if (rs.getTimestamp("date_visa") != null) {
                    patrouilleBean.setVisa(sdfDate.format(new Date(rs.getTimestamp("date_visa").getTime())));
                }
                dureePrec = duree;
                longueurPrec = longueur;
                first = false;
            }
            Log.debug("requette synthese fin recup\u00e9ration");
            if (!first) {
                patrouilleBeanList.add(patrouilleBean);
                if (!dates.contains(patrouilleBean.getDate())) {
                    dates.add(patrouilleBean.getDate());
                }
                if (!cerd.contains(patrouilleBean.getCerd())) {
                    cerd.add(patrouilleBean.getCerd());
                }
                if (!delegationList.contains(patrouilleBean.getDelegation())) {
                    delegationList.add(patrouilleBean.getDelegation());
                }
                if (!vehicules.contains(patrouilleBean.getVehicule())) {
                    vehicules.add(patrouilleBean.getVehicule());
                }
                if (!patrouilleurs.contains(patrouilleBean.getPatrouilleur())) {
                    patrouilleurs.add(patrouilleBean.getPatrouilleur());
                }
                dureeTotale += dureePrec;
                longueurTotale += longueurPrec;
                dureePrec = 0.0;
                longueurPrec = 0L;
                if (!patrouilleBean.getVisa().equals("")) {
                    ++nbVisa;
                }
            }
            syntheseViseeBean.setPatrouilles(patrouilleBeanList);
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        ArrayList patrouilles = syntheseViseeBean.getPatrouilles();
        Collections.sort(patrouilles);
        syntheseViseeBean.setPatrouilles(patrouilles);
        SyntheseViseeBeanCumul cumul = new SyntheseViseeBeanCumul();
        cumul.setDate("" + dates.size());
        cumul.setCerd("" + cerd.size());
        cumul.setDelegation("" + delegationList.size());
        cumul.setVehicule("" + vehicules.size());
        cumul.setPatrouilleur("" + patrouilleurs.size());
        if (dureeTotale > 0.0) {
            cumul.setDuree(dureeTotale);
        } else {
            cumul.setDuree(-1.0);
        }
        if (longueurTotale > 0L) {
            cumul.setLongueur("" + longueurTotale);
        } else {
            cumul.setLongueur("-");
        }
        if (patrouilles.size() > 0) {
            int pourcentage = nbVisa * 100 / patrouilles.size();
            cumul.setVisa(nbVisa + " (" + pourcentage + "%)");
        } else {
            cumul.setVisa("-");
        }
        syntheseViseeBean.setCumul(cumul);
        return syntheseViseeBean;
    }
}

