/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconStats;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IStatsDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.sql.SQL;
import java.awt.geom.Point2D;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.postgis.Geometry;

public class StatsDAOJDBC
implements IStatsDAO {
    private static final String SQL_PATROUILLES_RECHERCHE = "SELECT * FROM vh.evenement_vh v, prism.patrouille p WHERE v.id_patrouille = p.id AND st_intersects(v.coordonnees, st_buffer(st_transform(st_setsrid(st_makepoint(?,?), 4326), 32630), 25)) AND date > ? AND date < ? ORDER BY date DESC";
    private static final String SQL_KM_DENEIGEMENT_BY_YEAR = "SELECT p.delegation, p.centre, date_part('month',p.jour) as mois, COUNT(p.nb_patrouilles_circuit) as nb_patrouilles, st_length(st_union(p.coordonnees)) as nb_km_deneigement FROM ( SELECT DISTINCT 1 as nb_patrouilles_circuit, date_trunc('day',pat.debut) as jour, u.delegation, u.centre, st_union(coordonnees) as coordonnees FROM patrouille pat, mcig m, utilisateur u, vh.evenement_vh evh WHERE date_part('year',pat.debut) = ? AND pat.id_circuit >= 0 AND pat.type = ? AND pat.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND u.mse = ? AND u.centre IS NOT null AND u.delegation IS NOT NULL AND evh.mcig_id = m.mcig_id AND evh.deneigement = 1 GROUP BY delegation, centre, jour order by jour, delegation, centre ) p GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC";
    private static final String SQL_KM_SALAGE_BY_YEAR = "SELECT p.delegation, p.centre, date_part('month',p.jour) as mois, COUNT(p.nb_patrouilles_circuit) as nb_patrouilles,st_length(st_union(coordonnees))  as nb_km_salage FROM ( SELECT DISTINCT 1 as nb_patrouilles_circuit, date_trunc('day',pat.debut) as jour, u.delegation, u.centre, st_union(coordonnees) as coordonnees FROM patrouille pat, mcig m, utilisateur u, vh.evenement_vh evh WHERE date_part('year',pat.debut) = ? AND pat.id_circuit >= 0 AND pat.type = ? AND pat.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND u.mse = ? AND u.centre IS NOT null AND u.delegation IS NOT NULL AND evh.mcig_id = m.mcig_id AND evh.seuil_salage = 1 GROUP BY delegation, centre, jour order by jour, delegation, centre ) p GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC";
    private static final String SQL_KM_PARCOURU_BY_YEAR = "SELECT p.delegation, p.centre, date_part('month',p.jour) as mois, COUNT(p.nb_patrouilles_circuit) as nb_patrouilles, st_length(st_union(p.coordonnees)) as nb_km_parcouru FROM ( SELECT DISTINCT 1 as nb_patrouilles_circuit, date_trunc('day',pat.debut) as jour, u.delegation, u.centre, st_union(coordonnees) as coordonnees FROM patrouille pat, mcig m, utilisateur u, vh.evenement_vh evh WHERE date_part('year',pat.debut) = ? AND pat.id_circuit >= 0 AND pat.type = ? AND pat.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND u.mse = ? AND u.centre IS NOT null AND u.delegation IS NOT NULL AND evh.mcig_id = m.mcig_id GROUP BY delegation, centre, jour order by jour, delegation, centre ) p GROUP BY mois, delegation, centre ORDER BY delegation ASC, centre ASC, mois ASC";
    private static final String SQL_SCHEMA_ROUTIER_NIV_EXPLOITATION_HISTORIQUE = "SELECT *  FROM stats.schema_routier_exploitation_historique s, donnees_metier.schema_routier tc WHERE s.idtroncon = tc.oid AND s.date_calcul = DATE_TRUNC('day', ?::timestamp) ";
    private DAOFactory daoFactory;

    public StatsDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public List<Patrouille> getPatrouilles(List<Integer> codeModuleMetier, List<String> delegations, List<String> centres, Timestamp dateDebut, Timestamp dateFin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Patrouille> patrouilles = new ArrayList<Patrouille>();
        String req = SQL_PATROUILLES_RECHERCHE;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            Log.debug("requette recherche patrouielle : " + pstm);
            rs = pstm.executeQuery();
            SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
            while (rs.next()) {
                Patrouille p = new Patrouille();
                p.setId(rs.getString("id_patrouille"));
                p.setDebut(rs.getTimestamp("debut").getTime());
                if (rs.getTimestamp("fin") != null) {
                    p.setFin(rs.getTimestamp("fin").getTime());
                }
                p.setMcig(rs.getString("mcig_id"));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ModuleMetier", rs.getString("type"));
                p.setParametres(params);
                patrouilles.add(p);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouilles;
    }

    @Override
    public Map<String, Map<String, Map<Integer, Map<String, Integer>>>> getStatsSimplePatrouillesParAnneeVH(Integer annee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        LinkedHashMap<String, Map<String, Map<Integer, Map<String, Integer>>>> retour = new LinkedHashMap<String, Map<String, Map<Integer, Map<String, Integer>>>>();
        try {
            String reqSalage = SQL_KM_SALAGE_BY_YEAR;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(reqSalage);
            String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
            pstm.setInt(1, annee);
            pstm.setInt(2, 1);
            pstm.setString(3, zr);
            Log.debug("requette : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> mapMoisSats;
                String delegation = rs.getString("delegation");
                String centre = rs.getString("centre");
                int mois = rs.getInt("mois");
                int nbPatrouilles = rs.getInt("nb_patrouilles");
                int kmSalage = rs.getInt("nb_km_salage");
                Map mapCentre = new LinkedHashMap();
                if (retour.containsKey(delegation)) {
                    mapCentre = (Map)retour.get(delegation);
                }
                Map<Integer, HashMap<String, Integer>> mapMois = new HashMap();
                if (mapCentre.containsKey(centre)) {
                    mapMois = (Map)mapCentre.get(centre);
                }
                if ((mapMoisSats = (HashMap<String, Integer>)mapMois.get(mois - 1)) == null) {
                    mapMoisSats = new HashMap<String, Integer>();
                }
                mapMoisSats.put("SALAGE", kmSalage);
                mapMoisSats.put("PATROUILLE_SALAGE", nbPatrouilles);
                mapMois.put(mois - 1, mapMoisSats);
                mapCentre.put(centre, mapMois);
                retour.put(delegation, mapCentre);
            }
            rs.close();
            pstm.close();
            String reqDeneigement = SQL_KM_DENEIGEMENT_BY_YEAR;
            pstm = connection.prepareStatement(reqDeneigement);
            pstm.setInt(1, annee);
            pstm.setInt(2, 1);
            pstm.setString(3, zr);
            Log.debug("requette : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> mapMoisSats;
                String delegation = rs.getString("delegation");
                String centre = rs.getString("centre");
                int mois = rs.getInt("mois");
                int nbPatrouilles = rs.getInt("nb_patrouilles");
                int nbKmDeneiges = rs.getInt("nb_km_deneigement");
                Map mapCentre = new LinkedHashMap();
                if (retour.containsKey(delegation)) {
                    mapCentre = (Map)retour.get(delegation);
                }
                Map<Integer, HashMap<String, Integer>> mapMois = new HashMap();
                if (mapCentre.containsKey(centre)) {
                    mapMois = (Map)mapCentre.get(centre);
                }
                if ((mapMoisSats = (HashMap<String, Integer>)mapMois.get(mois - 1)) == null) {
                    mapMoisSats = new HashMap<String, Integer>();
                }
                mapMoisSats.put("DENEIGEMENT", nbKmDeneiges);
                mapMoisSats.put("PATROUILLE_DENEIGEMENT", nbPatrouilles);
                mapMois.put(mois - 1, mapMoisSats);
                mapCentre.put(centre, mapMois);
                retour.put(delegation, mapCentre);
            }
            rs.close();
            pstm.close();
            String reqKmTotal = SQL_KM_PARCOURU_BY_YEAR;
            pstm = connection.prepareStatement(reqKmTotal);
            pstm.setInt(1, annee);
            pstm.setInt(2, 1);
            pstm.setString(3, zr);
            Log.debug("requette : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> mapMoisSats;
                String delegation = rs.getString("delegation");
                String centre = rs.getString("centre");
                int mois = rs.getInt("mois");
                int nbPatrouilles = rs.getInt("nb_patrouilles");
                int kmPatrouilles = rs.getInt("nb_km_parcouru");
                Map mapCentre = new LinkedHashMap();
                if (retour.containsKey(delegation)) {
                    mapCentre = (Map)retour.get(delegation);
                }
                Map<Integer, HashMap<String, Integer>> mapMois = new HashMap();
                if (mapCentre.containsKey(centre)) {
                    mapMois = (Map)mapCentre.get(centre);
                }
                if ((mapMoisSats = (HashMap<String, Integer>)mapMois.get(mois - 1)) == null) {
                    mapMoisSats = new HashMap<String, Integer>();
                }
                mapMoisSats.put("KM_TOTAL", kmPatrouilles);
                mapMoisSats.put("PATROUILLE_TOTAL", nbPatrouilles);
                mapMois.put(mois - 1, mapMoisSats);
                mapCentre.put(centre, mapMois);
                retour.put(delegation, mapCentre);
            }
            rs.close();
            pstm.close();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public Map<String, Map<String, Map<Integer, Map<String, Integer>>>> getStatsSimplePatrouillesParAnnee(Integer annee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        LinkedHashMap<String, Map<String, Map<Integer, Map<String, Integer>>>> retour = new LinkedHashMap<String, Map<String, Map<Integer, Map<String, Integer>>>>();
        try {
            String reqKmTotal = SQL_KM_PARCOURU_BY_YEAR;
            String zr = ConfigurationFactory.getInstance().get("zoneroutiere");
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(reqKmTotal);
            pstm.setInt(1, annee);
            pstm.setInt(2, 0);
            pstm.setString(3, zr);
            Log.debug("requette : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                HashMap<String, Integer> mapMoisSats;
                String delegation = rs.getString("delegation");
                String centre = rs.getString("centre");
                int mois = rs.getInt("mois");
                int nbPatrouilles = rs.getInt("nb_patrouilles");
                int kmPatrouilles = rs.getInt("nb_km_parcouru");
                Map mapCentre = new LinkedHashMap();
                if (retour.containsKey(delegation)) {
                    mapCentre = (Map)retour.get(delegation);
                }
                Map<Integer, HashMap<String, Integer>> mapMois = new HashMap();
                if (mapCentre.containsKey(centre)) {
                    mapMois = (Map)mapCentre.get(centre);
                }
                if ((mapMoisSats = (HashMap<String, Integer>)mapMois.get(mois - 1)) == null) {
                    mapMoisSats = new HashMap<String, Integer>();
                }
                mapMoisSats.put("KM_TOTAL", kmPatrouilles);
                mapMoisSats.put("PATROUILLE_TOTAL", nbPatrouilles);
                mapMois.put(mois - 1, mapMoisSats);
                mapCentre.put(centre, mapMois);
                retour.put(delegation, mapCentre);
            }
            rs.close();
            pstm.close();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe, boolean dateDernierPassageConnu) {
        ArrayList retour = new ArrayList();
        Object troncons = null;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Date> mapDerniereDatePAssage = new HashMap<String, Date>();
        return this.getStatSchemaRoutierTronconPrecalcule(centres, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, axe, dateDebut);
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatSchemaRoutierTronconPrecalcule(List<Centre> centres, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, String axe, Timestamp dateCalcul) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = SQL_SCHEMA_ROUTIER_NIV_EXPLOITATION_HISTORIQUE;
            if (axe != null) {
                requete = requete + " AND axe = ?";
            }
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, dateCalcul);
            if (axe != null) {
                pstm.setString(2, axe);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String[] derniersPassages = null;
                Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                if (arrayIdPatrouilles != null) {
                    derniersPassages = (String[])arrayIdPatrouilles.getArray();
                }
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                mapPatrouillesId.put(tronocnID, derniersPassages);
                int pourcentage = rs.getInt("pourcentage_parcouru");
                Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                Timestamp datemaj = rs.getTimestamp("date_calcul");
                String delegation = null;
                String centre = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String abscissePrDebut = rs.getString("absd");
                String prFint = rs.getString("plof");
                String abscissePrFin = rs.getString("absf");
                int niveau = rs.getInt("fk_niveau_service");
                String description = rs.getString("axe");
                String niveauExploitation = rs.getString("niveau_exploitation");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                Vector<double[]> xsML = new Vector<double[]>();
                Vector<double[]> ysML = new Vector<double[]>();
                try {
                    Vector coordPArGeometry = SQL.getPoints2DByGeometry((Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                    for (int k = 0; k < coordPArGeometry.size(); ++k) {
                        Vector coord = (Vector)coordPArGeometry.get(k);
                        int nbPoint = coord.size();
                        double[] x = new double[nbPoint];
                        double[] y = new double[nbPoint];
                        for (int i = 0; i < nbPoint; ++i) {
                            x[i] = ((Point2D.Double)coord.get((int)i)).x;
                            y[i] = ((Point2D.Double)coord.get((int)i)).y;
                        }
                        xsML.add(x);
                        ysML.add(y);
                    }
                    mapPositionXs.put(tronocnID, xsML);
                    mapPositionYs.put(tronocnID, ysML);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (centres != null && !centres.contains(centre)) continue;
                retour.add(new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, pourcentage, niveau, derniersPassages, (Date)dateDernierPassage, (Date)datemaj, xsML, ysML, prDebut, abscissePrDebut, prFint, abscissePrFin, null, delegation, centre, niveauExploitation, longueur));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int typeGestionPasse, String delegation, String centre, String idCircuit, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours) {
        if (typeGestionPasse == 1) {
            return this.getStatistiqueSchemaFauchageHistoriqueGestionParCircuit(delegation, centre, idCircuit, dateDebut, dateFin, bufferSize, ratioParcours);
        }
        return this.getStatistiqueSchemaFauchageHistoriqueGestionParCentre(delegation, centre, dateDebut, dateFin, bufferSize, ratioParcours);
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistoriqueGestionParCircuit(String delegation, String centre, String idCircuit, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sfeh.idtroncon as idtroncon, pt.passe_type_libelle as passe_libelle, sum(coalesce(distance_cumulee,0)) as distance_cumulee,  sum(array_ndims(patrouille_id)) as nb_patrouilles, array_agg(date_dernier_passage) as dates_passage,  tc.axe as axe, tc.plod as plod, tc.plof as plof , st_length(st_transform(coordonnees,2154)) as longueur, c.delegation , c.centre from fauchage.schema_fauchage_exploitation_historique sfeh, \n fauchage.schema_fauchage tc, prism.circuit c, fauchage.passe_circuit pc, fauchage.passe_type pt  where  date_calcul >= ?  and date_calcul < ?  and tc.idcircuit  = c.id  and pc.passe_id_circuit  = c.id  and sfeh.idtroncon  = tc.oid and date_calcul >= pc.passe_debut  and date_calcul < coalesce(pc.passe_fin, now()) and pt.passe_type_id = pc.passe_type_id and sfeh.geom_parcourue is not null ";
            if (delegation != null && !delegation.equals("")) {
                requete = requete + " and c.delegation  = ? ";
            }
            if (centre != null && !centre.equals("")) {
                requete = requete + " and c.centre = ? ";
            }
            if (idCircuit != null && !idCircuit.equals("")) {
                requete = requete + " and  c.id = ? ";
            }
            requete = requete + " group by idtroncon, pt.passe_type_libelle, tc.axe, tc.plod, tc.plof,c.delegation , c.centre, tc.coordonnees ";
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            if (delegation != null && !delegation.equals("")) {
                pstm.setString(3, delegation);
            }
            if (centre != null && !centre.equals("")) {
                pstm.setString(4, centre);
            }
            if (idCircuit != null && !idCircuit.equals("")) {
                pstm.setInt(5, Integer.parseInt(idCircuit));
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                troncon.addParamater((Object)"passe_libelle", (Object)rs.getString("passe_libelle"));
                troncon.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                troncon.addParamater((Object)"nb_patrouilles", (Object)rs.getInt("nb_patrouilles"));
                Timestamp[] datesPassage = null;
                Array arrayIdPatrouilles = rs.getArray("dates_passage");
                if (arrayIdPatrouilles != null) {
                    datesPassage = (Timestamp[])arrayIdPatrouilles.getArray();
                }
                troncon.addParamater((Object)"dates_passage", (Object)datesPassage);
                troncon.addParamater((Object)"distance_cumulee", (Object)rs.getInt("distance_cumulee"));
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistoriqueGestionParCentre(String delegation, String centre, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sfeh.idtroncon as idtroncon, pt.passe_type_libelle as passe_libelle, sum(coalesce(distance_cumulee,0)) as distance_cumulee,  sum(array_ndims(patrouille_id)) as nb_patrouilles, array_agg(date_dernier_passage) as dates_passage,  tc.axe as axe, tc.plod as plod, tc.plof as plof , tc.longueur as longueur, tc.delegation , tc.centre from fauchage.schema_fauchage_exploitation_historique sfeh, \n fauchage.schema_fauchage tc, fauchage.passe_centre pc, fauchage.passe_type pt  where  date_calcul >= ?  and date_calcul < ?  and sfeh.idtroncon  = tc.oid and date_calcul >= pc.passe_debut  and date_calcul < coalesce(pc.passe_fin, now()) and pt.passe_type_id = pc.passe_type_id and tc.delegation = pc.passe_delegation_id  and tc.centre = pc.passe_centre_nom  and sfeh.geom_parcourue is not null";
            if (delegation != null) {
                requete = requete + " and tc.delegation in (select id from prism.delegation_rattachement where nom = ?) ";
            }
            if (centre != null) {
                requete = requete + " and tc.centre = ? ";
            }
            requete = requete + " group by idtroncon, pt.passe_type_libelle, tc.axe, tc.plod, tc.plof,tc.delegation , tc.centre, tc.longueur";
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            if (delegation != null) {
                pstm.setString(3, delegation);
            }
            if (centre != null) {
                pstm.setString(4, centre);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                troncon.addParamater((Object)"passe_libelle", (Object)rs.getString("passe_libelle"));
                troncon.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                troncon.addParamater((Object)"nb_patrouilles", (Object)rs.getInt("nb_patrouilles"));
                Timestamp[] datesPassage = null;
                Array arrayIdPatrouilles = rs.getArray("dates_passage");
                if (arrayIdPatrouilles != null) {
                    datesPassage = (Timestamp[])arrayIdPatrouilles.getArray();
                }
                troncon.addParamater((Object)"dates_passage", (Object)datesPassage);
                troncon.addParamater((Object)"distance_cumulee", (Object)rs.getInt("distance_cumulee"));
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistorique(int typeGestionPasse, String delegation, String centre, String idCircuit, String passe, int bufferSize, int ratioParcours) {
        if (typeGestionPasse == 0) {
            return this.getStatistiqueSchemaFauchageHistoriqueGestionParCentre(delegation, centre, passe, bufferSize, ratioParcours);
        }
        if (typeGestionPasse == 2) {
            return this.getStatistiqueSchemaFauchageHistoriqueGestionParCampagne(delegation, centre, passe, bufferSize, ratioParcours);
        }
        return this.getStatistiqueSchemaFauchageHistoriqueGestionParCircuit(delegation, centre, idCircuit, passe, bufferSize, ratioParcours);
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistoriqueGestionParCircuit(String delegation, String centre, String idCircuit, String passe, int bufferSize, int ratioParcours) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sfeh.idtroncon as idtroncon, pt.passe_type_libelle as passe_libelle, sum(coalesce(distance_cumulee,0)) as distance_cumulee,  sum(array_ndims(patrouille_id)) as nb_patrouilles, array_agg(date_dernier_passage) as dates_passage,  tc.axe as axe, tc.plod as plod, tc.plof as plof , st_length(st_transform(coordonnees,2154)) as longueur, c.delegation , c.centre,  sfeh.passe_type_id  from fauchage.schema_fauchage_exploitation_historique sfeh,  fauchage.schema_fauchage tc, prism.circuit c, fauchage.passe_circuit pc, fauchage.passe_type pt  where  tc.idcircuit  = c.id  and pc.passe_id_circuit  = c.id  and sfeh.idtroncon  = tc.oid and date_calcul >= pc.passe_debut  and date_calcul < coalesce(pc.passe_fin, now()) and pt.passe_type_id = pc.passe_type_id and pt.passe_type_libelle = ?  and sfeh.geom_parcourue is not null ";
            if (delegation != null && !delegation.equals("")) {
                requete = requete + " and c.delegation  = ? ";
            }
            if (centre != null && !centre.equals("")) {
                requete = requete + " and c.centre = ? ";
            }
            if (idCircuit != null && !idCircuit.equals("")) {
                requete = requete + " and  c.id = ? ";
            }
            requete = requete + " group by idtroncon, pt.passe_type_libelle, sfeh.passe_type_id, tc.axe, tc.plod, tc.plof,c.delegation , c.centre, tc.coordonnees";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, passe);
            if (delegation != null && !delegation.equals("")) {
                pstm.setString(2, delegation);
            }
            if (centre != null && !centre.equals("")) {
                pstm.setString(3, centre);
            }
            if (idCircuit != null && !idCircuit.equals("")) {
                pstm.setInt(4, Integer.parseInt(idCircuit));
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                Integer passeTypeId = rs.getInt("passe_type_id");
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                troncon.addParamater((Object)"passe_libelle", (Object)rs.getString("passe_libelle"));
                troncon.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                troncon.addParamater((Object)"nb_patrouilles", (Object)rs.getInt("nb_patrouilles"));
                Timestamp[] datesPassage = null;
                Array arrayIdPatrouilles = rs.getArray("dates_passage");
                if (arrayIdPatrouilles != null) {
                    datesPassage = (Timestamp[])arrayIdPatrouilles.getArray();
                }
                troncon.addParamater((Object)"dates_passage", (Object)datesPassage);
                troncon.addParamater((Object)"distance_cumulee", (Object)rs.getInt("distance_cumulee"));
                troncon.addParamater((Object)"passe_id_type", (Object)passeTypeId);
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistoriqueGestionParCampagne(String delegation, String centre, String passe, int bufferSize, int ratioParcours) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sfeh.idtroncon as idtroncon, pt.passe_type_libelle as passe_libelle, sum(coalesce(distance_cumulee,0)) as distance_cumulee,  sum(array_ndims(patrouille_id)) as nb_patrouilles, array_agg(date_dernier_passage) as dates_passage,  tc.axe as axe, tc.plod as plod, tc.plof as plof , tc.longueur as longueur, tc.delegation , tc.centre,  sfeh.passe_type_id as passe_type_id  from fauchage.schema_fauchage_exploitation_historique sfeh, \n fauchage.schema_fauchage tc, fauchage.passe_campagne pc, fauchage.passe_type pt  where  sfeh.idtroncon  = tc.oid and date_calcul >= pc.passe_debut  and date_calcul < coalesce(pc.passe_fin, now()) and pt.passe_type_id = pc.passe_type_id and pt.passe_type_libelle = ?  and sfeh.passe_type_id = pt.passe_type_id  and sfeh.geom_parcourue is not null ";
            if (delegation != null) {
                requete = requete + " and tc.delegation in (select id from prism.delegation_rattachement where nom = ?) ";
            }
            if (centre != null) {
                requete = requete + " and tc.centre = ? ";
            }
            requete = requete + " group by idtroncon, pt.passe_type_libelle, sfeh.passe_type_id, tc.axe, tc.plod, tc.plof, tc.delegation , tc.centre, tc.longueur";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, passe);
            if (delegation != null) {
                pstm.setString(2, delegation);
            }
            if (centre != null) {
                pstm.setString(3, centre);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                Integer passeTypeId = rs.getInt("passe_type_id");
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                troncon.addParamater((Object)"passe_libelle", (Object)rs.getString("passe_libelle"));
                troncon.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                troncon.addParamater((Object)"nb_patrouilles", (Object)rs.getInt("nb_patrouilles"));
                Timestamp[] datesPassage = null;
                Array arrayIdPatrouilles = rs.getArray("dates_passage");
                if (arrayIdPatrouilles != null) {
                    datesPassage = (Timestamp[])arrayIdPatrouilles.getArray();
                }
                troncon.addParamater((Object)"dates_passage", (Object)datesPassage);
                troncon.addParamater((Object)"distance_cumulee", (Object)rs.getInt("distance_cumulee"));
                troncon.addParamater((Object)"passe_type_id", (Object)passeTypeId);
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaFauchageHistoriqueGestionParCentre(String delegation, String centre, String passe, int bufferSize, int ratioParcours) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sfeh.idtroncon as idtroncon, pt.passe_type_libelle as passe_libelle, sum(coalesce(distance_cumulee,0)) as distance_cumulee,  sum(array_ndims(patrouille_id)) as nb_patrouilles, array_agg(date_dernier_passage) as dates_passage,  tc.axe as axe, tc.plod as plod, tc.plof as plof , tc.longueur as longueur, tc.delegation , tc.centre from fauchage.schema_fauchage_exploitation_historique sfeh, \n fauchage.schema_fauchage tc, fauchage.passe_centre pc, fauchage.passe_type pt  where  sfeh.idtroncon  = tc.oid and date_calcul >= pc.passe_debut  and date_calcul < coalesce(pc.passe_fin, now()) and pt.passe_type_id = pc.passe_type_id and pt.passe_type_libelle = ?  and tc.delegation = pc.passe_delegation_id and tc.centre = pc.passe_centre_nom  and sfeh.geom_parcourue is not null ";
            if (delegation != null) {
                requete = requete + " and tc.delegation in (select id from prism.delegation_rattachement where nom = ?) ";
            }
            if (centre != null) {
                requete = requete + " and tc.centre = ? ";
            }
            requete = requete + " group by idtroncon, pt.passe_type_libelle, tc.axe, tc.plod, tc.plof,tc.delegation , tc.centre, tc.longueur";
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, passe);
            if (delegation != null) {
                pstm.setString(2, delegation);
            }
            if (centre != null) {
                pstm.setString(3, centre);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                troncon.addParamater((Object)"passe_libelle", (Object)rs.getString("passe_libelle"));
                troncon.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                troncon.addParamater((Object)"nb_patrouilles", (Object)rs.getInt("nb_patrouilles"));
                Timestamp[] datesPassage = null;
                Array arrayIdPatrouilles = rs.getArray("dates_passage");
                if (arrayIdPatrouilles != null) {
                    datesPassage = (Timestamp[])arrayIdPatrouilles.getArray();
                }
                troncon.addParamater((Object)"dates_passage", (Object)datesPassage);
                troncon.addParamater((Object)"distance_cumulee", (Object)rs.getInt("distance_cumulee"));
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutierHistorique(Timestamp dateDebut, Timestamp dateFin, int codeModuleMetier, String delegation, String centre) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "select sreh.idtroncon ,sr.axe, sr.plod, sr.plof, sr.delegation , sr.centre, array_agg(date_calcul) as dates, array_agg(pourcentage_parcouru) as pourcentages from stats.schema_routier_exploitation_historique sreh , donnees_metier.schema_routier sr  where sreh.idtroncon  = sr.\"oid\" and sreh.date_calcul >= ?  and sreh.date_calcul < ?  and pourcentage_parcouru < 95";
            if (delegation != null) {
                requete = requete + " and sr.delegation in (select id from prism.delegation_rattachement where nom = ?) ";
            }
            if (centre != null) {
                requete = requete + " and sr.centre = ? ";
            }
            requete = requete + " group by idtroncon,  sr.axe, sr.plod, sr.plof, sr.delegation , sr.centre";
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            if (delegation != null) {
                pstm.setString(3, delegation);
            }
            if (centre != null) {
                pstm.setString(4, centre);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                String delegationTroncon = rs.getString("delegation");
                String centreTroncon = rs.getString("centre");
                String prDebut = rs.getString("plod");
                String prFint = rs.getString("plof");
                String description = rs.getString("axe");
                int longueur = -1;
                try {
                    longueur = rs.getInt("longueur");
                }
                catch (Exception e) {
                    longueur = -1;
                }
                SyntheseTableauBordStatistiqueSchemaRoutierBean troncon = new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, -1, 0, null, null, null, null, null, prDebut, null, prFint, null, null, delegationTroncon, centreTroncon, null, longueur);
                Timestamp[] dates = null;
                Array arrayDates = rs.getArray("dates");
                if (arrayDates != null) {
                    dates = (Timestamp[])arrayDates.getArray();
                }
                troncon.addParamater((Object)"dates", (Object)dates);
                Integer[] pourcentages = null;
                Array arrayPourcentages = rs.getArray("pourcentages");
                if (arrayPourcentages != null) {
                    pourcentages = (Integer[])arrayPourcentages.getArray();
                }
                troncon.addParamater((Object)"pourcentages", (Object)pourcentages);
                retour.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    public List<Troncon> getRoadsAmplitude2(String idPatrouille) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        String REQUETE = "select axe, max(pr*10000+abscisse_pr ) / 10000 as pr_max, max(pr*10000+abscisse_pr )%10000 as pr_abs_max ,\n min(pr*10000+abscisse_pr )  / 10000 as pr_min,  min(pr*10000+abscisse_pr ) %10000 as pr_abs_min\n ,cch  from prism.localisation l  where  ";
        REQUETE = REQUETE + "id_patrouille = ? ";
        REQUETE = REQUETE + " group by axe, cch;";
        try (Connection connection = this.daoFactory.getConnection();){
            pstm = connection.prepareStatement(REQUETE);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Troncon troncon = new Troncon();
                troncon.setAxe(rs.getString("axe"));
                troncon.setPrDebut(rs.getInt("pr_min"));
                troncon.setPrFin(rs.getInt("pr_max"));
                troncon.setAbscissePrDebut(rs.getInt("pr_abs_min"));
                troncon.setAbscissePrFin(rs.getInt("pr_abs_max"));
                troncon.setClassification(rs.getString("cch"));
                troncons.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return troncons;
    }

    public List<TronconStats> getRoadsAmplitude0(String idPatrouille) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconStats> troncons = new ArrayList<TronconStats>();
        String REQUETE = "select id, axe, sens_pr, pr,abscisse_pr, cch, date_heure_loc, st_x(coordonnees) as x, st_y(coordonnees) as y from prism.localisation where ";
        REQUETE = REQUETE + "id_patrouille = ? ";
        REQUETE = REQUETE + " order by date_heure_loc;";
        try (Connection connection = this.daoFactory.getConnection();){
            pstm = connection.prepareStatement(REQUETE);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            String axeEnCours = null;
            int sensPRENCours = -1;
            String cchEnCours = "";
            int prMinEnCours = Integer.MAX_VALUE;
            int prMaxEnCours = Integer.MIN_VALUE;
            int absMinEnCours = Integer.MAX_VALUE;
            int absMaxEnCours = Integer.MIN_VALUE;
            double xPrecedent = -1.0;
            double yPrecedent = -1.0;
            String prPrecedent = "";
            Timestamp dateEnCours = null;
            Timestamp dateDebut = null;
            double distanceEnCours = 0.0;
            Timestamp date = null;
            int positionConsecutive = 0;
            while (rs.next()) {
                TronconStats troncon;
                String id = rs.getString("id");
                String cch = rs.getString("cch");
                String axe = rs.getString("axe");
                String prString = rs.getString("pr");
                int pr = rs.getInt("pr");
                int abs = rs.getInt("abscisse_pr");
                int sensPR = rs.getInt("sens_pr");
                date = rs.getTimestamp("date_heure_loc");
                double x = rs.getDouble("x");
                double y = rs.getDouble("y");
                if (axeEnCours != null && axeEnCours.equals(axe) && cchEnCours.equals(cch)) {
                    if ((sensPRENCours == sensPR || sensPRENCours == 0) && cchEnCours.equals(cch)) {
                        if (prString != null) {
                            if (pr == prMinEnCours) {
                                absMinEnCours = Math.min(absMinEnCours, abs);
                            } else if (prMinEnCours > pr) {
                                prMinEnCours = pr;
                                absMinEnCours = abs;
                            }
                            if (pr == prMaxEnCours) {
                                absMaxEnCours = Math.max(absMaxEnCours, abs);
                            } else if (prMaxEnCours < pr) {
                                prMaxEnCours = pr;
                                absMaxEnCours = abs;
                            }
                        }
                        prPrecedent = String.valueOf(pr);
                        sensPRENCours = sensPR;
                        distanceEnCours = Math.sqrt((y - yPrecedent) * (y - yPrecedent) + (x - xPrecedent) * (x - xPrecedent));
                        dateEnCours = date;
                        ++positionConsecutive;
                        continue;
                    }
                    if (prPrecedent == null) {
                        prPrecedent = String.valueOf(pr);
                        sensPRENCours = sensPR;
                        distanceEnCours = Math.sqrt((y - yPrecedent) * (y - yPrecedent) + (x - xPrecedent) * (x - xPrecedent));
                        dateEnCours = date;
                        ++positionConsecutive;
                        continue;
                    }
                    troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, dateEnCours, distanceEnCours);
                    if (distanceEnCours > 0.0) {
                        troncons.add(troncon);
                        distanceEnCours = 0.0;
                        axeEnCours = axe;
                        sensPRENCours = sensPR;
                        cchEnCours = cch;
                        prMinEnCours = pr;
                        absMinEnCours = abs;
                        prMaxEnCours = pr;
                        absMaxEnCours = abs;
                        xPrecedent = x;
                        yPrecedent = y;
                        dateDebut = date;
                        dateEnCours = date;
                        continue;
                    }
                    axeEnCours = axe;
                    sensPRENCours = sensPR;
                    cchEnCours = cch;
                    continue;
                }
                if (axeEnCours != null) {
                    troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, dateEnCours, distanceEnCours);
                    if (distanceEnCours > 0.0) {
                        troncons.add(troncon);
                    }
                }
                axeEnCours = axe;
                sensPRENCours = sensPR;
                cchEnCours = cch;
                prMinEnCours = pr;
                absMinEnCours = abs;
                prMaxEnCours = pr;
                absMaxEnCours = abs;
                xPrecedent = x;
                yPrecedent = y;
                distanceEnCours = 0.0;
                dateDebut = date;
                dateEnCours = date;
                positionConsecutive = 0;
            }
            if (distanceEnCours > 0.0) {
                TronconStats troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, date, distanceEnCours);
                troncons.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return troncons;
    }

    private TronconStats creationTronconFauchage(String idPatrouille, String axeEnCours, int sensPRENCours, int prMinEnCours, int absMinEnCours, int prMaxEnCours, int absMaxEnCours, String cchEnCours, Timestamp dateDebut, Timestamp date, double distanceEnCours) {
        TronconStats troncon = new TronconStats();
        troncon.setId("stats" + UUID.randomUUID());
        troncon.setAxe(axeEnCours);
        if (sensPRENCours == 1) {
            troncon.setPrDebut(prMinEnCours);
            troncon.setAbscissePrDebut(absMinEnCours);
            troncon.setPrFin(prMaxEnCours);
            troncon.setAbscissePrFin(absMaxEnCours);
        } else {
            troncon.setPrDebut(prMaxEnCours);
            troncon.setAbscissePrDebut(absMaxEnCours);
            troncon.setPrFin(prMinEnCours);
            troncon.setAbscissePrFin(absMinEnCours);
        }
        troncon.setClassification(cchEnCours);
        troncon.setSensNumerique(sensPRENCours);
        troncon.setPremiereDate(dateDebut.getTime());
        troncon.setDerniereDate(date.getTime());
        double longueur = this.calculLongueurFromEvenementVH(idPatrouille, dateDebut, date);
        if (longueur == -1.0) {
            longueur = distanceEnCours;
        }
        troncon.setLongueur((int)longueur);
        troncon.setCircuit(distanceEnCours + " / " + longueur);
        return troncon;
    }

    private double calculLongueurFromEvenementVH(String idPatrouille, Timestamp dateDebut, Timestamp dateFin) {
        double longueurCalculee = -1.0;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String REQUETE = "SELECT  * from fauchage.calculLongueur(?,?,?)";
        try (Connection connection = this.daoFactory.getConnection();){
            pstm = connection.prepareStatement(REQUETE);
            pstm.setString(1, idPatrouille);
            pstm.setTimestamp(2, dateDebut);
            pstm.setTimestamp(3, dateFin);
            rs = pstm.executeQuery();
            while (rs.next()) {
                longueurCalculee = rs.getDouble(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return longueurCalculee;
    }

    @Override
    public List<TronconStats> getRoadsAmplitude(String idPatrouille) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<TronconStats> troncons = new ArrayList<TronconStats>();
        String REQUETE = "select id, axe, sens_pr, pr,abscisse_pr, cch, date_heure_loc, st_x(coordonnees) as x, st_y(coordonnees) as y from prism.localisation where ";
        REQUETE = REQUETE + "id_patrouille = ? ";
        REQUETE = REQUETE + " order by date_heure_loc;";
        try (Connection connection = this.daoFactory.getConnection();){
            pstm = connection.prepareStatement(REQUETE);
            pstm.setString(1, idPatrouille);
            rs = pstm.executeQuery();
            String axeEnCours = null;
            int sensPRENCours = -1;
            String cchEnCours = "";
            int prMinEnCours = Integer.MAX_VALUE;
            int prMaxEnCours = Integer.MIN_VALUE;
            int absMinEnCours = Integer.MAX_VALUE;
            int absMaxEnCours = Integer.MIN_VALUE;
            double xPrecedent = -1.0;
            double yPrecedent = -1.0;
            String prPrecedent = "";
            Timestamp dateEnCours = null;
            Timestamp dateDebut = null;
            double distanceEnCours = 0.0;
            Timestamp date = null;
            int positionConsecutive = 0;
            List<PositionTmp> positions = new ArrayList<PositionTmp>();
            while (rs.next()) {
                PositionTmp position = new PositionTmp();
                position.id = rs.getString("id");
                position.cch = rs.getString("cch");
                position.axe = rs.getString("axe");
                position.prString = rs.getString("pr");
                position.pr = rs.getInt("pr");
                position.abs = rs.getInt("abscisse_pr");
                position.sensPR = rs.getInt("sens_pr");
                position.date = rs.getTimestamp("date_heure_loc");
                position.x = rs.getDouble("x");
                position.y = rs.getDouble("y");
                positions.add(position);
            }
            positions = this.verifcationPositionsIsolees(positions);
            int index = 0;
            for (PositionTmp position : positions) {
                TronconStats troncon;
                date = position.date;
                if (axeEnCours != null && axeEnCours.equals(position.axe) && cchEnCours.equals(position.cch)) {
                    if ((sensPRENCours == position.sensPR || sensPRENCours == 0) && cchEnCours.equals(position.cch)) {
                        if (position.prString != null) {
                            if (position.pr == prMinEnCours) {
                                absMinEnCours = Math.min(absMinEnCours, position.abs);
                            } else if (prMinEnCours > position.pr) {
                                prMinEnCours = position.pr;
                                absMinEnCours = position.abs;
                            }
                            if (position.pr == prMaxEnCours) {
                                absMaxEnCours = Math.max(absMaxEnCours, position.abs);
                            } else if (prMaxEnCours < position.pr) {
                                prMaxEnCours = position.pr;
                                absMaxEnCours = position.abs;
                            }
                        }
                        prPrecedent = String.valueOf(position.pr);
                        sensPRENCours = position.sensPR;
                        distanceEnCours = Math.sqrt((position.y - yPrecedent) * (position.y - yPrecedent) + (position.x - xPrecedent) * (position.x - xPrecedent));
                        dateEnCours = position.date;
                        ++positionConsecutive;
                    } else if (prPrecedent == null) {
                        prPrecedent = String.valueOf(position.pr);
                        sensPRENCours = position.sensPR;
                        distanceEnCours = Math.sqrt((position.y - yPrecedent) * (position.y - yPrecedent) + (position.x - xPrecedent) * (position.x - xPrecedent));
                        dateEnCours = position.date;
                        ++positionConsecutive;
                    } else {
                        troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, dateEnCours, distanceEnCours);
                        if (distanceEnCours > 0.0) {
                            troncons.add(troncon);
                            distanceEnCours = 0.0;
                            axeEnCours = position.axe;
                            sensPRENCours = position.sensPR;
                            cchEnCours = position.cch;
                            prMinEnCours = position.pr;
                            absMinEnCours = position.abs;
                            prMaxEnCours = position.pr;
                            absMaxEnCours = position.abs;
                            xPrecedent = position.x;
                            yPrecedent = position.y;
                            dateDebut = position.date;
                            dateEnCours = position.date;
                        } else {
                            axeEnCours = position.axe;
                            sensPRENCours = position.sensPR;
                            cchEnCours = position.cch;
                        }
                    }
                } else {
                    if (axeEnCours != null) {
                        troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, dateEnCours, distanceEnCours);
                        if (distanceEnCours > 0.0) {
                            troncons.add(troncon);
                        }
                    }
                    axeEnCours = position.axe;
                    sensPRENCours = position.sensPR;
                    cchEnCours = position.cch;
                    prMinEnCours = position.pr;
                    absMinEnCours = position.abs;
                    prMaxEnCours = position.pr;
                    absMaxEnCours = position.abs;
                    xPrecedent = position.x;
                    yPrecedent = position.y;
                    distanceEnCours = 0.0;
                    dateDebut = position.date;
                    dateEnCours = position.date;
                    positionConsecutive = 0;
                }
                ++index;
            }
            if (distanceEnCours > 0.0) {
                TronconStats troncon = this.creationTronconFauchage(idPatrouille, axeEnCours, sensPRENCours, prMinEnCours, absMinEnCours, prMaxEnCours, absMaxEnCours, cchEnCours, dateDebut, date, distanceEnCours);
                troncons.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        return troncons;
    }

    private List<PositionTmp> verifcationPositionsIsolees(List<PositionTmp> positions) {
        ArrayList<PositionTmp> positionsFiltrees = new ArrayList<PositionTmp>();
        positionsFiltrees.add(positions.get(0));
        for (int i = 1; i < positions.size() - 2; ++i) {
            PositionTmp precedente = positions.get(i - 1);
            PositionTmp courante = positions.get(i);
            PositionTmp suivante = positions.get(i + 1);
            if (precedente.axe.equals(courante.axe) && courante.axe.equals(suivante.axe) && precedente.cch.equals(courante.cch) && courante.cch.equals(suivante.cch) && precedente.sensPR != courante.sensPR && courante.sensPR != suivante.sensPR && precedente.sensPR == suivante.sensPR) continue;
            positionsFiltrees.add(courante);
        }
        positionsFiltrees.add(positions.get(positions.size() - 1));
        return positionsFiltrees;
    }

    class PositionTmp {
        String id;
        String cch;
        String axe;
        String prString;
        int pr;
        int abs;
        int sensPR;
        Timestamp date;
        double x;
        double y;

        PositionTmp() {
        }
    }
}

