/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Ua;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.VehiculeScoop;
import com.geolocsystems.prismandroid.model.evenements.NatureEtDescription;
import com.geolocsystems.prismandroid.model.evenements.NatureEtDescriptionScoop;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IScoopDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.PrismCentralScoopUser;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ProfilScoop;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ScoopDAOJDBC
implements IScoopDAO {
    private static final String REQ_CORRES_EVENT = "select id_event,code_nature,code_description from scoop.corres_event";
    private static final String REQ_CORRES_EVENT_COMPLET = "select id_event,code_nature,code_description, dnp.libelle as libelle_description from scoop.corres_event ce, prism.description_nature_perso dnp where dnp.nature = ce.code_nature and dnp.code = ce.code_description";
    private static final String REQ_CORRES_UTILISATEUR = "select id_scoop,id_prism from scoop.corres_utilisateur";
    private static final String REQ_CORRES_VEHICULE = "select id_scoop,id_prism from scoop.corres_vehicule";
    private static final String REQ_CORRES_CIRCUIT = "select id_scoop,id_prism from scoop.corres_circuit";
    private static final String REQ_CORRES_MODULE_METIER = "select id_scoop,id_prism from scoop.corres_mm";
    private static final String SQL_CORRES_UA_PRISM = "select ua,delegation,centre from scoop.corres_ua";
    private static final String REQ_CORRES_PROFILS = "select id_scoop,nom_prism from scoop.corres_profil";
    private static final String REQ_CONFIG = "select champ,valeur from scoop.config";
    private static final String INSERT_UTILISATEUR = "insert into prism.utilisateur (nom,sna,delegation,centre,id_profil,mse,type,synchrodate,password,type_utilisateur,id_district,code_mode_vh,archive,id_utilisateur) values (?,?,?,?,(select p.id from prism.profil p where lower(nom)=lower(?)),?,1,now(),?,2,0,1,0,nextval('k_userid'));";
    private static final String MODIFIER_UTILISATEUR = "update prism.utilisateur set nom = ?,delegation = ?,centre = ?,archive = 0,synchrodate = now() where sna=?;";
    private static final String REQUETE_SELECTION_UA = "SELECT ua.ua as id_scoop, c.uaid as id, coalesce(ua.centre,ua.delegation) as name, c.parent as parent, c.attribution, c.box_minx, c.box_miny, c.box_maxx, c.box_maxy FROM scoop.corres_ua ua, prism.centre_rattachement c, prism.delegation_rattachement d WHERE (ua.delegation = d.nom AND ua.centre = c.nom) UNION SELECT ua.ua as id_scoop, d.uaid as id, ua.delegation as name, (SELECT ua.delegation from scoop.corres_ua ua where ua = 1) as parent, attribution, d.box_minx, d.box_miny, d.box_maxx, d.box_maxy FROM scoop.corres_ua ua, prism.delegation_rattachement d WHERE ua.delegation = d.nom AND (ua.centre IS null or ua.delegation = ua.centre) UNION SELECT ua.ua, 0, ua.delegation, null as parent, 1 as attribution, -1, -1, -1, -1 from scoop.corres_ua ua where ua = 1";
    private static final String REQ_CORRES_ACTIVITE_MODULE_METIER = "select id_scoop,id_prism, libelle, nom from scoop.corres_mm, prism.module_metier mm where id_prism = code";
    private static final String SQL_RECHERCHE_TOUTUTILISATEUR_PRISMSCOOP = "SELECT nom, sna, id_profil,id_utilisateur,delegation,mail,telephone,centre,archive,connection_type,admin_fonc, isadminua, issuperadmin, id_scoop FROM prism.utilisateur, scoop.corres_utilisateur WHERE mse = ? AND id_prism = sna ORDER BY nom ASC";
    private static final String SQL_RECHERCHE_TOUTUTILISATEUR = "SELECT * FROM prism.utilisateur WHERE mse = ?  ORDER BY nom ASC";
    private static final String SQL_VEHICULES = "SELECT v.*, cv.id_scoop  from prism.vehicule v, scoop.corres_vehicule cv WHERE zone_routiere=?  AND cv.id_prism = v.code ORDER BY code";
    private static final String SQL_TOUS_PROFIL_SCOOP = "SELECT p.id as id, p.nom as nom ,cp.id_scoop,id_action as action,a.parametres FROM prism.profil as p LEFT OUTER JOIN prism.profil_action as a ON p.id = a.id_profil, scoop.corres_profil cp WHERE p.nom = cp.nom_prism AND zone=? AND systeme = 0 AND (est_actif='t' OR est_actif IS NULL) ORDER BY p.id";
    private Map<String, NatureEtDescription> mapCorresEvent;
    private Map<String, NatureEtDescriptionScoop> mapCorresEventScoop;
    private Map<String, Centre> corresDelegationCentre;
    private Map<Integer, String> mapCorresVehicules;
    private Map<Integer, String> mapCorresProfils;
    private Map<Integer, String> mapCorresUtilisateurs;
    private Map<Integer, Integer> mapCorresModulesMetier;
    private Map<Integer, Integer> mapCorresCircuits;
    private Map<String, String> mapConfig;
    private Map<String, Map<?, ?>> mapScoop;
    private Map<Integer, ModuleMetier> mapCorrespModulesMetier;
    private DAOFactory daoFactory;
    private IReferentielDAO refDAO;
    private IAdminDAO adminDAO;
    private IUserDAO userDAO;

    public ScoopDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO, IAdminDAO adminDAO, IUserDAO userDAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
        this.adminDAO = adminDAO;
        this.userDAO = userDAO;
        this.init();
    }

    public void init() {
        this.corresDelegationCentre = new HashMap<String, Centre>();
        this.remplirCorrespondanceDelegationsCentre(SQL_CORRES_UA_PRISM, this.corresDelegationCentre);
        this.initCorresEvent();
        this.initCorresEventScoop();
        this.initCorresUtilisateur();
        this.initCorresVehicule();
        this.initCorresProfil();
        this.initConfig();
        this.initCorresCircuit();
        this.initCorresModuleMetier();
        this.initMapScoop();
    }

    private void initMapScoop() {
        this.mapScoop = null;
        this.mapScoop = new HashMap();
        this.mapScoop.put("scoop.utilisateurs", this.getCorresUtilisateur());
        this.mapScoop.put("scoop.vehicules", this.getCorresVehicule());
        this.mapScoop.put("scoop.events", this.getCorresEvent());
        this.mapScoop.put("scoop.eventsscoop", this.getCorresEventScoop());
        this.mapScoop.put("scoop.circuits", this.getCorresCircuit());
        this.mapScoop.put("scoop.mm", this.getCorresModuleMetier());
        this.mapScoop.put("scoop.config", this.getConfig());
    }

    @Override
    public void updateCorresEvent() {
        if (this.mapScoop != null) {
            this.initCorresEvent();
            this.mapScoop.put("scoop.events", this.getCorresEvent());
            this.initCorresEventScoop();
            this.mapScoop.put("scoop.eventsscoop", this.getCorresEventScoop());
        }
    }

    public void initCorresEvent() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresEvent = null;
        this.mapCorresEvent = new HashMap<String, NatureEtDescription>();
        String req = REQ_CORRES_EVENT_COMPLET;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                NatureEtDescription natureEtDescripton = new NatureEtDescription(rs.getString("code_nature"), rs.getString("code_description"));
                natureEtDescripton.setLibelleDescription(rs.getString("libelle_description"));
                this.mapCorresEvent.put(rs.getString("id_event"), natureEtDescripton);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresEventScoop() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresEventScoop = null;
        this.mapCorresEventScoop = new HashMap<String, NatureEtDescriptionScoop>();
        String req = REQ_CORRES_EVENT;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresEventScoop.put(rs.getString("id_event"), new NatureEtDescriptionScoop(rs.getString("id_event"), rs.getString("code_nature"), rs.getString("code_description")));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresVehicule() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresVehicules = null;
        this.mapCorresVehicules = new HashMap<Integer, String>();
        String req = REQ_CORRES_VEHICULE;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresVehicules.put(rs.getInt("id_scoop"), rs.getString("id_prism"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresProfil() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresProfils = null;
        this.mapCorresProfils = new HashMap<Integer, String>();
        String req = REQ_CORRES_PROFILS;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresProfils.put(rs.getInt("id_scoop"), rs.getString("nom_prism"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresCircuit() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresCircuits = null;
        this.mapCorresCircuits = new HashMap<Integer, Integer>();
        String req = REQ_CORRES_CIRCUIT;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresCircuits.put(rs.getInt("id_scoop"), rs.getInt("id_prism"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresModuleMetier() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresModulesMetier = null;
        this.mapCorresModulesMetier = new HashMap<Integer, Integer>();
        String req = REQ_CORRES_MODULE_METIER;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresModulesMetier.put(rs.getInt("id_scoop"), rs.getInt("id_prism"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initConfig() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapConfig = null;
        this.mapConfig = new HashMap<String, String>();
        String req = REQ_CONFIG;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapConfig.put(rs.getString("champ"), rs.getString("valeur"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void initCorresUtilisateur() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorresUtilisateurs = null;
        this.mapCorresUtilisateurs = new HashMap<Integer, String>();
        String req = REQ_CORRES_UTILISATEUR;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.mapCorresUtilisateurs.put(rs.getInt("id_scoop"), rs.getString("id_prism"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public Map<String, NatureEtDescription> getCorresEvent() {
        if (this.mapCorresEvent == null) {
            this.initCorresEvent();
        }
        return this.mapCorresEvent;
    }

    public Map<String, NatureEtDescriptionScoop> getCorresEventScoop() {
        if (this.mapCorresEventScoop == null) {
            this.initCorresEventScoop();
        }
        return this.mapCorresEventScoop;
    }

    public Map<Integer, Integer> getCorresCircuit() {
        if (this.mapCorresCircuits == null) {
            this.initCorresCircuit();
        }
        return this.mapCorresCircuits;
    }

    public Map<Integer, Integer> getCorresModuleMetier() {
        if (this.mapCorresModulesMetier == null) {
            this.initCorresModuleMetier();
        }
        return this.mapCorresModulesMetier;
    }

    public Map<String, String> getConfig() {
        if (this.mapConfig == null) {
            this.initConfig();
        }
        return this.mapConfig;
    }

    public Map<Integer, String> getCorresUtilisateur() {
        if (this.mapCorresUtilisateurs == null) {
            this.initCorresUtilisateur();
        }
        return this.mapCorresUtilisateurs;
    }

    public Map<Integer, String> getCorresVehicule() {
        if (this.mapCorresVehicules == null) {
            this.initCorresVehicule();
        }
        return this.mapCorresVehicules;
    }

    public Map<Integer, String> getCorresProfil() {
        if (this.mapCorresProfils == null) {
            this.initCorresProfil();
        }
        return this.mapCorresProfils;
    }

    public Map<String, Map<?, ?>> getScoopConfiguration() {
        if (this.mapScoop == null) {
            this.init();
        }
        return this.mapScoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondances(String type) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("delete from " + type);
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondance(String type, String champ, String id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("delete from " + type + " where " + champ + " = ?");
            pstm.setString(1, id);
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEtatImportation(PrismCentralUser u) {
        int n;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            block7: {
                connection = null;
                pstm = null;
                rs = null;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select nom,centre,delegation,archive from utilisateur where sna = ?");
                pstm.setString(1, u.getCode());
                rs = pstm.executeQuery();
                if (!rs.next()) break block6;
                if (GLS.egal((String)u.getNom(), (String)rs.getString("nom")) && GLS.egal((String)u.getCentre(), (String)rs.getString("centre")) && GLS.egal((String)u.getDelegation(), (String)rs.getString("delegation")) && u.isArchive() == GLS.getBoolean((int)rs.getInt("archive"), (boolean)false)) break block7;
                int n2 = 1;
                DAOUtil.close(connection, pstm, rs);
                return n2;
            }
            int n3 = 2;
            DAOUtil.close(connection, pstm, rs);
            return n3;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            int n4;
            try {
                Log.error("", e);
                n4 = 2;
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
            return n4;
        }
        DAOUtil.close(connection, pstm, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEtatImportation(Vehicule v) {
        int n;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            block7: {
                connection = null;
                pstm = null;
                rs = null;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select code,centre,delegation,immatriculation,id_marque_vehicule,archive from vehicule where code = ?");
                pstm.setString(1, v.getCode());
                rs = pstm.executeQuery();
                if (!rs.next()) break block6;
                if (GLS.egal((String)v.getImmatriculation(), (String)rs.getString("immatriculation")) && GLS.egal((String)v.getCentre(), (String)rs.getString("centre")) && GLS.egal((String)v.getDelegation(), (String)rs.getString("delegation")) && v.getType() == rs.getInt("id_marque_vehicule") && v.isArchive() == rs.getBoolean("archive")) break block7;
                int n2 = 1;
                DAOUtil.close(connection, pstm, rs);
                return n2;
            }
            int n3 = 2;
            DAOUtil.close(connection, pstm, rs);
            return n3;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            int n4;
            try {
                Log.error("", e);
                n4 = 2;
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
            return n4;
        }
        DAOUtil.close(connection, pstm, rs);
        return n;
    }

    public void archive() {
        this.archiveUtilisateurs();
        this.archiveVehicules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean archiveUtilisateurs() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean changement = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.utilisateur set archive = 1 where archive = 0 and type_utilisateur = 2 and sna not in (select id_prism from scoop.corres_utilisateur)");
            changement = pstm.execute();
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return changement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean archiveVehicules() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean changement = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.vehicule set archive = 'true' where archive = 'false' and id_marque_vehicule in (select m.id from prism.marque_vehicule m where m.code_type_vehicule <> 0) and code not in (select id_prism from scoop.corres_vehicule)");
            changement = pstm.execute();
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return changement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondance(String type, String idScoop) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("delete from " + type + " where id_scoop = ?");
            pstm.setInt(1, GLS.getInt((String)idScoop));
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterCorrespondance(String type, String idPrism, String idScoop, String idService) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("insert into " + type + " (id_prism, id_scoop) values (?,?)");
            pstm.setString(1, idPrism);
            pstm.setInt(2, GLS.getInt((String)idScoop));
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ajouterCorrespondance(String type, String idPrism, String idScoop, String idService, String nomColonnePrism) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("insert into " + type + " (" + nomColonnePrism + ", id_scoop) values (?,?)");
            pstm.setString(1, idPrism);
            pstm.setInt(2, GLS.getInt((String)idScoop));
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterUtilisateur(UserExport u, String password, String zoneRoutiere) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(INSERT_UTILISATEUR);
            pstm.setString(1, u.getNom());
            pstm.setString(2, u.getCode());
            if (!GLS.estVide((String)u.getCentre())) {
                pstm.setString(4, u.getCentre());
            } else {
                pstm.setNull(4, 12);
            }
            if (!GLS.estVide((String)u.getDelegation())) {
                pstm.setString(3, u.getDelegation());
            } else {
                pstm.setNull(3, 12);
            }
            pstm.setString(5, u.getProfil().getName());
            pstm.setString(6, zoneRoutiere);
            pstm.setString(7, password);
            try {
                pstm.execute();
            }
            catch (Exception e) {
                Log.error(" - Erreur importation utilisateur".concat(u.getCode()), e);
            }
            pstm.clearParameters();
        }
        catch (Exception e) {
            try {
                Log.error(" - Erreur globale importation utilisateur".concat(u.getCode()), e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, null);
        }
        DAOUtil.close(connection, pstm, null);
        this.supprimerCorrespondance("scoop.corres_utilisateur", u.getCode());
        this.ajouterCorrespondance("scoop.corres_utilisateur", u.getCode(), u.getCode(), u.getCodeServiceIg4());
    }

    @Override
    public void modiferVehicule(VehiculeExport v) {
        this.adminDAO.updateVehicule(v);
        this.supprimerCorrespondance("scoop.corres_vehicule", v.getCode());
        this.ajouterCorrespondance("scoop.corres_vehicule", v.getCode(), v.getCode(), v.getCodeServiceIg4());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modiferUtilisateur(UserExport u) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(MODIFIER_UTILISATEUR);
            pstm.setString(1, u.getNom());
            pstm.setString(2, u.getDelegation());
            pstm.setString(3, u.getCentre());
            pstm.setString(4, u.getCode());
            try {
                pstm.execute();
            }
            catch (Exception e) {
                Log.error(" - Erreur mise a jour utilisateur".concat(u.getCode()), e);
            }
            pstm.clearParameters();
        }
        catch (Exception e) {
            try {
                Log.error(" - Erreur mise a jour utilisateur".concat(u.getCode()), e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, null);
        }
        DAOUtil.close(connection, pstm, null);
        this.supprimerCorrespondance("scoop.corres_utilisateur", u.getCode());
        this.ajouterCorrespondance("scoop.corres_utilisateur", u.getCode(), u.getCode(), u.getCodeServiceIg4());
    }

    @Override
    public Map<String, Centre> getCorresDelegationsCentre() {
        return this.corresDelegationCentre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remplirCorrespondanceDelegationsCentre(String req, Map<String, Centre> corres) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Centre c = new Centre();
                c.setNom(rs.getString("centre"));
                c.setDelegation(rs.getString("delegation"));
                corres.put(rs.getString("ua"), c);
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void ajouterVehicule(VehiculeExport v) {
        this.adminDAO.creerVehicule(v);
        this.supprimerCorrespondance("scoop.corres_vehicule", v.getCode());
        this.ajouterCorrespondance("scoop.corres_vehicule", v.getCode(), v.getCode(), v.getCodeServiceIg4());
    }

    @Override
    public void verifierMarqueVehicule(String[] ligne) throws Exception {
        if (!this.adminDAO.marqueVehiculeExiste(this.getConfig().get("marque_vehicule_defaut"))) {
            throw new Exception("ERREUR VEHICULE NON IMPORTE - LA MARQUE " + ligne[4] + " N'EXISTE PAS");
        }
    }

    public Map<String, String> getCorresEventType() {
        return null;
    }

    @Override
    public void update() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Ua> getUas() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Ua> uas = new ArrayList<Ua>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_SELECTION_UA);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Ua ua = new Ua();
                ua.setId(rs.getInt("id"));
                ua.setIdScoop(rs.getInt("id_scoop"));
                ua.setName(rs.getString("name"));
                ua.setParent(rs.getString("parent"));
                ua.setArchivee(rs.getInt("attribution") == 0);
                if (rs.getString("box_minx") != null) {
                    ua.setBoxMinX(Double.valueOf(rs.getDouble("box_minx")));
                    ua.setBoxMaxX(Double.valueOf(rs.getDouble("box_maxx")));
                    ua.setBoxMinY(Double.valueOf(rs.getDouble("box_miny")));
                    ua.setBoxMaxY(Double.valueOf(rs.getDouble("box_maxy")));
                }
                uas.add(ua);
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return uas;
    }

    @Override
    public Map<Integer, ModuleMetier> getCorrespModuleMetier() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        this.mapCorrespModulesMetier = null;
        this.mapCorrespModulesMetier = new HashMap<Integer, ModuleMetier>();
        String req = REQ_CORRES_ACTIVITE_MODULE_METIER;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Integer idScoop = rs.getInt("id_scoop");
                ModuleMetier mm = new ModuleMetier();
                mm.setCode(rs.getInt("id_prism"));
                mm.setLibelle(rs.getString("libelle"));
                mm.setNom(rs.getString("nom"));
                this.mapCorrespModulesMetier.put(idScoop, mm);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return this.mapCorrespModulesMetier;
    }

    @Override
    public List<PrismCentralUser> rechercheToutUtilisateur() throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Vector<PrismCentralUser> liste = new Vector<PrismCentralUser>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_RECHERCHE_TOUTUTILISATEUR);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            rs = pstm.executeQuery();
            while (rs.next()) {
                PrismCentralScoopUser user = new PrismCentralScoopUser();
                user.setNom(rs.getString("nom"));
                user.setCode(rs.getString("sna"));
                user.setId(rs.getInt("id_utilisateur"));
                user.setIdProfil(rs.getLong("id_profil"));
                user.setArchive(rs.getInt("archive") == 1);
                user.setDelegation(rs.getString("delegation"));
                user.setCentre(rs.getString("centre"));
                user.setTelephone(rs.getString("telephone"));
                user.setMail(rs.getString("mail"));
                user.setConnectionType(rs.getString("connection_type"));
                user.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                user.setAdminUa(rs.getBoolean("isadminua"));
                user.setSuperAdminUa(rs.getBoolean("issuperadmin"));
                liste.add(user);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<PrismCentralUser> rechercheToutUtilisateurScoopPrism() throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Vector<PrismCentralUser> liste = new Vector<PrismCentralUser>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_RECHERCHE_TOUTUTILISATEUR_PRISMSCOOP);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            rs = pstm.executeQuery();
            while (rs.next()) {
                PrismCentralScoopUser user = new PrismCentralScoopUser();
                user.setNom(rs.getString("nom"));
                user.setCode(rs.getString("sna"));
                user.setId(rs.getInt("id_utilisateur"));
                user.setIdProfil(rs.getLong("id_profil"));
                user.setArchive(rs.getInt("archive") == 1);
                user.setDelegation(rs.getString("delegation"));
                user.setCentre(rs.getString("centre"));
                user.setTelephone(rs.getString("telephone"));
                user.setMail(rs.getString("mail"));
                user.setConnectionType(rs.getString("connection_type"));
                user.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                user.setIdScoop(rs.getInt("id_scoop"));
                user.setAdminUa(rs.getBoolean("isadminua"));
                user.setSuperAdminUa(rs.getBoolean("issuperadmin"));
                liste.add(user);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<Vehicule> getListeVehicule() {
        ArrayList<Vehicule> vs = new ArrayList<Vehicule>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_VEHICULES);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            rs = pstm.executeQuery();
            while (rs.next()) {
                VehiculeScoop v = new VehiculeScoop();
                v.setDelegation(rs.getString("delegation"));
                v.setCentre(rs.getString("centre"));
                v.setCode(rs.getString("code"));
                v.setImmatriculation(rs.getString("immatriculation"));
                v.setNumeroTelephone(rs.getString("numero_telephone"));
                v.setNumeroRadio(rs.getString("numero_radio"));
                v.setDescription(rs.getString("description"));
                v.setType(rs.getInt("id_marque_vehicule"));
                v.setArchive(rs.getBoolean("archive"));
                v.setIdScoop(rs.getInt("id_scoop"));
                vs.add((Vehicule)v);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return vs;
    }

    @Override
    public void ajouterCorrespondanceVehicule(VehiculeScoop v) {
        this.supprimerCorrespondance("scoop.corres_vehicule", String.valueOf(v.getIdScoop()));
        this.ajouterCorrespondance("scoop.corres_vehicule", v.getCode(), String.valueOf(v.getIdScoop()), null);
    }

    @Override
    public void ajouterCorrespondanceUtilisateur(PrismCentralScoopUser u) {
        this.supprimerCorrespondance("scoop.corres_utilisateur", String.valueOf(u.getIdScoop()));
        this.ajouterCorrespondance("scoop.corres_utilisateur", u.getCode(), String.valueOf(u.getIdScoop()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterCorrespondanceUA(int idScoop, String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            try {
                pstm = connection.prepareStatement("delete from scoop.corres_ua where ua = ?");
                pstm.setInt(1, GLS.getInt((Object)idScoop));
                pstm.execute();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            finally {
                DAOUtil.close(null, pstm, rs);
            }
            try {
                pstm = connection.prepareStatement("insert into scoop.corres_ua  (ua, delegation, centre) values (?,?,?)");
                pstm.setInt(1, idScoop);
                pstm.setString(2, delegation);
                pstm.setString(3, centre);
                pstm.execute();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            finally {
                DAOUtil.close(null, pstm, rs);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondanceUA(Ua ua) {
        if (ua.getParent().equals("DIR")) {
            String delegation = ua.getName();
            String centre = ua.getName();
        } else {
            String delegation = ua.getParent();
            String centre = ua.getName();
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            try {
                pstm = connection.prepareStatement("delete from scoop.corres_ua where ua = ?");
                pstm.setInt(1, GLS.getInt((Object)ua.idScoop));
                pstm.execute();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            finally {
                DAOUtil.close(null, pstm, rs);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondanceEvent(String id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            try {
                pstm = connection.prepareStatement("delete from scoop.corres_event where id_event = ?");
                pstm.setString(1, id);
                Log.debug(pstm.toString());
                pstm.execute();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            finally {
                DAOUtil.close(null, pstm, rs);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterCorrespondanceEvent(NatureEtDescriptionScoop corresEvent) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            try {
                pstm = connection.prepareStatement("insert into scoop.corres_event  (id_event, code_nature, code_description) values (?,?,?)");
                pstm.setString(1, corresEvent.getIdEventScoop());
                pstm.setString(2, corresEvent.getCodeNature());
                pstm.setString(3, corresEvent.getCodeDescription());
                Log.debug(pstm.toString());
                pstm.execute();
            }
            catch (Exception e) {
                Log.error("", e);
            }
            finally {
                DAOUtil.close(null, pstm, rs);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, null, null);
        }
    }

    @Override
    public List<Profil> getProfils() {
        ArrayList<Profil> ret = new ArrayList<Profil>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_TOUS_PROFIL_SCOOP);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            rs = pstm.executeQuery();
            ProfilScoop encours = null;
            HashSet<Integer> actions = null;
            HashMap<Integer, MapDescription> parametres = null;
            while (rs.next()) {
                int id = rs.getInt("id");
                if (encours == null) {
                    encours = new ProfilScoop();
                    actions = new HashSet<Integer>();
                    parametres = new HashMap<Integer, MapDescription>();
                    encours.setActions(actions);
                    encours.setParametres(parametres);
                } else if (encours.getId() != id) {
                    ret.add((Profil)encours);
                    encours = new ProfilScoop();
                    actions = new HashSet();
                    parametres = new HashMap();
                    encours.setActions(actions);
                    encours.setParametres(parametres);
                }
                encours.setId(id);
                encours.setName(rs.getString("nom"));
                encours.setIdScoop(rs.getInt("id_scoop"));
                actions.add(rs.getInt("action"));
                try {
                    Array array = rs.getArray("parametres");
                    if (array == null) continue;
                    parametres.put(rs.getInt("action"), MapDescription.parse((String[])((String[])array.getArray())));
                }
                catch (Throwable t) {
                    Log.error("ERROR PARAMETRES PROFIL ACTION", t);
                }
            }
            if (encours != null) {
                ret.add((Profil)encours);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return ret;
    }

    @Override
    public void ajouterCorrespondanceProfil(ProfilScoop profil) {
        this.supprimerCorrespondance("scoop.corres_profil", String.valueOf(profil.getIdScoop()));
        this.ajouterCorrespondance("scoop.corres_profil", profil.getName(), String.valueOf(profil.getIdScoop()), null, "nom_prism");
    }
}

