/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionDefinition;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionEtatEvenement;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionProfil;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionVehiculesEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionVraiFaux;
import java.util.ArrayList;
import java.util.List;

public class RestrictionFactory {
    public static final String ENTIER = "entier";
    public static final String TEXTE = "texte";
    public static final String CHOIX_UNIQUE = "choixUnique";
    public static final String LOCALISATION = "localisation";
    public static final String PROFIL = "profil";
    public static final String ETAT_EVENEMENT = "etatEvenement";
    public static final String ETAT_ON_CHANGE = "onChange";
    public static final String CHOIX_MULTIPLE = "choixMultiple";
    public static final String VEHICULE_EN_CAUSE = "vehiculeEnCause";
    public static final String VRAI_FAUX = "vraiFaux";

    public static List<Restriction> getRestrictions(String listeRestrictions) {
        ArrayList<Restriction> restrictions = null;
        if (listeRestrictions != null && !listeRestrictions.isEmpty()) {
            String[] l;
            restrictions = new ArrayList<Restriction>();
            for (String restriction : l = listeRestrictions.split(":")) {
                try {
                    restrictions.add(RestrictionFactory.getRestriction(restriction));
                }
                catch (Throwable t) {
                    throw new RuntimeException("La restriction n'est pas valide " + listeRestrictions);
                }
            }
        }
        return restrictions;
    }

    public static Restriction getRestriction(String restriction) {
        return RestrictionFactory.getRestriction(new RestrictionDefinition(restriction));
    }

    public static Restriction getRestriction(RestrictionDefinition resdef) {
        RestrictionEntier r = null;
        if (((String)resdef.get((Object)"type")).equals(ENTIER)) {
            r = new RestrictionEntier(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(CHOIX_UNIQUE)) {
            r = new RestrictionChoixUnique(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(TEXTE)) {
            r = new RestrictionTexte(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(VEHICULE_EN_CAUSE)) {
            r = new RestrictionVehiculesEnCause(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(CHOIX_MULTIPLE)) {
            r = new RestrictionMultiCheckBox(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(VRAI_FAUX)) {
            r = new RestrictionVraiFaux(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(LOCALISATION)) {
            r = new RestrictionLocalisation(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(PROFIL)) {
            r = new RestrictionProfil(resdef);
        } else if (((String)resdef.get((Object)"type")).equals(ETAT_EVENEMENT)) {
            r = new RestrictionEtatEvenement(resdef);
        }
        return r;
    }
}

