/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.Coordonnees;
import com.geolocsystems.prismcentral.beans.DatePublication;
import com.geolocsystems.prismcentral.beans.DynamicExport;
import com.geolocsystems.prismcentral.beans.DynamicMissionExport;
import com.geolocsystems.prismcentral.beans.DynamicVehiculeExport;
import com.geolocsystems.prismcentral.beans.EvenementPublication;
import com.geolocsystems.prismcentral.beans.IEvenementExport;
import com.geolocsystems.prismcentral.beans.MessageAlertePublication;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.beans.Troncon;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ISuiviActiviteService;
import com.geolocsystems.prismcentral.export.PublicationComposantFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.google.gson.Gson;
import gls.geometry.GeoPoint;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.sql.SQL;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.xml.bind.DatatypeConverter;
import org.postgis.LineString;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class PublicationDAOJDBC
implements IPublicationDAO {
    private static final String SQL_DATEPUBLICATION = "SELECT date FROM date_publication WHERE champ= ?";
    private static final String SQL_UPDATEDATEPUBLICATION = "UPDATE date_publication SET champ = 'derniere_date_publication', date = now()";
    private static final String SQL_GETCONFIGURATION = "SELECT code, type, valeur FROM prism.configuration_publication WHERE zone_routiere = ?";
    private static final String SQL_PUBLIERPATROUILLE = "UPDATE patrouille SET publie = true WHERE id = ?";
    private static final String SQL_DEPUBLIERPATROUILLE = "UPDATE patrouille SET publie = false WHERE id = ?";
    private static final String SQL_MAJ_EVENEMENTS_PUBLIES_PREVISIONNELS = "UPDATE publication_evt set statut = 'en cours' WHERE erf = ?";
    private static final String SQL_GET_MESSAGES_ALERTE = "SELECT id, libelle, texte, date_debut, date_fin, type_message, defaut FROM message_alerte ORDER BY date_debut ASC";
    private static final String SQL_CREATE_MESSAGES_ALERTE = "INSERT INTO message_alerte (libelle, texte, date_debut, date_fin, type_message, defaut) VALUES (?,?,?,?,?,?)";
    private static final String SQL_UPDATE_MESSAGES_ALERTE = "UPDATE message_alerte SET libelle = ?, texte = ?, date_debut = ?, date_fin = ?, type_message = ?, defaut=? WHERE id = ?";
    private static final String SQL_DELETE_MESSAGES_ALERTE = "DELETE FROM message_alerte WHERE id = ?";
    private static final String SQL_GET_MODELE_PUBLICATION = "SELECT libelle, texte FROM prism.modele_message WHERE type_modele = ? ORDER BY libelle ASC";
    private static final String SQL_GET_MESSAGE_ALERTE = "SELECT id, libelle, texte, date_debut, date_fin, type_message, defaut FROM message_alerte WHERE ? BETWEEN date_debut AND date_fin";
    private static final String SQL_GET_MESSAGE_SYNTHESE = "SELECT commentaire, nom, date FROM vh.synthese_publie WHERE nom = ?";
    private static final String SQL_SAVE_EVENEMENT_PUBLICATION = "INSERT INTO prism.publication_evt_structure (snm, erf, num_ligne, type_champ, complement_champ, valeur) VALUES ( ?, ?, ?, ?, ?, ?),( ?, ?, ?, ?, ?, ?),( ?, ?, ?, ?, ?, ?),( ?, ?, ?, ?, ?, ?),( ?, ?, ?, ?, ?, ?);";
    private static final String SQL_GET_SAVE_EVENEMENT_PUBLICATION = "SELECT num_ligne, type_champ, complement_champ, valeur FROM prism.publication_evt_structure WHERE snm = ? AND erf = ?";
    private static final String SQL_DELETE_SAVE_EVENEMENT_PUBLICATION = "DELETE FROM prism.publication_evt_structure WHERE snm = ? AND erf = ?";
    private static final String SQL_SELECTION_EVENEMENT_EXPORT = "SELECT k_eventid as \"id\", snm as \"id_situation\", erf as \"id_reference\",code_evenement, dob as \"code_nature\", vnm as \"version\", sta as \"date_creation\", sto as  \"date_fin\", inp as \"date_version\", erreur, description, e.fin, can, forevent, cei,district,lnp,nlq,direction,commentaireinterne,donneescomplementaires,programme,positionbretelle,lnp,direction,id_createur,  prdeb,prfin,distanceprdeb,distanceprfin,sens,route,commune,que as \"longueur\", lu,sur, photos,st_X(ST_Transform(coordonnees,4326)) as X, st_Y(ST_Transform(coordonnees,4326)) as Y,u.sna as code_agent,u.nom as nom_agent, p.parametres,p.code_vehicule FROM prism.evenement e inner join utilisateur u on e.id_utilisateur = u.id_utilisateur left join patrouille p on p.id = e.id_patrouille WHERE e.etat = 1 ";
    private static final String SQL_SELECTION_POSITION_EXPORT = "SELECT date_heure_loc as date,st_X(ST_Transform(coordonnees,4326)) as X, st_Y(ST_Transform(coordonnees,4326)) as Y,";
    private static final String CARTO_OSM = "carto_osm";
    private static final String CARTO_PROJECTION = "carto_projection";
    private static final String CARTO_PROJECTION_OSM = "carto_projection_osm";
    public static final String NATURES_PUBLIEES_AUTO = "nature_publiees_auto";
    public static final String NATURES_PUBLIEES_AUTO_CONFIRM = "nature_publiees_auto_confirm";
    public static final String ORDER = "order_";
    private DAOFactory daoFactory;
    private final String EN_COURS = "en cours";
    private final String PROGRAMME = "pr\u00e9visionnel";
    private Map<String, Object> configuration;
    private IReferentielDAO refDAO;
    private IVehiculeDAO vehiculeDAO;
    private IIG4DAO ig4DAO;
    private static final String NATURES = "natures";
    private static final String DATE = "date";
    private static final String DATE_DEBUT = "dateDebut";
    private static final String DATE_FIN = "dateFin";
    private static final String MM = "mm";
    private static final String DELEGATION = "delegation";
    private static final String CENTRE = "centre";
    private static final String PHOTOS = "photos";
    private static final String SEPARATEUR = "separateur";
    private static final String CLOTURE = "cloture";
    private static final String CHAMPS = "champs";
    private static final String TYPE = "type";
    private static final String TYPE_PRISM = "prism";
    private static final String TYPE_EXT = "ext";
    private static final String ACTIF = "actif";

    public PublicationDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO, IVehiculeDAO vehiculeDAO, IIG4DAO ig4DAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
        this.vehiculeDAO = vehiculeDAO;
        this.ig4DAO = ig4DAO;
        if (this.configuration == null) {
            this.configuration = this.getConfiguration();
        }
    }

    @Override
    public Calendar getDerniereDatePublication() {
        Calendar calendar;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Timestamp timestamp = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_DATEPUBLICATION);
            pstm.setString(1, "derniere_date_publication");
            rs = pstm.executeQuery();
            if (rs.next()) {
                timestamp = rs.getTimestamp(DATE);
            }
            Calendar cal = Calendar.getInstance();
            if (timestamp != null) {
                cal.setTime(timestamp);
            }
            calendar = cal;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return calendar;
    }

    @Override
    public List<EvenementPublication> getEvenements(String statut, String nature, String projection) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<EvenementPublication> liste = new ArrayList<EvenementPublication>();
        Vector<String> clausesWhere = new Vector<String>();
        Vector<String> variablesPreparedStatement = new Vector<String>();
        String where = null;
        String order = " ORDER BY date_publiee DESC";
        if (!GLS.estVide((String)statut)) {
            clausesWhere.add("statut = ? ");
            variablesPreparedStatement.add(statut);
            if (this.getConfiguration().get(ORDER + statut) != null) {
                order = " ORDER BY " + (String)this.getConfiguration().get(ORDER + statut);
            }
        }
        if (!GLS.estVide((String)nature)) {
            clausesWhere.add("nature = ? ");
            variablesPreparedStatement.add(nature);
        }
        where = !GLS.estVide(clausesWhere) ? " WHERE ".concat(GLS.getString(clausesWhere, (String)" AND ")) : "";
        String requete = "SELECT erf,snm,niveau,to_char(date_publiee,'dd/mm/yyyy hh24:mi:ss') as date_publiee,nature,champ_un,champ_deux,champ_trois,longueur,informationcomplementaire,champ_quatre,champ_cinq,ST_Transform(coordonnees," + this.getProjection(projection) + ") as coordonnees,statut FROM publication_evt " + where;
        requete = requete + order;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            if (!GLS.estVide((String)where)) {
                for (int i = 0; i < variablesPreparedStatement.size(); ++i) {
                    pstm.setString(i + 1, (String)variablesPreparedStatement.get(i));
                }
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                EvenementPublication evt = new EvenementPublication();
                evt.setErf(rs.getString("erf"));
                evt.setSnm(rs.getString("snm"));
                evt.setNiveau(rs.getString("niveau"));
                evt.setDatePublication(rs.getString("date_publiee"));
                evt.setNature(rs.getString("nature"));
                evt.setLigne1(rs.getString("champ_un"));
                evt.setLigne2(rs.getString("champ_deux"));
                evt.setLigne3(rs.getString("champ_trois"));
                evt.setLigne4(rs.getString("champ_quatre"));
                evt.setLigne5(rs.getString("champ_cinq"));
                evt.setLongueur(rs.getInt("longueur"));
                evt.setStatut(rs.getString("statut"));
                evt.setInformationComplementaire(rs.getString("informationcomplementaire"));
                Point point = null;
                try {
                    point = PublicationDAOJDBC.getChampGeometryPoint(rs.getObject("coordonnees"));
                }
                catch (Exception e) {
                    point = null;
                }
                if (point != null) {
                    evt.setX(point.x);
                    evt.setY(point.y);
                } else {
                    evt.setX(0.0);
                    evt.setY(0.0);
                }
                evt.setMaj(new SimpleDateFormat("dd.MM.yyyy '\u00e0' HH:mm:ss", Locale.FRENCH).format(new Date()));
                liste.add(evt);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    public List<EvenementPublication> getEvenementsExternes(String statut, String nature, String projection) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<EvenementPublication> liste = new ArrayList<EvenementPublication>();
        Vector<String> clausesWhere = new Vector<String>();
        Vector<String> variablesPreparedStatement = new Vector<String>();
        String where = null;
        String order = " ORDER BY date_publiee DESC";
        if (!GLS.estVide((String)statut)) {
            clausesWhere.add("statut = ? ");
            variablesPreparedStatement.add(statut);
            if (this.getConfiguration().get(ORDER + statut) != null) {
                order = " ORDER BY " + (String)this.getConfiguration().get(ORDER + statut);
            }
        }
        if (!GLS.estVide((String)nature)) {
            clausesWhere.add("nature = ? ");
            variablesPreparedStatement.add(nature);
        }
        where = !GLS.estVide(clausesWhere) ? " WHERE ".concat(GLS.getString(clausesWhere, (String)" AND ")) : "";
        String requete = "SELECT erf,snm,niveau,to_char(date_publiee,'dd/mm/yyyy hh24:mi:ss') as date_publiee,nature,champ_un,champ_deux,champ_trois,longueur,informationcomplementaire,champ_quatre,champ_cinq,ST_Transform(coordonnees," + this.getProjection(projection) + ") as coordonnees,statut FROM donnees_externes.publication_evt " + where;
        requete = requete + order;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            if (!GLS.estVide((String)where)) {
                for (int i = 0; i < variablesPreparedStatement.size(); ++i) {
                    pstm.setString(i + 1, (String)variablesPreparedStatement.get(i));
                }
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                EvenementPublication evt = new EvenementPublication();
                evt.setErf(rs.getString("erf"));
                evt.setSnm(rs.getString("snm"));
                evt.setNiveau(rs.getString("niveau"));
                evt.setDatePublication(rs.getString("date_publiee"));
                evt.setNature(rs.getString("nature"));
                evt.setLigne1(rs.getString("champ_un"));
                evt.setLigne2(rs.getString("champ_deux"));
                evt.setLigne3(rs.getString("champ_trois"));
                evt.setLigne4(rs.getString("champ_quatre"));
                evt.setLigne5(rs.getString("champ_cinq"));
                evt.setLongueur(rs.getInt("longueur"));
                evt.setStatut(rs.getString("statut"));
                evt.setInformationComplementaire(rs.getString("informationcomplementaire"));
                Point point = null;
                try {
                    point = PublicationDAOJDBC.getChampGeometryPoint(rs.getObject("coordonnees"));
                }
                catch (Exception e) {
                    point = null;
                }
                if (point != null) {
                    evt.setX(point.x);
                    evt.setY(point.y);
                } else {
                    evt.setX(0.0);
                    evt.setY(0.0);
                }
                evt.setMaj(new SimpleDateFormat("dd.MM.yyyy '\u00e0' HH:mm:ss", Locale.FRENCH).format(new Date()));
                liste.add(evt);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<EvenementPublication> getEvenementsPubliesEnCours() {
        return this.getEvenements("en cours", null, null);
    }

    @Override
    public List<EvenementPublication> getEvenementsPubliesPrevisonnels() {
        return this.getEvenements("pr\u00e9visionnel", null, null);
    }

    @Override
    public void depublierEvenement(Evenement evenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("DELETE FROM prism.publication_evt WHERE snm=? AND erf=?");
            pstm.setString(1, evenement.getIdSituation());
            pstm.setString(2, evenement.getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void depublierTousEvenementsExternes() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("DELETE FROM donnees_externes.publication_evt");
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void depublierEvenementExterne(EvenementPublication evenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("DELETE FROM donnees_externes.publication_evt WHERE snm=? AND erf=?");
            pstm.setString(1, evenement.getSnm());
            pstm.setString(2, evenement.getErf());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    private String getCorrespondanceNaturePublication(Connection connection, String codeNature, String decriptionNature) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String nature_publication = codeNature;
        try {
            pstm = connection.prepareStatement("SELECT nature_publication FROM publication_correspondance_description_nature WHERE nature = ? and description_nature = ?");
            pstm.setString(1, codeNature);
            pstm.setString(2, decriptionNature);
            Log.debug(pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                nature_publication = rs.getString("nature_publication");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(pstm);
                DAOUtil.close(rs);
                throw throwable;
            }
        }
        DAOUtil.close(pstm);
        DAOUtil.close(rs);
        return nature_publication;
    }

    @Override
    public void publierEvenement(Evenement evenement, String ligne1, String ligne2, String ligne3, String ligne4, String ligne5) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            this.depublierEvenement(evenement);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        try {
            connection = this.daoFactory.getConnection();
            String coordonnees = SQL.getChampGeometryPoint((GeoPoint)new GeoPoint(evenement.getLocalisation().getPositionDebut().getX(), evenement.getLocalisation().getPositionDebut().getY()), (int)4326);
            String lineaire = "";
            lineaire = evenement.getLocalisation().getLongueur() > 0 ? SQL.getChampGeometryLine((String)Geometry.getFloatToString((float[])evenement.getLocalisation().getX(), (float[])evenement.getLocalisation().getY()), (int)4326) : "null";
            String infos = MetierCommun.getStylePublication((Evenement)evenement, this.refDAO.getStylesPublication());
            pstm = connection.prepareStatement("INSERT INTO prism.publication_evt (snm,erf,nature,champ_un,champ_deux,champ_trois,champ_quatre,champ_cinq,statut,coordonnees,lineaire,longueur,informationcomplementaire) VALUES (?,?,?,?,?,?,?,?,?," + coordonnees + "," + lineaire + ",?,?)");
            String nature_publie = this.getCorrespondanceNaturePublication(connection, evenement.getValeurNature().getCode(), evenement.getValeurNature().getDescription().getValeur());
            pstm.setString(1, evenement.getIdSituation());
            pstm.setString(2, evenement.getIdReference());
            pstm.setString(3, nature_publie);
            pstm.setString(4, ligne1);
            pstm.setString(5, ligne2);
            pstm.setString(6, ligne3);
            pstm.setString(7, ligne4);
            pstm.setString(8, ligne5);
            pstm.setString(9, evenement.isPrevisionnel() ? "pr\u00e9visionnel" : "en cours");
            pstm.setInt(10, evenement.getLocalisation().getLongueur());
            pstm.setString(11, infos);
            Log.debug(pstm);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void publierEvenementExterne(EvenementPublication evenement) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            this.depublierEvenementExterne(evenement);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        try {
            connection = this.daoFactory.getConnection();
            String coordonnees = SQL.getChampGeometryPoint((GeoPoint)new GeoPoint(evenement.getX(), evenement.getY()), (int)4326);
            String lineaire = "";
            lineaire = "null";
            pstm = connection.prepareStatement("INSERT INTO donnees_externes.publication_evt (snm,erf,nature,champ_un,champ_deux,champ_trois,champ_quatre,champ_cinq,statut,coordonnees,lineaire,longueur,informationcomplementaire) VALUES (?,?,?,?,?,?,?,?,?," + coordonnees + "," + lineaire + ",?,?)");
            pstm.setString(1, evenement.getSnm());
            pstm.setString(2, evenement.getErf());
            pstm.setString(3, evenement.getNature());
            pstm.setString(4, evenement.getLigne1());
            pstm.setString(5, evenement.getLigne2());
            pstm.setString(6, evenement.getLigne3());
            pstm.setString(7, evenement.getLigne4());
            pstm.setString(8, evenement.getLigne5());
            pstm.setString(9, evenement.getStatut());
            pstm.setInt(10, evenement.getLongueur());
            pstm.setString(11, "");
            Log.debug(pstm);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    public void publicationAutomatique(Evenement e) throws Exception {
        int longueurMax = this.refDAO.getConfiguration().getInt("publicationLongueurLigneMax", 35);
        ReformulationDescription reformulation = this.getReformulation(e);
        Nature nature = (Nature)DeepCopy.copy((Object)this.refDAO.getNatureMap().get(reformulation.getCodeNature()));
        nature.chargerValeurs(e.getValeurNature());
        PublicationComposantFactory factory = new PublicationComposantFactory(this.refDAO.getValeursReformulation());
        String ligne1 = this.getLigneReformulee(e, nature, reformulation, factory, 1, reformulation.getType(1), reformulation.getValeur(1), longueurMax);
        String ligne2 = this.getLigneReformulee(e, nature, reformulation, factory, 2, reformulation.getType(2), reformulation.getValeur(2), longueurMax);
        String ligne3 = this.getLigneReformulee(e, nature, reformulation, factory, 3, reformulation.getType(3), reformulation.getValeur(3), longueurMax);
        String ligne4 = this.getLigneReformulee(e, nature, reformulation, factory, 4, reformulation.getType(4), reformulation.getValeur(4), longueurMax);
        String ligne5 = this.getLigneReformulee(e, nature, reformulation, factory, 5, reformulation.getType(5), reformulation.getValeur(5), longueurMax);
        this.publierEvenement(e, ligne1, ligne2, ligne3, ligne4, ligne5);
    }

    @Override
    public String getLigneReformulee(Evenement e, Nature nature, ReformulationDescription reformulation, PublicationComposantFactory factory, int indice, int type, String valeurChamp, int longueurMax) {
        String text = "";
        switch (type) {
            case 0: {
                text = "";
                break;
            }
            case 1: {
                text = nature.getLabel();
                break;
            }
            case 2: {
                text = reformulation.getLibelle();
                break;
            }
            case 3: {
                text = reformulation.getValeur(indice);
                break;
            }
            case 4: {
                text = this.getValeurChamp(nature, valeurChamp, factory);
                break;
            }
            case 5: {
                text = this.getValeurPeriode(e);
                break;
            }
        }
        if (text != null && text.length() > longueurMax) {
            text = text.substring(0, longueurMax);
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    @Override
    public String getValeurChamp(Nature nature, String nomChamp, PublicationComposantFactory factory) {
        Map champs = MetierCommun.getMapView((Nature)nature, (IComposantFactory)factory);
        if (champs.containsKey(nomChamp)) {
            String valeur = (String)champs.get(nomChamp);
            return valeur == null ? "" : valeur;
        }
        Log.error("impossible de trouver le champ configur\u00e9 " + nomChamp);
        return "";
    }

    @Override
    public String getValeurPeriode(Evenement e) {
        String text = PrismI18n.getString("publication.format.periode");
        SimpleDateFormat dateHeureFormat = new SimpleDateFormat(PrismI18n.getString("publication.format.periode.date"));
        if (e.getDateFin() <= 0L) {
            text = text.replace("[DATEDEB]", dateHeureFormat.format(new Date(e.getDateCreation())));
            text = text.replace("[DATEFIN]", "");
        } else {
            text = text.replace("[DATEDEB]", dateHeureFormat.format(new Date(e.getDateCreation())));
            text = text.replace("[DATEFIN]", dateHeureFormat.format(new Date(e.getDateFin())));
        }
        return text;
    }

    private ReformulationDescription getReformulation(Evenement e) {
        List<DescriptionNature> listeDesc = this.refDAO.getDescriptionsNatureMap().get(e.getValeurNature().getCode());
        DescriptionNature descriptionNature = null;
        String libelleDescription = e.getValeurNature().getDescription().getValeur();
        for (DescriptionNature d : listeDesc) {
            if (!d.getLibelle().equals(libelleDescription)) continue;
            descriptionNature = d;
            break;
        }
        String codeDescription = descriptionNature.getCode();
        ReformulationDescription reformulation = this.refDAO.getReformulations().get(codeDescription);
        if (reformulation == null) {
            Log.debug("Reformulation non configur\u00e9 pour la description " + codeDescription);
            reformulation = new ReformulationDescription();
            reformulation.setCode(codeDescription);
            reformulation.setCodeNature(e.getValeurNature().getCode());
            reformulation.setLibelle(descriptionNature.getLibelle());
        }
        return reformulation;
    }

    @Override
    public void datePublicationMaj() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_UPDATEDATEPUBLICATION);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    public static Point getChampGeometryPoint(Object obj) {
        Point point = obj != null ? (Point)((PGgeometry)obj).getGeometry() : new Point(0.0, 0.0);
        return point;
    }

    private String getProjection(String projection) {
        if (!GLS.estVide((String)projection) && GLS.estNumerique((String)projection)) {
            return projection;
        }
        boolean osm = GLS.getBoolean((String)GLS.getString((Object)this.configuration.get(CARTO_OSM)), (boolean)false);
        if (osm) {
            return GLS.getString((Object)this.configuration.get(CARTO_PROJECTION_OSM)).toLowerCase().replace("epsg:", "");
        }
        if (this.configuration.get(CARTO_PROJECTION) == null) {
            return "4326";
        }
        return GLS.getString((Object)this.configuration.get(CARTO_PROJECTION)).toLowerCase().replace("epsg:", "");
    }

    public List<Troncon> getCoordonneesEvenements() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        try {
            String requete = "SELECT snm,erf,ST_Transform(lineaire," + this.getProjection(null) + ") as lineaire FROM publication_evt where not lineaire is null";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            Log.debug(pstm.toString());
            rs = pstm.executeQuery();
            while (rs.next()) {
                Troncon troncon = new Troncon();
                troncon.setErf(rs.getString("erf"));
                troncon.setSnm(rs.getString("snm"));
                Vector<Coordonnees> listeCoordonnees = new Vector<Coordonnees>();
                Vector points = SQL.getPoints2D((LineString)SQL.getChampGeometryLine((Object)rs.getObject("lineaire")));
                for (Point2D.Double point : points) {
                    Coordonnees coordonnees = new Coordonnees();
                    coordonnees.setX(point.x);
                    coordonnees.setY(point.y);
                    listeCoordonnees.add(coordonnees);
                }
                troncon.setCoordonnees(listeCoordonnees);
                troncons.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    @Override
    public String getCoordonneesEvenementsJSON() {
        Gson g = new Gson();
        return g.toJson(this.getCoordonneesEvenements());
    }

    @Override
    public String getDerniereDatePublicationJSON(DatePublication datePublication) {
        Gson g = new Gson();
        return g.toJson((Object)datePublication);
    }

    @Override
    public String getEvenementsPubliesJSON(String status, String nature, String projection) {
        Gson g = new Gson();
        List<EvenementPublication> listeEvts = this.getEvenements(status, null, projection);
        if (this.refDAO.getConfiguration().getBoolean("publication.donnees_externes.vh", false)) {
            listeEvts.addAll(this.getEvenementsExternes(status, null, projection));
        }
        return g.toJson(listeEvts);
    }

    @Override
    public String getEvenementsPubliesJSON() {
        Gson g = new Gson();
        return g.toJson(this.getEvenements(null, null, null));
    }

    private DatePublication toDatePublication(Calendar cal) {
        DatePublication datePublication = new DatePublication();
        GLS.getDate();
        GLS.getDate();
        datePublication.setDatePublication(GLSDate.toDate((Calendar)cal, (DateFormat)GLSDate.formatDateComplete));
        GLS.getDate();
        GLS.getDate();
        datePublication.setJourPublication(GLSDate.toDate((Calendar)cal, (DateFormat)GLSDate.formatDateJour));
        GLS.getDate();
        GLS.getDate();
        datePublication.setHeurePublication(GLSDate.toDate((Calendar)cal, (DateFormat)GLSDate.formatHeure));
        return datePublication;
    }

    @Override
    public String getDerniereDatePublicationJSON() {
        Gson g = new Gson();
        return g.toJson((Object)this.toDatePublication(this.getDerniereDatePublication()));
    }

    public Map<String, Object> getConfiguration() {
        if (this.configuration == null) {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            this.configuration = new HashMap<String, Object>();
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GETCONFIGURATION);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Object valeur = this.configurationValueFactory(rs.getString(TYPE), rs.getString("valeur"));
                    this.configuration.put(rs.getString("code"), valeur);
                }
            }
            catch (Exception e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return this.configuration;
    }

    private Object configurationValueFactory(String type, String value) {
        switch (type) {
            case "arrayInt": {
                return this.configurationValueToArrayInt(value);
            }
            case "arrayString": {
                return this.configurationValueToArrayString(value);
            }
            case "arrayDouble": {
                return this.configurationValueToArrayDouble(value);
            }
            case "int": {
                return this.configurationValueToInt(value);
            }
            case "double": {
                return this.configurationValueToDouble(value);
            }
            case "string": {
                return this.configurationValueToString(value);
            }
        }
        return this.configurationValueToString(value);
    }

    private List<Integer> configurationValueToArrayInt(String value) {
        ArrayList<Integer> retour = new ArrayList<Integer>();
        for (String val : value.split(",")) {
            retour.add(Integer.valueOf(val));
        }
        return retour;
    }

    private List<Double> configurationValueToArrayDouble(String value) {
        ArrayList<Double> retour = new ArrayList<Double>();
        for (String val : value.split(",")) {
            retour.add(Double.valueOf(val));
        }
        return retour;
    }

    private List<String> configurationValueToArrayString(String value) {
        ArrayList<String> retour = new ArrayList<String>();
        for (String val : value.split(",")) {
            retour.add(val);
        }
        return retour;
    }

    private int configurationValueToInt(String value) {
        return Integer.valueOf(value);
    }

    private double configurationValueToDouble(String value) {
        return Double.valueOf(value);
    }

    private String configurationValueToString(String value) {
        return value;
    }

    @Override
    public String getConfigurationJSON() {
        Gson g = new Gson();
        if (this.configuration == null) {
            this.configuration = this.getConfiguration();
        }
        return g.toJson(this.configuration);
    }

    @Override
    public void publierPatrouilleVH(String idPatrouille) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_PUBLIERPATROUILLE);
            pstm.setString(1, idPatrouille);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void depublierPatrouilleVH(String idPatrouille) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_DEPUBLIERPATROUILLE);
            pstm.setString(1, idPatrouille);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void miseAJourEvenementPrevisionnel(List<String> ret) {
        block5: {
            Connection connection = null;
            PreparedStatement pstm = null;
            if (GLS.estVide(ret)) break block5;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MAJ_EVENEMENTS_PUBLIES_PREVISIONNELS);
                for (String erf : ret) {
                    pstm.setString(1, erf);
                    pstm.execute();
                    pstm.clearParameters();
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm);
            this.datePublicationMaj();
        }
    }

    @Override
    public void rechargerConfiguration() {
        this.configuration = null;
        this.configuration = this.getConfiguration();
    }

    @Override
    public void creerMessageAlertePublication(MessageAlertePublication message) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_CREATE_MESSAGES_ALERTE);
            pstm.setString(1, message.getLibelle());
            pstm.setString(2, message.getTexte());
            pstm.setTimestamp(3, message.getDateDebut());
            pstm.setTimestamp(4, message.getDateFin());
            pstm.setString(5, message.getType());
            pstm.setBoolean(6, message.isDefaut());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public void updateMessageAlertePublication(MessageAlertePublication message) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_UPDATE_MESSAGES_ALERTE);
            pstm.setString(1, message.getLibelle());
            pstm.setString(2, message.getTexte());
            pstm.setTimestamp(3, message.getDateDebut());
            pstm.setTimestamp(4, message.getDateFin());
            pstm.setString(5, message.getType());
            pstm.setBoolean(6, message.isDefaut());
            pstm.setInt(7, message.getId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public List<MessageAlertePublication> getMessagesAlertePublication() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<MessageAlertePublication> liste = new ArrayList<MessageAlertePublication>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_GET_MESSAGES_ALERTE);
            rs = pstm.executeQuery();
            while (rs.next()) {
                MessageAlertePublication message = new MessageAlertePublication();
                message.setId(rs.getInt("id"));
                message.setLibelle(rs.getString("libelle"));
                message.setTexte(rs.getString("texte"));
                message.setDateDebut(rs.getTimestamp("date_debut"));
                message.setDateFin(rs.getTimestamp("date_fin"));
                message.setType(rs.getString("type_message"));
                message.setDefaut(rs.getBoolean("defaut"));
                liste.add(message);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public void deleteMessageAlertePublication(MessageAlertePublication message) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_DELETE_MESSAGES_ALERTE);
            pstm.setInt(1, message.getId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
        this.datePublicationMaj();
    }

    @Override
    public TreeMap<String, String> getModelesMessagePublication(String typeModele) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        TreeMap<String, String> liste = new TreeMap<String, String>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_GET_MODELE_PUBLICATION);
            pstm.setString(1, typeModele);
            rs = pstm.executeQuery();
            while (rs.next()) {
                liste.put(rs.getString("libelle"), rs.getString("texte"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public String getMessageSyntheseJSON() {
        Gson g = new Gson();
        return g.toJson((Object)this.getMessageSynthesePublication());
    }

    @Override
    public String getMessageAlerteJSON() {
        Gson g = new Gson();
        List<MessageAlertePublication> messages = this.getMessageAlertePublication();
        if (messages.size() == 1) {
            return g.toJson((Object)messages.get(0));
        }
        MessageAlertePublication messageDefaut = new MessageAlertePublication();
        messageDefaut.setTexte("Pas de message");
        messageDefaut.setType("Fixe");
        for (MessageAlertePublication message : messages) {
            if (!message.isDefaut()) {
                return g.toJson((Object)message);
            }
            messageDefaut = message;
        }
        return g.toJson((Object)messageDefaut);
    }

    public List<MessageAlertePublication> getMessageAlertePublication() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<MessageAlertePublication> messages = new ArrayList<MessageAlertePublication>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_GET_MESSAGE_ALERTE);
            pstm.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            rs = pstm.executeQuery();
            while (rs.next()) {
                MessageAlertePublication message = new MessageAlertePublication();
                message.setTexte(rs.getString("texte"));
                message.setType(rs.getString("type_message"));
                message.setDefaut(rs.getBoolean("defaut"));
                messages.add(message);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return messages;
    }

    @Override
    public Synthese getMessageSynthesePublication() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Synthese synthese = new Synthese();
        String zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_GET_MESSAGE_SYNTHESE);
            pstm.setString(1, zoneRoutiere.toLowerCase());
            rs = pstm.executeQuery();
            if (rs.next()) {
                synthese.setCommentaire(rs.getString("commentaire"));
                synthese.setDate((Date)rs.getTimestamp(DATE));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return synthese;
    }

    @Override
    public HashMap<String, String> getSavePublicationEvenement(Evenement evt) {
        HashMap<String, String> retour = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_GET_SAVE_EVENEMENT_PUBLICATION);
            pstm.setString(1, evt.getIdSituation());
            pstm.setString(2, evt.getIdReference());
            rs = pstm.executeQuery();
            while (rs.next()) {
                int num_ligne = rs.getInt("num_ligne");
                retour.put(TYPE + num_ligne, rs.getString("type_champ"));
                retour.put("complement" + num_ligne, rs.getString("complement_champ"));
                retour.put("valeur" + num_ligne, rs.getString("valeur"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private void deleteSavePublicationEvenement(Evenement evt) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_DELETE_SAVE_EVENEMENT_PUBLICATION);
            pstm.setString(1, evt.getIdSituation());
            pstm.setString(2, evt.getIdReference());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void saveGetPublicationEvenement(Evenement evt, String type1, String complement1, String valeur1, String type2, String complement2, String valeur2, String type3, String complement3, String valeur3, String type4, String complement4, String valeur4, String type5, String complement5, String valeur5) {
        Connection connection = null;
        PreparedStatement pstm = null;
        this.deleteSavePublicationEvenement(evt);
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_SAVE_EVENEMENT_PUBLICATION);
            pstm.setString(1, evt.getIdSituation());
            pstm.setString(2, evt.getIdReference());
            pstm.setInt(3, 1);
            pstm.setString(4, type1);
            pstm.setString(5, complement1);
            pstm.setString(6, valeur1);
            pstm.setString(7, evt.getIdSituation());
            pstm.setString(8, evt.getIdReference());
            pstm.setInt(9, 2);
            pstm.setString(10, type2);
            pstm.setString(11, complement2);
            pstm.setString(12, valeur2);
            pstm.setString(13, evt.getIdSituation());
            pstm.setString(14, evt.getIdReference());
            pstm.setInt(15, 3);
            pstm.setString(16, type3);
            pstm.setString(17, complement3);
            pstm.setString(18, valeur3);
            pstm.setString(19, evt.getIdSituation());
            pstm.setString(20, evt.getIdReference());
            pstm.setInt(21, 4);
            pstm.setString(22, type4);
            pstm.setString(23, complement4);
            pstm.setString(24, valeur4);
            pstm.setString(25, evt.getIdSituation());
            pstm.setString(26, evt.getIdReference());
            pstm.setInt(27, 5);
            pstm.setString(28, type5);
            pstm.setString(29, complement5);
            pstm.setString(30, valeur5);
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void deleteGetPublicationEvenement(Evenement evt) {
        this.deleteSavePublicationEvenement(evt);
    }

    public static String getParametre(Object obj) {
        if (obj != null) {
            String[] t;
            if (obj instanceof String[] && (t = (String[])obj) != null && t.length > 0) {
                return t[0];
            }
        } else {
            return GLS.getString((Object)obj);
        }
        return "";
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getEvenementsExport(Map m, IPhotoDAO photoDao) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getMissionsExport(ISuiviActiviteService suiviActivite, Map m) {
        String paramDate = PublicationDAOJDBC.getParametre(m.get(DATE));
        String paramDateDebut = PublicationDAOJDBC.getParametre(m.get(DATE_DEBUT));
        String paramDateFin = PublicationDAOJDBC.getParametre(m.get(DATE_FIN));
        String champs = PublicationDAOJDBC.getParametre(m.get(CHAMPS));
        int codeMm = GLS.getInt((String)PublicationDAOJDBC.getParametre(m.get(MM)), (int)-1);
        String typeExport = PublicationDAOJDBC.getParametre(m.get("typeExport"));
        String separateur = PublicationDAOJDBC.getParametre(m.get(SEPARATEUR));
        String type = PublicationDAOJDBC.getParametre(m.get(TYPE));
        SimpleDateFormat formatJourHeure = new SimpleDateFormat("yyyyMMddHHmmss");
        Timestamp dateDebut = new Timestamp(System.currentTimeMillis());
        Timestamp dateFin = new Timestamp(System.currentTimeMillis());
        if (!GLS.estVide((String)paramDate) && !GLS.egal((String)"-1", (String)paramDate)) {
            if (!GLS.egal((String)paramDate, (String)"aujourdhui")) {
                if (GLS.egal((String)paramDate, (String)"hier")) {
                    Calendar c = GregorianCalendar.getInstance();
                    c.add(5, -1);
                    ((Date)dateDebut).setTime(c.getTimeInMillis());
                    dateFin.setTime(c.getTimeInMillis());
                } else {
                    SimpleDateFormat formatJour = new SimpleDateFormat("yyyyMMdd");
                    try {
                        dateDebut = new Timestamp(formatJour.parse(paramDate).getTime());
                        dateFin = new Timestamp(formatJour.parse(paramDate).getTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            dateDebut.setHours(0);
            dateDebut.setMinutes(0);
            dateDebut.setSeconds(0);
            dateFin.setHours(23);
            dateFin.setMinutes(59);
            dateFin.setSeconds(59);
        } else {
            if (!GLS.estVide((String)paramDateDebut) && !GLS.egal((String)"-1", (String)paramDateDebut)) {
                try {
                    dateDebut = new Timestamp(formatJourHeure.parse(paramDateDebut).getTime());
                }
                catch (Exception e) {
                    dateDebut.setHours(0);
                    dateDebut.setMinutes(0);
                    dateDebut.setSeconds(0);
                }
            } else {
                dateDebut.setHours(0);
                dateDebut.setMinutes(0);
                dateDebut.setSeconds(0);
            }
            if (!GLS.estVide((String)paramDateFin) && !GLS.egal((String)"-1", (String)paramDateFin)) {
                try {
                    dateFin = new Timestamp(formatJourHeure.parse(paramDateFin).getTime());
                }
                catch (Exception e) {
                    dateFin.setHours(23);
                    dateFin.setMinutes(59);
                    dateFin.setSeconds(59);
                }
            } else {
                dateFin.setHours(23);
                dateFin.setMinutes(59);
                dateFin.setSeconds(59);
            }
        }
        List<Mission> missions = GLS.egal((String)type, (String)TYPE_EXT) ? suiviActivite.getMissions((Date)dateDebut, (Date)dateFin) : this.ig4DAO.getMissionsPrism(dateDebut, dateFin, codeMm);
        ArrayList<DynamicMissionExport> l = new ArrayList<DynamicMissionExport>();
        MapDescription mapChampsExport = DynamicExport.getChampAExporter(champs, DynamicMissionExport.CHAMPS_DEFAUT);
        if (!GLS.estVide(missions)) {
            for (Mission mission : missions) {
                l.add(DynamicMissionExport.convert(mapChampsExport, mission));
            }
        }
        return this.exportDonnees(l, mapChampsExport, typeExport, separateur);
    }

    @Override
    public String getPositionsExport(Map m) {
        Object sdf;
        String delegation = PublicationDAOJDBC.getParametre(m.get(DELEGATION));
        String centre = PublicationDAOJDBC.getParametre(m.get(CENTRE));
        String date = PublicationDAOJDBC.getParametre(m.get(DATE));
        String champs = PublicationDAOJDBC.getParametre(m.get(CHAMPS));
        ArrayList<Integer> codeMms = new ArrayList<Integer>();
        if (m.get(MM) == null) {
            codeMms.add(-1);
        } else if (m.get(MM) instanceof String[] && ((String[])m.get(MM)).length > 0) {
            for (String mmTemp : (String[])m.get(MM)) {
                codeMms.add(GLS.getInt((String)mmTemp, (int)-1));
            }
        } else {
            codeMms.add(GLS.getInt((String)PublicationDAOJDBC.getParametre(m.get(MM)), (int)-1));
        }
        String typeExport = PublicationDAOJDBC.getParametre(m.get("typeExport"));
        String separateur = PublicationDAOJDBC.getParametre(m.get(SEPARATEUR));
        int actif = GLS.getInt((String)PublicationDAOJDBC.getParametre(m.get(ACTIF)), (int)-1);
        String typeExportWaze = PublicationDAOJDBC.getParametre(m.get("typeExportWaze"));
        IBusinessService.VehiculeFiltre f = IBusinessService.VehiculeFiltre.tous();
        if (!GLS.estVide((String)delegation)) {
            f.delegation = delegation;
        }
        if (!GLS.estVide((String)centre)) {
            f.centre = centre;
        }
        if (!GLS.estVide((String)date) && !GLS.egal((String)"-1", (String)date)) {
            sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Timestamp dateDebut = new Timestamp(System.currentTimeMillis());
            Timestamp dateFin = new Timestamp(System.currentTimeMillis());
            if (GLS.egal((String)date, (String)"aujourdhui")) {
                dateDebut.setHours(0);
                dateDebut.setMinutes(0);
                dateDebut.setSeconds(0);
            } else if (GLS.egal((String)date, (String)"hier")) {
                Calendar c = GregorianCalendar.getInstance();
                c.add(5, -1);
                dateDebut.setTime(c.getTimeInMillis());
                dateFin.setTime(c.getTimeInMillis());
                dateDebut.setHours(0);
                dateDebut.setMinutes(0);
                dateDebut.setSeconds(0);
            } else {
                try {
                    dateDebut = new Timestamp(((DateFormat)sdf).parse(date).getTime());
                    dateFin = new Timestamp(((DateFormat)sdf).parse(date).getTime());
                }
                catch (Exception e) {
                    dateDebut.setHours(0);
                    dateDebut.setMinutes(0);
                    dateDebut.setSeconds(0);
                }
            }
            dateFin.setHours(23);
            dateFin.setMinutes(59);
            dateFin.setSeconds(59);
            f.dateMin = dateDebut;
            f.dateMax = dateFin;
        }
        sdf = codeMms.iterator();
        while (sdf.hasNext()) {
            int mmTemp = (Integer)sdf.next();
            if (mmTemp == -1) continue;
            f.ajouterCodeMm(mmTemp);
        }
        if (actif != -1) {
            f.termine = actif == 1 ? 0 : 1;
        }
        f.addPositionPrecedenteAvecVitesse = "typeExportWazeIncidents".equals(typeExportWaze);
        List<VehiculeEnIntervention> vehicules = this.vehiculeDAO.getVehiculesEnIntervention(f);
        ArrayList<DynamicVehiculeExport> l = new ArrayList<DynamicVehiculeExport>();
        MapDescription mapChampsExport = DynamicExport.getChampAExporter(champs, DynamicVehiculeExport.CHAMPS_DEFAUT);
        if (!GLS.estVide(vehicules)) {
            for (VehiculeEnIntervention v : vehicules) {
                if ("typeExportWazeIncidents".equals(typeExportWaze)) {
                    if (!v.isWazeFluxIncidents()) continue;
                    l.add(DynamicVehiculeExport.convert(mapChampsExport, v, this.refDAO.getConfiguration(), "typeExportWazeIncidents"));
                    continue;
                }
                if ("typeExportWazeESH".equals(typeExportWaze)) {
                    l.add(DynamicVehiculeExport.convert(mapChampsExport, v, this.refDAO.getConfiguration(), "typeExportWazeESH"));
                    continue;
                }
                l.add(DynamicVehiculeExport.convert(mapChampsExport, v, this.refDAO.getConfiguration()));
            }
        }
        return this.exportDonnees(l, mapChampsExport, typeExport, separateur);
    }

    private String exportDonnees(List<?> l, MapDescription champsAExporter, String typeExport, String separator) {
        StringBuffer s = new StringBuffer();
        if (!GLS.estVide(l)) {
            if (GLS.egal((String)typeExport, (String)"csv")) {
                CsvSchema schema = null;
                CsvSchema.Builder schemaBuilder = CsvSchema.builder();
                if (champsAExporter != null) {
                    for (String col : champsAExporter.getCles()) {
                        schemaBuilder.addColumn(champsAExporter.getString(col, col));
                    }
                    schema = schemaBuilder.build().withLineSeparator(System.lineSeparator()).withArrayElementSeparator(System.lineSeparator()).withHeader();
                }
                String champsTexte = GLS.getString((Iterator)schemaBuilder.getColumns(), (String)",");
                String[] tabChamps = GLS.getTableauString((String)champsTexte, (String)",");
                Log.debug("Champs schema builder " + tabChamps.length + " -- " + champsTexte);
                if (!GLS.estVide((String)separator)) {
                    schema = schema.withColumnSeparator(separator.charAt(0));
                }
                CsvMapper mapper = new CsvMapper();
                mapper.configure(CsvGenerator.Feature.ALWAYS_QUOTE_STRINGS, true);
                mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
                mapper.disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
                mapper.enable(CsvParser.Feature.INSERT_NULLS_FOR_MISSING_COLUMNS);
                ObjectWriter writer = mapper.writer((FormatSchema)schema);
                try {
                    s.append(writer.writeValueAsString(l));
                }
                catch (Exception ex) {
                    Log.error("ERREUR EXPORT DONNEES CSV", ex);
                }
            } else {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    s.append(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(l));
                }
                catch (Exception ex) {
                    Log.error("ERREUR EXPORT DONNEES JSON", ex);
                }
            }
        }
        return s.toString();
    }

    private String getCodeUtilisateur(String sna) {
        PrismCentralUser u = this.refDAO.getUtilisateur(sna);
        if (u != null) {
            return u.getNom() + " (" + sna + ")";
        }
        return "";
    }

    private Map<Integer, Map<String, String>> chargerTousAttributs(String natures, String date, String cloture) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean datePresente = false;
        boolean naturesPresentes = false;
        String requete = "SELECT k_eventid as \"id\",champ,valeur FROM prism.attribut_evenement WHERE k_eventid IN (SELECT k_eventid FROM prism.evenement e  WHERE  e.etat = '1'";
        requete = requete + " AND e.can='N' ";
        Timestamp dateDebut = new Timestamp(2020, 1, 1, 0, 0, 0, 0);
        if (!GLS.estVide((String)date) && !GLS.egal((String)"-1", (String)date)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                dateDebut = new Timestamp(sdf.parse(date).getTime());
                requete = requete + " AND e.mst > ? ";
                datePresente = true;
            }
            catch (Exception sdf) {
                // empty catch block
            }
        }
        if (!GLS.estVide((String)natures)) {
            requete = requete + " AND e.dob =ANY (?) ";
            naturesPresentes = true;
        }
        if (GLS.egal((String)cloture, (String)"0")) {
            requete = requete + " AND e.fin is null ";
        }
        requete = requete + " )";
        HashMap<Integer, Map<String, String>> attributs = null;
        int iparam = 1;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            if (datePresente) {
                pstm.setTimestamp(iparam++, dateDebut);
            }
            if (naturesPresentes) {
                Array a = connection.createArrayOf("text", GLS.getTableauString((String)natures, (String)","));
                pstm.setArray(iparam++, a);
            }
            Log.debug("# requete charger tous attributs # " + pstm);
            rs = pstm.executeQuery();
            attributs = new HashMap<Integer, Map<String, String>>();
            while (rs.next()) {
                Map<String, String> map;
                int keventid = rs.getInt("id");
                if (attributs.containsKey(keventid)) {
                    map = (Map)attributs.get(keventid);
                } else {
                    map = new HashMap();
                    attributs.put(keventid, map);
                }
                map.put(rs.getString("champ"), rs.getString("valeur"));
            }
            rs.close();
        }
        catch (SQLException e) {
            try {
                Log.error("ERR SQL EVT EXPORT", e);
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return attributs;
    }

    private List<String> getPhotos(IPhotoDAO photoDao, boolean indatabase, File dirBasePhoto, IEvenementExport e, List<String> photosListe, int keventid, String refId, String sitId) {
        int nbPhotosEvenement = photosListe.size();
        ArrayList<String> images = new ArrayList<String>();
        if (indatabase) {
            for (int index = 0; index < nbPhotosEvenement; ++index) {
                String filename = photosListe.get(index);
                byte[] data = photoDao.getPhoto(filename);
                if (data != null) {
                    try {
                        images.add(DatatypeConverter.printBase64Binary((byte[])data));
                    }
                    catch (Exception ex) {
                        Log.error("image introuvable dans le r\u00e9pertoire ID=" + keventid + " - PH=" + filename, ex);
                    }
                    continue;
                }
                Log.error("image introuvable dans le r\u00e9pertoire ID=" + keventid + " - PH=" + filename);
            }
        } else {
            for (int index = 0; index < nbPhotosEvenement; ++index) {
                String filename = photosListe.get(index);
                File dir = new File(dirBasePhoto, sitId + File.separator + refId);
                File file = new File(dir, filename);
                if (file.exists()) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    try {
                        int readNum;
                        while ((readNum = fis.read(buf)) != -1) {
                            bos.write(buf, 0, readNum);
                        }
                    }
                    catch (Exception ex) {
                        Log.error("image en erreur " + filename);
                    }
                    byte[] bytes = bos.toByteArray();
                    try {
                        images.add(DatatypeConverter.printBase64Binary((byte[])GLS.getBytes((BufferedImage)GLS.getImage((ImageIcon)new ImageIcon(bytes), (int)360, (int)260))));
                    }
                    catch (Exception ex) {
                        Log.error("", ex);
                    }
                    continue;
                }
                Log.error("image introuvable dans le r\u00e9pertoire ID=" + keventid + " - PH=" + filename);
            }
        }
        return images;
    }

    @Override
    public Map<String, Object> getConfigurationPublication() {
        this.configuration = null;
        return this.getConfiguration();
    }

    @Override
    public List<EvenementPublication> getEvenements(String status, String nature) {
        return null;
    }

    @Override
    public String getEvenementsPubliesJSON(String status, String nature) {
        return this.getEvenementsPubliesJSON(status, nature, null);
    }
}

