/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IPhotoDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PhotoDAOJDBC
implements IPhotoDAO {
    private DAOFactory daoFactory;

    public PhotoDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public byte[] getPhoto(String hash) {
        byte[] byArray;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block5: {
            connection = null;
            pstm = null;
            rs = null;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT data FROM prism.photo WHERE hash=?");
            pstm.setString(1, hash);
            rs = pstm.executeQuery();
            if (!rs.next()) break block5;
            byte[] byArray2 = rs.getBytes(1);
            DAOUtil.close(connection, pstm, rs);
            return byArray2;
        }
        try {
            byArray = null;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return byArray;
    }

    @Override
    public void sauvegarderPhoto(Connection connectionInit, String hash, byte[] data) {
        PreparedStatement pstm = null;
        try {
            pstm = connectionInit.prepareStatement("DELETE FROM prism.photo WHERE hash=?");
            pstm.setString(1, hash);
            pstm.execute();
            DAOUtil.close(pstm);
            pstm = connectionInit.prepareStatement("INSERT INTO prism.photo (hash,data) VALUES (?,?)");
            pstm.setString(1, hash);
            pstm.setBytes(2, data);
            pstm.execute();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(null, pstm);
        }
    }

    @Override
    public boolean isPhotoExist(String hash) {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block5: {
            connection = null;
            pstm = null;
            rs = null;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT 1 FROM prism.photo WHERE hash=?");
            pstm.setString(1, hash);
            rs = pstm.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = true;
            DAOUtil.close(connection, pstm, rs);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return bl;
    }

    @Override
    public void sauvegarderPhoto(String filename, byte[] data) {
        try (Connection connection = this.daoFactory.getConnection();){
            connection.setAutoCommit(false);
            this.sauvegarderPhoto(connection, filename, data);
            connection.commit();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }
}

