/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.IUtilisateur;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.CommentaireMCIG;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.TableauBordFiltre;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Util;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.postgis.PGbox2d;
import org.postgis.Polygon;

public class McigDAOJDBC
implements IMcigDAO {
    private static final String ENTETE_REQUETE_MCIG = "select mcig_id,date_heure_deb,date_heure_fin, etat_mcig, nom_carto,plan, type_poste,u.id_utilisateur, arret, difficulte from mcig m inner join utilisateur u on u.id_utilisateur = m.id_utilisateur ";
    private static final String REQUETE_MCIG_ACTIVE = "select mcig_id,date_heure_deb,date_heure_fin, etat_mcig, nom_carto,plan, type_poste,u.id_utilisateur, arret, difficulte from mcig m inner join utilisateur u on u.id_utilisateur = m.id_utilisateur ".concat("where sna = ? and mse = ? and etat_mcig = 1 order by date_heure_deb desc");
    private static final String REQUETE_MCIG_PAR_ID = "select mcig_id,date_heure_deb,date_heure_fin, etat_mcig, nom_carto,plan, type_poste,u.id_utilisateur, arret, difficulte from mcig m inner join utilisateur u on u.id_utilisateur = m.id_utilisateur ".concat("where mcig_id = ?");
    private static final String REQUETE_MCIG_ACTIVE_MEME_JOURNEE = "select mcig_id,date_heure_deb,date_heure_fin, etat_mcig, nom_carto,plan, type_poste,u.id_utilisateur, arret, difficulte from mcig m inner join utilisateur u on u.id_utilisateur = m.id_utilisateur ".concat("where sna = ? and mse = ? and etat_mcig = 1 and date_trunc('day',to_timestamp(?/1000)) = date_trunc('day',date_heure_deb) and type_poste = ? order by date_heure_deb desc");
    private static final String REQUETE_INSERTION_MCIG = "insert into mcig (mcig_id,date_heure_deb,date_heure_fin,etat_mcig,id_utilisateur,arret,difficulte,type_poste,imei,sim,telephone,version) values (?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String REQUETE_INSERTION_COMMENTAIRE = "insert into commentaire_mcig (com_mcig_id,phr_com_mcig,date_heure_com,mcig_id,id_evenement,niveau,type,snm,erf) values (?,?,?,?,?,?,?,?,?)";
    private static final String REQUETE_INSERTION_COMMENTAIRE_SANS_TYPE = "insert into commentaire_mcig (com_mcig_id,phr_com_mcig,date_heure_com,mcig_id,id_evenement,niveau,snm,erf) values (?,?,?,?,?,?,?,?)";
    private static final String REQUETE_FERMER_MAIN_COURANTE = "update mcig set etat_mcig = 0,date_heure_fin = ? where mcig_id = ?";
    private static final String REQUETE_FIN_EVENEMENT_MISSION_MCIG = "update prism.evenement set fin='Y',mst=now(),valopedate=now() where dob in (select code from prism.nature_perso where code_categorie = 'mission')  and mcig_id = ?";
    private static final String PRISE_SERVICE = "Prise de service";
    private static final String FIN_SERVICE = "Fin de service";
    private DAOFactory daoFactory;
    private IReferentielDAO refDAO;
    private IVehiculeDAO vehiculeDAO;
    public static final int NON_DEFINI = 0;
    public static final int PATROUILLEUR = 1;
    public static final int FIXE = 2;
    public static char CHAR_SEPARATEUR_COMMENTAIRE = (char)167;

    public McigDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO, IVehiculeDAO vehiculeDAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
        this.vehiculeDAO = vehiculeDAO;
    }

    @Override
    public List<String> getKeyMCIG(TableauBordFiltre filtre) {
        ArrayList<String> keys = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String requete = "";
        if (filtre.snm != null && filtre.erf != null) {
            keys.add(filtre.snm + filtre.erf);
            return keys;
        }
        if (filtre.emetteur != null) {
            requete = "SELECT DISTINCT a.mcig_id as key, MAX(c.date_heure_com) FROM commentaire_mcig c, mcig a, utilisateur b";
            requete = requete + " WHERE a.id_utilisateur = b.id_utilisateur  AND c.mcig_id = a.mcig_id AND b.mse = ? AND b.sna = ?";
            if (filtre.dateDebut != null || filtre.dateFin != null) {
                requete = requete + " AND (a.date_heure_fin >= ? OR (a.date_heure_fin is null)) AND a.date_heure_deb <= ?";
            }
            if (filtre.axe != null) {
                requete = requete + " AND a.mcig_id IN (SELECT d.mcig_id FROM localisation d WHERE d.axe = ?)";
            }
            if (filtre.mcig_id != null) {
                requete = requete + " AND b.mcig_id = ?";
            }
            requete = requete + " GROUP BY a.mcig_id";
            requete = requete + " ORDER BY MAX(c.date_heure_com) DESC";
        } else if (filtre.mcig_id != null) {
            requete = "SELECT DISTINCT a.mcig_id as key FROM commentaire_mcig a, mcig b, utilisateur c";
            if (filtre.axe != null) {
                requete = requete + ", localisation d";
            }
            requete = requete + " WHERE c.id_utilisateur = b.id_utilisateur  AND b.mcig_id = a.mcig_id AND c.mse = ?";
            if (filtre.dateDebut != null && filtre.dateFin != null) {
                requete = requete + " AND (a.date_heure_com BETWEEN ? AND ?)";
            }
            if (filtre.delegation != null) {
                requete = requete + " AND c.delegation = ?";
            }
            if (filtre.centre != null) {
                requete = requete + " AND c.centre = ?";
            }
            if (filtre.profil != -1) {
                requete = requete + " AND c.id_profil = ?";
            }
            if (filtre.axe != null) {
                requete = requete + " AND d.mcig_id = b.mcig_id";
                requete = requete + " AND d.axe = ?";
            }
            if (filtre.mcig_id != null) {
                requete = requete + " AND b.mcig_id = ?";
            }
            requete = requete + " AND a.niveau <= " + filtre.niveau;
            requete = requete + " GROUP BY key";
        } else if (filtre.snm != null && filtre.erf != null) {
            requete = "SELECT DISTINCT CONCAT(a.snm,a.erf) as key FROM commentaire_mcig a, mcig b, utilisateur c WHERE c.id_utilisateur = b.id_utilisateur AND b.mcig_id = a.mcig_id AND c.mse = ? AND a.snm = ? AND a.erf = ?;";
        } else if (filtre.filtreQueSurDate) {
            requete = "SELECT b.mcig_id as key FROM mcig b WHERE ";
            if (filtre.dateFin != null && filtre.dateDebut == null) {
                requete = requete + " b.date_heure_deb < ?";
            } else if (filtre.dateFin != null && filtre.dateDebut != null) {
                requete = requete + " b.date_heure_deb BETWEEN ? AND ? ";
            }
        } else {
            requete = "SELECT DISTINCT to_char(a.date_heure_com,'dd/mm/yyyy') as key, MAX(a.date_heure_com) FROM commentaire_mcig a, mcig b, utilisateur c";
            if (filtre.axe != null) {
                requete = requete + ", localisation d";
            }
            requete = requete + " WHERE c.id_utilisateur = b.id_utilisateur  AND b.mcig_id = a.mcig_id AND c.mse = ? AND (a.date_heure_com BETWEEN ? AND ?)";
            if (filtre.delegation != null) {
                requete = requete + " AND c.delegation = ?";
            }
            if (filtre.centre != null) {
                requete = requete + " AND c.centre = ?";
            }
            if (filtre.profil != -1) {
                requete = requete + " AND c.id_profil = ?";
            }
            if (filtre.axe != null) {
                requete = requete + " AND d.mcig_id = b.mcig_id";
                requete = requete + " AND d.axe = ?";
            }
            if (filtre.mcig_id != null) {
                requete = requete + " AND b.mcig_id = ?";
            }
            requete = requete + " AND a.niveau <= " + filtre.niveau;
            requete = requete + " GROUP BY key";
            requete = requete + " ORDER BY MAX(a.date_heure_com) DESC";
        }
        Log.debug(requete);
        try {
            Timestamp dateFinTmp;
            Timestamp dateDebutTmp;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            int indexParam = 1;
            if (!filtre.filtreQueSurDate) {
                pstm.setString(indexParam, filtre.mse);
                ++indexParam;
            }
            if (filtre.emetteur != null) {
                pstm.setString(indexParam, filtre.emetteur);
                ++indexParam;
            }
            if (filtre.filtreQueSurDate) {
                if (filtre.dateFin != null && filtre.dateDebut == null) {
                    filtre.dateFin.set(11, 23);
                    filtre.dateFin.set(12, 59);
                    filtre.dateFin.set(13, 59);
                    Timestamp dateFinTmp2 = new Timestamp(filtre.dateFin.getTimeInMillis());
                    pstm.setTimestamp(indexParam, dateFinTmp2);
                    ++indexParam;
                } else if (filtre.dateFin != null && filtre.dateDebut != null) {
                    filtre.dateDebut.set(11, 0);
                    filtre.dateDebut.set(12, 0);
                    filtre.dateDebut.set(13, 0);
                    dateDebutTmp = new Timestamp(filtre.dateDebut.getTimeInMillis());
                    filtre.dateFin.set(11, 23);
                    filtre.dateFin.set(12, 59);
                    filtre.dateFin.set(13, 59);
                    dateFinTmp = new Timestamp(filtre.dateFin.getTimeInMillis());
                    pstm.setTimestamp(indexParam, dateDebutTmp);
                    pstm.setTimestamp(++indexParam, dateFinTmp);
                    ++indexParam;
                }
            } else if (filtre.dateDebut != null && filtre.dateFin != null) {
                filtre.dateDebut.set(11, 0);
                filtre.dateDebut.set(12, 0);
                filtre.dateDebut.set(13, 0);
                dateDebutTmp = new Timestamp(filtre.dateDebut.getTimeInMillis());
                filtre.dateFin.set(11, 23);
                filtre.dateFin.set(12, 59);
                filtre.dateFin.set(13, 59);
                dateFinTmp = new Timestamp(filtre.dateFin.getTimeInMillis());
                pstm.setTimestamp(indexParam, dateDebutTmp);
                pstm.setTimestamp(++indexParam, dateFinTmp);
                ++indexParam;
            } else if (filtre.dateDebut != null) {
                filtre.dateDebut.set(11, 0);
                filtre.dateDebut.set(12, 0);
                filtre.dateDebut.set(13, 0);
                dateDebutTmp = new Timestamp(filtre.dateDebut.getTimeInMillis());
                filtre.dateDebut.set(11, 23);
                filtre.dateDebut.set(12, 59);
                filtre.dateDebut.set(13, 59);
                dateFinTmp = new Timestamp(filtre.dateDebut.getTimeInMillis());
                pstm.setTimestamp(indexParam, dateDebutTmp);
                pstm.setTimestamp(++indexParam, dateFinTmp);
                ++indexParam;
            } else if (filtre.dateFin != null) {
                filtre.dateFin.set(11, 0);
                filtre.dateFin.set(12, 0);
                filtre.dateFin.set(13, 0);
                dateDebutTmp = new Timestamp(filtre.dateFin.getTimeInMillis());
                filtre.dateFin.set(11, 23);
                filtre.dateFin.set(12, 59);
                filtre.dateFin.set(13, 59);
                dateFinTmp = new Timestamp(filtre.dateFin.getTimeInMillis());
                pstm.setTimestamp(indexParam, dateDebutTmp);
                pstm.setTimestamp(++indexParam, dateFinTmp);
                ++indexParam;
            }
            if (filtre.snm != null && filtre.erf != null) {
                pstm.setString(indexParam, filtre.snm);
                pstm.setString(++indexParam, filtre.erf);
                ++indexParam;
            } else {
                if (filtre.emetteur == null) {
                    if (filtre.delegation != null) {
                        pstm.setString(indexParam, filtre.delegation);
                        ++indexParam;
                    }
                    if (filtre.centre != null) {
                        pstm.setString(indexParam, filtre.centre);
                        ++indexParam;
                    }
                    if (filtre.profil != -1) {
                        pstm.setInt(indexParam, filtre.profil);
                        ++indexParam;
                    }
                }
                if (filtre.axe != null) {
                    pstm.setString(indexParam, filtre.axe);
                    ++indexParam;
                }
                if (filtre.mcig_id != null) {
                    pstm.setString(indexParam, filtre.mcig_id);
                    ++indexParam;
                }
            }
            Log.debug("getKeyMCIG : " + pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                keys.add(rs.getString("key"));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return keys;
    }

    @Override
    public Collection<MCIG> getMCIGFromRange(TableauBordFiltre filtre, int startIndex, int endIndex, List<String> keys) {
        Vector<MCIG> MCIGs;
        block26: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            MCIGs = new Vector<MCIG>();
            Vector<CommentaireMCIG> commentairesMCIG = new Vector<CommentaireMCIG>();
            if (keys.size() <= 0) break block26;
            String requeteCle = "";
            String cle = "";
            String requete = "";
            if (endIndex - startIndex > 1) {
                for (int index = startIndex; index < endIndex; ++index) {
                    requeteCle = requeteCle.equals("") ? requeteCle + "'" + keys.get(index) + "'" : requeteCle + ",'" + keys.get(index) + "'";
                }
                requeteCle = "ARRAY[" + requeteCle + "]";
            } else {
                cle = keys.get(startIndex);
            }
            requete = "SELECT c.sna as sna, c.nom as nom, a.com_mcig_id, a.mcig_id, a.PHR_COM_MCIG, to_char(a.date_heure_com,'dd/mm/yyyy hh24:mi:ss') as date_heure_com, b.type_Poste, a.id_evenement,(select p2.equipier from patrouille p2 where p2.mcig_id = a.mcig_id order by p2.debut desc limit 1)  FROM commentaire_mcig a, mcig b, utilisateur c";
            requete = requete + " WHERE c.id_utilisateur = b.id_utilisateur AND c.mse = ? AND b.mcig_id = a.mcig_id";
            if (filtre.delegation != null) {
                requete = requete + " AND c.delegation = ?";
            }
            if (filtre.centre != null) {
                requete = requete + " AND c.centre = ?";
            }
            if (filtre.axe != null) {
                requete = requete + " AND b.mcig_id IN (SELECT d.mcig_id FROM localisation d WHERE d.axe = ?)";
            }
            if (filtre.profil != -1) {
                requete = requete + " AND c.id_profil = ?";
            }
            requete = requeteCle.equals("") ? (filtre.emetteur != null || filtre.mcig_id != null ? requete + " AND a.mcig_id = '" + cle + "'" : (filtre.snm != null && filtre.erf != null ? requete + " AND CONCAT(a.snm,a.erf) = '" + cle + "'" : requete + " AND a.date_heure_com >= '" + cle + "' AND a.date_heure_com < (date '" + cle + "' + interval '1 day')")) : (filtre.emetteur != null ? requete + " AND a.mcig_id = ANY (" + requeteCle + ")" : requete + " AND to_char(a.date_heure_com,'dd/mm/yyyy') = ANY (" + requeteCle + ")");
            requete = requete + " AND a.niveau <= " + filtre.niveau;
            requete = requete + " ORDER BY a.date_heure_com";
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                int indexParam = 1;
                pstm.setString(indexParam, filtre.mse);
                ++indexParam;
                if (filtre.delegation != null) {
                    pstm.setString(indexParam, filtre.delegation);
                    ++indexParam;
                }
                if (filtre.centre != null) {
                    pstm.setString(indexParam, filtre.centre);
                    ++indexParam;
                }
                if (filtre.axe != null) {
                    pstm.setString(indexParam, filtre.axe);
                    ++indexParam;
                }
                if (filtre.profil != -1) {
                    pstm.setInt(indexParam, filtre.profil);
                    ++indexParam;
                }
                Log.debug("getMCIGFromRange : " + pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    MCIG unMcig;
                    boolean verification;
                    CommentaireMCIG commentaireMCIG = new CommentaireMCIG();
                    commentaireMCIG.setMcigId(rs.getString("mcig_id"));
                    commentaireMCIG.setIdTypePoste(rs.getInt("type_Poste"));
                    commentaireMCIG.setDateCom(rs.getString("date_heure_com").substring(0, 11));
                    commentaireMCIG.setHeureCom(rs.getString("date_heure_com").substring(11));
                    commentaireMCIG.setDateHeureCom(rs.getString("date_heure_com"));
                    commentaireMCIG.setPhrComMcig(rs.getString("PHR_COM_MCIG"));
                    commentaireMCIG.setSna(rs.getString("sna"));
                    commentaireMCIG.setNom(rs.getString("nom"));
                    commentaireMCIG.setEquipier(rs.getString("equipier"));
                    if (rs.getObject("id_evenement") != null) {
                        commentaireMCIG.setIdEvenement(rs.getLong("id_evenement"));
                    } else {
                        commentaireMCIG.setIdEvenement(-1L);
                    }
                    commentairesMCIG.add(commentaireMCIG);
                    if (filtre.snm != null && filtre.erf != null) {
                        verification = false;
                        verification = MCIGs.size() > 0;
                        if (verification) continue;
                        unMcig = new MCIG();
                        unMcig.setMcigId(rs.getString("mcig_id"));
                        unMcig.setTypePoste(rs.getInt("type_poste"));
                        unMcig.setDateHeureDeb(rs.getString("date_heure_com").substring(0, 11));
                        unMcig.setIdEvenement(filtre.snm + "_" + filtre.erf);
                        MCIGs.add(unMcig);
                        continue;
                    }
                    if (filtre.emetteur != null) {
                        verification = false;
                        for (MCIG mcig : MCIGs) {
                            if (!mcig.getMcigId().equals(rs.getString("mcig_id"))) continue;
                            verification = true;
                        }
                        if (verification) continue;
                        unMcig = new MCIG();
                        unMcig.setMcigId(rs.getString("mcig_id"));
                        unMcig.setTypePoste(rs.getInt("type_poste"));
                        unMcig.setDateHeureDeb(rs.getString("date_heure_com").substring(0, 11));
                        unMcig.setSna(rs.getString("sna"));
                        unMcig.setNom(rs.getString("nom"));
                        unMcig.setEquipier(rs.getString("equipier"));
                        MCIGs.add(unMcig);
                        continue;
                    }
                    verification = false;
                    for (MCIG mcig : MCIGs) {
                        if (!mcig.getDateHeureDeb().substring(0, 11).equals(rs.getString("date_heure_com").substring(0, 11))) continue;
                        verification = true;
                    }
                    if (verification) continue;
                    unMcig = new MCIG();
                    unMcig.setMcigId(rs.getString("mcig_id"));
                    unMcig.setTypePoste(rs.getInt("type_poste"));
                    unMcig.setDateHeureDeb(rs.getString("date_heure_com").substring(0, 11));
                    MCIGs.add(unMcig);
                }
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            for (MCIG mcig : MCIGs) {
                Vector<CommentaireMCIG> comListe = new Vector<CommentaireMCIG>();
                for (CommentaireMCIG com : commentairesMCIG) {
                    if (filtre.snm != null && filtre.erf != null) {
                        comListe.add(com);
                        continue;
                    }
                    if (filtre.emetteur != null) {
                        if (!mcig.getMcigId().equals(com.getMcigId())) continue;
                        comListe.add(com);
                        continue;
                    }
                    if (!mcig.getDateHeureDeb().substring(0, 11).equals(com.getDateHeureCom().substring(0, 11))) continue;
                    comListe.add(com);
                }
                mcig.setCommentaireMcig(comListe);
            }
        }
        return MCIGs;
    }

    @Override
    public MainCourante creerMainCouranteCentral(PrismCentralUser user) {
        return this.creerMainCourante(user, null, 2);
    }

    @Override
    public MainCourante creerMainCourante(PrismCentralUser user, MainCourante mc, int typeSupport) {
        block14: {
            block11: {
                block12: {
                    boolean nouvelle = true;
                    MainCourante mca = this.getMainCouranteActiveMemeJournee((IUtilisateur)user, System.currentTimeMillis(), typeSupport);
                    if (typeSupport == 2 && mc == null) {
                        if (mca == null) {
                            mc = MetierCommun.genereMainCourante((IUtilisateur)user);
                        } else {
                            mc = mca;
                            nouvelle = false;
                        }
                    }
                    if (!nouvelle) break block11;
                    if (mc == null) break block12;
                    Connection connection = null;
                    PreparedStatement pstm = null;
                    ResultSet rs = null;
                    try {
                        connection = this.daoFactory.getConnection();
                        pstm = connection.prepareStatement(REQUETE_INSERTION_MCIG);
                        pstm.setString(1, mc.getId());
                        pstm.setTimestamp(2, new Timestamp(mc.getDateDebut()));
                        pstm.setNull(3, 93);
                        pstm.setInt(4, 1);
                        pstm.setInt(5, user.getId());
                        pstm.setInt(6, 0);
                        pstm.setInt(7, 0);
                        pstm.setInt(8, typeSupport);
                        if (typeSupport == 1 || typeSupport == 3) {
                            pstm.setString(9, GLS.getString((String)mc.getImei()));
                            pstm.setString(10, GLS.getString((String)mc.getSim()));
                            pstm.setString(11, GLS.getString((String)mc.getTelephone()));
                            pstm.setString(12, mc.getAppVersion());
                        } else {
                            pstm.setNull(9, 12);
                            pstm.setNull(10, 12);
                            pstm.setNull(11, 12);
                            pstm.setNull(12, 12);
                        }
                        pstm.execute();
                    }
                    catch (SQLException e) {
                        try {
                            throw new DAOException(e);
                        }
                        catch (Throwable throwable) {
                            DAOUtil.close(connection, pstm, rs);
                            throw throwable;
                        }
                    }
                    DAOUtil.close(connection, pstm, rs);
                    if (mca == null) {
                        this.ajouterCommentaire(mc, McigDAOJDBC.genereCommentairePriseService(mc));
                    } else {
                        this.ajouterCommentaire(mc, McigDAOJDBC.genereCommentaireRepriseService(mc));
                    }
                    break block14;
                }
                Log.error("ERREUR mci nulle");
                break block14;
            }
            this.ajouterCommentaire(mc, McigDAOJDBC.genereCommentaireConnexion());
        }
        return mc;
    }

    private void cloreMainCourante(MainCourante mc) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_FERMER_MAIN_COURANTE);
            if (mc.getDateFin() != -1L) {
                pstm.setTimestamp(1, new Timestamp(mc.getDateFin()));
            } else {
                pstm.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            }
            pstm.setString(2, mc.getId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (this.vehiculeDAO != null) {
            this.vehiculeDAO.desactiverPosition(mc.getId());
        }
        this.cloreEvenementMission(mc);
    }

    @Override
    public List<ActionCentral> getActionsCentral(String mcigId) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<ActionCentral> liste = new ArrayList<ActionCentral>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("select * from prism.actioncentral where mcig_id = ?");
            pstm.setString(1, mcigId);
            rs = pstm.executeQuery();
            while (rs.next()) {
                ActionCentral ac = new ActionCentral();
                ac.setDebut(rs.getTimestamp("debut").getTime());
                if (rs.getObject("fin") != null) {
                    ac.setFin(rs.getTimestamp("fin").getTime());
                } else {
                    ac.setFin(-1L);
                }
                ac.setType(rs.getString("type"));
                ac.setSousType(rs.getString("soustype"));
                ac.setCommentaire(rs.getString("commentaire"));
                ac.setCodeEvenement(rs.getString("code_evenement"));
                liste.add(ac);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public void nouvelleAction(ActionCentral a) {
        String requete = "";
        requete = "insert into actioncentral (type,soustype,commentaire,mcig_id,debut,fin,code_evenement) values (?,?,?,?,?,?,?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, GLS.getString((String)a.getType()));
            pstm.setString(2, GLS.getString((String)a.getSousType()));
            pstm.setString(3, GLS.getString((String)a.getCommentaire()));
            pstm.setString(4, a.getMcig());
            pstm.setTimestamp(5, new Timestamp(a.getDebut()));
            if (a.getFin() <= 0L) {
                pstm.setNull(6, 93);
            } else {
                pstm.setTimestamp(6, new Timestamp(a.getFin()));
            }
            pstm.setString(7, GLS.getString((String)a.getCodeEvenement()));
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void modifierDateFinAction(ActionCentral a) {
        String requete = "";
        requete = "update actioncentral (fin) values (?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, GLS.getString((String)a.getType()));
            pstm.setString(2, GLS.getString((String)a.getSousType()));
            pstm.setString(3, GLS.getString((String)a.getCommentaire()));
            pstm.setString(4, a.getMcig());
            pstm.setTimestamp(5, new Timestamp(a.getDebut()));
            if (a.getFin() <= 0L) {
                pstm.setNull(6, 93);
            } else {
                pstm.setTimestamp(6, new Timestamp(a.getFin()));
            }
            pstm.setString(7, GLS.getString((String)a.getCodeEvenement()));
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private void cloreEvenementMission(MainCourante mc) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_FIN_EVENEMENT_MISSION_MCIG);
            pstm.setString(1, mc.getId());
            Log.debug("Suppression evenement evenements missions MCIG - " + pstm + " - " + mc.getId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public static Commentaire genereCommentaireRepriseService(MainCourante mc) {
        return MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.repriseService"), (long)mc.getDateDebut(), null, (int)-1);
    }

    public static Commentaire genereCommentairePriseService(MainCourante mc) {
        return MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.priseService"), (long)mc.getDateDebut(), null, (int)-1);
    }

    public static Commentaire genereCommentaireFinService(MainCourante mc) {
        return MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.finService"), (long)mc.getDateFin(), null, (int)-1);
    }

    public static Commentaire genereCommentaireConnexion() {
        return MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.connexion"), (long)System.currentTimeMillis(), null, (int)-1);
    }

    public static Commentaire genereCommentaireDeconnexion() {
        return MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.deconnexion"), (long)System.currentTimeMillis(), null, (int)-1);
    }

    public static Commentaire genereCommentaire(String commentaire) {
        return MetierCommun.genereCommentaire((String)commentaire, (long)System.currentTimeMillis(), null, (int)-1);
    }

    public static Commentaire genereCommentaireVisa(VehiculeEnIntervention v) {
        StringBuilder stringBuilder = new StringBuilder().append(PrismI18n.getString("commentaire.visa"));
        GLS.getDate();
        GLS.getDate();
        Calendar calendar = GLSDate.toDate((long)v.getDebutPatrouille());
        GLS.getDate();
        return MetierCommun.genereCommentaire((String)stringBuilder.append(GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour)).append(" - ").append(v.getChauffeur()).append(" (").append(v.getCode()).append(")").toString(), (long)System.currentTimeMillis(), null, (int)-1);
    }

    @Override
    public void ajouterCommentaire(MainCourante mc, Commentaire c) {
        this.ajouterCommentaireAvecType(mc, c);
    }

    private boolean estUtilisateurSysteme(String codeUtilisateur) {
        try {
            PrismCentralUser user = this.refDAO.getUtilisateur(codeUtilisateur);
            if (user != null) {
                return user.isSysteme();
            }
        }
        catch (Exception e) {
            Log.error("ERREUR RECUP USER SYSTEME", e);
        }
        return false;
    }

    private void ajouterCommentaireAvecType(MainCourante mc, Commentaire c) {
        block11: {
            block10: {
                Connection connection = null;
                PreparedStatement pstm = null;
                ResultSet rs = null;
                if (this.estUtilisateurSysteme(mc.getCodeUtilisateur())) break block10;
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(REQUETE_INSERTION_COMMENTAIRE);
                    pstm.setString(1, c.getId());
                    pstm.setString(2, Util.limiterTaille((String)c.getLibelle(), (int)2000));
                    pstm.setTimestamp(3, new Timestamp(c.getDate()));
                    pstm.setString(4, mc.getId());
                    if (c.getIdEvenement() <= 0L) {
                        pstm.setNull(5, -5);
                    } else {
                        pstm.setLong(5, c.getIdEvenement());
                    }
                    pstm.setInt(6, c.getNiveau());
                    pstm.setInt(7, c.getType());
                    if (!GLS.estVide((String)c.getSnm())) {
                        pstm.setString(8, c.getSnm());
                    } else {
                        pstm.setNull(8, 12);
                    }
                    if (!GLS.estVide((String)c.getErf())) {
                        pstm.setString(9, c.getErf());
                    } else {
                        pstm.setNull(9, 12);
                    }
                    pstm.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new DAOException(e);
                    }
                    catch (Throwable throwable) {
                        DAOUtil.close(connection, pstm, rs);
                        throw throwable;
                    }
                }
                DAOUtil.close(connection, pstm, rs);
                break block11;
            }
            Log.debug("Maincourante inactive pour les utilisateurs syst\u00e8me - " + (mc != null ? mc.getCodeUtilisateur() : "--"));
        }
    }

    private void ajouterCommentaireSansType(MainCourante mc, Commentaire c) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_INSERTION_COMMENTAIRE_SANS_TYPE);
            pstm.setString(1, c.getId());
            pstm.setString(2, Util.limiterTaille((String)c.getLibelle(), (int)2000));
            pstm.setTimestamp(3, new Timestamp(c.getDate()));
            pstm.setString(4, mc.getId());
            if (c.getIdEvenement() <= 0L) {
                pstm.setNull(5, -5);
            } else {
                pstm.setLong(5, c.getIdEvenement());
            }
            pstm.setInt(6, c.getNiveau());
            if (!GLS.estVide((String)c.getSnm())) {
                pstm.setString(7, c.getSnm());
            } else {
                pstm.setNull(7, 12);
            }
            if (!GLS.estVide((String)c.getErf())) {
                pstm.setString(8, c.getErf());
            } else {
                pstm.setNull(8, 12);
            }
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public List<Patrouille> getPatrouillesActivesObsoletes() throws Exception {
        long dureeMaxSuppressionPatrouille = this.refDAO.getConfiguration().getInt("dureeMaxSuppressionPatrouille", 1440);
        ArrayList<Patrouille> l = new ArrayList<Patrouille>();
        String requete = "";
        requete = "select p.id,p.mcig_id from patrouille p inner join mcig m on m.mcig_id = p.mcig_id where m.type_poste <> 2 and p.fin is null and p.debut + interval '" + dureeMaxSuppressionPatrouille + " minutes' < now()";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            rs = pstm.executeQuery();
            if (rs.first()) {
                do {
                    Patrouille p = new Patrouille();
                    p.setId(rs.getString("id"));
                    p.setMcig(rs.getString("mcig_id"));
                    l.add(p);
                } while (rs.next());
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return l;
    }

    public List<MainCourante> getMainCourantesActivesObsoletes() throws Exception {
        long dureeMaxSuppressionPatrouille = this.refDAO.getConfiguration().getInt("dureeMaxSuppressionPatrouille", 1440);
        ArrayList<MainCourante> l = new ArrayList<MainCourante>();
        String requete = "";
        requete = "select m.mcig_id from mcig m where m.date_heure_fin is null and ((type_poste in (0,2) and date_trunc('day',m.date_heure_deb) < date_trunc('day',now())) or (type_poste not in(0,2) and m.date_heure_deb + interval '" + dureeMaxSuppressionPatrouille + " minutes' < now())) ";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            rs = pstm.executeQuery();
            if (rs.first()) {
                do {
                    MainCourante m = new MainCourante();
                    m.setId(rs.getString("mcig_id"));
                    m.setDateFin(-1L);
                    l.add(m);
                } while (rs.next());
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return l;
    }

    public void terminerPatrouillesActivesObsoletes(List<Patrouille> patrouilles) {
        String requete = "";
        requete = "update patrouille set fin = ? where id = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            for (Patrouille p : patrouilles) {
                MainCourante m = new MainCourante();
                m.setId(p.getMcig());
                long d = this.getDateDernierCommentaire(p.getMcig(), 1);
                pstm.clearParameters();
                pstm.setTimestamp(1, new Timestamp(d));
                pstm.setString(2, p.getId());
                pstm.execute();
                this.ajouterCommentaire(m, MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.finPatrouilleAuto"), (long)d, null, (int)-1));
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void terminerMainCourantesActivesObsoletes(List<MainCourante> mainCourantes) {
        for (MainCourante m : mainCourantes) {
            long d = this.getDateDernierCommentaire(m.getId(), 1);
            Commentaire c = MetierCommun.genereCommentaire((String)PrismI18n.getString("commentaire.finServiceAuto"), (long)d, null, (int)-1);
            this.fermerMainCourante(m, c);
        }
    }

    private List<MainCourante> getMainCouranteActive(IUtilisateur u) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<MainCourante> listeMc = new ArrayList<MainCourante>();
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_MCIG_ACTIVE);
            pstm.setString(1, u.getCode());
            pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
            rs = pstm.executeQuery();
            while (rs.next()) {
                MainCourante m = new MainCourante();
                m.setId(rs.getString("mcig_id"));
                m.setDateDebut(rs.getTimestamp("date_heure_deb").getTime());
                m.setDateFin(-1L);
                m.setCodeUtilisateur(u.getCode());
                listeMc.add(m);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return listeMc;
    }

    private MainCourante getMainCouranteActiveMemeJournee(IUtilisateur u, long journee, int typeSupport) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        MainCourante m = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_MCIG_ACTIVE_MEME_JOURNEE, 1004, 1007);
            pstm.setString(1, u.getCode());
            pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
            pstm.setLong(3, journee);
            pstm.setInt(4, typeSupport);
            rs = pstm.executeQuery();
            if (rs.first()) {
                m = new MainCourante();
                m.setId(rs.getString("mcig_id"));
                m.setDateDebut(rs.getTimestamp("date_heure_deb").getTime());
                m.setDateFin(-1L);
                m.setCodeUtilisateur(u.getCode());
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return m;
    }

    @Override
    public boolean verificationMainCouranteEmbarque(PrismCentralUser user, MainCourante m) {
        return this.verificationMainCourante(user, m, 1);
    }

    @Override
    public boolean verificationMainCourante(PrismCentralUser user, MainCourante m, int typeSupport) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean mainCouranteExiste = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(REQUETE_MCIG_PAR_ID, 1004, 1007);
            pstm.setString(1, m.getId());
            rs = pstm.executeQuery();
            mainCouranteExiste = rs.first();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        if (!mainCouranteExiste) {
            this.creerMainCourante(user, m, 1);
        }
        return mainCouranteExiste;
    }

    public long getHistoriqueEvenement(Evenement evt) {
        String requete = "select * from prism.commentaire_mcig c inner join prism.patrouille p on c.mcig_id = p.mcig_id where c.mcig_id = ? and p.id = ? and c.date_heure_com between p.debut and p.fin and niveau = -1 order by date_heure_com";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        long dateDernierCommentaire = -1L;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, evt.getMainCourante().getId());
            pstm.setString(2, evt.getMainCourante().getIdPatrouille());
            rs = pstm.executeQuery();
            if (rs.first()) {
                dateDernierCommentaire = rs.getTimestamp(1).getTime();
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return dateDernierCommentaire;
    }

    @Override
    public long getDateDernierCommentaire(String mcig, int delta) {
        String requete = "select date_heure_com + interval '" + delta + " second' from prism.commentaire_mcig where mcig_id = ? order by date_heure_com desc limit 1";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        long dateDernierCommentaire = -1L;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, mcig);
            rs = pstm.executeQuery();
            if (rs.first()) {
                dateDernierCommentaire = rs.getTimestamp(1).getTime();
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return dateDernierCommentaire;
    }

    @Override
    public void fermerMainCourante(MainCourante mc) {
        this.fermerMainCourante(mc, McigDAOJDBC.genereCommentaireFinService(mc));
    }

    @Override
    public void fermerMainCourante(MainCourante mc, Commentaire c) {
        this.ajouterCommentaire(mc, c);
        this.cloreMainCourante(mc);
    }

    @Override
    public void deconnexion(MainCourante mc) {
        this.ajouterCommentaire(mc, McigDAOJDBC.genereCommentaireDeconnexion());
    }

    @Override
    public Rectangle2D[] getExtentMcig2(String mcigId) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block5: {
            Rectangle2D[] rectangle2DArray;
            String requete = "select st_box2d(ST_Transform(st_setsrid(st_expand(st_extent(coordonnees),1000),32630),4326)) as extent, st_expand(st_extent(coordonnees),1000) as extent30  from prism.localisation where mcig_id = ?";
            connection = null;
            pstm = null;
            rs = null;
            try {
                Polygon p;
                PGbox2d ext;
                Bounds b;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                pstm.setString(1, mcigId);
                rs = pstm.executeQuery();
                if (!rs.first()) break block5;
                Object obj = rs.getObject("extent30");
                Rectangle2D[] r = new Rectangle2D[2];
                if (obj != null && obj instanceof PGbox2d) {
                    b = new Bounds();
                    ext = (PGbox2d)obj;
                    p = new Polygon();
                    r[0] = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                    Log.debug(r[0].getHeight() + "," + r[0].getWidth());
                }
                if ((obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block5;
                b = new Bounds();
                ext = (PGbox2d)obj;
                p = new Polygon();
                r[1] = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                rectangle2DArray = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2DArray;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public Rectangle2D getExtentMcig(String mcigId) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Rectangle2D rectangle2D;
            String requete = "select st_expand(st_extent(coordonnees),1500) as extent from prism.localisation where mcig_id = ?";
            connection = null;
            pstm = null;
            rs = null;
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                pstm.setString(1, mcigId);
                rs = pstm.executeQuery();
                if (!rs.first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block4;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public void verifierPatrouilleEtMainCouranteObsoletes() {
        Log.info("V\u00e9rification des donn\u00e9es de main courantes obsol\u00e8tes");
        try {
            List<Patrouille> listePatrouille = this.getPatrouillesActivesObsoletes();
            if (!GLS.estVide(listePatrouille)) {
                this.terminerPatrouillesActivesObsoletes(listePatrouille);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
        try {
            List<MainCourante> listeMc = this.getMainCourantesActivesObsoletes();
            if (!GLS.estVide(listeMc)) {
                this.terminerMainCourantesActivesObsoletes(listeMc);
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
    }

    @Override
    public Rectangle2D getExtentMcig(List<String> mcigIds) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Rectangle2D rectangle2D;
            String requete = "select st_expand(st_extent(coordonnees),6000) as extent from prism.localisation where mcig_id IN ";
            String paramMcigIds = String.join((CharSequence)"','", mcigIds);
            requete = requete + "('" + paramMcigIds + "')";
            connection = null;
            pstm = null;
            rs = null;
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                rs = pstm.executeQuery();
                if (!rs.first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block4;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public String getMCIGFromPatrouille(String patrouilleId) {
        String requete = "select mcig_id from prism.patrouille where id=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String mcigId = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete, 1004, 1007);
            pstm.setString(1, patrouilleId);
            rs = pstm.executeQuery();
            if (rs.first()) {
                mcigId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return mcigId;
    }
}

