/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IconDAOJDBC
implements IIconDAO {
    public static final String NATURE_ICON_FORMAT = "gif";
    public static final String ICON_FORMAT = "gif";
    private static final String NATURE_DEFAULT_ICON = "default_icon.gif";
    private static final String VEHICULE_ICON_FORMAT = "png";
    private static final String MODULE_METIER_ICON_FORMAT = "jpg";
    private static final String VEHICULE_DEFAULT_ICON = "default.png";
    public static final String ITEMCOMBO_ICON_FORMAT = "png";
    private File repNatureHd = new File(ConfigurationFactory.getInstance().get("iconevt.hd"));
    private File repHd = new File(ConfigurationFactory.getInstance().get("iconevt.hd"));
    private File defaultIcon = new File(this.repNatureHd, "default_icon.gif");
    private File repModuleMetier;
    private File repVehicule;
    private File defaultVehiculeIcon;
    private File repComboIcon;

    public IconDAOJDBC(DAOFactory daoFactory) {
        if (!this.defaultIcon.exists()) {
            throw new PrismConfigurationError("L'icone par d\u00e9faut " + this.defaultIcon.getAbsolutePath() + " doit obligatoirement exister");
        }
        this.repModuleMetier = new File(ConfigurationFactory.getInstance().get("iconmm.dir"));
        this.repVehicule = new File(ConfigurationFactory.getInstance().get("iconvehicule.dir"));
        this.defaultVehiculeIcon = new File(this.repVehicule, VEHICULE_DEFAULT_ICON);
        if (!this.defaultVehiculeIcon.exists()) {
            throw new PrismConfigurationError("L'icone par d\u00e9faut " + this.defaultVehiculeIcon.getAbsolutePath() + " doit obligatoirement exister");
        }
        this.repComboIcon = new File(ConfigurationFactory.getInstance().get("iconcomboitem.dir"));
        if (!this.repComboIcon.isDirectory()) {
            throw new PrismConfigurationError("Le r\u00e9pertoire des images pour les combobox image (" + this.repComboIcon.getAbsolutePath() + ") doit obligatoirement exister");
        }
    }

    @Override
    public File getNatureIconHd(String code) {
        File f = new File(this.repNatureHd, code + "." + "gif");
        if (!f.exists()) {
            Log.warn("pas d'icone pour le type '" + code + "'");
            return this.defaultIcon;
        }
        return f;
    }

    @Override
    public File getIconHd(String code) {
        File f = new File(this.repHd, code + "." + "png");
        if (!f.exists()) {
            Log.warn("pas d'icone pour le type '" + code + "'");
            return this.defaultIcon;
        }
        return f;
    }

    @Override
    public File getModuleMetierIcon(String code) {
        File f = new File(this.repModuleMetier, code + "." + MODULE_METIER_ICON_FORMAT);
        if (!f.exists()) {
            Log.warn("pas d'icone pour le type '" + code + "'");
            return this.defaultIcon;
        }
        return f;
    }

    @Override
    public File getVehicleIcon(String code) {
        File f = new File(this.repVehicule, code + "." + "png");
        if (!f.exists()) {
            Log.warn("pas d'icone pour le code type vehicule '" + code + "'");
            return this.defaultVehiculeIcon;
        }
        return f;
    }

    public void ecrireImage(String nomChamp, List<String> imagesB64) {
        File champDir = new File(this.repComboIcon, nomChamp);
        boolean etat = champDir.mkdir();
    }

    @Override
    public List<String> getListeNomsImage(String nomChamp, String champAutre) {
        File champDir = new File(this.repComboIcon, nomChamp);
        List<String> nomFichiers = new ArrayList<String>();
        boolean aChampAutre = false;
        try {
            File[] fs;
            for (File f : fs = Fichier.getFichiers((String)champDir.getAbsolutePath())) {
                if (!GLS.egal((String)Fichier.getExtension((String)f.getPath()), (String)"png")) continue;
                String nomFichier = Fichier.getNom((File)f);
                if (!GLS.estVide((String)champAutre) && GLS.egal((String)nomFichier, (String)champAutre)) {
                    aChampAutre = true;
                    continue;
                }
                nomFichiers.add(nomFichier);
            }
            nomFichiers = MetierCommun.trier(nomFichiers);
            if (aChampAutre) {
                nomFichiers.add(champAutre);
            }
        }
        catch (Exception e) {
            Log.error("ERR GET LISTE NOM FICHIERS DYN " + nomChamp, e);
        }
        return nomFichiers;
    }

    @Override
    public File getImageComboItemIcon(String nom, String valeur) {
        File icon;
        File champDir = new File(this.repComboIcon, nom);
        if (!champDir.isDirectory()) {
            Log.error("Le r\u00e9pertoire image pour le champ n'existe pas : " + champDir.getAbsolutePath());
        }
        if (!(icon = new File(champDir, valeur + "." + "png")).isFile()) {
            Log.error("Icone introuvable : " + icon.getAbsolutePath());
            icon = new File(this.repComboIcon, NATURE_DEFAULT_ICON);
        }
        return icon;
    }

    @Override
    public Map<String, Map<String, byte[]>> getImagesComposantsChoixImage(List<NatureOuRaccourci> natures) {
        HashMap<String, Map<String, byte[]>> imagesComposantsImage = new HashMap<String, Map<String, byte[]>>();
        for (NatureOuRaccourci n : natures) {
            if (!(n instanceof Nature)) continue;
            for (Champ c : MetierCommun.getChamps((List)((Nature)n).getChamps()).values()) {
                ChampChoixImage champImage;
                if (!(c instanceof ChampChoixImage) && !(c instanceof ChampChoixImageMultiple)) continue;
                File champDir = new File(this.repComboIcon, c.getNom());
                if (!champDir.isDirectory()) {
                    throw new PrismConfigurationError("Le r\u00e9pertoire image pour le champ n'existe pas : " + champDir.getAbsolutePath());
                }
                if (imagesComposantsImage.containsKey(c.getNom())) continue;
                boolean dynamique = false;
                List listeImages = new ArrayList();
                if (c instanceof ChampChoixImage) {
                    champImage = (ChampChoixImage)c;
                    dynamique = champImage.estDynamique();
                    listeImages = champImage.getValeurs();
                } else if (c instanceof ChampChoixImageMultiple) {
                    champImage = (ChampChoixImageMultiple)c;
                    dynamique = champImage.estDynamique();
                    listeImages = champImage.getValeurs();
                }
                HashMap<String, byte[]> images = new HashMap<String, byte[]>();
                if (dynamique) {
                    for (File icon : champDir.listFiles()) {
                        GLS.getFichier();
                        if (!Fichier.getExtension((String)icon.getPath()).equals("png")) continue;
                        Path p = Paths.get(icon.getPath(), new String[0]);
                        try {
                            GLS.getFichier();
                            images.put(Fichier.getNom((File)icon), Files.readAllBytes(p));
                        }
                        catch (Exception e) {
                            throw new PrismConfigurationError("Erreur dans la r\u00e9cup\u00e9ration de l'ic\u00f4ne : " + icon.getAbsolutePath());
                        }
                    }
                } else {
                    for (String image : listeImages) {
                        File icon = new File(champDir, image + "." + "png");
                        if (!icon.isFile()) {
                            throw new PrismConfigurationError(c.getNom() + "Icone introuvable : " + icon.getAbsolutePath());
                        }
                        Path p = Paths.get(icon.getPath(), new String[0]);
                        try {
                            images.put(image, Files.readAllBytes(p));
                        }
                        catch (Exception e) {
                            throw new PrismConfigurationError("Erreur dans la r\u00e9cup\u00e9ration de l'ic\u00f4ne : " + icon.getAbsolutePath());
                        }
                    }
                }
                imagesComposantsImage.put(c.getNom(), images);
            }
        }
        return imagesComposantsImage;
    }
}

