/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ActionCentral;
import com.geolocsystems.prismandroid.model.ActivitePeriode;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDateHeure;
import com.geolocsystems.prismandroid.model.ig4.Agent;
import com.geolocsystems.prismandroid.model.ig4.Mission;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IIG4DAO;
import com.geolocsystems.prismcentral.DAO.IMcigDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.IVehiculeDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.ig4.UserExport;
import com.geolocsystems.prismcentral.beans.ig4.VehiculeExport;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.csv.CSVUtils;
import com.geolocsystems.prismcentral.service.SuiviActiviteCD22Service;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.Nombre;
import gls.outils.Util;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.MonFichier;
import java.io.File;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class IG4DAOJDBC
implements IIG4DAO {
    private DAOFactory daoFactory;
    private Map<String, String> corresCentres;
    private Map<String, String> corresModalites;
    private Map<String, String> corresDelegations;
    private Map<String, String> corresUtilisateurs;
    private Map<String, String> corresVehicules;
    private Map<String, String> corresMissions;
    private Map<String, String> corresPref;
    private Map<String, String> corresUtilisateursService;
    private Map<String, String> corresVehiculesService;
    private Map<String, Centre> corresDelegationCentre;
    private Map<String, List<String>> corresModalitesCentre;
    private Map<String, String> corresRythmes;
    private Map<String, String> corresRythmesSynchro;
    private Map<String, String> corresCategorie;
    private Map<String, String> corresTrafic;
    private Map<String, Map<String, String>> correspondances = null;
    private IAdminDAO adminDAO;
    private IReferentielDAO refDAO;
    private IUserDAO userDAO;
    private Map<String, Map<?, ?>> mapIG4;
    private IEvenementsDAO evtDAO;
    private IMcigDAO mciDAO;
    private IVehiculeDAO vehDAO;
    private static final String CHAMP_TYPE_RD = "typeRD";
    private static final String TYPE_RD_BIDI = "Bidirectionnelle";
    private static final String TYPE_RD_2X2 = "2x2 voies";
    private static final String TYPE_RD_ROCADE = "Rocade";
    private static final String CODE_PRISM = "id_prism";
    private static final String CODE_PRISM_CENTRE = "id_prism_centre";
    private static final String CODE_PRISM_DELEGATION = "id_prism_delegation";
    private static final String CODE_IG4 = "id_ig4";
    private static final String CODE_SERVICE_IG4 = "id_service";
    private static final String SQL_MISSIONS_LONGUEUR = "select round(st_length(st_makeline(gps.coordonnees))) as longueur from (select coordonnees from prism.localisation l where l.id_patrouille = ? order by date_heure_loc asc) as gps";
    private static final String SQL_MISSIONS_QUANTITE = "select sum((largeur * longueur * salage) / 1000) as quantite_sel from vh.evenement_vh where id_patrouille = ? and largeur > 0 and longueur > 0 and salage > 0;";
    private static final String SQL_MISSIONS = "select u.centre,u.sna,p.type,p.debut,p.fin,u.id_utilisateur,u.sna,p.code_vehicule as vehicule,p.id,p.equipier from (prism.patrouille p inner join prism.mcig m on m.mcig_id = p.mcig_id) inner join prism.utilisateur u on m.id_utilisateur = u.id_utilisateur where not fin is null and fin between TIMESTAMP 'yesterday' and TIMESTAMP 'today' ";
    private static final String SQL_MISSIONS_V2 = "select u.centre,u.sna,p.parametres, p.type,p.debut,p.fin,u.id_utilisateur,u.sna,p.code_vehicule as vehicule,p.id,p.equipier from (prism.patrouille p inner join prism.mcig m on m.mcig_id = p.mcig_id) inner join prism.utilisateur u on m.id_utilisateur = u.id_utilisateur where not fin is null and fin between ? and ? ";
    private static final String SQL_MISSIONS_CENTRAL = "select u.centre,u.sna,m.date_heure_deb,m.date_heure_fin,u.id_utilisateur,u.sna,m.mcig_id from prism.mcig m inner join prism.utilisateur u on m.id_utilisateur = u.id_utilisateur where not date_heure_deb is null and date_heure_deb between ? and ? and u.id_profil in (select p.id from profil p where p.nom = any(?)) ";
    private static final String SQL_CORRES_CENTRES = "select id_prism,id_ig4 from ig4.corres_centres";
    private static final String SQL_CORRES_DELEGATIONS_CENTRES = "select id_prism_centre,id_prism_delegation,id_ig4 from ig4.corres_centres";
    private static final String SQL_CORRES_DELEGATIONS = "select id_prism,id_ig4 from ig4.corres_delegations";
    private static final String SQL_CORRES_UTILISATEURS = "select id_prism,id_ig4,id_service from ig4.corres_utilisateurs";
    private static final String SQL_CORRES_VEHICULES = "select id_prism,id_ig4,id_service from ig4.corres_vehicules";
    private static final String SQL_CORRES_MISSIONS = "select id_prism,id_ig4 from ig4.corres_missions";
    private static final String SQL_CORRES_PREF = "select id_prism,id_ig4 from ig4.corres_pref";
    private static final String SQL_CORRES_CATEGORIE = "select id_prism,id_ig4 from ig4.corres_categorie";
    private static final String SQL_CORRES_TRAFIC = "select id_prism,id_ig4 from ig4.corres_trafic";
    private static final String SQL_CORRES_MODALITES = "select code,libelle,centre from ig4.modalite";
    private static final String SQL_CORRES_RYTHMES = "select code,libelle from ig4.rythme";
    private static final String SQL_CORRESPONDANCES = "select cle, id_prism,id_import from ig4.correspondances";
    private static final String FICHIER_IMPORT_UTILISATEUR = "export_agent_m2m.csv";
    private static final String FICHIER_IMPORT_MATERIEL = "export_materiel_m2m.csv";
    private static final String CODE_IMPORT = "id_import";
    private static final String CLE = "cle";
    private static final String CODE_NATURE_ACTIVITE = "natureActivite";
    private static final String INSERT_UTILISATEUR = "insert into prism.utilisateur (nom,sna,delegation,centre,id_profil,mse,type,synchrodate,password,type_utilisateur,id_district,code_mode_vh,archive,id_utilisateur) values (?,?,?,?,(select p.id from prism.profil p where lower(nom)=lower(?) limit 1),?,1,now(),?,2,0,1,0,nextval('k_userid'));";
    private static final String MODIFIER_UTILISATEUR = "update prism.utilisateur set nom = ?,delegation = ?,centre = ?,id_profil = (select p.id from prism.profil p where lower(p.nom)=lower(?)),archive = 0,synchrodate = now() where sna=?;";
    private static final String INSERT_NIVEAU_EXPLOITATION = "INSERT INTO donnees_metier.niveau_exploitation(description, departementprdebut, axe, coordonnees, abscisseprdebut,prdebut, id, departementprfin, longueur, prfin, abscisseprfin,niveau,delegation,centre) VALUES (?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?,?,?,?);";

    public IG4DAOJDBC(DAOFactory daoFactory, IAdminDAO adminDAO, IReferentielDAO refDAO, IUserDAO userDAO, IEvenementsDAO evtDAO, IMcigDAO mciDAO, IVehiculeDAO vehDAO) {
        this.daoFactory = daoFactory;
        this.adminDAO = adminDAO;
        this.refDAO = refDAO;
        this.userDAO = userDAO;
        this.evtDAO = evtDAO;
        this.mciDAO = mciDAO;
        this.vehDAO = vehDAO;
        this.init();
    }

    private void init() {
        this.corresCentres = null;
        this.corresDelegations = null;
        this.corresUtilisateurs = null;
        this.corresVehicules = null;
        this.corresMissions = null;
        this.corresPref = null;
        this.corresVehiculesService = null;
        this.corresUtilisateursService = null;
        this.corresModalites = null;
        this.corresModalitesCentre = null;
        this.corresRythmes = null;
        this.corresRythmesSynchro = null;
        this.corresCategorie = null;
        this.corresTrafic = null;
        this.correspondances = null;
        this.remplirCorrespondances();
        this.mapIG4 = null;
        this.mapIG4 = new HashMap();
        this.mapIG4.put("ig4.modalites", this.corresModalitesCentre);
        this.mapIG4.put("ig4.rythmes", this.corresRythmesSynchro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondancesGenerales() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_CORRESPONDANCES);
            rs = pstm.executeQuery();
            while (rs.next()) {
                String cle = rs.getString(CLE);
                Map<String, String> corresCle = this.correspondances.get(cle);
                if (corresCle == null) {
                    corresCle = new HashMap<String, String>();
                    this.correspondances.put(cle, corresCle);
                }
                corresCle.put(rs.getString(CODE_IMPORT), rs.getString(CODE_PRISM));
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public boolean exportation(List<Partenaire> partenairesATraiter) {
        if (!GLS.estVide(partenairesATraiter)) {
            List<Mission> missions = this.getMissionsJourPrecedent();
            if (!GLS.estVide(missions)) {
                for (Partenaire partenaire : partenairesATraiter) {
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement en cours");
                    if (!new File(partenaire.getCheminServeur()).exists()) {
                        new File(partenaire.getCheminServeur()).mkdirs();
                    }
                    Fichier.effacerFichiers((String)partenaire.getCheminServeur());
                    if (!new File(partenaire.getRepArchivage()).exists()) {
                        new File(partenaire.getRepArchivage()).mkdirs();
                    }
                    String csv = CSVUtils.genereCSV(missions);
                    String nomFichier = Util.getFilePattern((String)partenaire.getPatternFichier(), (String)"", (String)"", (String)"", (int)0);
                    MonFichier f = new MonFichier(partenaire.getCheminServeur() + nomFichier, 1);
                    try {
                        f.ecrire(csv);
                        f.fermer();
                    }
                    catch (Exception e) {
                        Log.error("erreur ecriture fichier ", e);
                    }
                    f = new MonFichier(partenaire.getRepArchivage() + nomFichier, 1);
                    try {
                        f.ecrire(csv);
                        f.fermer();
                    }
                    catch (Exception e) {
                        Log.error("erreur ecriture fichier archivage ", e);
                    }
                    Log.debug("[" + partenaire.getLibelle() + "]Traitement export IG4 termin\u00e9");
                }
            } else {
                Log.info("aucune mission \u00e0 exporter ");
            }
        }
        return true;
    }

    public void remplirCorrespondances() {
        if (this.corresCentres == null) {
            this.corresCentres = new HashMap<String, String>();
            this.corresDelegations = new HashMap<String, String>();
            this.corresDelegationCentre = new HashMap<String, Centre>();
            this.corresUtilisateurs = new HashMap<String, String>();
            this.corresVehicules = new HashMap<String, String>();
            this.corresMissions = new HashMap<String, String>();
            this.corresPref = new HashMap<String, String>();
            this.corresVehiculesService = new HashMap<String, String>();
            this.corresUtilisateursService = new HashMap<String, String>();
            this.corresModalitesCentre = new HashMap<String, List<String>>();
            this.corresModalites = new HashMap<String, String>();
            this.corresRythmes = new TreeMap<String, String>();
            this.corresRythmesSynchro = new TreeMap<String, String>();
            this.corresCategorie = new HashMap<String, String>();
            this.corresTrafic = new HashMap<String, String>();
            this.correspondances = new HashMap<String, Map<String, String>>();
            this.remplirCorrespondanceDelegationsCentre(SQL_CORRES_DELEGATIONS_CENTRES, this.corresDelegationCentre, this.corresCentres);
            this.remplirCorrespondance(SQL_CORRES_DELEGATIONS, this.corresDelegations);
            this.remplirCorrespondanceAvecService(SQL_CORRES_UTILISATEURS, this.corresUtilisateurs, this.corresUtilisateursService);
            this.remplirCorrespondanceAvecService(SQL_CORRES_VEHICULES, this.corresVehicules, this.corresVehiculesService);
            this.remplirCorrespondance(SQL_CORRES_MISSIONS, this.corresMissions);
            this.remplirCorrespondance(SQL_CORRES_PREF, this.corresPref);
            this.remplirCorrespondance(SQL_CORRES_CATEGORIE, this.corresCategorie);
            this.remplirCorrespondance(SQL_CORRES_TRAFIC, this.corresTrafic);
            this.remplirCorrespondanceModalites();
            this.remplirCorrespondanceRythmes();
            this.remplirCorrespondancesGenerales();
        }
    }

    public Map<String, Map<?, ?>> getIG4Configuration() {
        if (this.mapIG4 == null) {
            this.init();
        }
        return this.mapIG4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondanceRythmes() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_CORRES_RYTHMES);
            rs = pstm.executeQuery();
            while (rs.next()) {
                this.corresRythmesSynchro.put(rs.getString("code"), rs.getString("libelle"));
                this.corresRythmes.put(rs.getString("libelle"), rs.getString("code"));
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondance(String req, Map<String, String> corres) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                corres.put(rs.getString(CODE_PRISM), rs.getString(CODE_IG4));
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondanceModalites() {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block7: {
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CORRES_MODALITES);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String code = rs.getString("code");
                    String centreIg4 = rs.getString("centre");
                    String centre = centreIg4 != null ? this.corresDelegationCentre.get(centreIg4).getNom() : "*";
                    String libelle = rs.getString("libelle");
                    this.corresModalites.put(libelle, code);
                    if (!this.corresModalitesCentre.containsKey(centre)) {
                        this.corresModalitesCentre.put(centre, new ArrayList());
                    }
                    this.corresModalitesCentre.get(centre).add(libelle);
                }
                List<String> modalitesCommunes = this.corresModalitesCentre.get("*");
                if (GLS.estVide(modalitesCommunes)) break block7;
                for (String k : this.corresModalitesCentre.keySet()) {
                    if (GLS.egal((String)k, (String)"*")) continue;
                    this.corresModalitesCentre.get(k).addAll(0, modalitesCommunes);
                }
            }
            catch (Exception e) {
                try {
                    Log.error("", e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondanceAvecService(String req, Map<String, String> corres, Map<String, String> corresService) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                corres.put(rs.getString(CODE_PRISM), rs.getString(CODE_IG4));
                corresService.put(rs.getString(CODE_IG4), rs.getString(CODE_SERVICE_IG4));
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remplirCorrespondanceDelegationsCentre(String req, Map<String, Centre> corres, Map<String, String> corresCentre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(req);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Centre c = new Centre();
                c.setNom(rs.getString(CODE_PRISM_CENTRE));
                c.setDelegation(rs.getString(CODE_PRISM_DELEGATION));
                corres.put(rs.getString(CODE_IG4), c);
                corresCentre.put(c.getNom(), rs.getString(CODE_IG4));
            }
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mission> getMissionsJourPrecedent() {
        ArrayList<Mission> missions = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_MISSIONS);
            rs = pstm.executeQuery();
            missions = new ArrayList<Mission>();
            while (rs.next()) {
                try {
                    Mission m = new Mission();
                    m.setId(rs.getString("id"));
                    m.setCodeAgent(this.corresUtilisateurs.get(rs.getString("sna")));
                    String serviceIg4 = null;
                    if (m.getCodeAgent() != null) {
                        serviceIg4 = this.corresUtilisateursService.get(m.getCodeAgent());
                    }
                    if (GLS.estVide(serviceIg4)) {
                        m.setCentre(this.corresCentres.get(rs.getString("centre")));
                    } else {
                        m.setCentre(serviceIg4);
                    }
                    m.setCodeMateriel(this.corresVehicules.get(rs.getString("vehicule")));
                    m.setCodeMission(this.corresMissions.get(GLS.getString((Object)rs.getInt("type"))));
                    String eq = rs.getString("equipier");
                    List<String> codesEquipiers = this.getCodesEquipiers(eq, rs.getString("centre"));
                    if (!GLS.estVide(codesEquipiers)) {
                        m.setCodeAgent2(this.corresUtilisateurs.get(codesEquipiers.get(0)));
                        if (codesEquipiers.size() > 1) {
                            m.setCodeAgent3(this.corresUtilisateurs.get(codesEquipiers.get(1)));
                        }
                    }
                    Timestamp deb = rs.getTimestamp("debut");
                    GLS.getDate();
                    Calendar c = GLSDate.toDate((long)deb.getTime());
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    Timestamp fin = rs.getTimestamp("fin");
                    long dureeTache = fin.getTime() - deb.getTime();
                    if (dureeTache > 60000L) {
                        GLS.getDate();
                        c = GLSDate.toDate((long)(fin.getTime() - 60000L));
                    } else {
                        GLS.getDate();
                        c = GLSDate.toDate((long)fin.getTime());
                    }
                    int dureeTacheMinute = (int)dureeTache / 60000;
                    int hours = (int)Math.floor(dureeTacheMinute / 60);
                    int minutes = dureeTacheMinute % 60;
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    m.setDureeTache(String.valueOf(hours).concat(":").concat(String.valueOf(minutes)));
                    if (rs.getInt("type") == 1000) {
                        m.setQuantiteOeuvre(String.valueOf(this.calculQuantiteSel(rs.getString("id"))));
                    } else {
                        m.setQuantiteOeuvre("");
                    }
                    GLS.getNombre();
                    m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(this.calculLongueurMission(rs.getString("id")) / 1000.0f), (int)3)));
                    missions.add(m);
                }
                catch (Exception e) {
                    Log.error("erreur conversion mission", e);
                }
            }
        }
        catch (Exception e) {
            try {
                Log.error("erreur conversion missions", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return missions;
    }

    public List<ActionCentral> getActionsEvenements(List<ActionCentral> actions, Evenement e) {
        ArrayList<ActionCentral> actionsEvenements = new ArrayList<ActionCentral>();
        for (ActionCentral a : actions) {
            if (!GLS.egal((String)a.getCodeEvenement(), (String)e.getCodeEvenement())) continue;
            actionsEvenements.add(a);
        }
        return actionsEvenements;
    }

    public List<ActionCentral> getActionsSansEvenementHorsActivite(List<ActionCentral> actions) {
        ArrayList<ActionCentral> actionsEvenements = new ArrayList<ActionCentral>();
        for (ActionCentral a : actions) {
            if (!GLS.estVide((String)a.getCodeEvenement()) || GLS.egal((String)a.getType(), (String)"D\u00e9but d'activit\u00e9") || GLS.egal((String)a.getType(), (String)"Fin d'activit\u00e9")) continue;
            actionsEvenements.add(a);
        }
        return actionsEvenements;
    }

    public ActionCentral getActionsDebutActiviteMin(List<ActionCentral> actions, String activite) {
        ActionCentral minDebutActivite = null;
        for (ActionCentral a : actions) {
            if (!GLS.estVide((String)a.getCodeEvenement()) || !GLS.egal((String)a.getType(), (String)"D\u00e9but d'activit\u00e9") || !GLS.egal((String)a.getSousType(), (String)activite) || minDebutActivite != null && minDebutActivite.getDebut() >= a.getDebut()) continue;
            minDebutActivite = a;
        }
        return minDebutActivite;
    }

    public ActionCentral getActionsFinActiviteMax(List<ActionCentral> actions, String activite) {
        ActionCentral maxFinActivite = null;
        for (ActionCentral a : actions) {
            if (!GLS.estVide((String)a.getCodeEvenement()) || !GLS.egal((String)a.getType(), (String)"Fin d'activit\u00e9") || !GLS.egal((String)a.getSousType(), (String)activite) || maxFinActivite != null && maxFinActivite.getDebut() <= a.getDebut()) continue;
            maxFinActivite = a;
        }
        return maxFinActivite;
    }

    private void recalculFinActivite(ActionCentral actionPrincipale, List<ActionCentral> actionsEvenements) {
        if (!GLS.estVide(actionsEvenements)) {
            for (ActionCentral a : actionsEvenements) {
                long hFin = SuiviActiviteCD22Service.getHeureFinRecalculee(a);
                if (hFin <= actionPrincipale.getFin()) continue;
                actionPrincipale.setFin(hFin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mission> getMissionsCentral(String[] profils, Date dateDeb, Date dateFin) {
        ArrayList<Mission> missions = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_MISSIONS_CENTRAL);
            pstm.setTimestamp(1, new Timestamp(dateDeb.getTime()));
            pstm.setTimestamp(2, new Timestamp(dateFin.getTime()));
            pstm.setArray(3, connection.createArrayOf("text", profils));
            Log.debug(pstm.toString());
            rs = pstm.executeQuery();
            missions = new ArrayList<Mission>();
            while (rs.next()) {
                int minutes;
                int hours;
                int dureeTacheMinute;
                long dureeTache;
                Calendar c;
                String serviceIg4;
                Mission m;
                Situation s2;
                IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.byMcigId((String)rs.getString("mcig_id"));
                f.initCodeMm(5);
                List<Situation> sit = this.evtDAO.getEvenements(f, null);
                List<ActionCentral> actionsCentral = this.mciDAO.getActionsCentral(rs.getString("mcig_id"));
                ArrayList<ActionCentral> actionsCentralEvenement = new ArrayList<ActionCentral>();
                if (!GLS.estVide(sit)) {
                    try {
                        for (Situation s2 : sit) {
                            for (Evenement e : s2.getEvenements()) {
                                ValeurChamp dateDebutActivite = MetierCommun.getValeurChamp((Evenement)e, (String)"dateAppel");
                                ValeurChamp dateFinActivite = MetierCommun.getValeurChamp((Evenement)e, (String)"dateFinActivite");
                                Calendar calDebut = null;
                                Calendar calFin = null;
                                if (dateDebutActivite != null && dateDebutActivite instanceof ValeurChampDateHeure) {
                                    calDebut = MetierCommun.getCalendrier((ValeurChampDateHeure)((ValeurChampDateHeure)dateDebutActivite));
                                }
                                if (dateFinActivite != null && dateFinActivite instanceof ValeurChampDateHeure && MetierCommun.estDateRemplie((ValeurChampDateHeure)((ValeurChampDateHeure)dateFinActivite))) {
                                    calFin = MetierCommun.getCalendrier((ValeurChampDateHeure)((ValeurChampDateHeure)dateFinActivite));
                                }
                                ActionCentral ac = new ActionCentral();
                                ac.setDebut(calDebut.getTimeInMillis());
                                if (calFin != null) {
                                    ac.setFin(calFin.getTimeInMillis());
                                } else {
                                    ac.setFin(-1L);
                                }
                                ac.setCodeEvenement(e.getCodeEvenement());
                                if (ac.getFin() == -1L || SuiviActiviteCD22Service.estHorsHeureNormaleService(ac.getDebut()) || SuiviActiviteCD22Service.estHorsHeureNormaleService(ac.getFin())) {
                                    ac.setFin(SuiviActiviteCD22Service.getHeureFinRecalculee(ac.getDebut(), ac.getFin()));
                                    this.recalculFinActivite(ac, this.getActionsEvenements(actionsCentral, e));
                                }
                                actionsCentralEvenement.add(ac);
                                Mission m2 = new Mission();
                                m2.setCodeAgent(this.corresUtilisateurs.get(rs.getString("sna")));
                                String serviceIg42 = null;
                                if (m2.getCodeAgent() != null) {
                                    serviceIg42 = this.corresUtilisateursService.get(m2.getCodeAgent());
                                }
                                if (GLS.estVide(serviceIg42)) {
                                    m2.setCentre(this.corresCentres.get(rs.getString("centre")));
                                } else {
                                    m2.setCentre(serviceIg42);
                                }
                                m2.setCodeEvenement(e.getCodeEvenement());
                                try {
                                    m2.setCategorieRoute(this.corresCategorie.get(e.getValeurNature().getLocalisation().getCategorie()));
                                }
                                catch (Exception ex) {
                                    m2.setCategorieRoute("");
                                }
                                try {
                                    m2.setTraficRoute(this.corresTrafic.get(e.getValeurNature().getLocalisation().getTrafic()));
                                }
                                catch (Exception ex) {
                                    m2.setTraficRoute("");
                                }
                                GLS.getDate();
                                Calendar c2 = GLSDate.toDate((long)ac.getDebut());
                                GLS.getDate();
                                GLS.getDate();
                                m2.setDateDebut(GLSDate.toDate((Calendar)c2, (DateFormat)GLSDate.formatDateJour));
                                GLS.getDate();
                                GLS.getDate();
                                m2.setHeureDebut(GLSDate.toDate((Calendar)c2, (DateFormat)GLSDate.formatHeure));
                                long dureeTache2 = ac.getFin() - ac.getDebut();
                                GLS.getDate();
                                c2 = GLSDate.toDate((long)ac.getFin());
                                int dureeTacheMinute2 = (int)dureeTache2 / 60000;
                                int hours2 = (int)Math.floor(dureeTacheMinute2 / 60);
                                int minutes2 = dureeTacheMinute2 % 60;
                                GLS.getDate();
                                GLS.getDate();
                                m2.setDateFin(GLSDate.toDate((Calendar)c2, (DateFormat)GLSDate.formatDateJour));
                                GLS.getDate();
                                GLS.getDate();
                                m2.setHeureFin(GLSDate.toDate((Calendar)c2, (DateFormat)GLSDate.formatHeure));
                                m2.setDureeTache(String.valueOf(hours2).concat(":").concat(String.valueOf(minutes2)));
                                m2.setCodeMission("");
                                m2.setType(5);
                                m2.setQuantiteOeuvre("");
                                m2.setKmsParcourus("0");
                                m2.setSupport(2);
                                missions.add(m2);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error("erreur conversion missions evenement", e);
                    }
                }
                List<ActionCentral> autresActions = this.getActionsSansEvenementHorsActivite(actionsCentral);
                s2 = autresActions.iterator();
                while (s2.hasNext()) {
                    ActionCentral ac = (ActionCentral)s2.next();
                    m = new Mission();
                    m.setCodeAgent(this.corresUtilisateurs.get(rs.getString("sna")));
                    serviceIg4 = null;
                    if (m.getCodeAgent() != null) {
                        serviceIg4 = this.corresUtilisateursService.get(m.getCodeAgent());
                    }
                    if (GLS.estVide(serviceIg4)) {
                        m.setCentre(this.corresCentres.get(rs.getString("centre")));
                    } else {
                        m.setCentre(serviceIg4);
                    }
                    m.setCodeEvenement("");
                    if (SuiviActiviteCD22Service.estHorsHeureNormaleService(ac.getDebut()) || SuiviActiviteCD22Service.estHorsHeureNormaleService(ac.getFin())) {
                        ac.setFin(SuiviActiviteCD22Service.getHeureFinRecalculee(ac.getDebut(), ac.getFin()));
                    }
                    GLS.getDate();
                    c = GLSDate.toDate((long)ac.getDebut());
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    dureeTache = ac.getFin() - ac.getDebut();
                    GLS.getDate();
                    c = GLSDate.toDate((long)ac.getFin());
                    dureeTacheMinute = (int)dureeTache / 60000;
                    hours = (int)Math.floor(dureeTacheMinute / 60);
                    minutes = dureeTacheMinute % 60;
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    m.setDureeTache(String.valueOf(hours).concat(":").concat(String.valueOf(minutes)));
                    m.setType(5);
                    m.setQuantiteOeuvre("");
                    m.setKmsParcourus("0");
                    m.setSupport(2);
                    missions.add(m);
                }
                ActionCentral actionDebutActivite = this.getActionsDebutActiviteMin(actionsCentral, "VH");
                ActionCentral actionFinActivite = this.getActionsFinActiviteMax(actionsCentral, "VH");
                if (actionDebutActivite == null || actionFinActivite == null || actionFinActivite.getDebut() <= actionDebutActivite.getDebut()) continue;
                actionDebutActivite.setFin(actionFinActivite.getDebut());
                m = new Mission();
                m.setCodeAgent(this.corresUtilisateurs.get(rs.getString("sna")));
                serviceIg4 = null;
                if (m.getCodeAgent() != null) {
                    serviceIg4 = this.corresUtilisateursService.get(m.getCodeAgent());
                }
                if (GLS.estVide((String)serviceIg4)) {
                    m.setCentre(this.corresCentres.get(rs.getString("centre")));
                } else {
                    m.setCentre(serviceIg4);
                }
                m.setCodeEvenement("");
                GLS.getDate();
                c = GLSDate.toDate((long)actionDebutActivite.getDebut());
                GLS.getDate();
                GLS.getDate();
                m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                GLS.getDate();
                GLS.getDate();
                m.setHeureDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                dureeTache = actionDebutActivite.getFin() - actionDebutActivite.getDebut();
                GLS.getDate();
                c = GLSDate.toDate((long)actionDebutActivite.getFin());
                dureeTacheMinute = (int)dureeTache / 60000;
                hours = (int)Math.floor(dureeTacheMinute / 60);
                minutes = dureeTacheMinute % 60;
                GLS.getDate();
                GLS.getDate();
                m.setDateFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                GLS.getDate();
                GLS.getDate();
                m.setHeureFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                m.setDureeTache(String.valueOf(hours).concat(":").concat(String.valueOf(minutes)));
                m.setType(1);
                m.setQuantiteOeuvre("");
                m.setKmsParcourus("0");
                m.setSupport(2);
                missions.add(m);
            }
        }
        catch (Exception e) {
            try {
                Log.error("erreur conversion missions evenement 2", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return missions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mission> getMissionsPrism(Date dateDeb, Date dateFin, int codeMm) {
        ArrayList<Mission> missions = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        SimpleDateFormat sdfHDBHRB = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        String requete = SQL_MISSIONS_V2;
        if (codeMm != -1) {
            requete = requete + " and p.type = ?";
        }
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, new Timestamp(dateDeb.getTime()));
            pstm.setTimestamp(2, new Timestamp(dateFin.getTime()));
            if (codeMm != -1) {
                pstm.setInt(3, codeMm);
            }
            Log.debug(pstm.toString());
            rs = pstm.executeQuery();
            missions = new ArrayList<Mission>();
            MapDescription parametres = null;
            boolean erreurParametres = true;
            while (rs.next()) {
                parametres = null;
                try {
                    Array array = rs.getArray("parametres");
                    if (array != null) {
                        parametres = MapDescription.newMap();
                        parametres.add(MapDescription.parse((String[])((String[])array.getArray())));
                    }
                }
                catch (Exception e) {
                    if (erreurParametres) {
                        Log.error("pas de champ parametres", e);
                    } else {
                        erreurParametres = false;
                    }
                    parametres = null;
                }
                try {
                    Mission m = new Mission();
                    m.setParametres(parametres);
                    m.setId(rs.getString("id"));
                    m.setCodeAgent(rs.getString("sna"));
                    m.setCentre(rs.getString("centre"));
                    m.setCodeMateriel(rs.getString("vehicule"));
                    m.setCodeMission(this.refDAO.getModulesMetiers().get(rs.getInt("type")).getNom());
                    String eq = rs.getString("equipier");
                    List<String> codesEquipiers = this.getCodesEquipiers(eq, rs.getString("centre"));
                    if (!GLS.estVide(codesEquipiers)) {
                        m.setCodeAgent2(codesEquipiers.get(0));
                        if (codesEquipiers.size() > 1) {
                            m.setCodeAgent3(codesEquipiers.get(1));
                        }
                    }
                    Timestamp deb = rs.getTimestamp("debut");
                    Timestamp fin = rs.getTimestamp("fin");
                    if (parametres != null) {
                        Evenement evt;
                        m.setAgents(this.getAgentsPrismFromParametres(parametres));
                        String erf = parametres.getString("codeEvenement", "");
                        if (!GLS.estVide((String)erf) && (evt = this.evtDAO.getDernierEvenementActif(null, erf)) != null) {
                            m.setCodeEvenement(evt.getCodeEvenement());
                            m.setCategorieRoute("");
                            m.setTraficRoute("");
                        }
                    }
                    GLS.getDate();
                    Calendar c = GLSDate.toDate((long)deb.getTime());
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    long dureeTache = fin.getTime() - deb.getTime();
                    if (dureeTache > 60000L) {
                        GLS.getDate();
                        c = GLSDate.toDate((long)(fin.getTime() - 60000L));
                    } else {
                        GLS.getDate();
                        c = GLSDate.toDate((long)fin.getTime());
                    }
                    int dureeTacheMinute = (int)dureeTache / 60000;
                    int hours = (int)Math.floor(dureeTacheMinute / 60);
                    int minutes = dureeTacheMinute % 60;
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    Nombre.instanceOf();
                    String string = Nombre.getNombre((int)hours, (int)2, (int)2, (int)0, (int)0).concat(":");
                    Nombre.instanceOf();
                    m.setDureeTache(string.concat(Nombre.getNombre((int)(minutes - 1), (int)2, (int)2, (int)0, (int)0)));
                    m.setType(rs.getInt("type"));
                    if (rs.getInt("type") == 1000) {
                        m.setQuantiteOeuvre(String.valueOf(this.calculQuantiteSel(rs.getString("id"))));
                    } else {
                        m.setQuantiteOeuvre("");
                    }
                    float longueurMission = this.calculLongueurMission(rs.getString("id"));
                    if (longueurMission > 500.0f) {
                        GLS.getNombre();
                        m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(longueurMission / 1000.0f), (int)0)));
                    } else {
                        m.setKmsParcourus("0");
                    }
                    missions.add(m);
                }
                catch (Exception e) {
                    Log.error("erreur conversion mission", e);
                }
            }
        }
        catch (Exception e) {
            try {
                Log.error("erreur conversion missions", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return missions;
    }

    public String getCorresInversee(String valeur, Map<String, String> map, String defaut) throws Exception {
        if (map.containsValue(valeur)) {
            for (String k : map.keySet()) {
                if (!map.get(k).equals(valeur)) continue;
                return k;
            }
        }
        return defaut;
    }

    public String getNatureActivite(String codeNature, String defaut) {
        if (this.correspondances.containsKey(CODE_NATURE_ACTIVITE)) {
            try {
                return this.getCorresInversee(codeNature, this.correspondances.get(CODE_NATURE_ACTIVITE), defaut);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mission> getMissionsV2(Date dateDeb, Date dateFin) {
        ArrayList<Mission> missions = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        SimpleDateFormat sdfHDBHRB = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(SQL_MISSIONS_V2);
            pstm.setTimestamp(1, new Timestamp(dateDeb.getTime()));
            pstm.setTimestamp(2, new Timestamp(dateFin.getTime()));
            Log.debug(pstm.toString());
            rs = pstm.executeQuery();
            missions = new ArrayList<Mission>();
            MapDescription parametres = null;
            boolean erreurParametres = true;
            while (rs.next()) {
                parametres = null;
                try {
                    Array array = rs.getArray("parametres");
                    if (array != null) {
                        parametres = MapDescription.newMap();
                        parametres.add(MapDescription.parse((String[])((String[])array.getArray())));
                    }
                }
                catch (Exception e) {
                    if (erreurParametres) {
                        Log.error("pas de champ parametres", e);
                    } else {
                        erreurParametres = false;
                    }
                    parametres = null;
                }
                try {
                    Mission m = new Mission();
                    m.setId(rs.getString("id"));
                    m.setCodeAgent(this.corresUtilisateurs.get(rs.getString("sna")));
                    String serviceIg4 = null;
                    if (m.getCodeAgent() != null) {
                        serviceIg4 = this.corresUtilisateursService.get(m.getCodeAgent());
                    }
                    if (GLS.estVide(serviceIg4)) {
                        m.setCentre(this.corresCentres.get(rs.getString("centre")));
                    } else {
                        m.setCentre(serviceIg4);
                    }
                    m.setCodeMateriel(this.corresVehicules.get(rs.getString("vehicule")));
                    m.setCodeMission(this.corresMissions.get(GLS.getString((Object)rs.getInt("type"))));
                    String eq = rs.getString("equipier");
                    List<String> codesEquipiers = this.getCodesEquipiers(eq, rs.getString("centre"));
                    if (!GLS.estVide(codesEquipiers)) {
                        m.setCodeAgent2(this.corresUtilisateurs.get(codesEquipiers.get(0)));
                        if (codesEquipiers.size() > 1) {
                            m.setCodeAgent3(this.corresUtilisateurs.get(codesEquipiers.get(1)));
                        }
                    }
                    m.setActivitesPeriode(this.vehDAO.getActivitesPatrouille(m.getId()));
                    if (!GLS.estVide((List)m.getActivitesPeriode())) {
                        for (ActivitePeriode act : m.getActivitesPeriode()) {
                            String natureActivite = this.getNatureActivite(act.getCode(), act.getCode());
                            Log.debug("NATURE ACTIVITES -- " + natureActivite + " -- " + act.getCode());
                            act.setCode(natureActivite);
                        }
                    }
                    Timestamp deb = rs.getTimestamp("debut");
                    Timestamp fin = rs.getTimestamp("fin");
                    if (parametres != null) {
                        Evenement evt;
                        ArrayList<String> autresVehicule = null;
                        if (parametres != null) {
                            autresVehicule = new ArrayList<String>();
                            for (String vehicule : MetierCommun.getChampsAutresVehicule((Map)parametres.getMap())) {
                                autresVehicule.add(this.corresVehicules.get(vehicule));
                            }
                        }
                        m.setAutresVehicules(autresVehicule);
                        m.setAgents(this.getAgentsFromParametres(parametres));
                        String erf = parametres.getString("codeEvenement", "");
                        if (!GLS.estVide((String)erf) && (evt = this.evtDAO.getDernierEvenementActifAvecRecalculTerritoire(erf)) != null) {
                            m.setCentre(this.corresCentres.get(evt.getCei()));
                            m.setCodeEvenement(evt.getCodeEvenement());
                            m.setNatureEvenement(evt.getValeurNature().getCode());
                            m.setNatureActivite(this.getNatureActivite(evt.getValeurNature().getCode(), ""));
                            try {
                                m.setCategorieRoute(this.corresCategorie.get(evt.getValeurNature().getLocalisation().getCategorie()));
                            }
                            catch (Exception e) {
                                m.setCategorieRoute("");
                            }
                            ValeurChamp v = MetierCommun.getValeurChamp((Evenement)evt, (String)CHAMP_TYPE_RD);
                            if (v != null && v instanceof ValeurChampCollectionChoixUnique) {
                                String typeRD = ((ValeurChampCollectionChoixUnique)v).getValeur();
                                if (GLS.egal((String)typeRD, (String)TYPE_RD_BIDI)) {
                                    m.setTraficRoute("111");
                                } else if (GLS.egal((String)typeRD, (String)TYPE_RD_2X2)) {
                                    m.setTraficRoute("110");
                                } else if (GLS.egal((String)typeRD, (String)TYPE_RD_ROCADE)) {
                                    m.setTraficRoute("112");
                                } else {
                                    try {
                                        m.setTraficRoute(this.corresTrafic.get(evt.getValeurNature().getLocalisation().getTrafic()));
                                    }
                                    catch (Exception e) {
                                        m.setTraficRoute("");
                                    }
                                }
                            } else {
                                try {
                                    m.setTraficRoute(this.corresTrafic.get(evt.getValeurNature().getLocalisation().getTrafic()));
                                }
                                catch (Exception e) {
                                    m.setTraficRoute("");
                                }
                            }
                        }
                    }
                    GLS.getDate();
                    Calendar c = GLSDate.toDate((long)deb.getTime());
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureDebut(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    long dureeTache = fin.getTime() - deb.getTime();
                    GLS.getDate();
                    c = GLSDate.toDate((long)fin.getTime());
                    int dureeTacheMinute = (int)dureeTache / 60000;
                    int hours = (int)Math.floor(dureeTacheMinute / 60);
                    int minutes = dureeTacheMinute % 60;
                    GLS.getDate();
                    GLS.getDate();
                    m.setDateFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatDateJour));
                    GLS.getDate();
                    GLS.getDate();
                    m.setHeureFin(GLSDate.toDate((Calendar)c, (DateFormat)GLSDate.formatHeure));
                    m.setDureeTache(String.valueOf(hours).concat(":").concat(String.valueOf(minutes)));
                    m.setType(rs.getInt("type"));
                    if (rs.getInt("type") == 1000) {
                        m.setQuantiteOeuvre(String.valueOf(this.calculQuantiteSel(rs.getString("id"))));
                    } else {
                        m.setQuantiteOeuvre("");
                    }
                    float longueurMission = this.calculLongueurMission(rs.getString("id"));
                    if (longueurMission > 500.0f) {
                        GLS.getNombre();
                        m.setKmsParcourus(String.valueOf(Nombre.getNombre((double)(longueurMission / 1000.0f), (int)1)));
                    } else {
                        m.setKmsParcourus("0");
                    }
                    m.setParametres(parametres);
                    missions.add(m);
                }
                catch (Exception e) {
                    Log.error("erreur conversion mission", e);
                }
            }
        }
        catch (Exception e) {
            try {
                Log.error("erreur conversion missions", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return missions;
    }

    public List<Agent> getAgentsFromParametres(MapDescription parametres) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        if (parametres != null) {
            boolean fin = false;
            int i = 1;
            while (!fin) {
                String champNom = MetierCommun.getChampAgentIntervention((int)i, (String)"nom");
                if (parametres.containsKey(champNom)) {
                    Agent agent = new Agent();
                    agent.setNom(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"nom"), ""));
                    String codeUtilisateurPrism = MetierCommun.getCodeUtilisateurFromLibelle((String)agent.getNom());
                    PrismCentralUser u = this.refDAO.getUtilisateur(codeUtilisateurPrism);
                    if (u != null) {
                        Log.debug("Utilisateur trouve - " + u.toString());
                        agent.setCentre(this.corresCentres.get(u.getCentre()));
                    } else {
                        Log.debug("Utilisateur null - " + codeUtilisateurPrism);
                        agent.setCentre(null);
                    }
                    agent.setCode(this.corresUtilisateurs.get(codeUtilisateurPrism));
                    agent.setArriveeSite(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateArriveeSite"), ""));
                    agent.setDepartSite(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateDepartSite"), ""));
                    agent.setDepartBase(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateDeclenchementIntervention"), ""));
                    agent.setRetourBase(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateFinIntervention"), ""));
                    agent.setModalite(this.corresModalites.get(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"modalite"), "")));
                    agent.setRythme(this.corresRythmes.get(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"rythme"), "")));
                    agents.add(agent);
                } else {
                    fin = true;
                }
                ++i;
            }
        }
        return agents;
    }

    public List<Agent> getAgentsPrismFromParametres(MapDescription parametres) {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        if (parametres != null) {
            boolean fin = false;
            int i = 1;
            while (!fin) {
                String champNom = MetierCommun.getChampAgentIntervention((int)i, (String)"nom");
                if (parametres.containsKey(champNom)) {
                    Agent agent = new Agent();
                    agent.setNom(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"nom"), ""));
                    agent.setCode(MetierCommun.getCodeUtilisateurFromLibelle((String)agent.getNom()));
                    agent.setArriveeSite(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateArriveeSite"), ""));
                    agent.setDepartSite(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateDepartSite"), ""));
                    agent.setDepartBase(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateDeclenchementIntervention"), ""));
                    agent.setRetourBase(parametres.getString(MetierCommun.getChampAgentIntervention((int)i, (String)"dateFinIntervention"), ""));
                    agent.setModalite("");
                    agent.setRythme("");
                    agents.add(agent);
                } else {
                    fin = true;
                }
                ++i;
            }
        }
        return agents;
    }

    private Utilisateur getUtilisateurParNom(String nom, String centre, List<Utilisateur> l) {
        if (!GLS.estVide((String)nom) && !GLS.estVide(l)) {
            for (Utilisateur u : l) {
                if (!GLS.egal((String)nom.trim(), (String)u.getNom().trim())) continue;
                return u;
            }
        }
        return null;
    }

    private List<String> getCodesEquipiers(String libellesEquipiers, String centre) {
        ArrayList<String> codeEquipiers = new ArrayList<String>();
        List<Utilisateur> l = this.userDAO.rechercheToutUtilisateurEmbarque();
        if (!GLS.estVide((String)libellesEquipiers)) {
            String[] splitEquipiers;
            for (String libelleEquipier : splitEquipiers = libellesEquipiers.split(",")) {
                Utilisateur u = this.getUtilisateurParNom(libelleEquipier, centre, l);
                if (u == null) continue;
                codeEquipiers.add(u.getCode());
            }
        }
        return codeEquipiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calculLongueurMission(String idPatrouille) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            float f;
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MISSIONS_LONGUEUR);
                pstm.setString(1, idPatrouille);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                f = rs.getFloat("longueur");
            }
            catch (Exception e) {
                try {
                    Log.error("", e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
            DAOUtil.close(connection, pstm, rs);
            return f;
        }
        DAOUtil.close(connection, pstm, rs);
        return -1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float calculQuantiteSel(String idPatrouille) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            float f;
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MISSIONS_QUANTITE);
                pstm.setString(1, idPatrouille);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                f = rs.getFloat("quantite_sel");
            }
            catch (Exception e) {
                try {
                    Log.error("", e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
            DAOUtil.close(connection, pstm, rs);
            return f;
        }
        DAOUtil.close(connection, pstm, rs);
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEtatImportation(PrismCentralUser u) {
        int n;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            block7: {
                connection = null;
                pstm = null;
                rs = null;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select u.nom,u.centre,u.delegation,u.archive,p.nom as nom_profil from utilisateur u inner join profil p on u.id_profil = p.id where u.sna = ?");
                pstm.setString(1, u.getCode());
                rs = pstm.executeQuery();
                Log.debug("Etat importation - " + u.getCode() + " - " + pstm.toString());
                if (!rs.next()) break block6;
                if (GLS.egal((String)u.getNom(), (String)rs.getString("nom")) && GLS.egal((String)u.getCentre(), (String)rs.getString("centre")) && GLS.egal((String)u.getDelegation(), (String)rs.getString("delegation")) && GLS.egal((Object)u.getProfil(), (Object)rs.getString("nom_profil")) && u.isArchive() == GLS.getBoolean((int)rs.getInt("archive"), (boolean)false)) break block7;
                int n2 = 1;
                DAOUtil.close(connection, pstm, rs);
                return n2;
            }
            int n3 = 2;
            DAOUtil.close(connection, pstm, rs);
            return n3;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            int n4;
            try {
                Log.error("", e);
                n4 = 2;
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
            return n4;
        }
        DAOUtil.close(connection, pstm, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEtatImportation(Vehicule v) {
        int n;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            block7: {
                connection = null;
                pstm = null;
                rs = null;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select code,centre,delegation,immatriculation,id_marque_vehicule,archive from vehicule where code = ?");
                pstm.setString(1, v.getCode());
                rs = pstm.executeQuery();
                if (!rs.next()) break block6;
                if (GLS.egal((String)v.getImmatriculation(), (String)rs.getString("immatriculation")) && GLS.egal((String)v.getCentre(), (String)rs.getString("centre")) && GLS.egal((String)v.getDelegation(), (String)rs.getString("delegation")) && v.getType() == rs.getInt("id_marque_vehicule") && v.isArchive() == rs.getBoolean("archive")) break block7;
                int n2 = 1;
                DAOUtil.close(connection, pstm, rs);
                return n2;
            }
            int n3 = 2;
            DAOUtil.close(connection, pstm, rs);
            return n3;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            int n4;
            try {
                Log.error("", e);
                n4 = 2;
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
            return n4;
        }
        DAOUtil.close(connection, pstm, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterCorrespondance(String type, String idPrism, String idIg4, String idService) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("insert into " + type + " (id_prism, id_ig4,id_service) values (?,?,?)");
            pstm.setString(1, idPrism);
            pstm.setString(2, idIg4);
            pstm.setString(3, idService);
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondances(String type) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("delete from " + type);
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void supprimerCorrespondance(String type, String idIg4) {
        this.supprimerCorrespondance(type, idIg4, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimerCorrespondance(String type, String idIg4, String where) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("delete from " + type + " where id_ig4 = ? " + GLS.getString((String)where, (String)""));
            pstm.setString(1, idIg4);
            pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    public void archive() {
        this.archiveUtilisateurs();
        this.archiveVehicules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean archiveUtilisateurs() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean changement = false;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("update prism.utilisateur set archive = 1 where archive = 0 and type_utilisateur = 2 and sna not in (select id_prism from ig4.corres_utilisateurs)");
            changement = pstm.execute();
        }
        catch (Exception e) {
            try {
                Log.error("", e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        DAOUtil.close(connection, pstm, rs);
        return changement;
    }

    @Override
    public boolean archiveVehicules() {
        return this.archiveVehicules(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean archiveVehicules(boolean avecMarques) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        boolean changement = false;
        try {
            connection = this.daoFactory.getConnection();
            StringBuffer sb = new StringBuffer();
            sb.append("update prism.vehicule set archive = 'true' where archive = 'false' ");
            if (avecMarques) {
                sb.append("and id_marque_vehicule in (select m.id from prism.marque_vehicule m where m.code_type_vehicule <> 0) ");
            }
            sb.append("and code not in (select id_prism from ig4.corres_vehicules)");
            pstm = connection.prepareStatement(sb.toString());
            changement = pstm.execute();
            DAOUtil.close(connection, pstm, rs);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        return changement;
    }

    @Override
    public void modiferVehicule(VehiculeExport v) {
        this.adminDAO.updateVehicule(v);
    }

    @Override
    public void verifierMarqueVehicule(String[] ligne) throws Exception {
        if (!this.adminDAO.marqueVehiculeExiste(ligne[4])) {
            throw new Exception("ERREUR VEHICULE NON IMPORTE - LA MARQUE " + ligne[4] + " N'EXISTE PAS");
        }
    }

    @Override
    public void ajouterVehicule(VehiculeExport v) {
        this.adminDAO.creerVehicule(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ajouterUtilisateur(UserExport u, String password, String zoneRoutiere) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(INSERT_UTILISATEUR);
            pstm.setString(1, u.getNom());
            pstm.setString(2, u.getCode());
            if (!GLS.estVide((String)u.getCentre())) {
                pstm.setString(4, u.getCentre());
            } else {
                pstm.setNull(4, 12);
            }
            if (!GLS.estVide((String)u.getDelegation())) {
                pstm.setString(3, u.getDelegation());
            } else {
                pstm.setNull(3, 12);
            }
            pstm.setString(5, u.getProfil().getName());
            pstm.setString(6, zoneRoutiere);
            pstm.setString(7, password);
            try {
                pstm.execute();
            }
            catch (Exception e) {
                Log.debug(pstm.toString());
                Log.error(" - Erreur importation utilisateur".concat(u.getCode()), e);
            }
            pstm.clearParameters();
        }
        catch (Exception e) {
            try {
                Log.error(" - Erreur globale importation utilisateur".concat(u.getCode()), e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, null);
        }
        DAOUtil.close(connection, pstm, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modiferUtilisateur(UserExport u) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(MODIFIER_UTILISATEUR);
            pstm.setString(1, u.getNom());
            pstm.setString(2, u.getDelegation());
            pstm.setString(3, u.getCentre());
            pstm.setString(4, u.getProfil().getName());
            pstm.setString(5, u.getCode());
            try {
                pstm.execute();
            }
            catch (Exception e) {
                Log.error(" - Erreur mise a jour utilisateur".concat(u.getCode()), e);
            }
            pstm.clearParameters();
        }
        catch (Exception e) {
            try {
                Log.error(" - Erreur mise a jour utilisateur".concat(u.getCode()), e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, null);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, null);
        }
        DAOUtil.close(connection, pstm, null);
    }

    public Map<String, List<String>> getModalitesCentre() {
        return this.corresModalitesCentre;
    }

    public Map<String, String> getModalites() {
        return this.corresModalites;
    }

    public Map<String, String> getRythmes() {
        return this.corresRythmes;
    }

    @Override
    public Map<String, String> getCorresCentres() {
        return this.corresCentres;
    }

    @Override
    public Map<String, String> getCorresDelegations() {
        return this.corresDelegations;
    }

    @Override
    public Map<String, String> getCorresUtilisateurs() {
        return this.corresUtilisateurs;
    }

    @Override
    public Map<String, String> getCorresVehicules() {
        return this.corresVehicules;
    }

    @Override
    public Map<String, String> getCorresMissions() {
        return this.corresMissions;
    }

    @Override
    public Map<String, String> getCorresPref() {
        return this.corresPref;
    }

    @Override
    public Map<String, Map<String, String>> getCorresDynamiques() {
        return this.correspondances;
    }

    @Override
    public Map<String, Centre> getCorresDelegationsCentre() {
        return this.corresDelegationCentre;
    }
}

