/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismandroid.model.Point;
import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IFauchageDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.sql.SQL;
import java.awt.geom.Point2D;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.postgis.PGgeometry;

public class FauchageDAOJDBC
implements IFauchageDAO {
    private static final String REQUETE_FAUCHAGE_PAR_DELEGATION_CENTRE = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (delegation = ? or delegation is null) and (centre =? or centre is null) and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_FAUCHAGE_PAR_DELEGATION = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (delegation = ? or delegation is null) and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_FAUCHAGE = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_DEBROUSSAILLAGE_PAR_DATE = "select axedeb,prdeb,communedeb,axefin,prfin,communefin,senspr,code_releve,mcig_id,l4,l20,den,arb,clo,voie,znc,zad,zd,date,st_transform(lateralize_line(coordonnees, (CASE l20 WHEN 'oui' THEN 15 ELSE 10 END), 1),4326) as coordonnees,longueur from fauchage.debroussaillage where date is null or date between ? and ? order by date";
    private static final String REQUETE_INSERTION_DEBROUSSAILLAGE = null;
    private DAOFactory daoFactory;

    public FauchageDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TronconFauchage> getTronconFauchage(Delegation delegation, Centre centre, Calendar dateDebut, Calendar dateFin) {
        ArrayList<TronconFauchage> troncons = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = delegation == null && centre == null ? REQUETE_FAUCHAGE : (centre == null ? REQUETE_FAUCHAGE_PAR_DELEGATION : REQUETE_FAUCHAGE_PAR_DELEGATION_CENTRE);
            pstm = connection.prepareStatement(requete);
            pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
            if (delegation == null && centre == null) {
                pstm.setDate(2, new Date(dateFin.getTimeInMillis()));
                pstm.setDate(3, new Date(dateDebut.getTimeInMillis()));
                pstm.setDate(4, new Date(dateFin.getTimeInMillis()));
            } else if (centre == null) {
                pstm.setString(2, delegation.getNom());
                pstm.setDate(3, new Date(dateFin.getTimeInMillis()));
                pstm.setDate(4, new Date(dateDebut.getTimeInMillis()));
                pstm.setDate(5, new Date(dateFin.getTimeInMillis()));
            } else {
                pstm.setString(2, delegation.getNom());
                pstm.setString(3, centre.getNom());
                pstm.setDate(4, new Date(dateFin.getTimeInMillis()));
                pstm.setDate(5, new Date(dateDebut.getTimeInMillis()));
                pstm.setDate(6, new Date(dateFin.getTimeInMillis()));
            }
            Log.debug("[FAUCHAGE] Requete fauchage " + pstm.toString());
            rs = pstm.executeQuery();
            troncons = new ArrayList<TronconFauchage>();
            while (rs.next()) {
                TronconFauchage t = new TronconFauchage();
                t.setAbscissePrDebut(rs.getInt("abs_pr_deb"));
                t.setPrDebut(rs.getInt("pr_debut"));
                t.setAbscissePrFin(rs.getInt("abs_pr_fin"));
                t.setPrFin(rs.getInt("pr_fin"));
                t.setAxe(rs.getString("axe"));
                t.setCentre(rs.getString("centre"));
                t.setDelegation(rs.getString("delegation"));
                GLS.getDate();
                t.setPremiereDatePassage(GLSDate.toDate((long)rs.getDate("premiere_date_passage").getTime()));
                if (rs.getObject("derniere_date_passage") != null) {
                    GLS.getDate();
                    t.setDerniereDatePassage(GLSDate.toDate((long)rs.getDate("derniere_date_passage").getTime()));
                } else {
                    t.setDerniereDatePassage(null);
                }
                t.setAnnee(rs.getInt("annee"));
                t.setLongueur(rs.getInt("longueur"));
                t.setId(rs.getString("id_troncon"));
                t.setNbPassage(rs.getInt("nb_passage"));
                try {
                    float[][] coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                    if (coordonnees != null) {
                        t.setX(coordonnees[0]);
                        t.setY(coordonnees[1]);
                    } else {
                        t.setX(null);
                        t.setY(null);
                    }
                }
                catch (Exception e) {
                    t.setX(null);
                    t.setY(null);
                    Log.error("", e);
                }
                troncons.add(t);
            }
            DAOUtil.close(connection, pstm, rs);
            return troncons;
        }
        catch (SQLException e) {
            throw new DAOException(e);
            catch (Exception e2) {
                Log.error("", e2);
                return troncons;
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TronconFauchage> getTronconDebroussaillage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Releve> getReleveDebroussaillage(Calendar dateDebut, Calendar dateFin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void insertionReleveDebroussaillage(DonneesSynchro d, Releve r) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String projection = ConfigurationFactory.getInstance().get("bdd.projection");
        try {
            String requete = "insert into fauchage.debroussaillage (axedeb,prdeb,communedeb,axefin,prfin,communefin,l4,l20,den,arb,clo,voie,znc,zad,zd,mcig_id,coordonnees,date,longueur) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?)";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            List l = MetierCommun.estDebroussaillageVD((String)r.getVoie()) ? d.getVh().getPositions() : MetierCommun.inverser((List)d.getVh().getPositions());
            float[][] f = MetierCommun.toFloat((List)l);
            pstm.setString(1, r.getAxeDebut());
            pstm.setString(2, r.getPrDebut());
            pstm.setString(3, r.getCommuneDebut());
            pstm.setString(4, r.getAxeFin());
            pstm.setString(5, r.getPrFin());
            pstm.setString(6, r.getCommuneFin());
            pstm.setString(7, r.getLargeur4m());
            pstm.setString(8, r.getLargeur20m());
            pstm.setString(9, r.getDense());
            pstm.setString(10, r.getArbre());
            pstm.setString(11, r.getCloture());
            pstm.setString(12, r.getVoie());
            pstm.setString(13, r.getZnc());
            pstm.setString(14, r.getZad());
            pstm.setString(15, r.getZd());
            pstm.setString(16, d.getMainCourrante().getId());
            pstm.setString(17, SQL.getGeometryLineUTM((float[])f[0], (float[])f[1]));
            pstm.setTimestamp(18, new Timestamp(d.getDate()));
            pstm.setInt(19, Geometry.calculerLongueurLL((float[])f[0], (float[])f[1]));
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<SyntheseTableauBordStatistiqueFauchageBean> getFauchageStatistiqueSchema(List<Centre> centres, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours, String axe, boolean dateDernierPassageConnue) {
        ArrayList<SyntheseTableauBordStatistiqueFauchageBean> retour = new ArrayList<SyntheseTableauBordStatistiqueFauchageBean>();
        List<Troncon> troncons = null;
        java.util.Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, java.util.Date> mapDerniereDatePAssage = new HashMap<String, java.util.Date>();
        HashMap<String, Integer> mapDistanceCumulee = new HashMap<String, Integer>();
        troncons = this.getTronconsFromSchemaFauchage(centres, axe, false);
        this.getStatFauchageTronconTempsReel(centres, axe, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, dateFin, dateDernierPassageConnue, mapDistanceCumulee);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueFauchageBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), -1, (String[])mapPatrouillesId.get(troncon.getId()), (java.util.Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), null, null, troncon.getCircuit(), troncon.getClassification(), troncon.getLongueur(), ((Integer)mapDistanceCumulee.get(troncon.getId())).intValue()));
        }
        return retour;
    }

    private List<Troncon> getTronconsFromSchemaFauchage(List<Centre> centres, String axe, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            String conditionWhere = "";
            String nomCentreSqlIn = "";
            if (centres != null && centres.size() > 0) {
                for (Centre centre : centres) {
                    nomCentreSqlIn = nomCentreSqlIn + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                }
                conditionWhere = "WHERE centre IN (" + nomCentreSqlIn + ")";
            }
            String axeWhere = "";
            if (axe != null && !"".equals(axe)) {
                axeWhere = "axe = '" + axe + "'";
                conditionWhere = conditionWhere + (conditionWhere.equals("") ? " WHERE " : " AND ") + axeWhere;
            }
            String sql = "SELECT * FROM fauchage.schema_fauchage " + conditionWhere;
            pstm = connection.prepareStatement(sql);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Troncon troncon = new Troncon();
                troncon.setId(rs.getString("oid"));
                troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                troncon.setAxe(rs.getString("axe"));
                troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                troncon.setPrDebut(rs.getInt("plod"));
                troncon.setPrFin(rs.getInt("plof"));
                troncon.setAbscissePrDebut(rs.getInt("absd"));
                troncon.setAbscissePrFin(rs.getInt("absf"));
                troncon.setCircuit(rs.getString("centre"));
                troncon.setClassification(rs.getString("niveau_exploitation"));
                try {
                    troncon.setLongueur(rs.getInt("longueur"));
                }
                catch (Exception e) {
                    troncon.setLongueur(-1);
                }
                if (avecGeometry) {
                    try {
                        float[][] coordonnees = null;
                        coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                        if (coordonnees != null) {
                            troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                            troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                            troncon.setX(coordonnees[0]);
                            troncon.setY(coordonnees[1]);
                        } else {
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            troncon.setX(null);
                            troncon.setY(null);
                        }
                    }
                    catch (Exception e) {
                        troncon.setX(null);
                        troncon.setY(null);
                        troncon.setPointDebut(null);
                        troncon.setPointFin(null);
                        Log.error("ERREUR COORDONNEES TRONCONS", e);
                    }
                }
                troncons.add(troncon);
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    private void getStatFauchageTronconTempsReel(List<Centre> centres, String axe, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, java.util.Date> mapDerniereDatePAssage, Timestamp dateDebut, Timestamp dateFin, boolean dateDernierPassageConnue, Map<String, Integer> mapDistanceCumulee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            String conditionWhere;
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT * FROM fauchage.get_stats_fauchage(?,?,?,?,?,?)");
            String centresNomSQL = "";
            if (centres != null && centres.size() > 0) {
                String centreWhere;
                for (Centre centre : centres) {
                    centresNomSQL = centresNomSQL + (centresNomSQL.equals("") ? "" : ",") + "'" + centre.getNom().replace("'", "''") + "'";
                }
                centresNomSQL = centreWhere = "centre IN (" + centresNomSQL + ")";
            }
            String axeWhere = "";
            if (axe != null && !"".equals(axe)) {
                axeWhere = "axe = '" + axe + "'";
            }
            String string = conditionWhere = axeWhere.equals("") && centresNomSQL.equals("") ? null : "oid IN (SELECT oid FROM fauchage.schema_fauchage WHERE % % % )";
            if (conditionWhere != null) {
                conditionWhere = conditionWhere.replaceFirst("%", centresNomSQL);
                conditionWhere = !axeWhere.equals("") && !centresNomSQL.equals("") ? conditionWhere.replaceFirst("%", "AND ") : conditionWhere.replaceFirst("%", "");
                conditionWhere = conditionWhere.replaceFirst("%", axeWhere);
            }
            pstm.setTimestamp(1, dateDebut);
            pstm.setTimestamp(2, dateFin);
            pstm.setString(3, conditionWhere);
            pstm.setInt(4, bufferSize + 5);
            pstm.setObject(5, (Object)1, 2);
            pstm.setBoolean(6, dateDernierPassageConnue);
            Log.debug(pstm);
            rs = pstm.executeQuery();
            while (rs.next()) {
                String[] derniersPassages = null;
                Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                if (arrayIdPatrouilles != null) {
                    derniersPassages = (String[])arrayIdPatrouilles.getArray();
                }
                String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                mapPatrouillesId.put(tronocnID, derniersPassages);
                mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                try {
                    mapDistanceCumulee.put(tronocnID, rs.getInt("distance_cumulee_parcourue"));
                }
                catch (Exception e) {
                    mapDistanceCumulee.put(tronocnID, -1);
                }
                try {
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                    for (int k = 0; k < coordPArGeometry.size(); ++k) {
                        Vector coord = (Vector)coordPArGeometry.get(k);
                        int nbPoint = coord.size();
                        double[] x = new double[nbPoint];
                        double[] y = new double[nbPoint];
                        for (int i = 0; i < nbPoint; ++i) {
                            x[i] = ((Point2D.Double)coord.get((int)i)).x;
                            y[i] = ((Point2D.Double)coord.get((int)i)).y;
                        }
                        xsML.add(x);
                        ysML.add(y);
                    }
                    mapPositionXs.put(tronocnID, xsML);
                    mapPositionYs.put(tronocnID, ysML);
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void creerFauchagePasse(FauchagePasse passe) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            String requete = "insert into fauchage.passe_centre (passe_type_id, passe_debut, passe_fin,passe_delegation_id,passe_centre_nom,passe_coefficient) values (?,?,?,(select id from prism.delegation_rattachement where nom = ?),?,?)";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, passe.getType());
            pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
            pstm.setTimestamp(3, new Timestamp(passe.getPasseFin()));
            pstm.setString(4, passe.getDelegation());
            pstm.setString(5, passe.getCentre());
            pstm.setDouble(6, passe.getCoefficent());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void updateFauchagePasse(FauchagePasse passe) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            String requete = "update fauchage.passe_centre set passe_type_id=?, passe_debut=?, passe_fin=?,passe_delegation_id=(select id from prism.delegation_rattachement where nom = ? LIMIT 1),passe_centre_nom=?,passe_coefficient=? where passe_id = ?";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, passe.getType());
            pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
            pstm.setTimestamp(3, new Timestamp(passe.getPasseFin()));
            pstm.setString(4, passe.getDelegation());
            pstm.setString(5, passe.getCentre());
            pstm.setDouble(6, passe.getCoefficent());
            pstm.setDouble(7, passe.getId());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<FauchagePasse> rechercheFauchage(String delegation, String centre) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<FauchagePasseType> listeTypePasse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FauchageCircuitPasse> rechercheFauchageCircuit(String delegation, String centre) {
        ArrayList<FauchageCircuitPasse> passes = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String REQUETE_PASSES_PAR_DELEGATION_CENTRE = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit AND (c.delegation = ? or c.delegation is null) AND (c.centre =? or c.centre is null)";
        String REQUETE_PASSES_PAR_DELEGATION = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit AND (c.delegation = ? or c.delegation is null)";
        String REQUETE_PASSES = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit";
        try {
            connection = this.daoFactory.getConnection();
            if (centre != null) {
                pstm = connection.prepareStatement(REQUETE_PASSES_PAR_DELEGATION_CENTRE);
                pstm.setString(1, delegation);
                pstm.setString(2, centre);
            } else if (delegation != null) {
                pstm = connection.prepareStatement(REQUETE_PASSES_PAR_DELEGATION);
                pstm.setString(1, delegation);
            } else {
                pstm = connection.prepareStatement(REQUETE_PASSES);
            }
            Log.debug("[rechercheFauchage]Requete: " + pstm.toString());
            rs = pstm.executeQuery();
            passes = new ArrayList<FauchageCircuitPasse>();
            while (rs.next()) {
                FauchageCircuitPasse passe = new FauchageCircuitPasse();
                passe.setId(rs.getInt("passe_id"));
                passe.setIdCircuit(rs.getInt("passe_id_circuit"));
                passe.setType(rs.getInt("passe_type_id"));
                passe.setCoefficent(rs.getDouble("passe_coefficient"));
                passe.setPasseDebut(rs.getTimestamp("passe_debut").getTime());
                passe.setDelegation(rs.getString("delegation"));
                passe.setCentre(rs.getString("centre"));
                passes.add(passe);
            }
            DAOUtil.close(connection, pstm, rs);
            return passes;
        }
        catch (SQLException e) {
            throw new DAOException(e);
            catch (Exception e2) {
                Log.error("", e2);
                return passes;
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void updateFauchageCircuitPasse(FauchageCircuitPasse passe) {
        String requete;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            requete = "update fauchage.passe_circuit set  passe_fin=? where passe_id_circuit=? and passe_fin is null";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setTimestamp(1, new Timestamp(passe.getPasseDebut()));
            pstm.setInt(2, passe.getIdCircuit());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        try {
            requete = "insert into fauchage.passe_circuit(passe_type_id, passe_debut, passe_fin,passe_coefficient,passe_id_circuit) values (?, ?, ?,?, ?)";
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement(requete);
            pstm.setInt(1, passe.getType());
            pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
            pstm.setNull(3, 93);
            pstm.setDouble(4, passe.getCoefficent());
            pstm.setInt(5, passe.getIdCircuit());
            pstm.execute();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }
}

